/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.util.Arrays;
import java.util.Collection;
import oracle.ide.model.Project;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdevimpl.library.LibraryContainer;

class ProjectLibraryContainer
implements LibraryContainer {
    private final Project project;

    static ProjectLibraryContainer getInstance(Project project) {
        return new ProjectLibraryContainer(project);
    }

    private ProjectLibraryContainer(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public Collection<JLibrary> getLibraryReferences() {
        return Arrays.asList(this.getProjectLibraries().getLibraries());
    }

    @Override
    public Collection<JLibrary> getExportedReferences() {
        return Arrays.asList(this.getProjectLibraries().getExports());
    }

    @Override
    public Collection<JLibrary> getModulePathReferences() {
        return Arrays.asList(this.getProjectLibraries().getModulePathLibraries());
    }

    @Override
    public Collection<JLibrary> getClassPathReferences() {
        return Arrays.asList(this.getProjectLibraries().getClassPathLibraries());
    }

    @Override
    public MutableLibraryList getLibraryDefinitions() {
        return this.getProjectLibraries().getProjectLibraryList();
    }

    @Override
    public boolean hasLibrary(Object id) {
        return this.getProjectLibraries().hasLibrary(id);
    }

    @Override
    public JLibrary resolveLibrary(Object id) {
        return this.getProjectLibraries().resolveLibrary(id);
    }

    private JProjectLibraries getProjectLibraries() {
        return JProjectLibraries.getInstance((PropertyStorage)this.project);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProjectLibraryContainer)) {
            return false;
        }
        ProjectLibraryContainer other = (ProjectLibraryContainer)obj;
        return this.project == other.project;
    }

    public int hashCode() {
        return System.identityHashCode(this.project);
    }
}

