/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.net.URLPath;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchProgress;
import oracle.jdeveloper.library.Library;
import oracle.jdevimpl.library.LibrarySearchQueryFilter;

public class LibrarySearchQueryFilterJarImpl
extends LibrarySearchQueryFilter {
    private static String JAR_URL_SUFFIX = "!/";
    private static String JAR_FILE_NAME_SUFIX = ".jar";
    private static String JAR_FILE_FULL = JAR_FILE_NAME_SUFIX + JAR_URL_SUFFIX;
    private List<DefaultMutableTreeNode> m_libraryNodesToBeFilteredOut;

    public LibrarySearchQueryFilterJarImpl(String searchQuery) {
        super(searchQuery.endsWith(JAR_FILE_NAME_SUFIX) ? searchQuery : searchQuery + JAR_FILE_NAME_SUFIX);
    }

    @Override
    public void preSearch(DefaultMutableTreeNode root) {
    }

    private boolean queryLibrariesRecursively(DefaultMutableTreeNode root, SearchProgress searchProgress, Pattern pattern) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode libraryChildNode = (DefaultMutableTreeNode)root.getChildAt(i);
            if (libraryChildNode.getChildCount() > 0) {
                this.queryLibrariesRecursively(libraryChildNode, searchProgress, pattern);
                continue;
            }
            if (!(libraryChildNode.getUserObject() instanceof Library)) continue;
            Library nextLibrary = (Library)libraryChildNode.getUserObject();
            URLPath urlPath = nextLibrary.getClassPath();
            URL[] urls = urlPath.getEntries();
            for (int j = 0; j < urls.length; ++j) {
                String jarName;
                String jarFileEntry = urls[j].getFile();
                if (!LibrarySearchQueryFilterJarImpl.isJarFile(jarFileEntry) || !pattern.matcher(jarName = LibrarySearchQueryFilterJarImpl.extractJarNameOnlyFromURL(jarFileEntry)).matches()) continue;
                DefaultMutableTreeNode jarChild = new DefaultMutableTreeNode();
                jarChild.setUserObject(jarName);
                LibrarySearchQueryFilter.removeLibraryTreeNodeByLibraryName(this.m_libraryNodesToBeFilteredOut, nextLibrary.getName());
                libraryChildNode.insert(jarChild, libraryChildNode.getChildCount());
            }
        }
        return true;
    }

    @Override
    public void filterSearchResults(DefaultMutableTreeNode treeRoot) {
        for (DefaultMutableTreeNode treeNode : this.m_libraryNodesToBeFilteredOut) {
            treeNode.removeFromParent();
        }
    }

    @Override
    public boolean queryLibraries(DefaultMutableTreeNode root, SearchProgress searchProgress) {
        this.m_libraryNodesToBeFilteredOut = this.getLibraryTreeNodeSubset(root);
        return this.queryLibrariesRecursively(root, searchProgress, this.compilePattern());
    }

    private static boolean isJarFile(String jarFile) {
        return jarFile.endsWith(JAR_FILE_FULL);
    }

    private static String extractJarNameOnlyFromURL(String jarFile) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(jarFile.substring(0, jarFile.length() - JAR_URL_SUFFIX.length()));
        int lastIndexOfForwardSeparator = buffer.lastIndexOf("/");
        int lastIndexOfBackSeparator = buffer.lastIndexOf("\\");
        return buffer.substring(lastIndexOfForwardSeparator != -1 ? lastIndexOfForwardSeparator + 1 : lastIndexOfBackSeparator + 1);
    }

    @Override
    public Icon getHitChildIcon() {
        return OracleIcons.getIcon((String)"archivefile.png");
    }
}

