/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.VersionNumber;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibraryEditPanel;

public class JDKEditPanel
extends LibraryEditPanel {
    protected JLabel lblExe = new JLabel();
    protected URLTextField fldExe = new URLTextField(null, false, false);
    protected JButton btnExe = new JButton();
    protected String[] vms;
    protected VersionNumber version;
    protected URL sdkDir;
    private ExeListener _listener = new ExeListener();

    public JDKEditPanel() {
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_idednewjdk_html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JDKEditPanel(JDK jdk) {
        this();
        this.setLibrary(jdk);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_idededitj2se_html");
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.fldName, (String)LibraryArb.getString(20));
        ResourceUtils.resLabel((JLabel)this.lblLibList, (Component)this.fldLibLists, (String)LibraryArb.getString(72));
        ResourceUtils.resLabel((JLabel)this.lblExe, (Component)this.fldExe, (String)LibraryArb.getString(21));
        this.lblExe.setHorizontalAlignment(0);
        this.fldExe.setDialogTitle(ControlsArb.getString(54));
        this.fldExe.setFilter((URLFilter)new JDKUtil.JDKExeFilter());
        this.fldExe.getDocument().addDocumentListener(this._listener);
        ResourceUtils.resButton((AbstractButton)this.btnExe, (String)LibraryArb.getString(22));
        this.btnExe.addActionListener((ActionListener)this.fldExe);
        this.remove(this.cbDeployedByDefault);
        this.add((Component)this.lblExe, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 5, 0, 2), 0, 0));
        this.add((Component)this.fldExe, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 2), 0, 0));
        this.add((Component)this.btnExe, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 5), 0, 0));
        this.add((Component)this.lblName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 2), 0, 0));
        this.add((Component)this.fldName, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.rightScroll, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 0, 5), 0, 0));
        this.add((Component)this.posPanel, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.add((Component)this.addPanel, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 13, 2, new Insets(5, 3, 0, 0), 0, 0));
    }

    @Override
    public void setListsVisible(boolean visible) {
        if (visible) {
            this.add((Component)this.lblLibList, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 2), 0, 0));
            this.add((Component)this.fldLibLists, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 5), 0, 0));
        } else {
            this.remove(this.lblLibList);
            this.remove(this.fldLibLists);
        }
    }

    public String[] getVMs() {
        return this.vms;
    }

    public VersionNumber getJavaVersion() {
        return this.version;
    }

    public URL getSDKDir() {
        return this.sdkDir;
    }

    public URL getExecutable() {
        return this.fldExe.getURL();
    }

    public String getExecutableText() {
        return this.fldExe.getText();
    }

    @Override
    public void setLibrary(Library source) {
        this.fldExe.getDocument().removeDocumentListener(this._listener);
        this.currentLib = source;
        this.updatePaths();
        boolean editable = true;
        if (this.currentLib != null) {
            editable = !this.currentLib.isLocked();
            this.fldName.setText(this.currentLib.getName());
            this.fldExe.setURL(((JDK)this.currentLib).getJavaExecutable());
        } else {
            this.fldName.setText("");
            this.fldExe.setText("");
            editable = false;
        }
        this.fldName.setEnabled(editable);
        this.fldName.setEditable(editable);
        this.fldExe.setEnabled(editable);
        this.fldExe.setEditable(editable);
        this.btnExe.setEnabled(editable);
        this.pathsTree.setEnabled(editable);
        this.fldExe.getDocument().addDocumentListener(this._listener);
        int count = this.pathsTree.getRowCount();
        while (--count >= 0) {
            this.pathsTree.expandRow(count);
        }
        this.updatePathsButtons(null);
    }

    @Override
    protected void updatePaths() {
        if (this.currentLib != null) {
            JDK currentJDK = (JDK)this.currentLib;
            this.vms = currentJDK.getInstalledVMs();
            this.version = currentJDK.getJavaVersion();
            this.sdkDir = currentJDK.getSDKBinDir();
        } else {
            this.vms = null;
            this.version = null;
            this.sdkDir = null;
        }
        super.updatePaths();
    }

    private void updateEXE() {
        URL newURL = this.fldExe.getURL();
        if (newURL != null) {
            VersionNumber oldVersionNumber;
            String oldVersion = null;
            if (this.currentLib != null && (oldVersionNumber = ((JDK)this.currentLib).getJavaVersion()) != null) {
                oldVersion = oldVersionNumber.toString();
            }
            JDKUtil.initNewJDK((JDK)this.currentLib, newURL);
            this.updatePaths();
            String name = this.fldName.getText();
            String string = name = name != null ? name.trim() : null;
            if (name == null || name.length() == 0 || oldVersion != null && name.equals(oldVersion.toString())) {
                VersionNumber version = ((JDK)this.currentLib).getJavaVersion();
                this.fldName.setText(version != null ? version.toString() : "");
            }
        }
    }

    private final class ExeListener
    implements DocumentListener {
        private ExeListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
            JDKEditPanel.this.updateEXE();
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            JDKEditPanel.this.updateEXE();
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            JDKEditPanel.this.updateEXE();
        }
    }
}

