/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.extension.rules;

import java.net.URL;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunction;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.model.ApplicationContent;

public class AdfMetaInfAppContentContains
extends RuleFunction {
    public boolean evaluate(RuleEvaluationContext ruleContext, Map<String, RuleFunctionParameter> parameters) throws RuleEvaluationException {
        ApplicationContent appContent;
        URL parentURL;
        boolean anyMatch = true;
        RuleFunctionParameter match = this.getRequiredParameterOrThrow(parameters, "match");
        String val = match.getValue();
        if ("all".equalsIgnoreCase(val)) {
            anyMatch = false;
        } else if (!"any".equalsIgnoreCase(val)) {
            throw new RuleEvaluationException("Invalid 'match' parameter=" + val + " in rule " + ((Object)((Object)this)).getClass().getName());
        }
        RuleFunctionParameter fileNamesParam = this.getRequiredParameterOrThrow(parameters, "file-names");
        Context ideContext = ruleContext.getIdeContext();
        if (ideContext == null) {
            return false;
        }
        Workspace wksp = ideContext.getWorkspace();
        if (wksp != null && (parentURL = (appContent = ApplicationContent.getInstance(wksp)).getADFMetaInfURL()) != null) {
            String[] fileNames = fileNamesParam.getValue().split(",");
            if (fileNames.length == 0) {
                return false;
            }
            for (String fileName : fileNames) {
                boolean exists = URLFileSystem.exists((URL)URLFactory.newURL((URL)parentURL, (String)fileName.trim()));
                if (anyMatch) {
                    if (!exists) continue;
                    return true;
                }
                if (exists) continue;
                return false;
            }
            return !anyMatch;
        }
        return false;
    }
}

