/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.model.Workspace;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.model.ApplicationContent;
import oracle.jdeveloper.resource.ApplicationPropertiesArb;

public final class ApplicationContentPanel
extends ProjectSettingsTraversablePanel {
    private JLabel _lblSourceDirectory = new JLabel();
    private URLTextField _tfSourceDirectory = new URLTextField(null, true, false);
    private JButton _browseSourceDirectory = new JButton();
    private JLabel _lblPackagePrefix = new JLabel();
    private JTextField _tfPackagePrefix = new JTextField();
    private static final String[] PROPERTY_KEYS = new String[]{"application-package-prefix", ApplicationContent.APPLICATION_SRC_CONTENT_SET_KEY};

    public ApplicationContentPanel() {
        JWrappedLabel lblPrompt = new JWrappedLabel(ApplicationPropertiesArb.getString(10));
        ResourceUtils.resLabel((JLabel)this._lblSourceDirectory, (Component)this._tfSourceDirectory, (String)ApplicationPropertiesArb.getString(5));
        ResourceUtils.resButton((AbstractButton)this._browseSourceDirectory, (String)ApplicationPropertiesArb.getString(9));
        ResourceUtils.resLabel((JLabel)this._lblPackagePrefix, (Component)this._tfPackagePrefix, (String)ApplicationPropertiesArb.getString(11));
        this.setLayout(new GridBagLayout());
        this.add((Component)lblPrompt, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.add(this._lblSourceDirectory, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this._tfSourceDirectory, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this._browseSourceDirectory, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._lblPackagePrefix, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 2, 0), 0, 0));
        this.add(this._tfPackagePrefix, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(new JLabel(""), new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._browseSourceDirectory.addActionListener((ActionListener)this._tfSourceDirectory);
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        this.setHelpID("f1_appcontent_html");
        ApplicationContent content = this.getApplicationContent(tc);
        this._tfSourceDirectory.setURL(content.getSourceURL());
        this._tfPackagePrefix.setText(content.getAppPackagePrefix());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        ApplicationContent content = this.getApplicationContent(tc);
        URL sourceDirectoryURL = this._tfSourceDirectory.getURL();
        if (sourceDirectoryURL == null || !URLFileSystem.isValid((URL)sourceDirectoryURL)) {
            String directory = this._tfSourceDirectory.getText().trim();
            this._tfSourceDirectory.requestFocus();
            throw new TraversalException(ApplicationPropertiesArb.format(6, directory), ApplicationPropertiesArb.getString(7));
        }
        content.setSourceURL(sourceDirectoryURL);
        String prefix = this._tfPackagePrefix.getText().trim();
        if (!IdeUtil.isPackageIdentifier((String)prefix)) {
            this._tfPackagePrefix.requestFocus();
            throw new TraversalException(ApplicationPropertiesArb.format(13, prefix), ApplicationPropertiesArb.getString(12), "f1_idedclassnameinvalid_html");
        }
        content.setAppPackagePrefix(prefix.length() > 0 ? prefix : null);
    }

    public ApplicationContent getApplicationContent(TraversableContext tc) {
        Workspace ws = (Workspace)tc.find("Application");
        PropertyStorage ps = ApplicationContentPanel.getPropertyData((Namespace)tc);
        return ApplicationContent.getInstance(ps, ws.getURL());
    }

    public String getDataKey() {
        return "Application";
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }
}

