/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ideimpl.macros.MacroUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryWithMacroSupport;

public abstract class LibraryAdapter
extends HashStructureAdapter
implements LibraryWithMacroSupport {
    public LibraryAdapter(HashStructure hash) {
        super(hash);
    }

    @Override
    public URLPath getClassPath() {
        return this.getClassPath(null, true);
    }

    @Override
    public URLPath getClassPath(boolean expandMacros) {
        return this.getClassPath(null, expandMacros);
    }

    @Override
    public URLPath getClassPath(Context context, boolean expandMacros) {
        ListStructure data = this._hash.getListStructure("classPath");
        if (data != null && expandMacros) {
            return this.expandMacrosInURLList(context, data);
        }
        return new URLPath((List)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLPath expandMacrosInURLList(Context context, ListStructure data) {
        Object object = data.iteratorLock();
        synchronized (object) {
            ArrayList<URL> list = new ArrayList<URL>(data.size());
            for (URL url : data) {
                if (MacroUtils.isMacroExpression((String)url.getPath())) {
                    url = MacroUtils.expand((Context)context, (URL)url);
                }
                list.add(url);
            }
            return new URLPath(list);
        }
    }

    @Override
    public void setClassPath(URLPath path) {
        if (path == null) {
            this._hash.remove("classPath");
        } else {
            ListStructure data = this._hash.getOrCreateListStructure("classPath");
            data.mirror(path.asList());
        }
    }

    @Override
    public URLPath getSourcePath() {
        return this.getSourcePath(null, true);
    }

    @Override
    public URLPath getSourcePath(boolean expandMacros) {
        return this.getSourcePath(null, expandMacros);
    }

    @Override
    public URLPath getSourcePath(Context context, boolean expandMacros) {
        ListStructure data = this._hash.getListStructure("sourcePath");
        if (data != null && expandMacros) {
            return this.expandMacrosInURLList(context, data);
        }
        return new URLPath((List)data);
    }

    @Override
    public void setSourcePath(URLPath path) {
        if (path == null) {
            this._hash.remove("sourcePath");
        } else {
            ListStructure data = this._hash.getOrCreateListStructure("sourcePath");
            data.mirror(path.asList());
        }
    }

    @Override
    public URLPath getDocPath() {
        return this.getDocPath(null, true);
    }

    @Override
    public URLPath getDocPath(boolean expandMacros) {
        return this.getDocPath(null, expandMacros);
    }

    @Override
    public URLPath getDocPath(Context context, boolean expandMacros) {
        ListStructure data = this._hash.getListStructure("docPath");
        if (data != null && expandMacros) {
            return this.expandMacrosInURLList(context, data);
        }
        return new URLPath((List)data);
    }

    @Override
    public void setDocPath(URLPath path) {
        if (path == null) {
            this._hash.remove("docPath");
        } else {
            ListStructure data = this._hash.getOrCreateListStructure("docPath");
            data.mirror(path.asList());
        }
    }

    @Override
    public boolean isLocked() {
        return this._hash.getBoolean("locked", false);
    }

    @Override
    public void setLocked(boolean isLocked) {
        this._hash.putBoolean("locked", isLocked);
    }

    @Override
    public boolean equivalent(Library library) {
        if (library == null) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getClassPath(), (Object)this.getClassPath())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getSourcePath(), (Object)this.getSourcePath())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getDocPath(), (Object)this.getDocPath())) {
            return false;
        }
        return library.isLocked() == this.isLocked();
    }

    @Override
    public void initFromLibrary(Library library) {
        if (library != null) {
            if (library instanceof LibraryWithMacroSupport) {
                LibraryWithMacroSupport libraryM = (LibraryWithMacroSupport)library;
                URLPath path = libraryM.getClassPath(false);
                if (ModelUtil.areDifferent((Object)path, (Object)this.getClassPath(false))) {
                    this.setClassPath(path);
                }
                if (ModelUtil.areDifferent((Object)(path = libraryM.getSourcePath(false)), (Object)this.getSourcePath(false))) {
                    this.setSourcePath(path);
                }
                if (ModelUtil.areDifferent((Object)(path = libraryM.getDocPath(false)), (Object)this.getDocPath(false))) {
                    this.setDocPath(path);
                }
            } else {
                URLPath path = library.getClassPath();
                if (ModelUtil.areDifferent((Object)path, (Object)this.getClassPath())) {
                    this.setClassPath(path);
                }
                if (ModelUtil.areDifferent((Object)(path = library.getSourcePath()), (Object)this.getSourcePath())) {
                    this.setSourcePath(path);
                }
                if (ModelUtil.areDifferent((Object)(path = library.getDocPath()), (Object)this.getDocPath())) {
                    this.setDocPath(path);
                }
            }
            if (library.isLocked() != this.isLocked()) {
                this.setLocked(library.isLocked());
            }
        }
    }

    public String getShortLabel() {
        return this.getName();
    }

    public String getLongLabel() {
        Object id = this.getID();
        if (id == null) {
            return "";
        }
        return id instanceof URL ? URLFileSystem.getPlatformPathName((URL)((URL)id)) : id.toString();
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"library.png");
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public String toString() {
        return this.getShortLabel();
    }

    @Override
    public String getName() {
        return this._hash.getString("description", "");
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            this._hash.remove("description");
        } else {
            this._hash.putString("description", name);
        }
    }

    @Override
    public Object getID() {
        return this._hash.getObject("id");
    }

    public void setID(Object id) {
        if (id == null) {
            this._hash.remove("id");
        } else if (id instanceof URL) {
            this._hash.putURL("id", (URL)id);
        } else {
            this._hash.putString("id", id.toString());
        }
    }

    @Override
    @Deprecated
    public URLPath getDefaultClassPath() {
        return this.getClassPath();
    }

    @Override
    @Deprecated
    public void setDefaultClassPath(URLPath path) {
        this.setClassPath(path);
    }

    @Override
    @Deprecated
    public URLPath getDefaultSourcePath() {
        return this.getSourcePath();
    }

    @Override
    @Deprecated
    public void setDefaultSourcePath(URLPath path) {
        this.setSourcePath(path);
    }

    @Override
    @Deprecated
    public URLPath getDefaultDocPath() {
        return this.getDocPath();
    }

    @Override
    @Deprecated
    public void setDefaultDocPath(URLPath path) {
        this.setDocPath(path);
    }
}

