/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.security.auth.x500.X500Principal;
import oracle.security.pki.OracleCertExtension;
import oracle.security.pki.OracleLDAP;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.internal.OraclePKIX509CertHelper;
import oracle.security.pki.internal.OraclePKIX509CertReqHelper;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.wallet.NZException;
import oracle.security.wallet.NZWallet;

public class OracleWalletTextUI {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    static String b = "wallet:\ncreate [-wallet [wallet]] [[-pwd <pwd>] [-auto_login|-auto_login_local]] | [-auto_login_only]\ndisplay [-wallet [wallet]] <-summary> [-pwd <pwd>]\nchange_pwd [-wallet [wallet]] [-oldpwd <oldpwd>] [-newpwd <newpwd>]\nadd [-wallet [wallet]] <[-keysize [512|1024|2048|4096]] [-dn [dn]]>\n     <-self_signed [-validity [days]] | [-valid_from [mm/dd/yyyy] -valid_until [mm/dd/yyyy]]\n                   [-serial_file <file_loc>] | [-serial_num <serial_num>]> <-addext_ski>\n     <[-cert [filename]] [-trusted_cert|-user_cert]> [-pwd <pwd>] | [-auto_login_only]\nremove [-wallet [wallet]] [-dn [dn]] [-trusted_cert_all|-trusted_cert|-user_cert|-cert_req]\n     [-pwd <pwd>] | [-auto_login_only]\nexport [-wallet [wallet]] [-dn [dn]] [-cert [filename] | -request [filename]] [-pwd <pwd>]\nexport_trust_chain [-wallet [wallet]] [-certchain [filename]] [-dn [user_cert_dn]] [-pwd <pwd>]\nupload [-wallet [wallet]] [-ldap [host:port]] [-user [user]] [-userpwd [userpwd]] [-pwd <pwd>]\ndownload [-wallet [wallet]] [-ldap [host:nonsslport]] [-user [user]] [-userpwd [userpwd]] [-pwd <pwd>]\njks_to_pkcs12 [-wallet [wallet]] [-pwd <pwd>] [-keystore [keystore]] [-jkspwd [jkspwd]]\n     <-aliases [alias:alias..]>\npkcs12_to_jks [-wallet [wallet]] [-pwd <pwd>] [-jksKeyStoreLoc <jksKSloc> -jksKeyStorepwd <jksKS_pwd>]\n     [-jksTrustStoreLoc <loc> -jksTrustStorepwd <pwd>]\np11_add [-wallet [wallet]] [-p11_lib <pkcs11Lib>] [-p11_tokenlabel <tokenLabel>]\n     [-p11_tokenpw <tokenPassphrase>] [-p11_certlabel <certlabel>] [-pwd <pwd>]\np11_verify [-wallet [wallet]] [-pwd <pwd>]\nhelp\n";

    public static void command(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        if (stringArray[0].equals("help")) {
            System.out.println(b);
            return;
        }
        if (stringArray[0].equals("display")) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            OracleWalletTextUI.display(stringArray2);
        } else if (stringArray[0].equals("create")) {
            String[] stringArray3 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray3, 0, stringArray3.length);
            OracleWalletTextUI.create(stringArray3);
        } else if (stringArray[0].equals("remove")) {
            String[] stringArray4 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray4, 0, stringArray4.length);
            OracleWalletTextUI.remove(stringArray4);
        } else if (stringArray[0].equals("test_api")) {
            String[] stringArray5 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray5, 0, stringArray5.length);
            OracleWalletTextUI.test_api(stringArray5);
        } else if (stringArray[0].equals("change_pwd")) {
            String[] stringArray6 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray6, 0, stringArray6.length);
            OracleWalletTextUI.change_pwd(stringArray6);
        } else if (stringArray[0].equals("add")) {
            String[] stringArray7 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray7, 0, stringArray7.length);
            OracleWalletTextUI.add(stringArray7);
        } else if (stringArray[0].equals("p11_add")) {
            String[] stringArray8 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray8, 0, stringArray8.length);
            OracleWalletTextUI.p11_add(stringArray8);
        } else if (stringArray[0].equals("p11_verify")) {
            String[] stringArray9 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray9, 0, stringArray9.length);
            OracleWalletTextUI.p11_verify(stringArray9);
        } else if (stringArray[0].equals("p11_test")) {
            String[] stringArray10 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray10, 0, stringArray10.length);
            OracleWalletTextUI.p11_test(stringArray10);
        } else if (stringArray[0].equals("export")) {
            String[] stringArray11 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray11, 0, stringArray11.length);
            OracleWalletTextUI.export(stringArray11);
        } else if (stringArray[0].equals("export_trust_chain")) {
            String[] stringArray12 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray12, 0, stringArray12.length);
            OracleWalletTextUI.exportchain(stringArray12);
        } else if (stringArray[0].equals("upload")) {
            String[] stringArray13 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray13, 0, stringArray13.length);
            OracleWalletTextUI.uploadWallet(stringArray13);
        } else if (stringArray[0].equals("download")) {
            String[] stringArray14 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray14, 0, stringArray14.length);
            OracleWalletTextUI.downloadWallet(stringArray14);
        } else if (stringArray[0].equals("verify_trust_chain")) {
            String[] stringArray15 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray15, 0, stringArray15.length);
            OracleWalletTextUI.verifychain(stringArray15);
        } else if (stringArray[0].equals("is_tcert_used_in_chain")) {
            String[] stringArray16 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray16, 0, stringArray16.length);
            OracleWalletTextUI.isTrustedCertUsedInChain(stringArray16);
        } else if (stringArray[0].equals("get_certreq_info")) {
            String[] stringArray17 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray17, 0, stringArray17.length);
            OracleWalletTextUI.getCertreqInfo(stringArray17);
        } else if (stringArray[0].equals("get_certreq_count_dns")) {
            String[] stringArray18 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray18, 0, stringArray18.length);
            OracleWalletTextUI.getCertReqCountDNs(stringArray18);
        } else if (stringArray[0].equals("validate_pswd")) {
            String[] stringArray19 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray19, 0, stringArray19.length);
            OracleWalletTextUI.isValidPassword(stringArray19);
        } else if (stringArray[0].equals("get_keysizes")) {
            String[] stringArray20 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray20, 0, stringArray20.length);
            OracleWalletTextUI.getKeysizes(stringArray20);
        } else if (stringArray[0].equals("jks_to_pkcs12")) {
            String[] stringArray21 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray21, 0, stringArray21.length);
            OracleWalletTextUI.migrateJKStoPKCS12(stringArray21);
        } else if (stringArray[0].equals("list_aliases")) {
            String[] stringArray22 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray22, 0, stringArray22.length);
            OracleWalletTextUI.listAliases(stringArray22);
        } else if (stringArray[0].equals("pkcs12_to_jks")) {
            String[] stringArray23 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray23, 0, stringArray23.length);
            OracleWalletTextUI.testJks_mig(stringArray23);
        } else if (stringArray[0].equals("test_jks_crt")) {
            String[] stringArray24 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray24, 0, stringArray24.length);
            OracleWalletTextUI.testJks_crt(stringArray24);
        } else if (stringArray[0].equals("test_jks_crt_ss")) {
            String[] stringArray25 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray25, 0, stringArray25.length);
            OracleWalletTextUI.testJks_crt_ss(stringArray25);
        } else if (stringArray[0].equals("test_jks_imp")) {
            String[] stringArray26 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray26, 0, stringArray26.length);
            OracleWalletTextUI.testJks_imp(stringArray26);
        } else if (stringArray[0].equals("test_jks_info")) {
            String[] stringArray27 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray27, 0, stringArray27.length);
            OracleWalletTextUI.testJks_info(stringArray27);
        } else if (stringArray[0].equals("test_jks_exp")) {
            String[] stringArray28 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray28, 0, stringArray28.length);
            OracleWalletTextUI.testJks_exp(stringArray28);
        } else if (stringArray[0].equals("test_jks_rem")) {
            String[] stringArray29 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray29, 0, stringArray29.length);
            OracleWalletTextUI.testJks_rem(stringArray29);
        } else if (stringArray[0].equals("test_jks_dis")) {
            String[] stringArray30 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray30, 0, stringArray30.length);
            OracleWalletTextUI.testJks_dis(stringArray30);
        } else if (stringArray[0].equals("test_jks_rem_all_tps")) {
            String[] stringArray31 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray31, 0, stringArray31.length);
            OracleWalletTextUI.testJks_rem_all_tps(stringArray31);
        } else {
            System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[0]);
            System.out.println(b);
            return;
        }
    }

    public static void uploadWallet(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "389";
        String string5 = "";
        String string6 = null;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-ldap")) {
                    int n2;
                    if ((n2 = stringArray[++i2].indexOf(58)) > 0) {
                        string3 = stringArray[i2].substring(0, n2);
                        string4 = stringArray[i2].substring(n2 + 1);
                        continue;
                    }
                    string3 = stringArray[i2];
                    continue;
                }
                if (stringArray[i2].equals("-user")) {
                    string5 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-userpwd")) {
                    string6 = stringArray[++i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        OracleWallet oracleWallet = null;
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
        }
        catch (Exception exception) {
            try {
                oracleWallet = new OracleWallet();
                oracleWallet.open(string, null);
                if (oracleWallet.isAutoLoginOnly()) {
                    System.out.println("Found Auto Login Only (ALO) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                } else {
                    System.out.println("Found Auto Login (AL) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                }
            }
            catch (Exception exception2) {
                System.out.println(exception.getLocalizedMessage());
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                return;
            }
        }
        try {
            OracleLDAP.uploadWallet(string3, string4, string5, string6.toCharArray(), string, string2.toCharArray());
        }
        catch (Exception exception) {
            System.out.println("Upload wallet failed : " + exception.getLocalizedMessage());
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            return;
        }
    }

    public static void downloadWallet(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "389";
        String string5 = "";
        String string6 = null;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-ldap")) {
                    int n2;
                    if ((n2 = stringArray[++i2].indexOf(58)) > 0) {
                        string3 = stringArray[i2].substring(0, n2);
                        string4 = stringArray[i2].substring(n2 + 1);
                        continue;
                    }
                    string3 = stringArray[i2];
                    continue;
                }
                if (stringArray[i2].equals("-user")) {
                    string5 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-userpwd")) {
                    string6 = stringArray[++i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        byte[] byArray = null;
        try {
            byArray = OracleLDAP.downloadWallet(string3, string4, string5, string6.toCharArray());
            OracleWallet oracleWallet = new OracleWallet();
            oracleWallet.setWalletArray(byArray, string2.toCharArray());
            oracleWallet.saveAs(string);
        }
        catch (Exception exception) {
            System.out.println("Download wallet failed : " + exception.getLocalizedMessage());
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            return;
        }
    }

    public static void testJks_crt(String[] stringArray) {
        OracleWallet oracleWallet;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-request")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-dn")) {
                    string4 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-keysize")) {
                    string5 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-alias")) {
                    string6 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string3 = stringArray[++i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        try {
            oracleWallet = OracleWallet.getInstance("jks");
            oracleWallet.create(OraclePKIGenFunc.getCreatePassword(string3, false));
            oracleWallet.saveAs(string);
        }
        catch (IOException iOException) {
            System.out.println("Unable to save wallet at " + string);
            return;
        }
        try {
            oracleWallet = OracleWallet.getInstance("jks");
            oracleWallet.open(string, string3.toCharArray());
            int n2 = Integer.parseInt(string5);
            oracleWallet.addCertRequest(new X500Principal(string4), n2, null, string6);
            oracleWallet.saveAs(string);
            String string7 = oracleWallet.exportCertReqB64(string6);
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write(string7);
            fileWriter.flush();
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            System.out.println("jks test failed.");
            exception.printStackTrace();
            return;
        }
    }

    public static void testJks_crt_ss(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-dn")) {
                    string3 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-keysize")) {
                    string4 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-alias")) {
                    string5 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-serial_num")) {
                    string6 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        try {
            OracleWallet oracleWallet = OracleWallet.getInstance("jks");
            oracleWallet.open(string, string2.toCharArray());
            BigInteger bigInteger = new BigInteger(string6);
            int n2 = Integer.parseInt(string4);
            oracleWallet.createSelfSigned(new X500Principal(string3), n2, 3650, bigInteger, null, string5);
            oracleWallet.saveAs(string);
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            System.out.println("jks test failed.");
            exception.printStackTrace();
            return;
        }
    }

    public static void testJks_imp(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = "jks";
        boolean bl = false;
        boolean bl2 = false;
        String string4 = null;
        String string5 = null;
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-trusted_cert")) {
                    bl = true;
                    bl2 = false;
                    continue;
                }
                if (stringArray[i2].equals("-user_cert")) {
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (stringArray[i2].equals("-cert")) {
                    string4 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-alias")) {
                    string5 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        if (string4 != null) {
            try {
                InputStream inputStream;
                try {
                    inputStream = new URL(string4).openStream();
                }
                catch (MalformedURLException malformedURLException) {
                    inputStream = new FileInputStream(string4);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n2 = inputStream.read();
                while (n2 != -1) {
                    byteArrayOutputStream.write((byte)n2);
                    n2 = inputStream.read();
                }
                OracleWallet oracleWallet = OracleWallet.getInstance("jks");
                oracleWallet.open(string, string2.toCharArray());
                if (bl) {
                    oracleWallet.importCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), true, string5);
                } else if (bl2) {
                    oracleWallet.importCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), false, string5);
                } else {
                    throw new IOException("User or trusted cert flag should be specified.");
                }
                oracleWallet.saveAs(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public static void testJks_info(String[] stringArray) {
        block12: {
            String string = null;
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            boolean bl2 = false;
            try {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (stringArray[i2].equals("-wallet")) {
                        string = stringArray[++i2];
                        continue;
                    }
                    if (stringArray[i2].equals("-alias")) {
                        string3 = stringArray[++i2];
                        continue;
                    }
                    if (stringArray[i2].equals("-pwd")) {
                        string2 = stringArray[++i2];
                        continue;
                    }
                    if (stringArray[i2].equals("-trusted_cert")) {
                        bl = true;
                        bl2 = false;
                        continue;
                    }
                    if (stringArray[i2].equals("-user_cert")) {
                        bl = false;
                        bl2 = true;
                        continue;
                    }
                    System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                    System.out.println(b);
                    return;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println(b);
                return;
            }
            try {
                OracleWallet oracleWallet = OracleWallet.getInstance("jks");
                boolean bl3 = oracleWallet.exists(string);
                oracleWallet.open(string, string2.toCharArray());
                String string4 = "welcome34";
                oracleWallet.changePassword(string4.toCharArray());
                oracleWallet.changePassword(string2.toCharArray());
                InputStream inputStream = oracleWallet.getWalletArray(false);
                OracleWallet oracleWallet2 = OracleWallet.getInstance("jks");
                oracleWallet2.setWalletArray(inputStream, string2.toCharArray());
                byte[] byArray = oracleWallet.getWalletArrayB(false);
                OracleWallet oracleWallet3 = OracleWallet.getInstance("jks");
                oracleWallet3.setWalletArray(byArray, string2.toCharArray());
                if (bl) {
                    oracleWallet.getTrustpointInfo(0, string3);
                    X509Certificate x509Certificate = oracleWallet.getTrustpoint(0, 1);
                    X500Principal[] x500PrincipalArray = oracleWallet.getTrustpointDNs(0);
                    int n2 = oracleWallet.getTrustpointCount(0);
                    String[] stringArray2 = oracleWallet.getTrustpointAliases(0);
                    ArrayList arrayList = oracleWallet.getTrustpointDNalias(0);
                    String string5 = oracleWallet.exportTrustedB64(string3);
                    break block12;
                }
                if (bl2) {
                    oracleWallet.getCertInfo(0, string3);
                    oracleWallet.getCertReqInfo(0, string3);
                    X509Certificate x509Certificate = oracleWallet.getCert(0, 1);
                    String[] stringArray3 = oracleWallet.getCertReqAliases(0);
                    int n3 = oracleWallet.getCertReqCount(0);
                    X500Principal[] x500PrincipalArray = oracleWallet.getCertReqDNs(0);
                    String[] stringArray4 = oracleWallet.getCertReqInfo(0, 0);
                    ArrayList arrayList = oracleWallet.getCertReqDNalias(0);
                    X500Principal[] x500PrincipalArray2 = oracleWallet.getCertDNs(0);
                    int n4 = oracleWallet.getCertCount(0);
                    String[] stringArray5 = oracleWallet.getCertAliases(0);
                    ArrayList arrayList2 = oracleWallet.getCertDNalias(0);
                    Enumeration enumeration = oracleWallet.listAliases();
                    break block12;
                }
                throw new IOException("User or trusted cert flag should be specified.");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public static void testJks_exp(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-cert")) {
                    string3 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-certchain")) {
                    string4 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-alias")) {
                    string5 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        if (string3 != null) {
            try {
                OracleWallet oracleWallet = OracleWallet.getInstance("jks");
                oracleWallet.open(string, string2.toCharArray());
                String string6 = oracleWallet.exportCertB64(string5);
                FileWriter fileWriter = new FileWriter(string3);
                fileWriter.write(string6);
                fileWriter.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (string4 != null) {
            try {
                OracleWallet oracleWallet = OracleWallet.getInstance("jks");
                oracleWallet.open(string, string2.toCharArray());
                String string7 = oracleWallet.exportCertChainB64(string5);
                FileWriter fileWriter = new FileWriter(string4);
                fileWriter.write(string7);
                fileWriter.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void testJks_rem(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-alias")) {
                    string3 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-trusted_cert")) {
                    bl = true;
                    bl2 = false;
                    continue;
                }
                if (stringArray[i2].equals("-user_cert")) {
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        try {
            OracleWallet oracleWallet = OracleWallet.getInstance("jks");
            oracleWallet.open(string, string2.toCharArray());
            if (bl) {
                oracleWallet.removeTrustpoint(string3);
            } else if (bl2) {
                oracleWallet.deleteCert(string3);
            } else {
                throw new IOException("User or trusted cert flag should be specified.");
            }
            oracleWallet.saveAs(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void testJks_mig(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-jksKeyStoreLoc")) {
                    string3 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-jksKeyStorepwd")) {
                    if (OracleWallet.isValidPassword((string4 = stringArray[++i2]).toCharArray())) continue;
                    System.out.println(a.getString("PKI-01002"));
                    return;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-jksTrustStoreLoc")) {
                    string5 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-jksTrustStorepwd")) {
                    if (OracleWallet.isValidPassword((string6 = stringArray[++i2]).toCharArray())) continue;
                    System.out.println(a.getString("PKI-01002"));
                    return;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        OracleWallet oracleWallet = new OracleWallet();
        boolean bl = false;
        try {
            if (string2 == null) {
                try {
                    oracleWallet.open(string, null);
                }
                catch (Exception exception) {
                    oracleWallet.open(string, OraclePKIGenFunc.getPassword("WALLET_PASSWORD_PROMPT"));
                    bl = true;
                }
                if (!oracleWallet.isAutoLoginOnly() && !bl) {
                    System.out.println("Can not convert regular SSO wallet to JKS.\nPlease provide corresponding p12 wallet with password.");
                    return;
                }
            } else {
                oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
            }
            if (string5 == null) {
                OracleWallet oracleWallet2 = oracleWallet.migratePKCS12toJKS(string4.toCharArray(), 0);
                oracleWallet2.saveAs(string3);
            } else {
                OracleWallet oracleWallet3 = oracleWallet.migratePKCS12toJKS(string4.toCharArray(), 1);
                oracleWallet3.saveAs(string3);
                OracleWallet oracleWallet4 = oracleWallet.migratePKCS12toJKS(string6.toCharArray(), 2);
                oracleWallet4.saveAs(string5);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void testJks_dis(String[] stringArray) {
        String string = null;
        String string2 = null;
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        try {
            OracleWallet oracleWallet = OracleWallet.getInstance("jks");
            oracleWallet.open(string, string2.toCharArray());
            KeyStore keyStore = oracleWallet.getKeyStore();
            Enumeration<String> enumeration = null;
            enumeration = keyStore.aliases();
            System.out.println("Keystore contains " + keyStore.size() + " entries.");
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                if (keyStore.isKeyEntry(string3)) {
                    System.out.println("keyEntry:" + string3);
                    Certificate[] certificateArray = keyStore.getCertificateChain(string3);
                    for (int i3 = 0; i3 < certificateArray.length; ++i3) {
                        if (((Object)((X509Certificate)certificateArray[i3]).getIssuerDN()).equals(((X509Certificate)certificateArray[i3]).getSubjectDN())) {
                            System.out.print("  " + (i3 + 1) + " (self-signed)");
                        } else {
                            System.out.print("  " + (i3 + 1));
                        }
                        System.out.println("  " + ((X509Certificate)certificateArray[i3]).getSubjectDN());
                    }
                    continue;
                }
                if (!keyStore.isCertificateEntry(string3)) continue;
                System.out.println("trustedCertEntry:" + string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void testJks_rem_all_tps(String[] stringArray) {
        String string = null;
        String string2 = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\ntest_jks_rem_all_tps [-jksKeyStoreLoc <jksKSloc> -jksKeyStorepwd <jksKS_pwd>]\nhelp");
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-jksKeyStoreLoc")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-jksKeyStorepwd")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println("wallet:\ntest_jks_rem_all_tps [-jksKeyStoreLoc <jksKSloc> -jksKeyStorepwd <jksKS_pwd>]\nhelp");
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("wallet:\ntest_jks_rem_all_tps [-jksKeyStoreLoc <jksKSloc> -jksKeyStorepwd <jksKS_pwd>]\nhelp");
            return;
        }
        try {
            OracleWallet oracleWallet = OracleWallet.getInstance("jks");
            oracleWallet.open(string, string2.toCharArray());
            oracleWallet.removeTrustpoints();
            oracleWallet.saveAs(string);
        }
        catch (Exception exception) {
            System.out.println("Could not remove trustpoints: " + exception.getLocalizedMessage());
            return;
        }
    }

    public static void test_bug5610097(String[] stringArray) {
        String string = "/scratch/rchahal/temp/dgoswami/wall1";
        try {
            OracleWallet oracleWallet = new OracleWallet();
            oracleWallet.createSSO();
            oracleWallet.saveAs(string);
            OracleWallet oracleWallet2 = new OracleWallet();
            oracleWallet2.open(string, null);
            OracleSecretStore oracleSecretStore = oracleWallet2.getSecretStore();
            if (oracleSecretStore != null && oracleWallet2 != null) {
                oracleSecretStore.setSecret(new String("alias"), "secret".toCharArray());
                oracleWallet2.setSecretStore(oracleSecretStore);
            }
            if (oracleWallet2 != null) {
                oracleWallet2.save();
            }
            if (oracleWallet2 != null) {
                oracleSecretStore.setSecret(new String("alias2"), "secret2".toCharArray());
                oracleWallet2.setSecretStore(oracleSecretStore);
            }
            if (oracleWallet2 != null) {
                oracleWallet2.save();
            }
            if (oracleWallet2 != null) {
                oracleWallet2.save();
            }
        }
        catch (IOException iOException) {
            System.out.println(a.getString("GEN_UNKNOWN_ERROR") + string);
            if (OraclePKIDebug.getDebugFlag()) {
                iOException.printStackTrace();
            }
            return;
        }
        catch (OracleSecretStoreException oracleSecretStoreException) {
            System.out.println(oracleSecretStoreException.getLocalizedMessage());
            if (OraclePKIDebug.getDebugFlag()) {
                oracleSecretStoreException.printStackTrace();
            }
            return;
        }
    }

    public static void migrateJKStoPKCS12(String[] stringArray) {
        String string = null;
        String string2 = null;
        char[] cArray = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String[] stringArray2 = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\njks_to_pkcs12 [-wallet [wallet]] [-pwd [pwd]] [-keystore [keystore]] [-jkspwd [jkspwd]] <-aliases [alias:alias..]>\nhelp");
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equals("-wallet")) {
                string3 = stringArray[++i2];
                continue;
            }
            if (stringArray[i2].equals("-pwd")) {
                string4 = stringArray[++i2];
                continue;
            }
            if (stringArray[i2].equals("-keystore")) {
                string = stringArray[++i2];
                continue;
            }
            if (stringArray[i2].equals("-jkspwd")) {
                string2 = stringArray[++i2];
                cArray = string2.toCharArray();
                continue;
            }
            if (stringArray[i2].equals("-aliases")) {
                string5 = stringArray[++i2];
                stringArray2 = string5.split(":");
                continue;
            }
            System.out.println("wallet:\njks_to_pkcs12 [-wallet [wallet]] [-pwd [pwd]] [-keystore [keystore]] [-jkspwd [jkspwd]] <-aliases [alias:alias..]>\nhelp");
            return;
        }
        OracleWallet oracleWallet = new OracleWallet();
        boolean bl = false;
        try {
            if (string4 == null) {
                try {
                    oracleWallet.open(string3, null);
                }
                catch (Exception exception) {
                    oracleWallet.open(string3, OraclePKIGenFunc.getPassword("WALLET_PASSWORD_PROMPT"));
                    bl = true;
                }
                if (!oracleWallet.isAutoLoginOnly() && !bl) {
                    System.out.println("Can not convert JKS to regular SSO wallet.\nPlease provide p12 wallet with password or provide editable SSO wallet.");
                    return;
                }
            } else {
                oracleWallet = OraclePKIGenFunc.openAWallet(string3, string4, false);
            }
            KeyStore keyStore = KeyStore.getInstance("JKS");
            FileInputStream fileInputStream = new FileInputStream(string);
            keyStore.load(fileInputStream, cArray);
            oracleWallet.migrateJKStoPKCS12(keyStore, cArray, stringArray2);
            oracleWallet.save();
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
        }
    }

    public static void listAliases(String[] stringArray) {
        String string = null;
        String string2 = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\nlist_aliases [-wallet [wallet]] [-pwd [pwd]]\nhelp");
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equals("-wallet")) {
                string = stringArray[++i2];
                continue;
            }
            if (stringArray[i2].equals("-pwd")) {
                string2 = stringArray[++i2];
                continue;
            }
            System.out.println("wallet:\nlist_aliases [-wallet [wallet]] [-pwd [pwd]]\nhelp");
            return;
        }
        try {
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
            Enumeration enumeration = oracleWallet.listAliases();
            while (enumeration.hasMoreElements()) {
                System.out.println("alias : " + enumeration.nextElement());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
        }
    }

    public static void create(String[] stringArray) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = null;
        String string2 = null;
        boolean bl5 = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-auto_login")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i2].equals("-auto_login_local")) {
                    bl3 = true;
                    continue;
                }
                if (stringArray[i2].equals("-auto_login_only")) {
                    bl4 = true;
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-obpwd")) {
                    bl5 = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        if (bl2 && bl3 || bl2 && bl4 || bl3 && bl4) {
            System.out.println(b);
            return;
        }
        if (string2 != null && bl4) {
            System.out.println(b);
            return;
        }
        OracleWallet oracleWallet = new OracleWallet();
        try {
            OracleWallet oracleWallet2 = new OracleWallet();
            oracleWallet2.create(new char[]{'a', '2', 'v', 'b', 'n', '9', '8', 'z'});
            bl = oracleWallet2.exists(string);
        }
        catch (IOException iOException) {
            System.out.println(a.getString("GEN_UNKNOWN_ERROR") + string);
            return;
        }
        if (bl) {
            if (bl2 || bl3) {
                try {
                    oracleWallet.open(string, OraclePKIGenFunc.getPassword(string2, bl5, "WALLET_PASSWORD_PROMPT"));
                }
                catch (Exception exception) {
                    System.out.println(a.getString("PKI-02003") + string);
                    return;
                }
            }
            System.out.println(a.getString("PKI-02001") + string);
            return;
        }
        if (!bl4) {
            try {
                oracleWallet.create(OraclePKIGenFunc.getCreatePassword(string2, bl5));
                oracleWallet.saveAs(string);
            }
            catch (IOException iOException) {
                System.out.println("Unable to save wallet at " + string);
                return;
            }
        }
        if (bl2) {
            try {
                oracleWallet.saveSSO();
            }
            catch (IOException iOException) {
                System.out.println("Unable to save wallet at " + string);
                return;
            }
        }
        if (bl3) {
            try {
                oracleWallet.saveLSSO();
            }
            catch (IOException iOException) {
                System.out.println("Unable to save wallet at " + string);
                return;
            }
        }
        if (bl4) {
            try {
                oracleWallet.createSSO();
                oracleWallet.saveAs(string);
            }
            catch (IOException iOException) {
                System.out.println("Unable to create auto-login-only wallet: " + iOException.toString());
                if (OraclePKIDebug.getDebugFlag()) {
                    iOException.printStackTrace();
                }
                return;
            }
        }
    }

    public static void display(String[] stringArray) {
        boolean bl = true;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        boolean bl3 = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-summary")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i2].equals("-complete")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-obpwd")) {
                    bl3 = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        OracleWallet oracleWallet = null;
        KeyStore keyStore = null;
        OracleSecretStore oracleSecretStore = null;
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, bl3);
            keyStore = oracleWallet.getKeyStore();
            oracleSecretStore = oracleWallet.getSecretStore();
        }
        catch (Exception exception) {
            try {
                oracleWallet = new OracleWallet();
                oracleWallet.open(string, null);
                keyStore = oracleWallet.getKeyStore();
                oracleSecretStore = oracleWallet.getSecretStore();
                if (oracleWallet.isAutoLoginOnly()) {
                    System.out.println("Found Auto Login Only (ALO) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                } else {
                    System.out.println("Found Auto Login (AL) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                }
            }
            catch (Exception exception2) {
                System.out.println(exception.getLocalizedMessage());
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                return;
            }
        }
        if (bl) {
            Object object;
            try {
                object = oracleWallet.getPkcs11Info();
                if (object != null && object[0] != null) {
                    System.out.println("PKCS11 token information:");
                    System.out.println("  Library:" + (String)object[0]);
                    if (object[1] != null) {
                        System.out.println("  Token label:" + (String)object[1]);
                    }
                    if (object[2] != null) {
                        System.out.println("  Token passphrase:<...>");
                    }
                    if (object[3] != null) {
                        System.out.println("  Certificate label:" + (String)object[3]);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println(a.getString("GEN_UNKNOWN_ERROR") + string);
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                return;
            }
            try {
                Object object2;
                Object object3;
                System.out.println("Requested Certificates: ");
                object = keyStore.aliases();
                while (object.hasMoreElements()) {
                    object3 = (String)object.nextElement();
                    if (!keyStore.isKeyEntry((String)object3) || keyStore.getCertificate((String)object3) != null || (object2 = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)object3, null)).getCertificateRequest()) == null) continue;
                    System.out.println("Subject:        " + object2.getSubject());
                }
                System.out.println("User Certificates:");
                object = keyStore.aliases();
                while (object.hasMoreElements()) {
                    object3 = (String)object.nextElement();
                    if (!keyStore.isKeyEntry((String)object3) || (object2 = (OraclePKIX509CertImpl)keyStore.getCertificate((String)object3)) == null) continue;
                    System.out.println("Subject:        " + ((OraclePKIX509CertImpl)object2).getSubjectDN());
                }
                object3 = oracleWallet.getSecretStore().internalAliases();
                if (object3.hasMoreElements()) {
                    System.out.println(a.getString("ENTRIES_LIST"));
                }
                while (object3.hasMoreElements()) {
                    System.out.println(object3.nextElement());
                }
                System.out.println("Trusted Certificates: ");
                object = keyStore.aliases();
                while (object.hasMoreElements()) {
                    object2 = (String)object.nextElement();
                    if (!keyStore.isCertificateEntry((String)object2)) continue;
                    OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate((String)object2);
                    System.out.println("Subject:        " + oraclePKIX509CertImpl.getSubjectDN());
                }
            }
            catch (Exception exception) {
                System.out.println(a.getString("GEN_UNKNOWN_ERROR") + string);
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                return;
            }
        }
    }

    public static void change_pwd(String[] stringArray) {
        char[] cArray;
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-oldpwd")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-newpwd")) {
                    string3 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-obpwd_old")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i2].equals("-obpwd_new")) {
                    bl2 = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        char[] cArray2 = OraclePKIGenFunc.getPassword(string2, bl, "WALLET_PASSWORD_PROMPT");
        if (string3 == null) {
            System.out.println("New password:");
        }
        if (!OracleWallet.isValidPassword(cArray = OraclePKIGenFunc.getPassword(string3, bl2, "WALLET_PASSWORD_PROMPT"))) {
            System.out.println(a.getString("PKI-01002"));
            return;
        }
        if (Arrays.equals(cArray2, cArray)) {
            System.out.println("Unable to change the password, old and new password should not be same.");
            return;
        }
        OracleWallet oracleWallet = new OracleWallet();
        try {
            oracleWallet.open(string, cArray2);
            oracleWallet.changePassword(cArray);
            oracleWallet.saveAs(string);
        }
        catch (Exception exception) {
            System.out.println(a.getString("PKI-02003") + string);
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            return;
        }
    }

    public static void p11_verify(String[] stringArray) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        char[] cArray = OraclePKIGenFunc.getPassword(string2, bl, "WALLET_PASSWORD_PROMPT");
        NZWallet nZWallet = null;
        try {
            nZWallet = NZWallet.getPersonasWithTypeOld_P11((String)("file:" + string), (String)new String(cArray));
            nZWallet.setWRL_P11("file:" + string);
            nZWallet.setPersonaTypes_P11(new String(cArray));
        }
        catch (Exception exception) {
            System.out.println(a.getString("PKI-02003") + string);
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            return;
        }
        try {
            nZWallet.verifyPkcs11Credentials();
        }
        catch (NZException nZException) {
            System.out.println("Error: " + nZException.getExceptionId());
        }
    }

    public static void p11_add(String[] stringArray) {
        block20: {
            OracleWallet oracleWallet;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            boolean bl = false;
            if (stringArray.length == 0) {
                System.out.println(b);
                return;
            }
            try {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (stringArray[i2].equals("-wallet")) {
                        string = stringArray[++i2];
                        continue;
                    }
                    if (stringArray[i2].equals("-p11_lib")) {
                        string2 = stringArray[++i2];
                        continue;
                    }
                    if (stringArray[i2].equals("-p11_tokenlabel")) {
                        string3 = stringArray[++i2];
                        continue;
                    }
                    if (stringArray[i2].equals("-p11_tokenpw")) {
                        string4 = stringArray[++i2];
                        continue;
                    }
                    if (stringArray[i2].equals("-p11_certlabel")) {
                        string5 = stringArray[++i2];
                        continue;
                    }
                    if (stringArray[i2].equals("-pwd")) {
                        string6 = stringArray[++i2];
                        continue;
                    }
                    if (stringArray[i2].equals("-obpwd")) {
                        bl = true;
                        continue;
                    }
                    System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                    System.out.println(b);
                    return;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println(b);
                return;
            }
            char[] cArray = OraclePKIGenFunc.getPassword(string6, bl, "WALLET_PASSWORD_PROMPT");
            try {
                oracleWallet = OraclePKIGenFunc.openAWallet(string, string6, bl);
            }
            catch (Exception exception) {
                System.out.println(a.getString("PKI-02003") + string);
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                return;
            }
            try {
                if (string2 == null) {
                    System.out.println("pkcs11 library location is required");
                    return;
                }
                oracleWallet.addP11Lib(string2);
                if (string3 != null) {
                    oracleWallet.addP11TokenLabel(string3);
                }
                if (string4 != null) {
                    oracleWallet.addP11TokenPwd(string4);
                }
                if (string5 != null) {
                    oracleWallet.addP11CertLbl(string5);
                }
                oracleWallet.saveAs(string);
            }
            catch (Exception exception) {
                System.out.println("Add pkcs11 info to wallet failed: " + exception.toString());
                if (!OraclePKIDebug.getDebugFlag()) break block20;
                exception.printStackTrace();
            }
        }
    }

    public static void p11_test(String[] stringArray) {
        block13: {
            OracleWallet oracleWallet;
            boolean bl;
            String string;
            String string2;
            block12: {
                string2 = null;
                string = null;
                bl = false;
                String string3 = "/usr/lunasa/lib/libCryptoki2.so";
                String string4 = "partition_1";
                String string5 = "....";
                if (stringArray.length == 0) {
                    System.out.println(b);
                    return;
                }
                try {
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        if (stringArray[i2].equals("-wallet")) {
                            string2 = stringArray[++i2];
                            continue;
                        }
                        if (stringArray[i2].equals("-pwd")) {
                            string = stringArray[++i2];
                            continue;
                        }
                        if (stringArray[i2].equals("-obpwd")) {
                            bl = true;
                            continue;
                        }
                        System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                        System.out.println(b);
                        return;
                    }
                }
                catch (Exception exception) {
                    System.out.println("pkcs11 test failed: " + exception.toString());
                    if (!OraclePKIDebug.getDebugFlag()) break block12;
                    exception.printStackTrace();
                }
            }
            char[] cArray = OraclePKIGenFunc.getPassword(string, bl, "WALLET_PASSWORD_PROMPT");
            try {
                oracleWallet = OraclePKIGenFunc.openAWallet(string2, string, bl);
            }
            catch (Exception exception) {
                System.out.println(a.getString("PKI-02003") + string2);
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                return;
            }
            try {
                X509Certificate x509Certificate = oracleWallet.getSSLCert(true);
                byte[] byArray = x509Certificate.getEncoded();
                String string6 = oracleWallet.getSSLCertAlias(true);
                byte[] byArray2 = oracleWallet.getPPvtBytesUnEnc(0, string6);
                oracleWallet.removePrivateKey(string6);
                oracleWallet.saveAs(string2);
            }
            catch (Exception exception) {
                System.out.println("Add pvt key to HSM failed: " + exception.toString());
                if (!OraclePKIDebug.getDebugFlag()) break block13;
                exception.printStackTrace();
            }
        }
    }

    public static void test_api(String[] stringArray) {
        boolean bl = false;
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-auto_login")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-obpwd")) {
                    bl2 = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        try {
            Object object;
            OracleWallet oracleWallet;
            OracleWallet oracleWallet2 = OraclePKIGenFunc.openAWallet(string, string2, bl2);
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            if (string2 != null) {
                inputStream = oracleWallet2.getWalletArray(false);
                inputStream2 = oracleWallet2.getWalletArray(true);
            } else {
                inputStream2 = oracleWallet2.getWalletArray(true);
            }
            if (string2 != null) {
                oracleWallet = new OracleWallet();
                oracleWallet.setWalletArray(inputStream, string2.toCharArray());
            }
            oracleWallet = new OracleWallet();
            oracleWallet.setWalletArray(inputStream2, null);
            boolean bl3 = oracleWallet.isAutoLoginOnly();
            if (bl3) {
                System.out.println("Wallet is auto login only (ALO).");
            } else {
                System.out.println("Wallet is not auto login only (ALO).");
            }
            int n2 = oracleWallet.getPersonaCount();
            X500Principal[] x500PrincipalArray = oracleWallet.getCertReqDNs(0);
            System.out.println("Number of certificate requests in wallet:" + oracleWallet.getCertReqCount(0));
            for (int i3 = 0; i3 < x500PrincipalArray.length; ++i3) {
                String[] stringArray2 = oracleWallet.getCertReqInfo(0, i3);
                System.out.println("   DN:" + stringArray2[0] + ", keysize:" + stringArray2[1] + " bytes, " + " keytype:" + stringArray2[2]);
            }
            X500Principal[] x500PrincipalArray2 = oracleWallet.getCertDNs(0);
            System.out.println("Number of certs in wallet:" + oracleWallet.getCertCount(0));
            for (int i4 = 0; i4 < x500PrincipalArray2.length; ++i4) {
                X509Certificate x509Certificate = oracleWallet.getCert(0, i4);
                System.out.println("  " + x509Certificate.getSubjectX500Principal());
            }
            X500Principal[] x500PrincipalArray3 = oracleWallet.getTrustpointDNs(0);
            System.out.println("Number of trusted certs in wallet:" + oracleWallet.getTrustpointCount(0));
            for (int i5 = 0; i5 < x500PrincipalArray3.length; ++i5) {
                object = oracleWallet.getTrustpoint(0, i5);
                System.out.println("  " + ((X509Certificate)object).getSubjectX500Principal());
            }
            X509Certificate x509Certificate = oracleWallet.getSSLCert(false);
            if (x509Certificate != null) {
                System.out.println("During SSL cert with DN \"" + x509Certificate.getSubjectDN() + "\" will be used");
            } else {
                System.out.println("No SSL cert found in wallet.");
            }
            object = "-----BEGIN CERTIFICATE-----\nMIIBKzCB1gIBADANBgkqhkiG9w0BAQQFADAhMQswCQYDVQQGEwJVUzESMBAGA1UEAwwJcm9vdF90\nZXN0MB4XDTA2MDQyNzE5MTM1N1oXDTE2MDQyNDE5MTM1N1owITELMAkGA1UEBhMCVVMxEjAQBgNV\nBAMMCXRlc3RfdGVzdDBcMA0GCSqGSIb3DQEBAQUAA0sAMEgCQQCd8QhmcTRmq9/GN+xATEZsQC7C\nnvkOl8Mfy5qXClyU/UdMFBZPC3oCylxjdekg286Kjlf3UPKHYkMg8EHk6ULZAgMBAAEwDQYJKoZI\nhvcNAQEEBQADQQBlEVBYPyavz07/8NrgbEMYJpQ/r1D517w1eVx6XqUpW64rEYV1aBYh73yyTleN\n4FTnoda3JkKujFFaYVBWAogA\n-----END CERTIFICATE-----";
            String string3 = OraclePKIX509CertHelper.removeCertHeaderFooter((String)object);
            String string4 = OraclePKIX509CertHelper.addCertHeaderFooter(string3);
            OracleWallet oracleWallet3 = new OracleWallet();
            oracleWallet3.createSSO();
            oracleWallet3.importCert(new ByteArrayInputStream(string4.getBytes()), true);
            String string5 = "-----BEGIN NEW CERTIFICATE REQUEST-----\nMIHbMIGGAgEAMCExCzAJBgNVBAYTAlVTMRIwEAYDVQQDDAl0ZXN0X3Rlc3QwXDANBgkqhkiG9w0B\nAQEFAANLADBIAkEAnfEIZnE0ZqvfxjfsQExGbEAuwp75DpfDH8ualwpclP1HTBQWTwt6AspcY3Xp\nINvOio5X91Dyh2JDIPBB5OlC2QIDAQABoAAwDQYJKoZIhvcNAQEEBQADQQAo3oNVwcYy4yhXMHIc\n7u8E2u8zJkTYRgZ7S7W1D0QutglTMbvB+wmeMkgQEPqM4M3NUg3z0VsgVxA0eizUhCWt\n-----END NEW CERTIFICATE REQUEST-----";
            String string6 = OraclePKIX509CertReqHelper.removeCertReqHeaderFooter(string5);
            String string7 = OraclePKIX509CertReqHelper.addCertReqHeaderFooter(string6);
            OraclePKIX509CertReqHelper.readB64CertReqFrom(new StringReader(string7));
        }
        catch (Exception exception) {
            System.out.println("test_api failed: " + exception.toString());
            return;
        }
    }

    public static void remove(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string4 = null;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-dn")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-trusted_cert_all")) {
                    bl = true;
                    bl2 = false;
                    bl3 = false;
                    bl4 = false;
                    continue;
                }
                if (stringArray[i2].equals("-trusted_cert")) {
                    bl = false;
                    bl2 = true;
                    bl3 = false;
                    bl4 = false;
                    continue;
                }
                if (stringArray[i2].equals("-user_cert")) {
                    bl = false;
                    bl2 = false;
                    bl3 = true;
                    bl4 = false;
                    continue;
                }
                if (stringArray[i2].equals("-cert_req")) {
                    bl = false;
                    bl2 = false;
                    bl3 = false;
                    bl4 = true;
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string3 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-obpwd")) {
                    bl5 = true;
                    continue;
                }
                if (stringArray[i2].equals("-auto_login_only")) {
                    bl6 = true;
                    continue;
                }
                if (stringArray[i2].equals("-alias")) {
                    string4 = stringArray[++i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        if (bl6 && string3 != null) {
            System.out.println(b);
            return;
        }
        try {
            block49: {
                OracleWallet oracleWallet;
                try {
                    oracleWallet = OraclePKIGenFunc.openAWallet(string, string3, bl5);
                }
                catch (Exception exception) {
                    System.out.println(a.getString("PKI-02003") + string);
                    if (OraclePKIDebug.getDebugFlag()) {
                        exception.printStackTrace();
                    }
                    return;
                }
                if (oracleWallet.isAutoLoginOnly() && !bl6 || !oracleWallet.isAutoLoginOnly() && bl6) {
                    System.out.println(b);
                    return;
                }
                if (bl) {
                    try {
                        oracleWallet.removeTrustpoints();
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getLocalizedMessage());
                        if (OraclePKIDebug.getDebugFlag()) {
                            exception.printStackTrace();
                        }
                        return;
                    }
                } else if (bl2) {
                    try {
                        if (string2 != null) {
                            oracleWallet.removeTrustpoint(new X500Principal(string2));
                        }
                        if (string4 != null) {
                            oracleWallet.removeTrustpoint(string4);
                        }
                        System.out.println("Please provide DN or alias");
                        return;
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getLocalizedMessage());
                        if (OraclePKIDebug.getDebugFlag()) {
                            exception.printStackTrace();
                        }
                        return;
                    }
                } else if (bl3) {
                    try {
                        if (string2 != null) {
                            oracleWallet.deleteCert(new X500Principal(string2));
                        }
                        if (string4 != null) {
                            oracleWallet.deleteCert(string4);
                        }
                        System.out.println("Please provide DN or alias");
                        return;
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getLocalizedMessage());
                        if (OraclePKIDebug.getDebugFlag()) {
                            exception.printStackTrace();
                        }
                        return;
                    }
                } else if (bl4) {
                    try {
                        if (string2 != null) {
                            oracleWallet.deleteCertReq(new X500Principal(string2));
                        }
                        if (string4 != null) {
                            oracleWallet.deleteCertReq(string4);
                        }
                        System.out.println("Please provide DN or alias");
                        return;
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getLocalizedMessage());
                        if (OraclePKIDebug.getDebugFlag()) {
                            exception.printStackTrace();
                        }
                        return;
                    }
                } else {
                    System.out.println(b);
                    return;
                }
                try {
                    oracleWallet.saveAs(string);
                }
                catch (IOException iOException) {
                    System.out.println("Wallet save failed.");
                    if (!OraclePKIDebug.getDebugFlag()) break block49;
                    iOException.printStackTrace();
                }
            }
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }

    public static void verifychain(String[] stringArray) {
        Object object;
        OracleWallet oracleWallet;
        String string = null;
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl2 = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equals("-wallet")) {
                string = stringArray[++i2];
                continue;
            }
            if (stringArray[i2].equals("-dn")) {
                string5 = stringArray[++i2];
                continue;
            }
            if (stringArray[i2].equals("-trustchain")) {
                string3 = stringArray[++i2];
                continue;
            }
            if (stringArray[i2].equals("-cert")) {
                string4 = stringArray[++i2];
                continue;
            }
            if (stringArray[i2].equals("-pwd")) {
                string2 = stringArray[++i2];
                continue;
            }
            if (stringArray[i2].equals("-obpwd")) {
                bl = true;
                continue;
            }
            if (stringArray[i2].equals("-lowestTp")) {
                bl2 = true;
                continue;
            }
            System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
            System.out.println(b);
            return;
        }
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, bl);
        }
        catch (Exception exception) {
            System.out.println(a.getString("PKI-02003"));
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = new FileInputStream(string3);
            int n2 = ((InputStream)object).read();
            while (n2 != -1) {
                byteArrayOutputStream.write((byte)n2);
                n2 = ((InputStream)object).read();
            }
        }
        catch (IOException iOException) {
            System.out.println("Unable to read cert chain at " + string3);
            return;
        }
        try {
            object = oracleWallet.trustpointNeededB64(byteArrayOutputStream.toString(), string5, bl2);
            if (object == null) {
                System.out.println("Matching trustpoint exists in wallet.");
                return;
            }
            FileWriter fileWriter = new FileWriter(string4);
            fileWriter.write((String)object);
            fileWriter.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void add(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string9 = null;
        boolean bl4 = false;
        boolean bl5 = false;
        String string10 = null;
        String string11 = null;
        BigInteger bigInteger = null;
        boolean bl6 = false;
        int n2 = 0;
        boolean bl7 = false;
        String string12 = null;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-dn")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-keysize")) {
                    string3 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-validity")) {
                    string4 = stringArray[++i2];
                    try {
                        n2 = Integer.parseInt(string4);
                        if (n2 <= 0) {
                            throw new NumberFormatException("");
                        }
                        if (n2 <= 182500) continue;
                        System.out.println("Validity should not be more than 182500 days.");
                        return;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Validity must be a positive integer.");
                        return;
                    }
                }
                if (stringArray[i2].equals("-valid_from")) {
                    string5 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-valid_until")) {
                    string6 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-self_signed")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i2].equals("-request")) {
                    string7 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-cert")) {
                    string8 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-trusted_cert")) {
                    bl2 = true;
                    bl3 = false;
                    continue;
                }
                if (stringArray[i2].equals("-user_cert")) {
                    bl2 = false;
                    bl3 = true;
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string9 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-obpwd")) {
                    bl4 = true;
                    continue;
                }
                if (stringArray[i2].equals("-addext_ski")) {
                    bl7 = true;
                    continue;
                }
                if (stringArray[i2].equals("-auto_login_only")) {
                    bl5 = true;
                    continue;
                }
                if (stringArray[i2].equals("-serial_file")) {
                    string10 = stringArray[++i2];
                    bigInteger = OraclePKIGenFunc.getSerialNum(string10);
                    bigInteger = bigInteger.add(BigInteger.ONE);
                    bl6 = true;
                    continue;
                }
                if (stringArray[i2].equals("-serial_num")) {
                    string11 = stringArray[++i2];
                    bigInteger = new BigInteger(string11);
                    bl6 = true;
                    continue;
                }
                if (stringArray[i2].equals("-alias")) {
                    string12 = stringArray[++i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        if (string9 != null && bl5) {
            System.out.println(b);
            return;
        }
        if (bl && bl6 && bigInteger == null) {
            System.out.println("Serial number should not be null....");
            return;
        }
        try {
            OracleWallet oracleWallet;
            try {
                oracleWallet = OraclePKIGenFunc.openAWallet(string, string9, bl4);
            }
            catch (Exception exception) {
                System.out.println(a.getString("PKI-02003") + string);
                if (!OraclePKIDebug.getDebugFlag()) return;
                exception.printStackTrace();
                return;
            }
            if (oracleWallet.isAutoLoginOnly() && !bl5 || !oracleWallet.isAutoLoginOnly() && bl5) {
                System.out.println(b);
                return;
            }
            if (bl) {
                if (string5 == null && string6 != null || string5 != null && string6 == null || string5 == null && string6 == null && string4 == null || string5 != null && string6 != null && string4 != null) {
                    System.out.println("Please specify [-validity] alone OR both [-valid_from] and [-valid_until]");
                    return;
                }
                int n3 = 0;
                n3 = Integer.parseInt(string3);
                try {
                    if (n2 == 0) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
                        Date date = simpleDateFormat.parse(string5, new ParsePosition(0));
                        Date date2 = simpleDateFormat.parse(string6, new ParsePosition(0));
                        if (date == null || date2 == null) {
                            System.out.println("Please follow the format [mm/dd/yyyy] for valid_from and valid_until");
                            return;
                        }
                        if (bl7) {
                            OracleCertExtension oracleCertExtension = new OracleCertExtension();
                            oracleCertExtension.setSubjectKeyId(true);
                            if (!bl6) {
                                if (string12 == null) {
                                    oracleWallet.createSelfSigned(new X500Principal(string2), n3, date, date2, BigInteger.ZERO, oracleCertExtension);
                                } else {
                                    oracleWallet.createSelfSigned(new X500Principal(string2), n3, date, date2, BigInteger.ZERO, oracleCertExtension, string12);
                                }
                            } else if (string12 == null) {
                                oracleWallet.createSelfSigned(new X500Principal(string2), n3, date, date2, bigInteger, oracleCertExtension);
                            } else {
                                oracleWallet.createSelfSigned(new X500Principal(string2), n3, date, date2, bigInteger, oracleCertExtension, string12);
                            }
                        } else if (!bl6) {
                            if (string12 == null) {
                                oracleWallet.createSelfSigned(new X500Principal(string2), n3, date, date2);
                            } else {
                                oracleWallet.createSelfSigned(new X500Principal(string2), n3, date, date2, BigInteger.ZERO, string12);
                            }
                        } else if (string12 == null) {
                            oracleWallet.createSelfSigned(new X500Principal(string2), n3, date, date2, bigInteger);
                        } else {
                            oracleWallet.createSelfSigned(new X500Principal(string2), n3, date, date2, bigInteger, string12);
                        }
                    } else if (bl7) {
                        OracleCertExtension oracleCertExtension = new OracleCertExtension();
                        oracleCertExtension.setSubjectKeyId(true);
                        if (!bl6) {
                            if (string12 == null) {
                                oracleWallet.createSelfSigned(new X500Principal(string2), n3, n2, BigInteger.ZERO, oracleCertExtension);
                            } else {
                                oracleWallet.createSelfSigned(new X500Principal(string2), n3, n2, BigInteger.ZERO, oracleCertExtension, string12);
                            }
                        } else if (string12 == null) {
                            oracleWallet.createSelfSigned(new X500Principal(string2), n3, n2, bigInteger, oracleCertExtension);
                        } else {
                            oracleWallet.createSelfSigned(new X500Principal(string2), n3, n2, bigInteger, oracleCertExtension, string12);
                        }
                    } else if (!bl6) {
                        if (string12 == null) {
                            oracleWallet.createSelfSigned(new X500Principal(string2), n3, n2);
                        } else {
                            oracleWallet.createSelfSigned(new X500Principal(string2), n3, n2, BigInteger.ZERO, string12);
                        }
                    } else if (string12 == null) {
                        oracleWallet.createSelfSigned(new X500Principal(string2), n3, n2, bigInteger);
                    } else {
                        oracleWallet.createSelfSigned(new X500Principal(string2), n3, n2, bigInteger, string12);
                    }
                    oracleWallet.save();
                    if (string10 == null) return;
                    OraclePKIGenFunc.updateSerialNum(string10, bigInteger);
                    return;
                }
                catch (Exception exception) {
                    System.out.println(exception.getLocalizedMessage());
                    if (!OraclePKIDebug.getDebugFlag()) return;
                    exception.printStackTrace();
                    return;
                }
            }
            if (string8 != null) {
                try {
                    InputStream inputStream;
                    try {
                        inputStream = new URL(string8).openStream();
                    }
                    catch (MalformedURLException malformedURLException) {
                        inputStream = new FileInputStream(string8);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n4 = inputStream.read();
                    while (n4 != -1) {
                        byteArrayOutputStream.write((byte)n4);
                        n4 = inputStream.read();
                    }
                    if (bl2) {
                        try {
                            if (string12 == null) {
                                oracleWallet.importCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), true);
                            }
                            oracleWallet.importCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), true, string12);
                        }
                        catch (Exception exception) {
                            System.out.println("Could not install trusted cert at" + string8);
                            System.out.println(exception.getLocalizedMessage());
                            if (!OraclePKIDebug.getDebugFlag()) return;
                            exception.printStackTrace();
                            return;
                        }
                    } else if (bl3) {
                        try {
                            if (string12 == null) {
                                oracleWallet.importCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), false);
                            } else {
                                oracleWallet.importCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), false, string12);
                            }
                        }
                        catch (Exception exception) {
                            System.out.println(exception.getLocalizedMessage());
                            System.out.println("Could not install user cert at" + string8);
                            System.out.println("Please add all trusted certificates before adding the user certificate");
                            return;
                        }
                    }
                    oracleWallet.saveAs(string);
                    return;
                }
                catch (IOException iOException) {
                    System.out.println("Unable to read certificate at " + string8);
                }
                return;
            }
            if (string2 != null) {
                int n5 = 0;
                n5 = Integer.parseInt(string3);
                try {
                    if (bl7) {
                        OracleCertExtension oracleCertExtension = new OracleCertExtension();
                        oracleCertExtension.setSubjectKeyId(true);
                        if (string12 == null) {
                            oracleWallet.addCertRequest(new X500Principal(string2), n5, oracleCertExtension);
                        } else {
                            oracleWallet.addCertRequest(new X500Principal(string2), n5, oracleCertExtension, string12);
                        }
                    } else if (string12 == null) {
                        oracleWallet.addCertRequest(new X500Principal(string2), n5);
                    } else {
                        oracleWallet.addCertRequest(new X500Principal(string2), n5, string12);
                    }
                    oracleWallet.saveAs(string);
                    return;
                }
                catch (Exception exception) {
                    System.out.println(exception.getLocalizedMessage());
                    return;
                }
            }
            if (string8 == null) return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public static void export(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        X500Principal x500Principal = null;
        String string6 = null;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-dn")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-request")) {
                    string3 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-cert")) {
                    string4 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string5 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i2].equals("-alias")) {
                    string6 = stringArray[++i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        try {
            if (string2 != null) {
                x500Principal = new X500Principal(string2);
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Please provide : -dn [dn]");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Please provide proper DN.");
            return;
        }
        OracleWallet oracleWallet = null;
        KeyStore keyStore = null;
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string5, bl);
            keyStore = oracleWallet.getKeyStore();
        }
        catch (Exception exception) {
            try {
                oracleWallet = new OracleWallet();
                oracleWallet.open(string, null);
                keyStore = oracleWallet.getKeyStore();
                if (oracleWallet.isAutoLoginOnly()) {
                    System.out.println("Found Auto Login Only (ALO) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                } else {
                    System.out.println("Found Auto Login (AL) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                }
            }
            catch (Exception exception2) {
                System.out.println(exception.getLocalizedMessage());
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                return;
            }
        }
        if (string4 != null) {
            try {
                String string7 = null;
                if (x500Principal != null) {
                    string7 = oracleWallet.exportCertB64(x500Principal);
                } else if (string6 != null) {
                    string7 = oracleWallet.exportCertB64(string6);
                } else {
                    System.out.println("Please provide DN or alias");
                    return;
                }
                if (string7 == null) {
                    System.out.println("Please check DN, could not found certificate with matching DN.");
                    return;
                }
                FileWriter fileWriter = new FileWriter(string4);
                fileWriter.write(string7);
                fileWriter.flush();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                return;
            }
        }
        if (string3 != null) {
            try {
                String string8 = null;
                if (x500Principal != null) {
                    string8 = oracleWallet.exportCertReqB64(x500Principal);
                } else if (string6 != null) {
                    string8 = oracleWallet.exportCertReqB64(string6);
                } else {
                    System.out.println("Please provide DN or alias");
                    return;
                }
                if (string8 == null) {
                    System.out.println("Please check DN, could not found certificate request with matching DN.");
                    return;
                }
                FileWriter fileWriter = new FileWriter(string3);
                fileWriter.write(string8);
                fileWriter.flush();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                return;
            }
        }
    }

    public static void exportchain(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        String string5 = null;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-dn")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-certchain")) {
                    string3 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string4 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i2].equals("-alias")) {
                    string5 = stringArray[++i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        OracleWallet oracleWallet = null;
        String string6 = null;
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string4, bl);
        }
        catch (Exception exception) {
            try {
                oracleWallet = new OracleWallet();
                oracleWallet.open(string, null);
                if (oracleWallet.isAutoLoginOnly()) {
                    System.out.println("Found Auto Login Only (ALO) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                } else {
                    System.out.println("Found Auto Login (AL) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                }
            }
            catch (Exception exception2) {
                System.out.println(exception.getLocalizedMessage());
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                return;
            }
        }
        try {
            string6 = string2 != null ? oracleWallet.exportCertChainB64(new X500Principal(string2)) : (string5 != null ? oracleWallet.exportCertChainB64(string5) : oracleWallet.exportUserCertChainB64());
            FileWriter fileWriter = new FileWriter(string3);
            fileWriter.write(string6);
            fileWriter.flush();
        }
        catch (Exception exception) {
            System.out.println("Unable to export trust chain.");
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            return;
        }
    }

    private static char[] a() {
        boolean bl;
        char[] cArray = null;
        char[] cArray2 = null;
        do {
            bl = (cArray = OraclePKIGenFunc.getPassword("ENTER_PASSWORD")).length == (cArray2 = OraclePKIGenFunc.getPassword("ENTER_PASSWORD_AGAIN")).length;
            for (int i2 = 0; i2 < cArray.length && bl; ++i2) {
                bl = cArray[i2] == cArray2[i2];
            }
            if (bl) continue;
            System.out.println(a.getString("PKI-01003"));
        } while (!bl);
        return cArray;
    }

    public static void isTrustedCertUsedInChain(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\nis_tcert_used_in_chain [-wallet [wallet]] [-pwd [pwd]] [-dn [dn]]\nhelp");
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equals("-wallet")) {
                string = stringArray[++i2];
                continue;
            }
            if (stringArray[i2].equals("-pwd")) {
                string2 = stringArray[++i2];
                continue;
            }
            if (stringArray[i2].equals("-dn")) {
                string3 = stringArray[++i2];
                continue;
            }
            System.out.println("wallet:\nis_tcert_used_in_chain [-wallet [wallet]] [-pwd [pwd]] [-dn [dn]]\nhelp");
            return;
        }
        try {
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
            System.out.println("Result of isTrustedCertUsedInChain = " + oracleWallet.isTrustedCertUsedInChain(new X500Principal(string3)));
        }
        catch (Exception exception) {
            System.out.println("Exception in isTrustedCertUsedInChain : " + exception);
        }
    }

    public static void getCertreqInfo(String[] stringArray) {
        String string = null;
        String string2 = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\nget_certreq_info [-wallet [wallet]] [-pwd [pwd]]\nhelp");
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equals("-wallet")) {
                string = stringArray[++i2];
                continue;
            }
            if (stringArray[i2].equals("-pwd")) {
                string2 = stringArray[++i2];
                continue;
            }
            System.out.println("wallet:\nget_certreq_info [-wallet [wallet]] [-pwd [pwd]]\nhelp");
            return;
        }
        try {
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
            String[] stringArray2 = oracleWallet.getCertReqInfo(0, 0);
            System.out.println("DN      : " + stringArray2[0]);
            System.out.println("keySize : " + stringArray2[1]);
            System.out.println("keyType : " + stringArray2[2]);
            System.out.println("alias   : " + stringArray2[3]);
        }
        catch (Exception exception) {
            System.out.println("Exception in getCertreqInfo : " + exception);
        }
    }

    public static void getCertReqCountDNs(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\nget_certreq_count_dns [-wallet [wallet]] [-pwd [pwd]] [-isNonissuedCertOnly [true|false]]\nhelp");
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equals("-wallet")) {
                string = stringArray[++i2];
                continue;
            }
            if (stringArray[i2].equals("-pwd")) {
                string2 = stringArray[++i2];
                continue;
            }
            if (stringArray[i2].equals("-isNonissuedCertOnly")) {
                string3 = stringArray[++i2];
                continue;
            }
            System.out.println("wallet:\nget_certreq_count_dns [-wallet [wallet]] [-pwd [pwd]] [-isNonissuedCertOnly [true|false]]\nhelp");
            return;
        }
        try {
            Boolean bl = Boolean.valueOf(string3);
            boolean bl2 = bl;
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
            int n2 = oracleWallet.getCertReqCount(0, bl2);
            System.out.println("Certificate Request Count = " + n2);
            X500Principal[] x500PrincipalArray = oracleWallet.getCertReqDNs(0, bl2);
            System.out.println("Certificate Request DNs info : ");
            for (int i3 = 0; i3 < x500PrincipalArray.length; ++i3) {
                System.out.println("Subject : " + x500PrincipalArray[i3]);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in getCertReqCountDNs : " + exception);
        }
    }

    public static void isValidPassword(String[] stringArray) {
        String string = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\nvalidate_pswd [-pwd [pwd]]\nhelp");
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals("-pwd")) {
                System.out.println("wallet:\nvalidate_pswd [-pwd [pwd]]\nhelp");
                return;
            }
            string = stringArray[++i2];
        }
        if (OracleWallet.isValidPassword(string.toCharArray())) {
            System.out.println("Result : Valid Password");
        } else {
            System.out.println(a.getString("PKI-01002"));
        }
    }

    public static void getKeysizes(String[] stringArray) {
        if (stringArray.length == 0) {
            int[] nArray = OracleWallet.getKeysizes();
            System.out.print("Supported keysizes : ");
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                System.out.print("\t" + nArray[i2]);
            }
            System.out.println();
        } else {
            System.out.println("wallet:\nget_keysizes\nhelp");
        }
    }
}

