/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.pki.OracleCRL;
import oracle.security.pki.OraclePKIPrincipalImpl;
import oracle.security.pki.OraclePKIX509CrlFileStore;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.ldap.ConnectionUtil;
import oracle.security.pki.textui.OraclePKIGenFunc;
import sun.misc.BASE64Encoder;

public class OracleCRLTextUI {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    private static final String b = "-----BEGIN X509 CRL-----";
    private static final String c = "-----END X509 CRL-----";

    public static void command(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        if (stringArray[0].equals("help")) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        if (stringArray[0].equals("hash")) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            OracleCRLTextUI.hashName(stringArray2);
        } else if (stringArray[0].equals("upload")) {
            String[] stringArray3 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray3, 0, stringArray3.length);
            OracleCRLTextUI.upload(stringArray3);
        } else if (stringArray[0].equals("delete")) {
            String[] stringArray4 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray4, 0, stringArray4.length);
            OracleCRLTextUI.delete(stringArray4);
        } else if (stringArray[0].equals("list")) {
            String[] stringArray5 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray5, 0, stringArray5.length);
            OracleCRLTextUI.list(stringArray5);
        } else if (stringArray[0].equals("display")) {
            String[] stringArray6 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray6, 0, stringArray6.length);
            OracleCRLTextUI.display(stringArray6);
        } else if (stringArray[0].equals("create")) {
            String[] stringArray7 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray7, 0, stringArray7.length);
            OracleCRLTextUI.createCRL(stringArray7);
        } else if (stringArray[0].equals("revoke")) {
            String[] stringArray8 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray8, 0, stringArray8.length);
            OracleCRLTextUI.revokeCertificate(stringArray8);
        } else if (stringArray[0].equals("verify")) {
            String[] stringArray9 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray9, 0, stringArray9.length);
            OracleCRLTextUI.verify(stringArray9);
        } else if (stringArray[0].equals("status")) {
            String[] stringArray10 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray10, 0, stringArray10.length);
            OracleCRLTextUI.revocationStatus(stringArray10);
        } else {
            System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[0]);
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
    }

    public static void createCRL(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        int n2 = 0;
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string3 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-crl")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-nextupdate")) {
                    n2 = Integer.parseInt(stringArray[++i2].trim());
                    continue;
                }
                if (stringArray[i2].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(a.getString("CRL_USE_STRING"));
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        try {
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string2, string3, bl);
            CRL cRL = oracleWallet.createCRL(n2);
            if (cRL == null) {
                System.out.println("Could not create CRL.");
                return;
            }
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            byte[] byArray = cRL.getEncoded();
            String string4 = "-----BEGIN X509 CRL-----\n" + bASE64Encoder.encodeBuffer(byArray) + c + "\n";
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(new String(string4));
            fileWriter.flush();
            System.out.println("Created CRL at : " + string);
        }
        catch (Exception exception) {
            System.out.println("Could not create CRL : " + exception.getLocalizedMessage());
        }
    }

    public static void revokeCertificate(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-wallet")) {
                    string3 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string4 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-crl")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-cert")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(a.getString("CRL_USE_STRING"));
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        try {
            InputStream inputStream;
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string3, string4, bl);
            try {
                inputStream = new URL(string2).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                inputStream = new FileInputStream(string2);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = inputStream.read();
            while (n2 != -1) {
                byteArrayOutputStream.write((byte)n2);
                n2 = inputStream.read();
            }
            CRL cRL = OraclePKIGenFunc.readCRLAt(string);
            CRL cRL2 = oracleWallet.revokeCertificate(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), cRL);
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            byte[] byArray = cRL2.getEncoded();
            String string5 = "-----BEGIN X509 CRL-----\n" + bASE64Encoder.encodeBuffer(byArray) + c + "\n";
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(new String(string5));
            fileWriter.flush();
            System.out.println("Revoked certificate and updated the CRL at : " + string);
        }
        catch (Exception exception) {
            System.out.println("Could not revoke a certificate : " + exception.getLocalizedMessage());
        }
    }

    public static void verify(String[] stringArray) {
        String string = null;
        String string2 = null;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-crl")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-cert")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(a.getString("CRL_USE_STRING"));
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        try {
            InputStream inputStream;
            try {
                inputStream = new URL(string2).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                inputStream = new FileInputStream(string2);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = inputStream.read();
            while (n2 != -1) {
                byteArrayOutputStream.write((byte)n2);
                n2 = inputStream.read();
            }
            CRL cRL = OraclePKIGenFunc.readCRLAt(string);
            boolean bl = OracleWallet.verifyCRLSignature(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), cRL);
            if (bl) {
                System.out.println("Successfully verified CRL signature.");
            } else {
                System.out.println("Failed to Verify CRL signature.");
            }
        }
        catch (Exception exception) {
            System.out.println("Could not verify CRL signature : " + exception.getLocalizedMessage());
        }
    }

    public static void revocationStatus(String[] stringArray) {
        String string = null;
        String string2 = null;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-crl")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-cert")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(a.getString("CRL_USE_STRING"));
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        try {
            InputStream inputStream;
            try {
                inputStream = new URL(string2).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                inputStream = new FileInputStream(string2);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = inputStream.read();
            while (n2 != -1) {
                byteArrayOutputStream.write((byte)n2);
                n2 = inputStream.read();
            }
            CRL cRL = OraclePKIGenFunc.readCRLAt(string);
            boolean bl = OracleWallet.getRevocationStatus(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), cRL);
            if (bl) {
                System.out.println("The certificate has been revoked.");
            } else {
                System.out.println("The certificate is not revoked.");
            }
        }
        catch (Exception exception) {
            System.out.println("Failed with exception : " + exception.getLocalizedMessage());
        }
    }

    public static void hashName(String[] stringArray) {
        CRL cRL;
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        String string4 = null;
        boolean bl3 = false;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-crl")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-wallet")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-symlink")) {
                    ++i2;
                    bl = true;
                    bl2 = false;
                    if (n2 == -1) {
                        n2 = 0;
                    }
                    string3 = stringArray[i2];
                    continue;
                }
                if (stringArray[i2].equals("-copy")) {
                    ++i2;
                    bl2 = true;
                    bl = false;
                    if (n2 == -1) {
                        n2 = 0;
                    }
                    string3 = stringArray[i2];
                    continue;
                }
                if (stringArray[i2].equals("-summary")) {
                    n2 = 1;
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string4 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-obpwd")) {
                    bl3 = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(a.getString("CRL_USE_STRING"));
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        Object var10_12 = null;
        try {
            cRL = OraclePKIGenFunc.readCRLAt(string);
        }
        catch (Exception exception) {
            System.out.println(a.getString("PKI-05001") + string);
            return;
        }
        String string5 = OraclePKIX509CrlFileStore.hashName(cRL.getIssuer());
        if (n2 != 0) {
            System.out.println(a.getString("GEN_ISSUER_OUT") + cRL.getIssuer());
            System.out.println(a.getString("GEN_HASH_OUT") + string5);
        }
        try {
            OracleCRLTextUI.a(string2, cRL, string4, bl3);
        }
        catch (Exception exception) {
            return;
        }
        if (bl2 || bl) {
            File file = new File(string3);
            if (!file.exists()) {
                System.out.println(a.getString("PKI-02006") + string3);
                return;
            }
            if (!file.isDirectory()) {
                System.out.println(a.getString("PKI-02007") + string3);
                return;
            }
            File file2 = new File(file, string5);
            if (bl) {
                String string6 = new File(string).getAbsolutePath();
                String string7 = file2.getAbsolutePath();
                Process process = null;
                try {
                    process = Runtime.getRuntime().exec("ln -s " + string6 + " " + string7);
                    process.waitFor();
                }
                catch (Exception exception) {
                    int n3 = process.exitValue();
                    System.out.println(a.getString("PKI-05005") + n3);
                    return;
                }
                int n4 = process.exitValue();
                if (n4 != 0) {
                    System.out.println(a.getString("PKI-05005") + n4);
                    return;
                }
            } else if (bl2) {
                try {
                    file2.createNewFile();
                    cRL.output((OutputStream)new FileOutputStream(file2));
                }
                catch (IOException iOException) {
                    System.out.println(a.getString("PKI-05002"));
                    return;
                }
            }
        }
    }

    public static void upload(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "";
        String string5 = "389";
        char[] cArray = null;
        boolean bl = false;
        String string6 = null;
        boolean bl2 = false;
        InputStream inputStream = null;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-crl")) {
                    string = stringArray[++i2];
                    try {
                        inputStream = new URL(string).openStream();
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        try {
                            inputStream = new FileInputStream(string);
                            continue;
                        }
                        catch (IOException iOException) {
                            System.out.println("File not found : " + string);
                            return;
                        }
                    }
                    catch (IOException iOException) {
                        System.out.println("Found valid URL but invalid CRL there.");
                        return;
                    }
                }
                if (stringArray[i2].equals("-ldap")) {
                    int n2;
                    if ((n2 = stringArray[++i2].indexOf(58)) > 0) {
                        string2 = stringArray[i2].substring(0, n2);
                        string5 = stringArray[i2].substring(n2 + 1);
                        continue;
                    }
                    string2 = stringArray[i2];
                    continue;
                }
                if (stringArray[i2].equals("-ldappwd")) {
                    cArray = stringArray[++i2].toCharArray();
                    continue;
                }
                if (stringArray[i2].equals("-user")) {
                    string4 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-wallet")) {
                    string3 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-summary")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string6 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-obpwd")) {
                    bl2 = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(a.getString("CRL_USE_STRING"));
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        if (cArray == null) {
            cArray = OraclePKIGenFunc.getPassword("LDAP_PASSWORD_PROMPT");
        }
        try {
            OracleCRL.uploadCRL(string3, string6.toCharArray(), bl2, inputStream, string2, string5, string4, cArray, bl);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println("Could not upload CRL to the directory.");
        }
    }

    private static BasicAttributes a(String string) {
        BasicAttribute basicAttribute = new BasicAttribute("objectclass");
        basicAttribute.add("orclPKICRL");
        basicAttribute.add("cRLDistributionPoint");
        basicAttribute.add("top");
        BasicAttributes basicAttributes = new BasicAttributes(true);
        basicAttributes.put(basicAttribute);
        basicAttributes.put(new BasicAttribute("x509issuer", string));
        return basicAttributes;
    }

    public static void list(String[] stringArray) {
        Object var1_1 = null;
        String string = null;
        Object var3_3 = null;
        Object var4_4 = null;
        String string2 = "389";
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-ldap")) {
                    int n2;
                    if ((n2 = stringArray[++i2].indexOf(58)) > 0) {
                        string = stringArray[i2].substring(0, n2);
                        string2 = stringArray[i2].substring(n2 + 1);
                        continue;
                    }
                    string = stringArray[i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(a.getString("CRL_USE_STRING"));
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        try {
            InitialLdapContext initialLdapContext = null;
            try {
                initialLdapContext = ConnectionUtil.getDefaultDirCtx(string, string2, "", "");
            }
            catch (Exception exception) {
                initialLdapContext = ConnectionUtil.getSSLDirCtx(string, string2, "", "");
            }
            BasicAttributes basicAttributes = OracleCRLTextUI.a(null);
            NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search("cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext", (Attributes)basicAttributes);
            if (!namingEnumeration.hasMore()) {
                System.out.println(a.getString("CRLS_NOT_PRESENT") + string + ":" + string2);
                return;
            }
            System.out.println();
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Attributes attributes = searchResult.getAttributes();
                System.out.println(a.getString("GEN_ISSUER_OUT") + attributes.get("x509issuer").get());
                System.out.println(a.getString("GEN_LOCATION_OUT") + "ldap://" + string + ":" + string2 + "/" + "cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext" + "?" + "certificaterevocationlist" + "?one?" + "x509issuer" + "=" + attributes.get("x509issuer").get());
                System.out.println();
            }
        }
        catch (javax.naming.AuthenticationException authenticationException) {
            System.out.println(a.getString("PKI-07001"));
            return;
        }
        catch (NameNotFoundException nameNotFoundException) {
            System.out.println(a.getString("PKI-07002") + "cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext");
            return;
        }
        catch (NoPermissionException noPermissionException) {
            System.out.println(a.getString("PKI-07003"));
            return;
        }
        catch (NamingException namingException) {
            System.out.println(a.getString("GEN_UNKNOWN_ERROR") + namingException);
            return;
        }
    }

    public static void delete(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = "389";
        String string4 = null;
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-issuer")) {
                    string4 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-ldap")) {
                    int n2;
                    if ((n2 = stringArray[++i2].indexOf(58)) > 0) {
                        string = stringArray[i2].substring(0, n2);
                        string3 = stringArray[i2].substring(n2 + 1);
                        continue;
                    }
                    string = stringArray[i2];
                    continue;
                }
                if (stringArray[i2].equals("-user")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-summary")) {
                    bl = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(a.getString("CRL_USE_STRING"));
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        try {
            InitialLdapContext initialLdapContext = ConnectionUtil.getSSLDirCtx(string, string3, string2, new String(OraclePKIGenFunc.getPassword("LDAP_PASSWORD_PROMPT")));
            BasicAttributes basicAttributes = OracleCRLTextUI.a(string4);
            NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search("cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext", (Attributes)basicAttributes);
            if (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                String string5 = searchResult.getName() + "," + "cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext";
                BasicAttributes basicAttributes2 = new BasicAttributes();
                initialLdapContext.unbind(string5);
                if (bl) {
                    System.out.println(a.getString("LDAP_CRL_DELETED") + string5);
                }
            } else if (bl) {
                System.out.println(a.getString("PKI-05004") + string4);
            }
        }
        catch (javax.naming.AuthenticationException authenticationException) {
            System.out.println(a.getString("PKI-07001"));
            return;
        }
        catch (NameNotFoundException nameNotFoundException) {
            System.out.println(a.getString("PKI-07002") + "cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext");
        }
        catch (NoPermissionException noPermissionException) {
            System.out.println(a.getString("PKI-07003"));
            return;
        }
        catch (NamingException namingException) {
            System.out.println(a.getString("GEN_UNKNOWN_ERROR") + namingException);
            return;
        }
    }

    public static void display(String[] stringArray) {
        CRL cRL;
        String string = null;
        String string2 = null;
        Object var3_3 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = null;
        boolean bl3 = false;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-crl")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-wallet")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-summary")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i2].equals("-complete")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string3 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-obpwd")) {
                    bl3 = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(a.getString("CRL_USE_STRING"));
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            return;
        }
        Object var9_11 = null;
        try {
            cRL = OraclePKIGenFunc.readCRLAt(string);
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            System.out.println("Please check the port, could not display CRL for ssl-port.");
            return;
        }
        catch (Exception exception) {
            System.out.println(a.getString("PKI-05001") + string);
            return;
        }
        if (bl2 && !bl || !bl && !bl2 || bl && bl2) {
            System.out.println(a.getString("GEN_ISSUER_OUT") + cRL.getIssuer());
            System.out.println(a.getString("GEN_DATE_OUT") + cRL.getDate());
            System.out.println(a.getString("CRL_NEXT_DATE_OUT") + cRL.getNextDate());
        } else if (bl && !bl2) {
            if (!cRL.revokedSerialNos().hasMoreElements()) {
                System.out.println(a.getString("GEN_ISSUER_OUT") + cRL.getIssuer());
                System.out.println(a.getString("GEN_DATE_OUT") + cRL.getDate());
                System.out.println(a.getString("CRL_NEXT_DATE_OUT") + cRL.getNextDate());
                System.out.println("There are no Revoked Certificates.");
            } else {
                System.out.println(cRL);
            }
        }
        if (bl && bl2) {
            if (!cRL.revokedSerialNos().hasMoreElements()) {
                System.out.println("There are no Revoked Certificates.");
            } else {
                System.out.println(cRL);
            }
        }
        try {
            OracleCRLTextUI.a(string2, cRL, string3, bl3);
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void a(CRL cRL, OracleWallet oracleWallet) throws AuthenticationException {
        OraclePKIPrincipalImpl oraclePKIPrincipalImpl = new OraclePKIPrincipalImpl(cRL.getIssuer());
        KeyStore keyStore = null;
        Enumeration<String> enumeration = null;
        if (!cRL.verifyDate()) {
            throw new AuthenticationException("CRL expired/not yet valid");
        }
        try {
            keyStore = oracleWallet.getKeyStore();
            enumeration = keyStore.aliases();
        }
        catch (Exception exception) {
            throw new AuthenticationException();
        }
        while (enumeration.hasMoreElements()) {
            try {
                Certificate certificate = keyStore.getCertificate(enumeration.nextElement());
                if (!(certificate instanceof X509Certificate) || !oraclePKIPrincipalImpl.equals(((X509Certificate)certificate).getSubjectDN()) || !certificate.getPublicKey().getAlgorithm().equals("RSA")) continue;
                cRL.setPublicKey((PublicKey)new RSAPublicKey(certificate.getPublicKey().getEncoded()));
                if (!cRL.verify()) continue;
                return;
            }
            catch (KeyStoreException keyStoreException) {
                break;
            }
            catch (IOException iOException) {
                // empty catch block
                break;
            }
        }
        throw new AuthenticationException(a.getString("PKI-05006"));
    }

    private static void a(String string, CRL cRL, String string2, boolean bl) throws Exception {
        if (string != null) {
            OracleWallet oracleWallet;
            try {
                oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, bl);
            }
            catch (Exception exception) {
                System.out.println(a.getString("PKI-02003") + string);
                throw exception;
            }
            try {
                OracleCRLTextUI.a(cRL, oracleWallet);
                System.out.println(a.getString("CRL_VERIFY_OK"));
            }
            catch (AuthenticationException authenticationException) {
                System.out.println(a.getString("PKI-05003"));
                throw authenticationException;
            }
        }
    }

    static {
        System.setProperty("java.protocol.handler.pkgs", "oracle.security.pki");
    }
}

