/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.PKCS12;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12CertBag;
import oracle.security.crypto.cert.PKCS12KeyBag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.cert.PKCS12SecretBag;
import oracle.security.crypto.cert.PKCS12ShroudedKeyBag;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.RSA;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.b;
import oracle.security.pki.d;
import oracle.security.pki.e;
import oracle.security.pki.f;
import oracle.security.pki.i;
import oracle.security.pki.n;
import oracle.security.pki.t;
import oracle.security.wallet.NZNative;

public class OracleKeyStoreSpi
extends KeyStoreSpi {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    private PKCS12 b = null;
    private Hashtable c = new Hashtable();
    private Hashtable d = new Hashtable();
    private String e;
    private String f;
    private String g;
    private String h;
    public static final String p11LibOID = "2.16.840.1.113894.2.99.300.2";
    public static final String p11TokLblOID = "2.16.840.1.113894.2.99.300.3";
    public static final String p11TokPwdOID = "2.16.840.1.113894.2.99.300.4";
    public static final String p11CrtLblOID = "2.16.840.1.113894.2.99.300.5";
    public static final String CREDENTIAL_CONNECT_STRING = "oracle.security.client.connect_string";
    public static final String CREDENTIAL_USERNAME = "oracle.security.client.username";
    public static final String CREDENTIAL_PASSWORD = "oracle.security.client.password";

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.engineContainsAlias(string)) {
            return ((t)this.c.get(string)).d();
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        OraclePKIDebug.a("OracleKeyStoreSpi: getCertificateChain alias \"" + (null == string ? "null" : string) + "\"");
        if (this.engineContainsAlias(string)) {
            return ((t)this.c.get(string)).e();
        }
        return null;
    }

    public Certificate engineGetCertificate(String string) {
        OraclePKIDebug.a("OracleKeyStoreSpi: getCertificate alias \"" + (null == string ? "null" : string) + "\"");
        if (this.engineContainsAlias(string)) {
            return ((t)this.c.get(string)).a();
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        if (this.engineContainsAlias(string)) {
            return ((t)this.c.get(string)).g();
        }
        return null;
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Not Implemented");
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Not Implemented");
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.engineContainsAlias(string) && !((t)this.c.get(string)).b()) {
            throw new KeyStoreException(a.getString("PKI-04013"));
        }
        b b2 = new b(certificate);
        this.c.put(string, b2);
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (!this.engineContainsAlias(string)) {
            throw new KeyStoreException(a.getString("PKI-04014"));
        }
        this.c.remove(string);
    }

    public Enumeration engineAliases() {
        return new Vector(this.c.keySet()).elements();
    }

    public boolean engineContainsAlias(String string) {
        return this.c.containsKey(string);
    }

    public int engineSize() {
        return this.c.size();
    }

    public boolean engineIsKeyEntry(String string) {
        if (this.engineContainsAlias(string)) {
            return ((t)this.c.get(string)).f();
        }
        return false;
    }

    public boolean engineIsCertificateEntry(String string) {
        if (this.engineContainsAlias(string)) {
            return ((t)this.c.get(string)).b();
        }
        return false;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Set set = this.c.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((t)entry.getValue()).a().equals(certificate)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        PKCS12 pKCS12 = null;
        OraclePKIDebug.a("OracleKeyStoreSpi: Loading wallet from stream");
        AccessController.doPrivileged(new f(this));
        if (inputStream == null) {
            pKCS12 = new PKCS12();
            pKCS12.setPassword(new String(cArray));
        } else {
            FileChannel fileChannel = null;
            FileLock fileLock = null;
            boolean bl = false;
            try {
                try {
                    if (inputStream instanceof FileInputStream) {
                        OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:getting channel..");
                        fileChannel = ((FileInputStream)inputStream).getChannel();
                        OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:locking file (shared)..");
                        fileLock = fileChannel.lock(0L, inputStream.available(), true);
                        OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:locked file.");
                        bl = true;
                    }
                }
                catch (OverlappingFileLockException overlappingFileLockException) {
                    // empty catch block
                }
                pKCS12 = new PKCS12(new String(cArray), inputStream);
            }
            finally {
                if (fileLock != null) {
                    OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:releasing lock..");
                    fileLock.release();
                }
                if (bl && fileChannel != null) {
                    OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:closing channel..");
                    fileChannel.close();
                }
            }
        }
        boolean bl = false;
        try {
            bl = pKCS12.verify();
        }
        catch (AuthenticationException authenticationException) {
            bl = false;
        }
        if (!bl) {
            throw new IOException(a.getString("PKI-02010"));
        }
        this.a(pKCS12);
        OraclePKIDebug.a("OracleKeyStoreSpi: Keystore Loaded");
    }

    public void printLocalKeyIDs(PKCS12 pKCS12) {
        System.out.println("-------------------");
        PKCS12Safe pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i2);
            byte[] byArray = pKCS12Bag.getLocalKeyID();
            if (OracleKeyStoreSpi.b(pKCS12Bag)) {
                System.out.println("CertReqBag = " + oracle.security.pki.e.k(byArray));
            }
            if (OracleKeyStoreSpi.a(pKCS12Bag) && oracle.security.pki.e.b(byArray)) {
                System.out.println("User CertBag = " + oracle.security.pki.e.k(byArray));
            }
            if (OracleKeyStoreSpi.a(pKCS12Bag) && oracle.security.pki.e.c(pKCS12Bag.getLocalKeyID())) {
                System.out.println("Trusted CertBag = " + oracle.security.pki.e.k(byArray));
            }
            if (OracleKeyStoreSpi.c(pKCS12Bag)) {
                System.out.println("KeyBag = " + oracle.security.pki.e.k(byArray));
            }
            if (!OracleKeyStoreSpi.d(pKCS12Bag)) continue;
            System.out.println("SecretStoreBag = " + oracle.security.pki.e.k(byArray));
        }
    }

    int a() {
        return this.d.size();
    }

    Enumeration b() {
        TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
        treeSet.addAll(this.d.keySet());
        return new Vector<Object>(treeSet).elements();
    }

    Enumeration c() {
        return new Vector(this.d.keySet()).elements();
    }

    public void secretStoreDeleteSecret(String string) throws OracleSecretStoreException {
        if (!this.secretStoreContainsAlias(string)) {
            throw new OracleSecretStoreException("No such alias in secret store");
        }
        this.d.remove(string);
    }

    public void secretStoreSetSecret(String string, char[] cArray) throws OracleSecretStoreException {
        if (this.secretStoreContainsAlias(string)) {
            d d2 = (d)this.d.get(string);
            d2.a(cArray);
        } else {
            d d3 = new d(string, cArray);
            this.d.put(d3.b(), d3);
        }
    }

    public char[] secretStoreGetSecret(String string) throws OracleSecretStoreException {
        if (this.secretStoreContainsAlias(string)) {
            return ((d)this.d.get(string)).a();
        }
        return null;
    }

    public boolean secretStoreContainsAlias(String string) throws OracleSecretStoreException {
        return this.d.containsKey(string);
    }

    public void secretStoreCreateCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        int n2 = 1;
        Enumeration enumeration = new Vector(this.d.values()).elements();
        System.out.print("Create credential ");
        while (enumeration.hasMoreElements()) {
            d d2 = (d)enumeration.nextElement();
            String string = new String(d2.a());
            String string2 = d2.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            throw new OracleSecretStoreException("Credential already exists");
        }
        while (this.secretStoreContainsAlias(CREDENTIAL_CONNECT_STRING + n2)) {
            ++n2;
        }
        System.out.println(CREDENTIAL_CONNECT_STRING + n2);
        this.secretStoreSetSecret(CREDENTIAL_CONNECT_STRING + n2, cArray);
        this.secretStoreSetSecret(CREDENTIAL_USERNAME + n2, cArray2);
        this.secretStoreSetSecret(CREDENTIAL_PASSWORD + n2, cArray3);
    }

    public void secretStoreModifyCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        boolean bl = false;
        Enumeration enumeration = new Vector(this.d.values()).elements();
        System.out.println("Modify credential ");
        while (enumeration.hasMoreElements()) {
            d d2 = (d)enumeration.nextElement();
            String string = new String(d2.a());
            String string2 = d2.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            System.out.println("Modify " + string3);
            this.secretStoreDeleteSecret(CREDENTIAL_USERNAME + string3);
            this.secretStoreSetSecret(CREDENTIAL_USERNAME + string3, cArray2);
            this.secretStoreDeleteSecret(CREDENTIAL_PASSWORD + string3);
            this.secretStoreSetSecret(CREDENTIAL_PASSWORD + string3, cArray3);
            bl = true;
            break;
        }
        if (!bl) {
            throw new OracleSecretStoreException("Credential does not exists");
        }
    }

    public void secretStoreDeleteCredential(char[] cArray) throws OracleSecretStoreException {
        boolean bl = false;
        Enumeration enumeration = new Vector(this.d.values()).elements();
        System.out.println("Delete credential ");
        while (enumeration.hasMoreElements()) {
            d d2 = (d)enumeration.nextElement();
            String string = new String(d2.a());
            String string2 = d2.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            System.out.println("Delete " + string3);
            this.secretStoreDeleteSecret(string2);
            this.secretStoreDeleteSecret(CREDENTIAL_USERNAME + string3);
            this.secretStoreDeleteSecret(CREDENTIAL_PASSWORD + string3);
            bl = true;
            break;
        }
        if (!bl) {
            throw new OracleSecretStoreException("Credential does not exists");
        }
    }

    public void secretStoreListCredential() throws OracleSecretStoreException {
        Enumeration enumeration = new Vector(this.d.values()).elements();
        System.out.println("List credential (index: connect_string username)");
        while (enumeration.hasMoreElements()) {
            d d2 = (d)enumeration.nextElement();
            String string = new String(d2.a());
            String string2 = d2.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING)) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            System.out.println(string3 + ": " + string + " " + new String(this.secretStoreGetSecret(CREDENTIAL_USERNAME + string3)));
        }
    }

    private static boolean a(PKCS12Bag pKCS12Bag) {
        return pKCS12Bag instanceof PKCS12CertBag;
    }

    private static boolean b(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return oracle.security.pki.e.a(pKCS12Bag.getLocalKeyID());
    }

    private static boolean c(PKCS12Bag pKCS12Bag) {
        return pKCS12Bag instanceof PKCS12KeyBag || pKCS12Bag instanceof PKCS12ShroudedKeyBag;
    }

    private static boolean d(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return oracle.security.pki.e.d(pKCS12Bag.getLocalKeyID());
    }

    private static boolean e(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return oracle.security.pki.e.e(pKCS12Bag.getLocalKeyID());
    }

    private static boolean f(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return oracle.security.pki.e.f(pKCS12Bag.getLocalKeyID());
    }

    private static boolean g(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return oracle.security.pki.e.g(pKCS12Bag.getLocalKeyID());
    }

    private static boolean h(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return oracle.security.pki.e.h(pKCS12Bag.getLocalKeyID());
    }

    private static Vector b(PKCS12 pKCS12) {
        Vector vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)vector.elementAt(i2);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i2);
            Vector vector3 = pKCS12Safe.getBags();
            for (int i3 = 0; i3 < vector3.size(); ++i3) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector3.elementAt(i3);
                if (!OracleKeyStoreSpi.d(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found secret store bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(i3);
                --i3;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    private void c(PKCS12 pKCS12) {
        Vector vector = pKCS12.getAuthSafes();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)vector.elementAt(i2);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i2);
            Vector vector2 = pKCS12Safe.getBags();
            for (int i3 = 0; i3 < vector2.size(); ++i3) {
                ASN1Object aSN1Object;
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector2.elementAt(i3);
                if (OracleKeyStoreSpi.e(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 lib info");
                    aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue();
                    this.e = new String(((ASN1OctetString)aSN1Object).getValue());
                    vector2.removeElementAt(i3);
                    --i3;
                }
                if (OracleKeyStoreSpi.f(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 tokenlabel info");
                    aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue();
                    this.f = new String(((ASN1OctetString)aSN1Object).getValue());
                    vector2.removeElementAt(i3);
                    --i3;
                }
                if (OracleKeyStoreSpi.g(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 tokenlabel info");
                    aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue();
                    this.g = new String(((ASN1OctetString)aSN1Object).getValue());
                    vector2.removeElementAt(i3);
                    --i3;
                }
                if (!OracleKeyStoreSpi.h(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 tokenlabel info");
                aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue();
                this.h = new String(((ASN1OctetString)aSN1Object).getValue());
                vector2.removeElementAt(i3);
                --i3;
            }
            pKCS12Safe.setBags(vector2);
        }
    }

    public String getP11Lib() {
        return this.e;
    }

    public String getP11TokenLabel() {
        return this.f;
    }

    public String getP11TokenPassphrase() {
        return this.g;
    }

    public String getP11CertLabel() {
        return this.h;
    }

    byte[] d(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException {
        Object object;
        PKCS12 pKCS12;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes(pKCS12.getAuthSafes());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            pKCS12.setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafes().elementAt(0);
        }
        Vector vector = pKCS12.getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        boolean bl = false;
        int n2 = 0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object = (PKCS12Bag)vector.elementAt(n2);
            if (!OracleKeyStoreSpi.e(object)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 lib bag");
            bl = true;
            break;
        }
        if (bl) {
            vector.remove(n2);
        }
        object = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11LibOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)pKCS12, aSN1ObjectID, (ASN1Object)object);
        pKCS12SecretBag.setLocalKeyID(oracle.security.pki.e.a(0));
        vector.addElement(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 lib bag ");
        pKCS12.setBags(vector);
        if (vector.size() > 0 && pKCS122.getAuthSafes().size() == 0) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] e(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException {
        Object object;
        PKCS12 pKCS12;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes(pKCS12.getAuthSafes());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            pKCS12.setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafes().elementAt(0);
        }
        Vector vector = pKCS12.getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        boolean bl = false;
        int n2 = 0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object = (PKCS12Bag)vector.elementAt(n2);
            if (!OracleKeyStoreSpi.f(object)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 token label bag");
            bl = true;
            break;
        }
        if (bl) {
            vector.remove(n2);
        }
        object = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11TokLblOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)pKCS12, aSN1ObjectID, (ASN1Object)object);
        pKCS12SecretBag.setLocalKeyID(oracle.security.pki.e.b(0));
        vector.addElement(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 token label bag ");
        pKCS12.setBags(vector);
        if (vector.size() > 0 && pKCS122.getAuthSafes().size() == 0) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] f(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException {
        Object object;
        PKCS12 pKCS12;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes(pKCS12.getAuthSafes());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            pKCS12.setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafes().elementAt(0);
        }
        Vector vector = pKCS12.getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        boolean bl = false;
        int n2 = 0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object = (PKCS12Bag)vector.elementAt(n2);
            if (!OracleKeyStoreSpi.g(object)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 token pwd bag");
            bl = true;
            break;
        }
        if (bl) {
            vector.remove(n2);
        }
        object = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11TokPwdOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)pKCS12, aSN1ObjectID, (ASN1Object)object);
        pKCS12SecretBag.setLocalKeyID(oracle.security.pki.e.c(0));
        vector.addElement(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 token pwd bag ");
        pKCS12.setBags(vector);
        if (vector.size() > 0 && pKCS122.getAuthSafes().size() == 0) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] g(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException {
        Object object;
        PKCS12 pKCS12;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes(pKCS12.getAuthSafes());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            pKCS12.setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafes().elementAt(0);
        }
        Vector vector = pKCS12.getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        boolean bl = false;
        int n2 = 0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object = (PKCS12Bag)vector.elementAt(n2);
            if (!OracleKeyStoreSpi.h(object)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 cert label bag");
            bl = true;
            break;
        }
        if (bl) {
            vector.remove(n2);
        }
        object = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11CrtLblOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)pKCS12, aSN1ObjectID, (ASN1Object)object);
        pKCS12SecretBag.setLocalKeyID(oracle.security.pki.e.d(0));
        vector.addElement(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 cert label bag ");
        pKCS12.setBags(vector);
        if (vector.size() > 0 && pKCS122.getAuthSafes().size() == 0) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static Vector d(PKCS12 pKCS12) {
        Vector vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)vector.elementAt(i2);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i2);
            Vector vector3 = pKCS12Safe.getBags();
            for (int i3 = 0; i3 < vector3.size(); ++i3) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector3.elementAt(i3);
                if (!OracleKeyStoreSpi.c(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found key bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(i3);
                --i3;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    private static Vector e(PKCS12 pKCS12) {
        Vector vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)vector.elementAt(i2);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i2);
            Vector vector3 = pKCS12Safe.getBags();
            for (int i3 = 0; i3 < vector3.size(); ++i3) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector3.elementAt(i3);
                if (!OracleKeyStoreSpi.a(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found cert bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(i3);
                --i3;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    private static Vector f(PKCS12 pKCS12) {
        Vector vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)vector.elementAt(i2);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i2);
            Vector vector3 = pKCS12Safe.getBags();
            for (int i3 = 0; i3 < vector3.size(); ++i3) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector3.elementAt(i3);
                if (!OracleKeyStoreSpi.b(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found cert req bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(i3);
                --i3;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    void a(PKCS12 pKCS12) throws NoSuchAlgorithmException, CertificateException, IOException {
        int n2;
        String string;
        PKCS12Bag pKCS12Bag;
        String string2;
        Object object;
        int n3;
        Vector vector = OracleKeyStoreSpi.d(pKCS12);
        Vector vector2 = OracleKeyStoreSpi.e(pKCS12);
        Vector vector3 = OracleKeyStoreSpi.b(pKCS12);
        Vector vector4 = OracleKeyStoreSpi.f(pKCS12);
        this.c(pKCS12);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(vector.size() + vector2.size());
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>(vector3.size());
        for (n3 = 0; n3 < vector.size(); ++n3) {
            OraclePKIDebug.a("Processing identity " + n3);
            object = new n((PKCS12Bag)vector.elementAt(n3), vector2, vector4);
            string2 = null;
            pKCS12Bag = (PKCS12Bag)vector.elementAt(n3);
            string = pKCS12Bag.getFriendlyName();
            if (string != null) {
                string2 = string;
            } else {
                string2 = ((t)object).c();
                n2 = 1;
                while (hashtable.containsKey(string2)) {
                    string2 = string2 + ' ' + Integer.toString(n2);
                    ++n2;
                }
            }
            OraclePKIDebug.a("Storing identity " + n3 + " as " + string2);
            hashtable.put(string2, object);
        }
        for (n3 = 0; n3 < vector4.size(); ++n3) {
            OraclePKIDebug.a("Processing CertReq with no matching pvt key " + n3);
            object = new n((PKCS12Bag)vector4.elementAt(n3), vector2);
            string2 = null;
            pKCS12Bag = (PKCS12Bag)vector4.elementAt(n3);
            string = pKCS12Bag.getFriendlyName();
            if (string != null) {
                string2 = string;
            } else {
                string2 = ((t)object).c();
                n2 = 1;
                while (hashtable.containsKey(string2)) {
                    string2 = string2 + ' ' + Integer.toString(n2);
                    ++n2;
                }
            }
            OraclePKIDebug.a("Storing creq " + n3 + " as " + string2);
            hashtable.put(string2, object);
        }
        for (n3 = 0; n3 < vector2.size(); ++n3) {
            OraclePKIDebug.a("Processing TP " + n3);
            object = new b((PKCS12CertBag)vector2.elementAt(n3));
            string2 = null;
            pKCS12Bag = (PKCS12Bag)vector2.elementAt(n3);
            string = pKCS12Bag.getFriendlyName();
            if (string != null) {
                string2 = string;
            } else {
                string2 = ((t)object).c();
                n2 = 1;
                while (hashtable.containsKey(string2)) {
                    string2 = ((t)object).c() + ' ' + Integer.toString(n2);
                    ++n2;
                }
            }
            OraclePKIDebug.a("Storing TP " + n3 + " as " + string2);
            hashtable.put(string2, object);
        }
        try {
            for (n3 = 0; n3 < vector3.size(); ++n3) {
                OraclePKIDebug.a("OracleKeyStoreSpi: Storing Secret" + n3);
                object = new d((PKCS12SecretBag)vector3.elementAt(n3));
                hashtable2.put(((d)object).b(), object);
            }
        }
        catch (OracleSecretStoreException oracleSecretStoreException) {
            throw new IOException(oracleSecretStoreException.toString());
        }
        this.c = hashtable;
        this.d = hashtable2;
    }

    byte[] a(InputStream inputStream, char[] cArray) throws IOException, OracleSecretStoreException {
        Object object;
        PKCS12 pKCS12;
        PKCS12 pKCS122 = null;
        pKCS122 = new PKCS12();
        pKCS122.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes(pKCS12.getAuthSafes());
            OracleKeyStoreSpi.b(pKCS122);
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new secret store");
            pKCS12 = new PKCS12Safe(pKCS122);
            pKCS12.setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafes().elementAt(0);
        }
        Vector vector = pKCS12.getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + "bags");
        if (this.d.size() > 0) {
            object = this.d.entrySet();
            Iterator iterator = object.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                d d2 = (d)iterator.next().getValue();
                PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)pKCS12);
                d2.a(pKCS12SecretBag);
                pKCS12SecretBag.setLocalKeyID(oracle.security.pki.e.a(0, n2));
                vector.insertElementAt(pKCS12SecretBag, 0);
                ++n2;
                OraclePKIDebug.a("OracleWallet: added secret bag");
            }
        }
        pKCS12.setBags(vector);
        if (vector.size() > 0 && pKCS122.getAuthSafes().size() == 0) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        OraclePKIDebug.a("OracleWallet: wallet has " + pKCS122.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleWallet: wallet size " + pKCS122.length());
        object = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, KeyStore keyStore, char[] cArray) throws IOException, KeyStoreException, CertificateException {
        PKCS12 pKCS12;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes(pKCS12.getAuthSafes());
            OracleKeyStoreSpi.d(pKCS122);
            OracleKeyStoreSpi.e(pKCS122);
            OracleKeyStoreSpi.f(pKCS122);
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            pKCS12.setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafes().elementAt(0);
        }
        Vector vector = pKCS12.getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        Object object = keyStore.aliases();
        while (object.hasMoreElements()) {
            int n2 = 0;
            String string = object.nextElement();
            if (keyStore.isCertificateEntry(string)) {
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                X509 x509 = x509Certificate instanceof OraclePKIX509CertImpl ? ((OraclePKIX509CertImpl)x509Certificate).getX509() : new X509(x509Certificate.getEncoded());
                PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)pKCS12, x509);
                pKCS12CertBag.setLocalKeyID(oracle.security.pki.e.b(0, n2));
                vector.insertElementAt(pKCS12CertBag, 0);
                OraclePKIDebug.a("OracleWallet: added cert bag");
                continue;
            }
            if (!keyStore.isKeyEntry(string)) continue;
            throw new IOException("Not Implemented for private keys");
        }
        pKCS12.setBags(vector);
        if (vector.size() > 0 && pKCS122.getAuthSafes().size() == 0) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        OraclePKIDebug.a("OracleWallet: wallet has " + pKCS122.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleWallet: wallet size " + pKCS122.length());
        object = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    static void a(InputStream inputStream, char[] cArray, OutputStream outputStream, char[] cArray2) throws IOException {
        PKCS12 pKCS12 = new PKCS12(new String(cArray), inputStream);
        boolean bl = cArray.length == cArray2.length;
        for (int i2 = 0; bl && i2 < cArray.length; ++i2) {
            if (cArray[i2] == cArray2[i2]) continue;
            bl = false;
        }
        if (!bl) {
            pKCS12.setPassword(new String(cArray2));
            Vector vector = pKCS12.getAuthSafes();
            for (int i3 = 0; i3 < vector.size(); ++i3) {
                ((PKCS12Safe)vector.elementAt(i3)).setPassword(new String(cArray2));
            }
        }
        try {
            pKCS12.output(outputStream);
            OraclePKIDebug.a("Verifying wallet " + pKCS12.verify());
        }
        catch (AuthenticationException authenticationException) {
            OraclePKIDebug.a("Verifying wallet failed" + authenticationException);
            throw new IOException("Could not store wallet " + authenticationException);
        }
    }

    byte[] a(InputStream inputStream, char[] cArray, CertificateRequest certificateRequest, RSAPrivateKey rSAPrivateKey, String string) throws IOException, KeyStoreException {
        Object object;
        Object object2;
        PKCS12 pKCS12;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes(pKCS12.getAuthSafes());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            pKCS12.setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafes().elementAt(0);
        }
        Vector vector = pKCS12.getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n2 = 0;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            boolean bl;
            int n3;
            object2 = (PKCS12Bag)vector.elementAt(i2);
            if (OracleKeyStoreSpi.c(object2)) {
                OraclePKIDebug.a("OracleKeyStoreSpi: found key bag");
                if (string != null && object2.getFriendlyName().equalsIgnoreCase(string)) {
                    throw new IOException(a.getString("PKI-04008") + string);
                }
                object = object2.getLocalKeyID();
                n3 = oracle.security.pki.e.k(object);
                if (n3 == n2) {
                    ++n2;
                } else if (n3 > n2) {
                    n2 = n3 + 1;
                }
            }
            if (!OracleKeyStoreSpi.b(object2) || (bl = this.a(pKCS122, n3 = oracle.security.pki.e.k(object = object2.getLocalKeyID())))) continue;
            if (n3 == n2) {
                ++n2;
                continue;
            }
            if (n3 <= n2) continue;
            n2 = n3 + 1;
        }
        if (string == null) {
            string = n2 == 0 ? "orakey" : "orakey" + Integer.toString(n2);
        }
        if (rSAPrivateKey != null) {
            PKCS12KeyBag pKCS12KeyBag = new PKCS12KeyBag((PKCS12Safe)pKCS12, (PrivateKey)rSAPrivateKey);
            pKCS12KeyBag.setLocalKeyID(oracle.security.pki.e.c(0, n2));
            pKCS12KeyBag.setFriendlyName(string.toLowerCase());
            vector.addElement(pKCS12KeyBag);
            OraclePKIDebug.a("OracleWallet: added key bag " + n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)byteArrayOutputStream);
        object2 = byteArrayOutputStream.toByteArray();
        object = new ASN1OctetString((byte[])object2);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)pKCS12, new ASN1ObjectID("42.134.72.134.247.13.1.10"), (ASN1Object)object);
        pKCS12SecretBag.setLocalKeyID(oracle.security.pki.e.d(0, n2));
        pKCS12SecretBag.setFriendlyName(string.toLowerCase());
        vector.addElement(pKCS12SecretBag);
        OraclePKIDebug.a("OracleKeyStoreSpi: added req bag " + n2);
        pKCS12.setBags(vector);
        if (vector.size() > 0 && pKCS122.getAuthSafes().size() == 0) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS122.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + pKCS122.length());
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)byteArrayOutputStream2);
        return byteArrayOutputStream2.toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string) throws IOException, KeyStoreException {
        Object object;
        PKCS12 pKCS12;
        if (this.b(oraclePKIX509CertImpl)) {
            throw new KeyStoreException(a.getString("PKI-04003"));
        }
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes(pKCS12.getAuthSafes());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            pKCS12.setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafes().elementAt(0);
        }
        Vector vector = pKCS12.getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n2 = 0;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            object = (PKCS12Bag)vector.elementAt(i2);
            if (string != null && object.getFriendlyName() != null && object.getFriendlyName().equalsIgnoreCase(string)) {
                throw new IOException(a.getString("PKI-04008") + string);
            }
            if (!OracleKeyStoreSpi.a((PKCS12Bag)object) || !oracle.security.pki.e.c(object.getLocalKeyID())) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found cert bag");
            ++n2;
        }
        PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)pKCS12, oraclePKIX509CertImpl.getX509());
        pKCS12CertBag.setLocalKeyID(oracle.security.pki.e.b(0, n2));
        if (string != null) {
            pKCS12CertBag.setFriendlyName(string.toLowerCase());
        }
        vector.addElement(pKCS12CertBag);
        OraclePKIDebug.a("OracleWallet: added key bag " + n2);
        pKCS12.setBags(vector);
        if (vector.size() > 0 && pKCS122.getAuthSafes().size() == 0) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS122.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + pKCS122.length());
        object = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ASN1Object aSN1Object;
        PKCS12Safe pKCS12Safe;
        Object object;
        Object object2;
        Object object3;
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object3) || (certificateRequest = ((OraclePKIRSAPrivateKey)this.engineGetKey((String)object3, null)).getCertificateRequest()) == null || !x500Name.equals((Object)new X500Name((String)(object2 = (Object)certificateRequest.getSubject().toString())))) continue;
            object = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object3);
            if (object != null) {
                throw new IOException(a.getString("PKI-04011"));
            }
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveCertReq: No cert request in wallet with matching DN.");
            throw new IOException(a.getString("PKI-04005"));
        }
        object3 = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)object3);
        object2 = ((ByteArrayOutputStream)object3).toByteArray();
        object = null;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(pKCS12Safe.getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            byte[] byArray;
            boolean bl2;
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i2);
            if (!OracleKeyStoreSpi.b(pKCS12Bag) || !(bl2 = Arrays.equals(object2, byArray = ((ASN1OctetString)(aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue())).getValue()))) continue;
            object = pKCS12Bag.getLocalKeyID();
            vector.removeElementAt(i2);
            break;
        }
        byte[] byArray = oracle.security.pki.e.c(oracle.security.pki.e.j((byte[])object), oracle.security.pki.e.k((byte[])object));
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            aSN1Object = (PKCS12Bag)vector.elementAt(i3);
            if (!OracleKeyStoreSpi.c((PKCS12Bag)aSN1Object) || !this.a(aSN1Object.getLocalKeyID(), byArray)) continue;
            vector.removeElementAt(i3);
            break;
        }
        pKCS12Safe.setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe(pKCS12Safe);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + pKCS12.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ASN1Object aSN1Object;
        PKCS12Safe pKCS12Safe;
        Object object;
        Object object2;
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object2) || !string.equals(object2) || (certificateRequest = ((OraclePKIRSAPrivateKey)this.engineGetKey((String)object2, null)).getCertificateRequest()) == null) continue;
            object = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object2);
            if (object != null) {
                throw new IOException(a.getString("PKI-04011"));
            }
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveCertReq: No cert request in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04009") + string);
        }
        object2 = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)object2);
        object = ((ByteArrayOutputStream)object2).toByteArray();
        byte[] byArray = null;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(pKCS12Safe.getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            byte[] byArray2;
            boolean bl2;
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i2);
            if (!OracleKeyStoreSpi.b(pKCS12Bag) || !(bl2 = Arrays.equals(object, byArray2 = ((ASN1OctetString)(aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue())).getValue()))) continue;
            byArray = pKCS12Bag.getLocalKeyID();
            vector.removeElementAt(i2);
            break;
        }
        byte[] byArray3 = oracle.security.pki.e.c(oracle.security.pki.e.j(byArray), oracle.security.pki.e.k(byArray));
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            aSN1Object = (PKCS12Bag)vector.elementAt(i3);
            if (!OracleKeyStoreSpi.c((PKCS12Bag)aSN1Object) || !this.a(aSN1Object.getLocalKeyID(), byArray3)) continue;
            vector.removeElementAt(i3);
            break;
        }
        pKCS12Safe.setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe(pKCS12Safe);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + pKCS12.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] h(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ASN1Object aSN1Object;
        PKCS12Safe pKCS12Safe;
        Object object;
        Object object2;
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object2) || !string.equals(object2)) continue;
            object = (OraclePKIRSAPrivateKey)this.engineGetKey((String)object2, null);
            certificateRequest = ((OraclePKIRSAPrivateKey)object).getCertificateRequest();
            if (!((OraclePKIRSAPrivateKey)object).isPvtKeyPresent()) {
                throw new IOException(a.getString("PKI-04009") + string);
            }
            if (certificateRequest == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemovePrivateKey: No cert request in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04009") + string);
        }
        object2 = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)object2);
        object = ((ByteArrayOutputStream)object2).toByteArray();
        byte[] byArray = null;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(pKCS12Safe.getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            byte[] byArray2;
            boolean bl2;
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i2);
            if (!OracleKeyStoreSpi.b(pKCS12Bag) || !(bl2 = Arrays.equals((byte[])object, byArray2 = ((ASN1OctetString)(aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue())).getValue()))) continue;
            byArray = pKCS12Bag.getLocalKeyID();
            break;
        }
        byte[] byArray3 = oracle.security.pki.e.c(oracle.security.pki.e.j(byArray), oracle.security.pki.e.k(byArray));
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            aSN1Object = (PKCS12Bag)vector.elementAt(i3);
            if (!OracleKeyStoreSpi.c((PKCS12Bag)aSN1Object) || !this.a(aSN1Object.getLocalKeyID(), byArray3)) continue;
            vector.removeElementAt(i3);
            break;
        }
        pKCS12Safe.setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe(pKCS12Safe);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + pKCS12.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    int i(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        PKCS12Safe pKCS12Safe;
        Object object;
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object) || !string.equals(object) || (certificateRequest = ((OraclePKIRSAPrivateKey)this.engineGetKey((String)object, null)).getCertificateRequest()) == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalGetCRCompNum: No cert request in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04009") + string);
        }
        object = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)object);
        byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
        byte[] byArray2 = null;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(pKCS12Safe.getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            ASN1Object aSN1Object;
            byte[] byArray3;
            boolean bl2;
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i2);
            if (!OracleKeyStoreSpi.b(pKCS12Bag) || !(bl2 = Arrays.equals(byArray, byArray3 = ((ASN1OctetString)(aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue())).getValue()))) continue;
            byArray2 = pKCS12Bag.getLocalKeyID();
            return oracle.security.pki.e.k(byArray2);
        }
        throw new IOException("Check wallet.");
    }

    byte[] b(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        String string;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !x500Name.equals((Object)new X500Name(string = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString()))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveUserCert: No user cert in wallet with matching DN.");
            throw new IOException(a.getString("PKI-04007") + ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString());
        }
        string2 = new PKCS12();
        string2.setPassword(new String(cArray));
        if (inputStream != null) {
            string = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes(string.getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        string = (PKCS12Safe)string2.getAuthSafes().elementAt(0);
        Vector vector = string.getBags();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>(vector.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i2);
            if (OracleKeyStoreSpi.a(pKCS12Bag) && oracle.security.pki.e.b(pKCS12Bag.getLocalKeyID())) {
                X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals((Object)x509)) continue;
                vector2.addElement(pKCS12Bag);
                continue;
            }
            vector2.addElement(pKCS12Bag);
        }
        string.setBags(vector2);
        if (vector2.size() > 0 && string2.getAuthSafes().size() == 0) {
            string2.addAuthSafe((PKCS12Safe)string);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + string2.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + string2.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string2.length());
        string2.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] b(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        PKCS12Safe pKCS12Safe;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !string.equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveUserCert: No user cert in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04010") + string);
        }
        string2 = new PKCS12();
        string2.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes(pKCS12Safe.getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)string2.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>(vector.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i2);
            if (OracleKeyStoreSpi.a(pKCS12Bag) && oracle.security.pki.e.b(pKCS12Bag.getLocalKeyID())) {
                X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals((Object)x509)) continue;
                vector2.addElement(pKCS12Bag);
                continue;
            }
            vector2.addElement(pKCS12Bag);
        }
        pKCS12Safe.setBags(vector2);
        if (vector2.size() > 0 && string2.getAuthSafes().size() == 0) {
            string2.addAuthSafe(pKCS12Safe);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + string2.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + string2.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string2.length());
        string2.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] b(InputStream inputStream, char[] cArray) throws IOException, KeyStoreException, CertificateEncodingException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl;
        String string;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string)) == null || !this.a(oraclePKIX509CertImpl)) continue;
            OraclePKIDebug.a("Trusted cert is used in cert chain.");
            throw new IOException(a.getString("PKI-04015") + " " + ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString());
        }
        string = new PKCS12();
        string.setPassword(new String(cArray));
        if (inputStream != null) {
            oraclePKIX509CertImpl = new PKCS12(new String(cArray), inputStream);
            string.setAuthSafes(oraclePKIX509CertImpl.getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        oraclePKIX509CertImpl = (PKCS12Safe)string.getAuthSafes().elementAt(0);
        Vector vector = oraclePKIX509CertImpl.getBags();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>(vector.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i2);
            if (OracleKeyStoreSpi.a(pKCS12Bag) && oracle.security.pki.e.c(pKCS12Bag.getLocalKeyID())) continue;
            vector2.addElement(pKCS12Bag);
        }
        oraclePKIX509CertImpl.setBags(vector2);
        if (vector2.size() > 0 && string.getAuthSafes().size() == 0) {
            string.addAuthSafe((PKCS12Safe)oraclePKIX509CertImpl);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + string.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        string.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    boolean a(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !x500Name.equals((Object)new X500Name(string = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString()))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalIsTrustedCertUsedInChain: No trusted cert in wallet with matching DN.");
            return false;
        }
        return this.a(oraclePKIX509CertImpl);
    }

    boolean a(String string) throws IOException, KeyStoreException, CertificateEncodingException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2)) continue;
            oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2);
            if (!string.equals(string2) || oraclePKIX509CertImpl == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalIsTrustedCertUsedInChain: No trusted cert in wallet with matching alias.");
            return false;
        }
        return this.a(oraclePKIX509CertImpl);
    }

    int j(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        PKCS12Safe pKCS12Safe;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !string.equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalGetCertCompNum: No user cert in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04010") + string);
        }
        string2 = new PKCS12();
        string2.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes(pKCS12Safe.getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)string2.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        Vector vector2 = new Vector(vector.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i2);
            if (!OracleKeyStoreSpi.a(pKCS12Bag) || !oracle.security.pki.e.b(pKCS12Bag.getLocalKeyID())) continue;
            X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
            X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
            if (!x5092.equals((Object)x509)) continue;
            byte[] byArray = pKCS12Bag.getLocalKeyID();
            return oracle.security.pki.e.k(byArray);
        }
        throw new IOException("Check wallet.");
    }

    int k(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        PKCS12Safe pKCS12Safe;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !string.equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalGetTCertCompNum: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        string2 = new PKCS12();
        string2.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes(pKCS12Safe.getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)string2.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        Vector vector2 = new Vector(vector.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        boolean bl2 = false;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i2);
            if (!OracleKeyStoreSpi.a(pKCS12Bag) || !oracle.security.pki.e.c(pKCS12Bag.getLocalKeyID())) continue;
            X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
            X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
            if (!x5092.equals((Object)x509)) continue;
            byte[] byArray = pKCS12Bag.getLocalKeyID();
            return oracle.security.pki.e.k(byArray);
        }
        throw new IOException("Check wallet.");
    }

    byte[] c(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        String string;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !x500Name.equals((Object)new X500Name(string = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString()))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveTrustedCert: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        if (this.a(oraclePKIX509CertImpl)) {
            OraclePKIDebug.a("internalRemoveTrustedCert: Trusted cert is used in cert chain.");
            throw new IOException(a.getString("PKI-04015"));
        }
        string2 = new PKCS12();
        string2.setPassword(new String(cArray));
        if (inputStream != null) {
            string = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes(string.getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        string = (PKCS12Safe)string2.getAuthSafes().elementAt(0);
        Vector vector = string.getBags();
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n2 = 0;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i2);
            if (OracleKeyStoreSpi.a(pKCS12Bag) && oracle.security.pki.e.c(pKCS12Bag.getLocalKeyID())) {
                X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals((Object)x509)) continue;
                PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)string, x509);
                pKCS12CertBag.setLocalKeyID(oracle.security.pki.e.b(0, n2));
                String string3 = pKCS12Bag.getFriendlyName();
                if (string3 != null) {
                    pKCS12CertBag.setFriendlyName(string3);
                }
                vector2.addElement(pKCS12CertBag);
                OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                ++n2;
                continue;
            }
            vector2.addElement(pKCS12Bag);
        }
        string.setBags(vector2);
        if (vector2.size() > 0 && string2.getAuthSafes().size() == 0) {
            string2.addAuthSafe((PKCS12Safe)string);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + string2.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + string2.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string2.length());
        string2.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] c(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        PKCS12Safe pKCS12Safe;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !string.equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveTrustedCert: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        if (this.a(oraclePKIX509CertImpl)) {
            OraclePKIDebug.a("internalRemoveTrustedCert: Trusted cert is used in cert chain.");
            throw new IOException(a.getString("PKI-04015"));
        }
        string2 = new PKCS12();
        string2.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes(pKCS12Safe.getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)string2.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n2 = 0;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i2);
            if (OracleKeyStoreSpi.a(pKCS12Bag) && oracle.security.pki.e.c(pKCS12Bag.getLocalKeyID())) {
                X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals((Object)x509)) continue;
                PKCS12CertBag pKCS12CertBag = new PKCS12CertBag(pKCS12Safe, x509);
                pKCS12CertBag.setLocalKeyID(oracle.security.pki.e.b(0, n2));
                String string3 = pKCS12Bag.getFriendlyName();
                if (string3 != null) {
                    pKCS12CertBag.setFriendlyName(string3);
                }
                vector2.addElement(pKCS12CertBag);
                OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                ++n2;
                continue;
            }
            vector2.addElement(pKCS12Bag);
        }
        pKCS12Safe.setBags(vector2);
        if (vector2.size() > 0 && string2.getAuthSafes().size() == 0) {
            string2.addAuthSafe(pKCS12Safe);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + string2.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + string2.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string2.length());
        string2.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] b(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string) throws IOException, KeyStoreException {
        int n2;
        Object object;
        PKCS12 pKCS12;
        ((ByteArrayInputStream)inputStream).mark(((ByteArrayInputStream)inputStream).available());
        byte[] byArray = this.b(inputStream, cArray, oraclePKIX509CertImpl);
        ((ByteArrayInputStream)inputStream).reset();
        if (byArray == null && this.getP11Lib() != null) {
            byArray = this.a(inputStream, cArray, oraclePKIX509CertImpl);
        }
        ((ByteArrayInputStream)inputStream).reset();
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes(pKCS12.getAuthSafes());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            pKCS12.setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafes().elementAt(0);
        }
        Vector vector = pKCS12.getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n3 = 0;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            object = (PKCS12Bag)vector.elementAt(i2);
            if (!OracleKeyStoreSpi.a(object) || !oracle.security.pki.e.b(object.getLocalKeyID())) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found cert bag");
            ++n3;
        }
        PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)pKCS12, oraclePKIX509CertImpl.getX509());
        pKCS12CertBag.setLocalKeyID(byArray);
        object = null;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = BigInteger.TEN;
        RSA rSA = new RSA();
        RSAPublicKey rSAPublicKey = new RSAPublicKey(oraclePKIX509CertImpl.getPublicKey().getEncoded());
        rSA.setKey(rSAPublicKey);
        object = rSA.performOp(bigInteger2);
        if (string != null) {
            n2 = 0;
            for (int i3 = 0; i3 < vector.size(); ++i3) {
                RSAPrivateKey rSAPrivateKey;
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i3);
                if (pKCS12Bag.getFriendlyName() == null || !pKCS12Bag.getFriendlyName().equals(string)) continue;
                if (pKCS12Bag instanceof PKCS12KeyBag) {
                    rSAPrivateKey = (RSAPrivateKey)((PKCS12KeyBag)pKCS12Bag).getPrivateKey();
                    rSA.setKey(rSAPrivateKey);
                    bigInteger = rSA.performOp((BigInteger)object);
                } else if (pKCS12Bag instanceof PKCS12ShroudedKeyBag) {
                    rSAPrivateKey = (RSAPrivateKey)((PKCS12ShroudedKeyBag)pKCS12Bag).getPrivateKey();
                    rSA.setKey(rSAPrivateKey);
                    bigInteger = rSA.performOp((BigInteger)object);
                }
                if (null == bigInteger || !bigInteger.equals(bigInteger2)) continue;
                n2 = 1;
                break;
            }
            if (n2 == 0) {
                throw new IOException(a.getString("PKI-04009") + string);
            }
        } else {
            for (n2 = 0; n2 < vector.size(); ++n2) {
                RSAPrivateKey rSAPrivateKey;
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(n2);
                if (pKCS12Bag instanceof PKCS12KeyBag) {
                    rSAPrivateKey = (RSAPrivateKey)((PKCS12KeyBag)pKCS12Bag).getPrivateKey();
                    rSA.setKey(rSAPrivateKey);
                    bigInteger = rSA.performOp((BigInteger)object);
                } else if (pKCS12Bag instanceof PKCS12ShroudedKeyBag) {
                    rSAPrivateKey = (RSAPrivateKey)((PKCS12ShroudedKeyBag)pKCS12Bag).getPrivateKey();
                    rSA.setKey(rSAPrivateKey);
                    bigInteger = rSA.performOp((BigInteger)object);
                }
                if (null == bigInteger || !bigInteger.equals(bigInteger2)) continue;
                string = pKCS12Bag.getFriendlyName();
                break;
            }
        }
        if (string != null) {
            pKCS12CertBag.setFriendlyName(string.toLowerCase());
        }
        vector.addElement(pKCS12CertBag);
        OraclePKIDebug.a("OracleWallet: added key bag " + n3);
        pKCS12.setBags(vector);
        if (vector.size() > 0 && pKCS122.getAuthSafes().size() == 0) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS122.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + pKCS122.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException {
        byte[] byArray = null;
        int n2 = -1;
        try {
            int n3 = NZNative.Pkcs11HasMatchingPvtKey((String)this.getP11Lib(), (String)this.getP11TokenLabel(), (String)this.getP11TokenPassphrase(), (byte[])oraclePKIX509CertImpl.getEncoded());
            if (n3 != 0) {
                OraclePKIDebug.a("OracleKeyStoreSpi: No matching private key for cert in HSM");
                throw new IOException(a.getString("PKI-04006"));
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            IOException iOException = new IOException();
            iOException.initCause(certificateEncodingException);
            throw iOException;
        }
        Set set = this.c.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((t)entry.getValue() instanceof n)) continue;
            n n4 = (n)entry.getValue();
            OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey = (OraclePKIRSAPrivateKey)n4.d();
            CertificateRequest certificateRequest = oraclePKIRSAPrivateKey.getCertificateRequest();
            i i2 = (i)oraclePKIX509CertImpl.getPublicKey();
            if (oraclePKIRSAPrivateKey.isPvtKeyPresent() || certificateRequest == null || !this.a(i2, certificateRequest)) continue;
            n2 = ((n)entry.getValue()).i();
            if (((n)entry.getValue()).a() != null) {
                throw new IOException(a.getString("PKI-04004"));
            }
            PKCS12 pKCS12 = new PKCS12(new String(cArray), inputStream);
            Vector vector = OracleKeyStoreSpi.e(pKCS12);
            Vector<OraclePKIX509CertImpl> vector2 = new Vector<OraclePKIX509CertImpl>(vector.size());
            vector2.addElement(oraclePKIX509CertImpl);
            X509Certificate x509Certificate = (X509Certificate)vector2.lastElement();
            while (!((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i3 = 0; i3 < vector.size(); ++i3) {
                    PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i3);
                    if (!((Object)x509Certificate.getIssuerDN()).equals(pKCS12CertBag.getCert().getSubject())) continue;
                    bl = true;
                    vector2.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
                    x509Certificate = (X509Certificate)vector2.lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: Cert chain incomplete for cert ");
                throw new IOException(a.getString("PKI-04012"));
            }
            OraclePKIDebug.a("OracleKeyStoreSpi: Cert chain determined");
            break;
        }
        if (n2 == -1) {
            OraclePKIDebug.a("OracleKeyStoreSpi: Could not generate localkeyID");
            throw new IOException("OracleKeyStoreSpi: Could not generate localkeyID");
        }
        byArray = oracle.security.pki.e.e(0, n2);
        return byArray;
    }

    byte[] b(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException {
        byte[] byArray = null;
        Set set = this.c.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((t)entry.getValue() instanceof n)) continue;
            OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey = (OraclePKIRSAPrivateKey)((t)entry.getValue()).d();
            i i2 = (i)oraclePKIX509CertImpl.getPublicKey();
            if (!oraclePKIRSAPrivateKey.isPvtKeyPresent() || !this.a(i2, oraclePKIRSAPrivateKey)) continue;
            byArray = ((n)entry.getValue()).h();
            if (((n)entry.getValue()).a() != null) {
                throw new IOException(a.getString("PKI-04004"));
            }
            if (oraclePKIRSAPrivateKey.getCertificateRequest() == null) {
                throw new IOException(a.getString("PKI-04005"));
            }
            PKCS12 pKCS12 = new PKCS12(new String(cArray), inputStream);
            Vector vector = OracleKeyStoreSpi.e(pKCS12);
            Vector<OraclePKIX509CertImpl> vector2 = new Vector<OraclePKIX509CertImpl>(vector.size());
            vector2.addElement(oraclePKIX509CertImpl);
            X509Certificate x509Certificate = (X509Certificate)vector2.lastElement();
            while (!((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i3 = 0; i3 < vector.size(); ++i3) {
                    PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i3);
                    if (!((Object)x509Certificate.getIssuerDN()).equals(pKCS12CertBag.getCert().getSubject())) continue;
                    bl = true;
                    vector2.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
                    x509Certificate = (X509Certificate)vector2.lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: Cert chain incomplete for cert ");
                throw new IOException(a.getString("PKI-04012"));
            }
            OraclePKIDebug.a("OracleKeyStoreSpi: Cert chain determined");
            break;
        }
        if (byArray == null) {
            OraclePKIDebug.a("OracleKeyStoreSpi: No matching private key for cert in wallet");
            if (this.getP11Lib() == null) {
                throw new IOException(a.getString("PKI-04006"));
            }
        }
        return byArray;
    }

    boolean a(i i2, CertificateRequest certificateRequest) {
        boolean bl = false;
        BigInteger bigInteger = i2.getPublicExponent();
        BigInteger bigInteger2 = i2.getModulus();
        BigInteger bigInteger3 = ((RSAPublicKey)certificateRequest.getPublicKey()).getExponent();
        BigInteger bigInteger4 = ((RSAPublicKey)certificateRequest.getPublicKey()).getModulus();
        if (bigInteger.equals(bigInteger3) && bigInteger2.equals(bigInteger4)) {
            bl = true;
        }
        return bl;
    }

    boolean a(i i2, OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey) {
        boolean bl = false;
        BigInteger bigInteger = oraclePKIRSAPrivateKey.getPublicExponent();
        BigInteger bigInteger2 = oraclePKIRSAPrivateKey.getModulus();
        if (bigInteger.equals(i2.getPublicExponent()) && bigInteger2.equals(i2.getModulus())) {
            bl = true;
        }
        return bl;
    }

    boolean a(OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException {
        boolean bl = false;
        Set set = this.c.entrySet();
        Iterator iterator = set.iterator();
        block0: while (iterator.hasNext() && !bl) {
            Certificate[] certificateArray;
            Map.Entry entry = iterator.next();
            if (!((t)entry.getValue() instanceof n) || (certificateArray = ((n)entry.getValue()).e()) == null) continue;
            for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                if (!oraclePKIX509CertImpl.equals(certificateArray[i2])) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    boolean b(OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException {
        boolean bl = false;
        Set set = this.c.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Serializable serializable;
            Map.Entry entry = iterator.next();
            if (!((t)entry.getValue() instanceof b)) continue;
            X509Certificate x509Certificate = (X509Certificate)((t)entry.getValue()).a();
            X509 x509 = null;
            try {
                x509 = new X509(x509Certificate.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                serializable = new IOException("Cert getEncoded failed.");
                ((Throwable)serializable).initCause(certificateEncodingException);
                throw serializable;
            }
            RSAPublicKey rSAPublicKey = (RSAPublicKey)x509.getPublicKey();
            serializable = (i)oraclePKIX509CertImpl.getPublicKey();
            BigInteger bigInteger = rSAPublicKey.getExponent();
            BigInteger bigInteger2 = rSAPublicKey.getModulus();
            if (!bigInteger.equals(((i)serializable).getPublicExponent()) || !bigInteger2.equals(((i)serializable).getModulus())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null | byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    private boolean a(PKCS12 pKCS12, int n2) throws IOException {
        boolean bl = false;
        PKCS12Safe pKCS12Safe = null;
        if (pKCS12.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12Safe = new PKCS12Safe(pKCS12);
            pKCS12Safe.setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafes().elementAt(0);
        }
        Vector vector = pKCS12Safe.getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            byte[] byArray;
            int n3;
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i2);
            if (!OracleKeyStoreSpi.c(pKCS12Bag) || (n3 = oracle.security.pki.e.k(byArray = pKCS12Bag.getLocalKeyID())) != n2) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

