/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml.navigator;

import oracle.dbtools.common.utils.Version;
import oracle.dbtools.xml.navigator.Descriptor;
import oracle.dbtools.xml.navigator.IconElement;
import oracle.xml.parser.v2.XMLNode;

public final class ConnectionTypeElement
extends Descriptor {
    private static final String CONNECTION_TAB_NAME = "connectionTabName";
    private static final String CONNECTION_PANEL_CLASS = "connectionPanelClass";
    private static final String PROVIDER_CLASS = "providerClass";
    private static final String IMPL_CLASS = "implClass";
    private static final String SUPPORTS_ROW_ID = "supportsRowId";
    private static final String SUPPORTS_CATALOG = "supportsCatalog";
    private static final String SHOW_ALL_SCHEMAS = "showAllSchemas";
    private static final String SUPPORTS_OTHER_SCHEMAS = "supportsOtherSchemas";
    private static final String MAX_VERSION = "maxVersion";
    private static final String MIN_VERSION = "minVersion";
    private IconElement icon;
    private Version minimumVersion;
    private Version maximumVersion;
    private boolean otherSchemasSupport;
    private boolean showAllSchemas;
    private boolean supportsCatalogs;
    private boolean supportsRowID;
    private String implClass;
    private String providerClass;
    private String panelClass;
    private String panelLabel;

    ConnectionTypeElement(XMLNode node) {
        super(node);
        this.icon = new IconElement(node);
        this.minimumVersion = ConnectionTypeElement.getVersion("", MIN_VERSION, node);
        this.maximumVersion = ConnectionTypeElement.getVersion("", MAX_VERSION, node);
        this.otherSchemasSupport = ConnectionTypeElement.getBooleanValue("", SUPPORTS_OTHER_SCHEMAS, node);
        this.showAllSchemas = ConnectionTypeElement.getBooleanValue("", SHOW_ALL_SCHEMAS, node);
        this.supportsCatalogs = ConnectionTypeElement.getBooleanValue("", SUPPORTS_CATALOG, node);
        this.supportsRowID = ConnectionTypeElement.getBooleanValue("", SUPPORTS_ROW_ID, node);
        this.implClass = ConnectionTypeElement.getAttributeValue("", IMPL_CLASS, node);
        this.providerClass = ConnectionTypeElement.getAttributeValue("", PROVIDER_CLASS, node);
        this.panelClass = ConnectionTypeElement.getAttributeValue("", CONNECTION_PANEL_CLASS, node);
        this.panelLabel = ConnectionTypeElement.getAttributeValue("", CONNECTION_TAB_NAME, node);
    }

    public String getType() {
        return this.getID();
    }

    public IconElement getIcon() {
        return this.icon;
    }

    public Version getMinimumVersion() {
        return this.minimumVersion;
    }

    public Version getMaximumVersion() {
        return this.maximumVersion;
    }

    public boolean isOtherSchemasSupport() {
        return this.otherSchemasSupport;
    }

    public boolean isShowAllSchemas() {
        return this.showAllSchemas;
    }

    public boolean isSupportsCatalogs() {
        return this.supportsCatalogs;
    }

    public boolean isSupportsRowID() {
        return this.supportsRowID;
    }

    public String getImplClass() {
        return this.implClass;
    }

    public String getProviderClass() {
        return this.providerClass;
    }

    public String getPanelClass() {
        return this.panelClass;
    }

    public String getPanelLabel() {
        return this.panelLabel;
    }
}

