/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.encoding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import oracle.dbtools.util.encoding.Decoder;
import oracle.dbtools.util.encoding.Encoder;
import oracle.dbtools.util.encoding.Encoding;
import oracle.dbtools.util.encoding.EncodingException;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.dbtools.util.encoding.MimeType;

public class BASE64Encoding
extends Encoding
implements Decoder,
Encoder {
    private static char[] map1;
    private static byte[] map2;

    public BASE64Encoding(MimeType mimeType) {
        super(EncodingType.ENCODING_BASE64, mimeType);
    }

    public char[] encodeToCharArray(byte[] in) throws IOException, EncodingException {
        return this.encodeToCharArray(in, -1, null);
    }

    public char[] encodeToCharArray(byte[] in, int breakAt, String breakChars) throws IOException, EncodingException {
        return this.encodeToString(in, breakAt, breakChars).toCharArray();
    }

    public String encodeToString(byte[] in) throws IOException, EncodingException {
        return this.encodeToString(in, -1, null);
    }

    public String encodeToString(byte[] in, int breakAt, String breakChars) throws IOException, EncodingException {
        StringWriter os = new StringWriter();
        this.encode(new ByteArrayInputStream(in), os, breakAt, breakChars);
        return os.toString();
    }

    public long getEncodeLength(byte[] in, int breakAt, String breakChars) {
        return this.getEncodeLength(in.length, breakAt, breakChars);
    }

    public long getEncodeLength(long inLen, int breakAt, String breakChars) {
        long oLen = (inLen + 2L) / 3L * 4L;
        long breakLen = 0L;
        if (breakAt > 0 && breakChars != null) {
            int breakSeg = breakChars.length();
            breakLen = oLen / (long)breakAt * (long)breakSeg;
            if (oLen % (long)breakAt == 0L) {
                breakLen -= (long)breakSeg;
            }
        }
        return oLen + breakLen;
    }

    @Override
    public long getEncodeLength(long inLen) {
        return this.getEncodeLength(inLen, -1, null);
    }

    public void encode(InputStream in, Writer out) throws IOException, EncodingException {
        this.encode(in, out, -1, null);
    }

    public void encode(InputStream in, Writer out, int breakAt, String breakChars) throws IOException, EncodingException {
        long ip = 0L;
        long op = 0L;
        int i0 = in.read();
        while (i0 != -1) {
            ++ip;
            int i1 = in.read();
            int i2 = in.read();
            if (i1 == -1) {
                i1 = 0;
            } else {
                i1 &= 0xFF;
                ++ip;
            }
            if (i2 == -1) {
                i2 = 0;
            } else {
                i2 &= 0xFF;
                ++ip;
            }
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            BASE64Encoding.writeChar(out, map1[o0], op++, breakAt, breakChars);
            BASE64Encoding.writeChar(out, map1[o1], op++, breakAt, breakChars);
            long oDataLen = (ip * 4L + 2L) / 3L;
            if (op < oDataLen) {
                BASE64Encoding.writeChar(out, map1[o2], op++, breakAt, breakChars);
            }
            if (op < oDataLen) {
                BASE64Encoding.writeChar(out, map1[o3], op++, breakAt, breakChars);
            }
            i0 = in.read();
        }
        long oLen = (ip + 2L) / 3L * 4L;
        long pCount = oLen - op;
        for (long i = 0L; i < pCount; ++i) {
            BASE64Encoding.writeChar(out, 61, op++, breakAt, breakChars);
        }
        out.flush();
    }

    private static void writeChar(Writer out, int c, long count, int breakAt, String breakChars) throws IOException {
        if (breakAt > 0 && count > 0L && breakChars != null && count % (long)breakAt == 0L) {
            out.write(breakChars);
        }
        out.write(c);
    }

    public byte[] decodeToByteArray(char[] in) throws EncodingException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.decode(new CharArrayReader(in), os);
        return os.toByteArray();
    }

    public byte[] decodeToByteArray(String in) throws EncodingException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.decode(new StringReader(in), os);
        return os.toByteArray();
    }

    public long getDecodeLength(String in) throws EncodingException {
        long iLen = 0L;
        long pCount = 0L;
        for (int i = 0; i < in.length(); ++i) {
            if (Character.isWhitespace(in.charAt(i))) continue;
            ++iLen;
            if (in.charAt(i) != '=') continue;
            ++pCount;
        }
        return this.getDecodeLength(iLen) - pCount;
    }

    @Override
    public long getDecodeLength(long inLen) throws EncodingException {
        if (inLen % 4L != 0L) {
            throw new EncodingException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        return inLen * 3L / 4L;
    }

    public long getDecodeLength(char[] in) throws EncodingException {
        long iLen = 0L;
        long pCount = 0L;
        for (int i = 0; i < in.length; ++i) {
            if (Character.isWhitespace(in[i])) continue;
            ++iLen;
            if (in[i] != '=') continue;
            ++pCount;
        }
        return this.getDecodeLength(iLen) - pCount;
    }

    @Override
    public int getDecodeBlocksize() {
        return 4;
    }

    @Override
    public int getEncodeBlocksize() {
        return 3;
    }

    public void decode(Reader in, OutputStream out) throws EncodingException, IOException {
        int i0 = BASE64Encoding.readChar(in);
        while (i0 != -1) {
            int i1 = BASE64Encoding.readChar(in);
            int i2 = BASE64Encoding.readChar(in);
            int i3 = BASE64Encoding.readChar(in);
            if (i3 == -1) {
                throw new EncodingException("Length of Base64 encoded input is not a multiple of 4.");
            }
            int x2 = i2;
            int x3 = i3;
            if ((char)i2 == '=') {
                i2 = 65;
            }
            if ((char)i3 == '=') {
                i3 = 65;
            }
            if (i0 > 127 || i1 > 127 || i2 > 127 || i3 > 127) {
                throw new EncodingException("Illegal character in Base64 encoded input.");
            }
            byte b0 = map2[i0];
            byte b1 = map2[i1];
            byte b2 = map2[i2];
            byte b3 = map2[i3];
            if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                throw new EncodingException("Illegal character in Base64 encoded input.");
            }
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            out.write(o0);
            if ((char)x2 != '=') {
                out.write(o1);
            }
            if ((char)x3 != '=') {
                out.write(o2);
            }
            i0 = BASE64Encoding.readChar(in);
        }
        out.flush();
    }

    private static int readChar(Reader in) throws IOException {
        int i = in.read();
        while (i != -1 && Character.isWhitespace((char)i)) {
            i = in.read();
        }
        return i;
    }

    public Object decodeBuffer(Object in) throws EncodingException, IOException {
        if (in == null) {
            return null;
        }
        return this.decodeToByteArray((String)in);
    }

    @Override
    public void decodeStream(Object in, Object out) throws EncodingException, IOException {
        this.decode((Reader)in, (OutputStream)out);
    }

    public Object encodeBuffer(Object in) throws EncodingException, IOException {
        return this.encodeToString((byte[])in);
    }

    @Override
    public void encodeStream(Object in, Object out) throws EncodingException, IOException {
        this.encode((InputStream)in, (Writer)out);
    }

    static {
        int c;
        map1 = new char[64];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            BASE64Encoding.map1[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            BASE64Encoding.map1[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            BASE64Encoding.map1[i++] = c;
        }
        BASE64Encoding.map1[i++] = 43;
        BASE64Encoding.map1[i++] = 47;
        map2 = new byte[128];
        for (i = 0; i < map2.length; ++i) {
            BASE64Encoding.map2[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            BASE64Encoding.map2[BASE64Encoding.map1[i]] = (byte)i;
        }
    }
}

