/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class Debug {
    private static int debugLevel = 0;
    public static boolean DEBUG = false;

    private static synchronized void init() {
    }

    public static void setDebug(boolean flag) {
        DEBUG = flag;
    }

    private static void print(Object obj, String sep) {
        if (obj instanceof String) {
            System.err.print(obj);
        } else if (obj instanceof String[]) {
            int ii = ((String[])obj).length;
            for (int i = 0; i < ii; ++i) {
                Debug.print(((String[])obj)[i], ",");
            }
        } else if (obj instanceof HashMap) {
            Set keys = ((HashMap)obj).keySet();
            for (String key : keys) {
                System.err.print(key + "=");
                Debug.print(((HashMap)obj).get(key), ",");
            }
        } else if (obj instanceof List) {
            int ii = ((List)obj).size();
            for (int i = 0; i < ii; ++i) {
                Debug.print(((List)obj).get(i), ",");
            }
        } else {
            System.err.print(obj);
        }
        System.err.print(sep);
    }

    public static void debug(Object s) {
        Debug.init();
        if (debugLevel >= 3) {
            Debug.print(s, "\n");
        }
    }

    public static void info(Object s) {
        Debug.init();
        if (debugLevel >= 2) {
            Debug.print(s, "\n");
        }
    }

    public static void warn(Object s) {
        Debug.init();
        if (debugLevel >= 1) {
            Debug.print(s, "\n");
        }
    }

    public static void error(Object s) {
        Debug.init();
        Debug.print(s, "\n");
    }

    public static boolean isDebugBuild() {
        return DEBUG;
    }
}

