/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer;

import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.transfer.file.FileSet;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.task.TransferTask;

public class TransferManager {
    public static TransferManager INSTANCE = new TransferManager();
    Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    private TransferManager() {
    }

    public TransferTask createTransferTask(String name, IRaptorTaskRunMode mode, FileSet fileSet, Location targetLocation, String targetDir) {
        TransferTask task = new TransferTask(name, mode, fileSet, targetLocation, targetDir);
        return task;
    }

    public void setPackageLogStream(OutputStream out, boolean useParentHandlers) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS %4$-6s %2$s %5$s%6$s%n");
        StreamHandler handler = new StreamHandler(out, new SimpleFormatter(){

            @Override
            public synchronized String format(LogRecord record) {
                return Thread.currentThread().toString() + " " + super.format(record);
            }
        }){

            @Override
            public synchronized void publish(LogRecord record) {
                super.publish(record);
                this.flush();
            }
        };
        this.logger.addHandler(handler);
        this.logger.setUseParentHandlers(useParentHandlers);
        String msg = out == System.out ? "System.out" : (out == System.err ? "System.err" : String.valueOf(out));
        oracle.dbtools.util.Logger.info(this.getClass(), msg + ", useParentHandlers=" + useParentHandlers);
    }

    public void setPackageLogLevel(Level newLevel) {
        oracle.dbtools.util.Logger.info(this.getClass(), String.valueOf(newLevel));
        this.logger.setLevel(newLevel);
    }
}

