/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.generators;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.NoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class RestCodeGenerator {
    private static volatile RestCodeGenerator _instance;
    private static final String DEFAULT_ORDS_GROUP = "ordsgen";
    private StringTemplateGroup m_templateGroup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RestCodeGenerator getInstance() {
        if (_instance != null) return _instance;
        Class<RestCodeGenerator> clazz = RestCodeGenerator.class;
        synchronized (RestCodeGenerator.class) {
            if (_instance != null) return _instance;
            _instance = new RestCodeGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private RestCodeGenerator() {
        this.loadTemplates();
    }

    private void loadTemplates() {
        RestGroupLoader loader = new RestGroupLoader("oracle/dbtools/rest/generators/templates", this.getClass().getClassLoader());
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)loader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
    }

    protected void loadGroup() {
        this.m_templateGroup = StringTemplateGroup.loadGroup((String)DEFAULT_ORDS_GROUP);
    }

    protected void loadGroup(String ordsVer) {
        this.m_templateGroup = StringTemplateGroup.loadGroup((String)DEFAULT_ORDS_GROUP);
    }

    protected StringTemplateGroup getTemplateGroup() {
        if (this.m_templateGroup == null) {
            this.loadGroup();
        }
        return this.m_templateGroup;
    }

    protected String getTemplate(String templateName, Map<String, Object> properties) {
        StringTemplate st = this.getTemplateGroup().lookupTemplate(templateName);
        if (st != null) {
            st.setAttributes(properties);
            NoIndentWriter out = new NoIndentWriter((Writer)new StringWriter(30));
            try {
                st.write((StringTemplateWriter)out);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return st.toString();
        }
        return null;
    }

    private class RestGroupLoader
    extends CommonGroupLoader {
        private ClassLoader m_cl;

        public RestGroupLoader(String dir, ClassLoader cl) {
            super(dir, null);
            assert (cl != null);
            this.m_cl = cl;
        }

        protected BufferedReader locate(String name) throws IOException {
            for (Object o : this.dirs) {
                String dir = (String)o;
                String fName = dir + "/" + name;
                InputStream is = this.m_cl.getResourceAsStream(fName);
                if (is == null) continue;
                return new BufferedReader(this.getInputStreamReader(is));
            }
            return null;
        }
    }
}

