/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;

public final class ResolvedDBObject {
    private String _owner;
    private String _part1;
    private String _part2;
    private String _dblink;
    private int _type;
    private String _filter;
    private BigDecimal _id;
    private boolean bad = false;
    private static String error = "";
    private static final String PLSQL_DBMS_UTILITY_RESOLVE = "begin  DBMS_UTILITY.NAME_RESOLVE (   name          => :NAME,    context       => :CTX,   schema        => :SCHEMA,    part1         => :PART1,    part2         => :PART2,   dblink        => :DBLINK,    part1_type    => :PART1_TYPE,    object_number => :NUM);end;";
    private static final String QUERY_OWNED_SYNONYM = "select owner,table_name,table_owner from all_synonyms where synonym_name = :NAME and owner = :OWNER";
    private static final String QUERY_SYNONYM = "select owner,table_name,table_owner from all_synonyms where synonym_name = :NAME";
    private static final String PLSQL_DBMS_UTILITY_TOKENIZE = "begin  DBMS_UTILITY.NAME_TOKENIZE (   name   => :NAME,    a      => :A,    b      => :B,    c      => :C,    dblink => :DBLINK,    nextpos => :NEXTPOS);end;";

    private ResolvedDBObject(String owner, String part1, String part2, String dblink, int type, String filter, BigDecimal objId) {
        this._owner = owner;
        this._part1 = part1;
        this._part2 = part2;
        this._dblink = dblink;
        this._type = type;
        this._filter = filter;
        this._id = objId;
    }

    private ResolvedDBObject(String errorMessage) {
        this.bad = true;
        error = errorMessage;
    }

    public BigDecimal getId() {
        return this._id;
    }

    public String getName() {
        if (this._type == 2 || this._type == 4) {
            return this._part1;
        }
        if (this._type == 7 || this._type == 8) {
            return this._part2;
        }
        if (this._type == 9) {
            return this._part1;
        }
        return this._part1;
    }

    public int getType() {
        return this._type;
    }

    public String getTypeName() {
        switch (this._type) {
            case 1: {
                return "TABLE";
            }
            case 2: {
                return "TABLE";
            }
            case 4: {
                return "VIEW";
            }
            case 5: {
                return "SYNONYM";
            }
            case 7: {
                return "PROCEDURE";
            }
            case 8: {
                return "FUNCTION";
            }
            case 9: {
                return "PACKAGE";
            }
        }
        return null;
    }

    public String getFilter() {
        return this._filter;
    }

    public String getOwner() {
        return this._owner;
    }

    public String getPart1() {
        return this._part1;
    }

    public String getPart2() {
        return this._part2;
    }

    public String getDBlink() {
        return this._dblink;
    }

    public HashMap<String, ?> getBinds() {
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OBJECT_OWNER", this._owner);
        binds.put("FILTER", this._filter);
        if (this._type == 2 || this._type == 4) {
            binds.put("OBJECT_NAME", this._part1);
        } else if (this._type == 7 || this._type == 8) {
            binds.put("OBJECT_NAME", this._part2);
        } else if (this._type == 9) {
            binds.put("OBJECT_NAME", this._part1);
            binds.put("FILTER", this._part2);
        }
        return binds;
    }

    public static ResolvedDBObject resolveDBObject(Connection conn, String rawName, String filter) {
        if (conn == null) {
            return new ResolvedDBObject("no connection");
        }
        ResolvedDBObject dbObj = null;
        if (conn != null) {
            for (int i = 0; i < 11 && dbObj == null; ++i) {
                if (dbObj == null) {
                    dbObj = ResolvedDBObject.getResolvedObject(conn, rawName, i, filter);
                }
                if (i != 9 || !rawName.contains(".")) continue;
                filter = rawName.substring(rawName.lastIndexOf(".") + 1);
                rawName = rawName.substring(0, rawName.lastIndexOf("."));
                i = -1;
            }
        }
        if (dbObj == null) {
            dbObj = ResolvedDBObject.getSynonymnReference(conn, rawName);
        }
        if (dbObj == null && rawName.contains("@")) {
            dbObj = ResolvedDBObject.getResolvedObjectlink(conn, rawName);
        }
        return dbObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResolvedDBObject getSynonymnReference(Connection conn, String rawName) {
        ResolvedDBObject dbObj = null;
        String synonymName = null;
        String synonymOwner = null;
        OracleCallableStatement call = null;
        try {
            call = (OracleCallableStatement)conn.prepareCall(PLSQL_DBMS_UTILITY_TOKENIZE);
            call.registerOutParameter(2, 12);
            call.registerOutParameter(3, 12);
            call.registerOutParameter(4, 12);
            call.registerOutParameter(5, 12);
            call.registerOutParameter(6, 2);
            call.setString(1, rawName);
            call.execute();
            String a = call.getString(2);
            String b = call.getString(3);
            String c = call.getString(4);
            String dblink = call.getString(5);
            int nextpos = call.getInt(6);
            if (b == null) {
                synonymName = a;
            } else {
                synonymOwner = a;
                synonymName = b;
            }
        }
        catch (SQLException e) {
            synonymName = rawName;
        }
        finally {
            if (call != null) {
                try {
                    call.close();
                }
                catch (SQLException e) {}
            }
        }
        try {
            OraclePreparedStatement stmt = null;
            OracleResultSet rset = null;
            try {
                if (synonymOwner != null) {
                    stmt = (OraclePreparedStatement)conn.prepareStatement(QUERY_OWNED_SYNONYM);
                    stmt.setStringAtName("OWNER", synonymOwner);
                } else {
                    stmt = (OraclePreparedStatement)conn.prepareStatement(QUERY_SYNONYM);
                }
                stmt.setStringAtName("NAME", synonymName);
                rset = (OracleResultSet)stmt.executeQuery();
                if (rset.next()) {
                    synonymOwner = rset.getString(1);
                    String objectName = rset.getString(2);
                    String objectOwner = rset.getString(3);
                    dbObj = new ResolvedDBObject(synonymOwner, synonymName, "\"" + objectOwner + "\".\"" + objectName + "\"", null, 5, null, null);
                }
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                stmt.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return dbObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResolvedDBObject getResolvedObjectlink(Connection conn, String rawName) {
        block46: {
            Object object;
            Object dblink;
            Object call = null;
            try {
                String link = rawName;
                dblink = "";
                String object2 = "";
                String schema = "";
                object2 = link.indexOf(64) > -1 ? link.substring(0, link.indexOf("@")) : "";
                if (object2.indexOf(46) > -1) {
                    schema = object2.substring(0, object2.indexOf(46));
                    object2 = object2.substring(object2.indexOf(46) + 1, object2.length());
                } else {
                    schema = "";
                }
                dblink = link.indexOf("@") > -1 ? link.substring(link.indexOf("@") + 1, link.length()) : "";
                OraclePreparedStatement checkStmt = (OraclePreparedStatement)conn.prepareStatement("select username,owner from all_db_links where UPPER(db_link) like UPPER(:LINK)||'%'");
                checkStmt.setStringAtName("LINK", ((String)dblink).toUpperCase());
                ResultSet rset = checkStmt.executeQuery();
                rset.next();
                if (rset.getString(1) != null && !rset.getString(1).trim().equals("")) {
                    schema = rset.getString(1);
                }
                rset.close();
                checkStmt.close();
                checkStmt = (OraclePreparedStatement)conn.prepareStatement(MessageFormat.format("select object_type from all_objects{0} where UPPER(object_name) = UPPER(:NAME) and UPPER(owner) = UPPER(:OWNER)", "@" + ((String)dblink).toUpperCase()));
                checkStmt.setStringAtName("NAME", object2);
                checkStmt.setStringAtName("OWNER", schema);
                rset = checkStmt.executeQuery();
                rset.next();
                if (rset.getString(1).length() == 0) {
                    ResolvedDBObject resolvedDBObject = null;
                    return resolvedDBObject;
                }
                String type = rset.getString(1);
                int context = 0;
                switch (type) {
                    case "TABLE": {
                        context = 1;
                        break;
                    }
                    case "VIEW": {
                        context = 4;
                        break;
                    }
                    case "FUNCTION": {
                        context = 8;
                        break;
                    }
                    case "PROCEDURE": {
                        context = 7;
                        break;
                    }
                    case "PACKAGE": {
                        context = 9;
                        break;
                    }
                    case "SYNONYM": {
                        context = 5;
                        break;
                    }
                    default: {
                        context = 1;
                    }
                }
                object = new ResolvedDBObject(schema, object2, "", (String)dblink, context, "", null);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 6563) {
                    dblink = new ResolvedDBObject("Object Not Found: " + rawName);
                    return dblink;
                }
                if (e.getErrorCode() == 931) {
                    dblink = new ResolvedDBObject("invalid object name");
                    return dblink;
                }
                if (e.getErrorCode() != 4047 && e.getErrorCode() != 6564) {
                    ResolvedDBObject dbObj;
                    ResolvedDBObject resolvedDBObject = dbObj = new ResolvedDBObject(e.getMessage());
                    return resolvedDBObject;
                }
                break block46;
            }
            finally {
                if (call != null) {
                    try {
                        call.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResolvedDBObject getResolvedObject(Connection conn, String rawName, int ctx, String filter) {
        OracleCallableStatement call = null;
        try {
            call = (OracleCallableStatement)conn.prepareCall(PLSQL_DBMS_UTILITY_RESOLVE);
            call.registerOutParameter(3, 12);
            call.registerOutParameter(4, 12);
            call.registerOutParameter(5, 12);
            call.registerOutParameter(6, 12);
            call.registerOutParameter(7, 2);
            call.registerOutParameter(8, 2);
            call.setString(1, rawName);
            call.setInt(2, ctx);
            call.execute();
            String schema = call.getString(3);
            String part1 = call.getString(4);
            String part2 = call.getString(5);
            String dblink = call.getString(6);
            int type = call.getInt(7);
            BigDecimal objId = call.getBigDecimal(8);
            ResolvedDBObject dbObj = new ResolvedDBObject(schema, part1, part2, dblink, type, filter, objId);
            PreparedStatement checkStmt = conn.prepareStatement("select count(*) from all_objects where object_name = :NAME and owner = :OWNER");
            checkStmt.setString(1, dbObj.getName());
            checkStmt.setString(2, dbObj.getOwner());
            ResultSet rset = checkStmt.executeQuery();
            rset.next();
            if (rset.getInt(1) == 0) {
                dbObj = null;
            }
            ResolvedDBObject resolvedDBObject = dbObj;
            return resolvedDBObject;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 6563) {
                ResolvedDBObject part1 = new ResolvedDBObject("Object Not Found: " + rawName);
                return part1;
            }
            if (e.getErrorCode() == 931) {
                ResolvedDBObject part1 = new ResolvedDBObject("invalid object name");
                return part1;
            }
            if (e.getErrorCode() != 4047 && e.getErrorCode() != 6564) {
                ResolvedDBObject dbObj;
                ResolvedDBObject resolvedDBObject = dbObj = new ResolvedDBObject(e.getMessage());
                return resolvedDBObject;
            }
        }
        finally {
            if (call != null) {
                try {
                    call.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return null;
    }

    public final boolean isBad() {
        return this.bad;
    }

    public final String getError() {
        return error;
    }
}

