/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.DatabaseFeature;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Logger;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class DatabaseFeatureRegistry {
    private static final String CLASSNAME_ELEMENT = "classname";
    private static final String QUERIES_ELEMENT = "queries";
    private static final String ID_ATTR = "id";
    private static final String FEATURE_ELEMENT = "feature";
    public static final DatabaseFeatureRegistry DEFAULT_REGISTRY;
    private static DatabaseFeatureRegistry sInstance;
    private Map<String, DatabaseFeature> classnameMap = new HashMap<String, DatabaseFeature>();
    private Map<String, DatabaseFeature> knownFeatures;
    private Map<ConnectionIdentifier.Key, Map<String, Boolean>> m_features = new HashMap<ConnectionIdentifier.Key, Map<String, Boolean>>();

    public static void setFeatureRegistry(DatabaseFeatureRegistry registry) {
        sInstance = registry;
        sInstance.initialize();
    }

    public static boolean isFeatureEnabled(ConnectionIdentifier connID, String featureID) {
        return sInstance.isFeatureEnabledImpl(connID, featureID);
    }

    protected abstract void loadFeaturesImpl();

    protected final void loadFeatures() {
        if (this.knownFeatures == null) {
            this.knownFeatures = new HashMap<String, DatabaseFeature>();
            this.loadFeaturesImpl();
        }
    }

    protected void initialize() {
    }

    protected boolean isFeatureEnabledImpl(ConnectionIdentifier connID, String featureID) {
        boolean enabled = false;
        Map<String, Boolean> features = this.m_features.get(connID.getIdentifierKey());
        if (features != null) {
            Boolean val = features.get(featureID);
            enabled = val != null && val != false;
        }
        return enabled;
    }

    private Map<String, Boolean> getFeatures(ConnectionIdentifier connID) {
        ConnectionIdentifier.Key key = connID.getIdentifierKey();
        Map<String, Boolean> features = this.m_features.get(key);
        if (features == null) {
            features = new HashMap<String, Boolean>();
            this.m_features.put(key, features);
        }
        return features;
    }

    protected void initializeFeatures(ConnectionIdentifier connID) {
        Map<String, Boolean> features = this.getFeatures(connID);
        for (Map.Entry<String, DatabaseFeature> entry : this.getKnownFeatures().entrySet()) {
            String id = entry.getKey();
            DatabaseFeature df = entry.getValue();
            features.put(id, df.isFeatureEnabled(connID, id));
        }
    }

    private Map<String, DatabaseFeature> getKnownFeatures() {
        this.loadFeatures();
        return Collections.unmodifiableMap(this.knownFeatures);
    }

    protected void cleanupFeatures(ConnectionIdentifier connID) {
        this.m_features.remove(connID.getIdentifierKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processURL(URL url, ClassLoader cl) {
        HashMap<String, DatabaseFeature> localFeatures = new HashMap<String, DatabaseFeature>();
        InputStream in = null;
        try {
            XMLNode[] featureNodes;
            DOMParser parser = new DOMParser();
            parser.setPreserveWhitespace(false);
            in = url.openStream();
            parser.parse(in);
            XMLDocument doc = parser.getDocument();
            Node root = doc.getFirstChild();
            for (XMLNode node : featureNodes = XMLHelper.getChildNodes(root, FEATURE_ELEMENT)) {
                String id = XMLHelper.getAttributeNode((Node)node, ID_ATTR);
                Node child = XMLHelper.getChildNode((Node)node, QUERIES_ELEMENT);
                if (child != null) {
                    if (!(child instanceof XMLNode)) continue;
                    localFeatures.put(id, new QueryFeature((XMLNode)child));
                    continue;
                }
                child = XMLHelper.getChildNode((Node)node, CLASSNAME_ELEMENT);
                if (child == null) continue;
                String clsName = null;
                Node txt = child.getFirstChild();
                if (txt instanceof Text) {
                    clsName = txt.getTextContent();
                }
                if (!ModelUtil.hasLength(clsName)) continue;
                DatabaseFeature feature = this.classnameMap.get(clsName);
                if (feature == null) {
                    Class<DatabaseFeature> cls = cl.loadClass(clsName).asSubclass(DatabaseFeature.class);
                    feature = cls.newInstance();
                    this.classnameMap.put(clsName, feature);
                }
                localFeatures.put(id, feature);
            }
        }
        catch (Exception e) {
            Logger.severe(DatabaseFeatureRegistry.class, "Error parsing file " + url.toString(), e);
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        this.knownFeatures.putAll(localFeatures);
    }

    static {
        sInstance = DEFAULT_REGISTRY = new DatabaseFeatureRegistry(){

            @Override
            protected void loadFeaturesImpl() {
            }
        };
    }

    private static class QueryFeature
    implements DatabaseFeature {
        private ObjectQueries m_queries;

        QueryFeature(XMLNode elem) {
            this.m_queries = new ObjectQueries(elem);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFeatureEnabled(ConnectionIdentifier connID, String featureID) {
            Query q = this.m_queries.getQuery(connID);
            if (q != null) {
                String sql = q.getSql();
                DBUtil util = DBUtil.getInstance(connID);
                try {
                    boolean bl = util.executeReturnOneCol(sql) != null;
                    return bl;
                }
                finally {
                    SQLException ex = util.getLastException();
                    if (ex != null) {
                        Logger.fine(DatabaseFeatureRegistry.class, ex);
                    }
                }
            }
            return false;
        }
    }
}

