/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.ssh.core.Descriptor;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;

public final class TunnelDescriptor
extends Descriptor {
    public static final int AUTO_ASSIGN_LOCAL_PORT = -1;
    private final String mHost;
    private final int mHostPort;
    private final int mPort;
    private final Type type;
    private HostDescriptor host;

    private TunnelDescriptor(String name, Type type, String remoteHost, int remotePort, int localPort) {
        super(name);
        this.mHost = remoteHost;
        this.mHostPort = remotePort;
        this.mPort = localPort;
        this.type = type;
    }

    public String getHostname() {
        return this.mHost;
    }

    public int getHostport() {
        return this.mHostPort;
    }

    public int getPort() {
        return this.mPort;
    }

    public void setHost(HostDescriptor host) {
        this.host = host;
    }

    public HostDescriptor getHost() {
        return this.host;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TunnelDescriptor) {
            TunnelDescriptor other = (TunnelDescriptor)obj;
            return this.equalsImpl(other);
        }
        return false;
    }

    protected boolean equalsImpl(TunnelDescriptor other) {
        return super.equalsImpl(other) && this.type == other.type && ModelUtil.areEqual(this.mHost, other.mHost) && this.mHostPort == other.mHostPort && this.mPort == other.mPort;
    }

    public String toString() {
        return this.getName() + (this.mPort > 0 ? this.mPort + ":" : "") + this.mHost + ":" + this.mHostPort;
    }

    public static final class Builder {
        private final String name;
        private final Type type;
        private String mHostname = "localhost";
        private int mHostPort;
        private int mPort = -1;

        public Builder(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        public Builder port(int localPort) {
            this.mPort = localPort;
            return this;
        }

        public Builder host(String hostname) {
            this.mHostname = hostname;
            return this;
        }

        public Builder hostPort(int hostPort) {
            this.mHostPort = hostPort;
            return this;
        }

        public TunnelDescriptor getDescriptor() {
            TunnelDescriptor desc = new TunnelDescriptor(this.name, this.type, this.mHostname, this.mHostPort, this.mPort);
            return desc;
        }
    }

    public static enum Type {
        LOCAL,
        REMOTE;

    }
}

