/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.OpenSSHConfig;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.ssh.core.ClientEvent;
import oracle.dbtools.raptor.ssh.core.ClientListener;
import oracle.dbtools.raptor.ssh.core.HostConnection;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.SshConfigParameter;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ssh.core.StoreEvent;
import oracle.dbtools.raptor.ssh.core.StoreListener;
import oracle.dbtools.raptor.ssh.core.Tunnel;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Pair;

public abstract class Client {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_SSH_PORT = 22;
    private static Class<? extends Client> sImplementationClass;
    private Store mStore;
    private final JSch sshClient;
    private Map<String, HostConnection> mConns = new HashMap<String, HostConnection>();
    private List<ClientListener> listeners = new CopyOnWriteArrayList<ClientListener>();
    private URL knownHosts;
    private final ConfigRepository defaultConfig;

    public static synchronized void setImplementationClass(Class<? extends Client> cls) {
        if (sImplementationClass != null) {
            throw new IllegalStateException("Client implementation already set: " + sImplementationClass.getName());
        }
        sImplementationClass = cls;
    }

    public static Client getInstance() {
        return Holder.INSTANCE;
    }

    protected Client() {
        this.sshClient = new JSch();
        this.defaultConfig = this.sshClient.getConfigRepository();
    }

    public Store getStore() {
        return this.mStore;
    }

    protected abstract Store createStore();

    private void init() {
        this.mStore = this.createStore();
        this.mStore.addStoreListener(new StoreListener(){

            @Override
            public void hostRemoved(StoreEvent event) {
                HostDescriptor desc = event.getHostDescriptor();
                Client.this.closeConnection(desc);
            }

            @Override
            public void hostChanged(StoreEvent event) {
                HostDescriptor desc = (HostDescriptor)event.getOldDescriptor();
                Client.this.closeConnection(desc);
            }

            @Override
            public void tunnelRemoved(StoreEvent event) {
                TunnelDescriptor desc = event.getTunnelDescriptor();
                try {
                    Client.this.closeTunnel(desc);
                }
                catch (JSchException jSchException) {
                    // empty catch block
                }
            }

            @Override
            public void tunnelChanged(StoreEvent event) {
                TunnelDescriptor desc = (TunnelDescriptor)event.getOldDescriptor();
                try {
                    Client.this.closeTunnel(desc);
                }
                catch (JSchException jSchException) {
                    // empty catch block
                }
            }
        });
        this.initSSHClient();
    }

    protected abstract URL getStoreURL();

    protected abstract void initSSHClient();

    protected final JSch getSSHClient() {
        return this.sshClient;
    }

    private final Session createSession(HostDescriptor desc) throws JSchException {
        Session session = this.sshClient.getSession(desc.getUsername(), desc.getHostname(), desc.getPort());
        URL knownHosts = this.getKnownHosts();
        if (knownHosts == null) {
            session.setConfig("StrictHostKeyChecking", "no");
        }
        session.setTimeout(15000);
        IdentityRepository ir = this.getRepository(desc);
        if (ir != null) {
            session.setIdentityRepository(ir);
        }
        this.initSession(session, desc);
        return session;
    }

    protected URL getKnownHosts() {
        return this.knownHosts;
    }

    protected void setKnownHosts(URL file) {
        String fName;
        this.knownHosts = file;
        if (this.knownHosts != null && (fName = Client.convertURLToFilePath(this.knownHosts)) != null) {
            try {
                this.sshClient.setKnownHosts(fName);
            }
            catch (JSchException e) {
                Logger.severe(Client.class, e);
            }
        }
    }

    protected void setConfigParamters(List<Pair<SshConfigParameter, String>> configParams) {
        String cfgString = SshConfigParameter.convertToConfigString(configParams);
        if (ModelUtil.hasLength(cfgString)) {
            try {
                OpenSSHConfig cfgRepo = OpenSSHConfig.parse((String)cfgString);
                this.setConfigRepository((ConfigRepository)cfgRepo);
            }
            catch (IOException e) {
                Logger.severe(Client.class, e);
            }
        }
    }

    protected void setConfigFile(URL cfgFile) {
        String path;
        if (cfgFile != null && (path = Client.convertURLToFilePath(cfgFile)) != null) {
            try {
                this.setConfigRepository((ConfigRepository)OpenSSHConfig.parseFile((String)path));
            }
            catch (IOException e1) {
                Logger.severe(Client.class, e1);
            }
        }
    }

    protected void resetConfigRepository() {
        this.setConfigRepository(null);
    }

    private void setConfigRepository(ConfigRepository cfgRepos) {
        if (cfgRepos == null) {
            this.sshClient.setConfigRepository(this.defaultConfig);
        } else {
            this.sshClient.setConfigRepository(cfgRepos);
        }
    }

    protected static String convertURLToFilePath(URL url) {
        String fName = null;
        try {
            URI fileURI = url.toURI();
            File f = new File(fileURI);
            fName = f.getAbsolutePath();
        }
        catch (URISyntaxException e) {
            Logger.severe(Client.class, e);
        }
        return fName;
    }

    protected abstract IdentityRepository getRepository(HostDescriptor var1) throws JSchException;

    protected abstract void initSession(Session var1, HostDescriptor var2);

    public final synchronized HostConnection openConnection(HostDescriptor host) throws JSchException {
        String name = host.getName();
        HostConnection conn = this.mConns.get(name);
        if (conn == null) {
            Session session = this.createSession(host);
            session.connect();
            conn = new HostConnection(this, session, host);
            this.fireConnectionOpened(conn);
            this.mConns.put(name, conn);
        }
        return conn;
    }

    public final synchronized void closeConnection(HostDescriptor host) {
        String name = host.getName();
        HostConnection conn = this.mConns.remove(name);
        if (conn != null) {
            conn.disconnect();
            this.fireConnectionClosed(conn);
        }
    }

    public final boolean isConnectionOpen(HostDescriptor host) {
        String name = host.getName();
        return this.mConns.containsKey(name);
    }

    public final synchronized Tunnel openTunnel(TunnelDescriptor tunnelDesc) throws JSchException {
        HostDescriptor host = tunnelDesc.getHost();
        HostConnection conn = this.openConnection(host);
        return conn != null ? conn.openTunnel(tunnelDesc) : null;
    }

    public final void closeTunnel(TunnelDescriptor tunnelDesc) throws JSchException {
        HostDescriptor host = tunnelDesc.getHost();
        String connName = host.getName();
        HostConnection conn = this.mConns.get(connName);
        if (conn != null) {
            conn.closeTunnel(tunnelDesc);
        }
    }

    public final boolean isTunnelOpen(TunnelDescriptor desc) {
        HostDescriptor host = desc.getHost();
        String connName = host.getName();
        HostConnection conn = this.mConns.get(connName);
        return conn != null && conn.isTunnelOpen(desc);
    }

    public final void testConnection(HostDescriptor host) throws JSchException {
        Session session = this.createSession(host);
        session.connect();
        session.disconnect();
    }

    public final void addListener(ClientListener l) {
        this.listeners.add(l);
    }

    public final void removeListener(ClientListener l) {
        this.listeners.remove(l);
    }

    final void fireConnectionOpened(HostConnection conn) {
        ClientEvent e = null;
        for (ClientListener l : this.listeners) {
            if (e == null) {
                e = new ClientEvent(this, ClientEvent.EventType.SESSION_OPENED, conn);
            }
            l.connectionOpened(e);
        }
    }

    final void fireConnectionClosed(HostConnection conn) {
        ClientEvent e = null;
        for (ClientListener l : this.listeners) {
            if (e == null) {
                e = new ClientEvent(this, ClientEvent.EventType.SESSION_CLOSED, conn);
            }
            l.connectionClosed(e);
        }
    }

    final void fireTunnelOpened(Tunnel tunnel) {
        ClientEvent e = null;
        for (ClientListener l : this.listeners) {
            if (e == null) {
                e = new ClientEvent(this, ClientEvent.EventType.TUNNEL_OPENED, tunnel);
            }
            l.tunnelOpened(e);
        }
    }

    final void fireTunnelClosed(Tunnel tunnel) {
        ClientEvent e = null;
        for (ClientListener l : this.listeners) {
            if (e == null) {
                e = new ClientEvent(this, ClientEvent.EventType.TUNNEL_CLOSED, tunnel);
            }
            l.tunnelClosed(e);
        }
    }

    private static final class Holder {
        static final Client INSTANCE;

        private Holder() {
        }

        static {
            if (sImplementationClass == null) {
                throw new IllegalStateException("SSH Client Implementation not set.");
            }
            try {
                INSTANCE = (Client)sImplementationClass.newInstance();
                Holder.INSTANCE.init();
            }
            catch (Exception ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
    }
}

