/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.query.Bind;
import oracle.jdbc.OracleDriver;

public class Parser {
    private static Object LOCK = new Object();
    private static Parser _instance;

    public static void main(String[] args) throws Exception {
        String input = "select 1 from dual where x=:1 and y=:b";
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("1", Integer.toString(1));
        binds.put("b", "be");
        System.out.println(Parser.getInstance().inlineBinds(input, binds));
        input = "select 1 from dual where x=? and y=?";
        System.out.println(Parser.getInstance().getQuestionMarks(input));
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection c = DriverManager.getConnection("jdbc:oracle:thin:@gbr30060.uk.oracle.com:1521/DB12PERF", "hr", "hr");
        String sql = "with d as ( SELECT rownum true_rownum, floor(rownum/3) rn FROM dual connect by rownum <= 100 )\nSELECT * FROM d\nMATCH_RECOGNIZE (\nORDER BY true_rownum\nMEASURES five.rn as five_rn,\nfive.true_rownum as five_true_rownum,\ntwelve.rn as twelve_rn,\ntwelve.true_rownum as twelve_true_rownum\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN ( five anything*? twelve )\nDEFINE five AS five.rn = 5,\ntwelve AS twelve.rn = 12\n) mr;";
        PreparedStatement cs = c.prepareStatement(sql);
        cs.setString(1, "?");
        ResultSet rs = cs.executeQuery();
        rs.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Parser getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new Parser();
            }
        }
        return _instance;
    }

    public ArrayList<String> getBindNames(String in) {
        return this.getBindNames(in, false);
    }

    public ArrayList<String> getBindNames(String in, boolean all) {
        ArrayList<Bind> binds = this.getBinds(in, all);
        ArrayList<String> ret = new ArrayList<String>();
        for (Bind b : binds) {
            ret.add(b.getName().intern());
        }
        return ret;
    }

    public ArrayList<Bind> getBinds(String in) {
        return this.getBinds(in, false);
    }

    public ArrayList<Bind> getBinds(String input, boolean all) {
        ArrayList<Bind> ret = new ArrayList<Bind>();
        if (input == null) {
            return ret;
        }
        List<LexerToken> src = LexerToken.parse(input, true);
        boolean sawColon = false;
        int colonStart = 0;
        boolean foundReturning = false;
        for (LexerToken t : src) {
            if (sawColon) {
                if (all || !Parser.contains(ret, t.content)) {
                    if (t.type == Token.WS) continue;
                    if (t.type == Token.IDENTIFIER || t.type == Token.DIGITS) {
                        Bind b = new Bind(t.content, null, t.content, "NULL_VALUE", t.content, foundReturning ? Bind.Mode.RETURNING : Bind.Mode.UNKNOWN);
                        b.setBegin(colonStart);
                        b.setEnd(t.end);
                        ret.add(b);
                    }
                }
                sawColon = false;
                continue;
            }
            if (":".equals(t.content)) {
                sawColon = true;
                colonStart = t.begin;
                continue;
            }
            if (!"returning".equals(t.content.toLowerCase())) continue;
            foundReturning = true;
            sawColon = false;
        }
        return ret;
    }

    public List<Integer> getQuestionMarks(String input) {
        LinkedList<Integer> ret = new LinkedList<Integer>();
        if (input == null) {
            return ret;
        }
        List<LexerToken> src = LexerToken.parse(input, true);
        for (LexerToken t : src) {
            if (!"?".equals(t.content)) continue;
            ret.add(t.begin);
        }
        return ret;
    }

    public String inlineBinds(String input, Map<String, String> bindValues) {
        StringBuilder ret = new StringBuilder();
        List<LexerToken> src = LexerToken.parse(input, true);
        boolean sawColon = false;
        for (LexerToken t : src) {
            if (sawColon) {
                if (t.type == Token.IDENTIFIER || t.type == Token.DIGITS) {
                    String value = bindValues.get(t.content);
                    if (value instanceof Integer) {
                        ret.append((Object)value);
                    } else {
                        ret.append("'" + value + "'");
                    }
                }
                sawColon = false;
                continue;
            }
            if (":".equals(t.content)) {
                sawColon = true;
                continue;
            }
            ret.append(t.content);
        }
        return ret.toString();
    }

    private static boolean contains(ArrayList<Bind> binds, String name) {
        for (Bind bind : binds) {
            if (!bind.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

