/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMP;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraTemporalDatumFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.TIMESTAMP;

public class OraTIMESTAMPFormat
extends OraTemporalDatumFormat {
    public OraTIMESTAMPFormat(String pattern, OraLocaleInfo localeInfo) throws ParseException {
        this(pattern, localeInfo, null);
    }

    public OraTIMESTAMPFormat(String pattern, OraLocaleInfo localeInfo, TimeZone sessionTimeZone) throws ParseException {
        super(pattern, localeInfo, sessionTimeZone);
    }

    @Override
    public void applyPattern(String pattern) throws ParseException {
        String uc = pattern.toUpperCase(Locale.US);
        StringBuffer pat = new StringBuffer(pattern);
        int pos = -1;
        pos = -1;
        while ((pos = uc.indexOf("TZ", pos + 1)) >= 0 && pos <= uc.length() - 3) {
            char c = uc.charAt(pos + 2);
            if (c != 'R' && c != 'D' && c != 'H' && c != 'M') continue;
            int i = -1;
            int cnt = 0;
            while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                ++cnt;
            }
            if (cnt % 2 != 0) continue;
            throw new ParseException(Messages.getString("OraTIMESTAMPFormat.11"), pos);
        }
        super.applyPattern(pat.toString());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof OraTIMESTAMPFormat && super.equals(object);
    }

    public String format(TIMESTAMP date) {
        return this.format(date, new StringBuffer(), new FieldPosition(1000)).toString();
    }

    public StringBuffer format(TIMESTAMP date, StringBuffer toAppendTo, FieldPosition pos) {
        return this.formatTemporalDatum(OraTIMESTAMP.getInstance(date), toAppendTo, pos);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null || obj instanceof TIMESTAMP) {
            return this.format((TIMESTAMP)obj, toAppendTo, pos);
        }
        throw new IllegalArgumentException(Messages.getString("OraTIMESTAMPFormat.51"));
    }

    public TIMESTAMP parse(String text, ParsePosition pos) {
        OraTIMESTAMP temporalDatum = (OraTIMESTAMP)this.parseTemporalDatum(text, pos, UTC);
        return temporalDatum != null ? temporalDatum.getDatum() : null;
    }

    @Override
    protected OraTemporalDatum getTemporalDatum(Calendar calendar, int nanos) {
        OraTIMESTAMP ret = OraTIMESTAMP.getInstance(calendar, nanos);
        ret.setSessionTimeZone(this.getSessionTimeZone());
        return ret;
    }
}

