/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowSuffix
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWSUFFIX = new String[]{"suffix"};

    @Override
    public String[] getShowAliases() {
        return SHOWSUFFIX;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowSuffix(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowSuffix(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String message = (String)ctx.getProperty("script.runner.file.suffix");
        message = message.replaceAll("^\"|\"$", "");
        ctx.write("suffix \"" + message + "\"" + System.getProperty("line.separator"));
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        return StoreRegistry.getCommand("suffix", String.valueOf(ctx.getProperty("script.runner.file.suffix")));
    }
}

