/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.io.BufferedOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.db.SQLPLUSCmdFormatter;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowNoRows;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.dbtools.raptor.newscriptrunner.commands.show.Messages;
import oracle.jdbc.OracleConnection;

public class ShowPDBS
extends CommandListener
implements IShowCommand,
IShowPrefixNameNewline,
IShowNoRows {
    String sql = "SELECT CON_ID, NAME as \"CON_NAME\", OPEN_MODE as \"OPEN MODE\", RESTRICTED FROM V$PDBS";

    @Override
    public String[] getShowAliases() {
        return new String[]{"PDBS"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ConnectionIdentifier id = DefaultConnectionIdentifier.createIdentifier(null, conn);
        DBUtil dbUtil = DBUtil.getInstance(id);
        ResultSet rs = null;
        boolean amILocked = false;
        try {
            amILocked = LockManager.lock(ctx.getBaseConnection());
            if (amILocked) {
                if (VersionTracker.checkVersion(id, new Version("15"), new Version("12.0"))) {
                    rs = dbUtil.executeOracleQuery(this.sql, null);
                }
                if (rs != null && conn instanceof OracleConnection) {
                    if (rs.isBeforeFirst()) {
                        String optionalHeader = (String)ctx.getProperty("script.runner.optional_show_header");
                        if (optionalHeader != null && !optionalHeader.equals("")) {
                            ctx.write(optionalHeader);
                        }
                        this.addColumnFormatForShowPDBs(conn, ctx);
                        SQLPLUSCmdFormatter rFormat = new SQLPLUSCmdFormatter(ctx);
                        rFormat.formatResults((BufferedOutputStream)ctx.getOutputStream(), rs, this.sql);
                        this.clearColumnFormatForShowPDBs(ctx);
                    }
                } else {
                    ctx.write(Messages.getString("NO_SHOW_PDBS_COMMAND"));
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        finally {
            try {
                if (rs != null) {
                    DBUtil.closeResultSet(rs);
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            if (amILocked) {
                try {
                    LockManager.unlock(ctx.getBaseConnection());
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private void addColumnFormatForShowPDBs(Connection conn, ScriptRunnerContext ctx) {
        HashMap<String, ArrayList<String>> storedColumns = ctx.getStoredFormatCmds();
        ArrayList<String> cmdlist = new ArrayList<String>();
        cmdlist.add("format a10");
        storedColumns.put("con_id", cmdlist);
        cmdlist = new ArrayList();
        cmdlist.add("format a30");
        storedColumns.put("con_name", cmdlist);
        cmdlist = new ArrayList();
        cmdlist.add("format a10");
        storedColumns.put("open mode", cmdlist);
        cmdlist = new ArrayList();
        cmdlist.add("format a10");
        storedColumns.put("restricted", cmdlist);
    }

    private void clearColumnFormatForShowPDBs(ScriptRunnerContext ctx) {
        HashMap<String, ArrayList<String>> storedColumns = ctx.getStoredFormatCmds();
        storedColumns.remove("con_id");
        storedColumns.remove("con_name");
        storedColumns.remove("open mode");
        storedColumns.remove("restricted");
    }
}

