/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.net;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.raptor.newscriptrunner.commands.net.Net;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class NetParser {
    private static final String NET = "net";
    private static final String NETENTRIES = "netentries";
    private static final String DESC = "description";
    private static final String QUERIES = "queries";
    private static final String QUERY = "query";
    private static final String SQL = "sql";
    private static final String NAME = "name";
    protected static Logger LOGGER = Logger.getLogger(NetParser.class.getName());
    private XMLDocument _document;
    private DOMParser parser;
    ArrayList<Net> netAL = new ArrayList();

    public NetParser() {
    }

    public NetParser(URL u) {
        try {
            this.parser.parse(u.openStream());
            this._document = this.parser.getDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putXML(File f, ArrayList<Net> netAL) throws Exception {
        f.createNewFile();
        Element e = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.newDocument();
        Element rootEle = dom.createElement(NETENTRIES);
        for (Net aNet : netAL) {
            e = dom.createElement(NET);
            e.setAttribute(NAME, aNet.getName());
            Element desc = dom.createElement(DESC);
            desc.appendChild(dom.createCDATASection(aNet.getDesc()));
            e.appendChild(desc);
            Element queries = dom.createElement(QUERIES);
            Element query = dom.createElement(QUERY);
            Element sql = dom.createElement(SQL);
            sql.appendChild(dom.createCDATASection(aNet.getQuery()));
            query.appendChild(sql);
            queries.appendChild(query);
            e.appendChild(queries);
            rootEle.appendChild(e);
        }
        dom.appendChild(rootEle);
        FileOutputStream fos = null;
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("encoding", "UTF-8");
            tr.setOutputProperty("cdata-section-elements", "sql description");
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            fos = new FileOutputStream(f.getAbsolutePath());
            tr.transform(new DOMSource(dom), new StreamResult(fos));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ioe.getLocalizedMessage());
                }
            }
        }
    }

    public ArrayList<Net> processXML(URL u) throws Exception {
        if (this.parser == null) {
            this.parser = new DOMParser();
        } else {
            this.parser.reset();
        }
        this.parser.setPreserveWhitespace(false);
        this.parser.parse(u.openStream());
        this._document = this.parser.getDocument();
        NodeList rootNodes = this._document.getChildNodes();
        for (int i = 0; i < rootNodes.getLength(); ++i) {
            this.processNodes(rootNodes.item(i));
        }
        return this.netAL;
    }

    private void processNodes(Node item) {
        NodeList children = item.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (!childName.equalsIgnoreCase(NET)) continue;
            this.newItem(child);
        }
    }

    private void newItem(Node child) {
        String netname = XMLHelper.getAttributeNode(child, NAME);
        String desc = "";
        String query = "";
        NodeList items = child.getChildNodes();
        for (int i = 0; i < items.getLength(); ++i) {
            Node n1;
            Node x = items.item(i);
            if (x.getNodeName().equalsIgnoreCase(DESC) && (n1 = x.getFirstChild()) instanceof Text) {
                desc = ((Text)n1).getTextContent();
            }
            if (!x.getNodeName().equalsIgnoreCase(QUERIES)) continue;
            NodeList ql = x.getChildNodes();
            for (int j = 0; j < ql.getLength(); ++j) {
                Node y = ql.item(j);
                if (!y.getLocalName().equalsIgnoreCase(QUERY)) continue;
                NodeList sqls = y.getChildNodes();
                for (int k = 0; k < sqls.getLength(); ++k) {
                    Node z = sqls.item(k);
                    Node n12 = z.getFirstChild();
                    if (!(n12 instanceof Text)) continue;
                    query = ((Text)n12).getTextContent();
                }
            }
        }
        this.netAL.add(new Net(netname, query, desc));
    }
}

