/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.alias;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Alias;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.AliasParser;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Messages;

public class Aliases {
    public static final String CONFIGFILE = File.separator + "aliases.xml";
    public static final String CONFIGBACK = File.separator + "aliases.xml~";
    private HashMap<String, Alias> aliases = new HashMap();
    private static Aliases _INSTANCE;
    private Set<String> defaultAliases = new HashSet<String>();

    public static String getBase() {
        String storage = System.getProperty("user.home") + File.separator + ".sqlcl";
        if (PlatformUtils.isWindows()) {
            String appData = System.getenv("APPDATA");
            storage = appData != null ? appData + File.separator + "sqlcl" : null;
        }
        return storage;
    }

    public static Aliases getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new Aliases();
            _INSTANCE.load();
        }
        return _INSTANCE;
    }

    public Aliases() {
        URL u = this.getClass().getClassLoader().getResource("oracle/dbtools/raptor/newscriptrunner/commands/alias/aliases.xml");
        AliasParser parser = new AliasParser();
        try {
            ArrayList<Alias> filealiases = parser.processXML(u);
            for (Alias a : filealiases) {
                this.defaultAliases.add(a.getName().toUpperCase());
                this.aliases.put(a.getName(), a);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    public void add() {
    }

    public void add(String name, String query, String desc) {
        if (this.aliases.containsKey(name)) {
            this.aliases.remove(name);
        }
        Alias alias = new Alias(name, query, desc);
        this.aliases.put(name, alias);
    }

    public void add(String name, String query) {
        this.add(name, query, "");
    }

    public String drop(String name) {
        if (this.aliases.containsKey(name)) {
            this.aliases.remove(name);
            return MessageFormat.format(Messages.getString("Aliases.0"), name);
        }
        return MessageFormat.format(Messages.getString("Aliases.1"), name);
    }

    public ArrayList<String> getAliases() {
        ArrayList<String> list = new ArrayList<String>();
        for (String alias : this.aliases.keySet()) {
            list.add(alias);
        }
        Collections.sort(list);
        return list;
    }

    public boolean contains(String key) {
        return this.aliases.containsKey(key);
    }

    public boolean addDescription(String key, String description) {
        if (this.aliases.containsKey(key)) {
            this.aliases.get(key).setDesc(description);
            return true;
        }
        return false;
    }

    public Alias get(String key) {
        return this.aliases.get(key);
    }

    public String save() {
        return this.save(null);
    }

    public String save(String filename) {
        String base = Aliases.getBase();
        new File(base).mkdirs();
        File file = null;
        if (filename != null) {
            if (filename.lastIndexOf(47) > -1) {
                if (!filename.substring(filename.lastIndexOf(47)).contains(".")) {
                    filename = filename + ".xml";
                }
            } else if (!filename.contains(".")) {
                filename = filename + ".xml";
            }
            file = new File(filename);
        } else {
            filename = base + CONFIGFILE;
            file = new File(filename);
        }
        ArrayList<Alias> aliasesAL = new ArrayList<Alias>();
        AliasParser parser = new AliasParser();
        try {
            for (Map.Entry<String, Alias> a : this.aliases.entrySet()) {
                Alias al = a.getValue();
                if (this.defaultAliases.contains(al.getName().toUpperCase())) continue;
                aliasesAL.add(al);
            }
            if (base == null) {
                return Messages.getString("Aliases.8");
            }
            if (file.exists()) {
                try {
                    int a = 1;
                    boolean found = false;
                    String filenamebak = filename + ".bak_";
                    while (!found) {
                        File findme = new File(filenamebak + a);
                        if (findme.exists() && a < 3) {
                            ++a;
                            continue;
                        }
                        Files.deleteIfExists(Paths.get(filenamebak + a, new String[0]));
                        found = true;
                    }
                    if (file.exists()) {
                        Files.move(Paths.get(filename, new String[0]), Paths.get(filenamebak + a, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (Exception e) {
                    return MessageFormat.format(Messages.getString("Aliases.11"), filename, filename + ".bak", e.getMessage());
                }
            }
            if (base != null) {
                parser.putXML(new File(filename), aliasesAL);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
        }
        return MessageFormat.format(Messages.getString("Aliases.13"), filename);
    }

    public String load() {
        String base = Aliases.getBase();
        if (base == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.getString("Aliases.14"));
        }
        String filename = base + CONFIGFILE;
        return this.load(filename);
    }

    public String load(String filename) {
        File file = null;
        URLConnection uc = null;
        try {
            if (filename != null) {
                if (filename.lastIndexOf(47) > -1) {
                    if (!filename.substring(filename.lastIndexOf(47)).contains(".")) {
                        filename = filename + ".xml";
                    }
                } else if (!filename.contains(".")) {
                    filename = filename + ".xml";
                }
                if (Aliases.startsWithHttpOrFtp(filename) && Aliases.haveIBytes(filename)) {
                    uc = new URL(filename.replaceAll("\\\\", "/")).openConnection();
                } else {
                    file = new File(filename);
                    if (file.exists()) {
                        uc = file.toURI().toURL().openConnection();
                    }
                }
            } else {
                String base = Aliases.getBase();
                if (base == null) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.getString("Aliases.14"));
                }
                if ((file = new File(filename = base + CONFIGFILE)).exists()) {
                    uc = file.toURI().toURL().openConnection();
                }
            }
        }
        catch (MalformedURLException base) {
        }
        catch (IOException base) {
            // empty catch block
        }
        if (uc != null) {
            try {
                AliasParser parser = new AliasParser();
                if (uc.getInputStream() != null) {
                    ArrayList<Alias> filealiases = parser.processXML(uc.getInputStream());
                    for (Alias a : filealiases) {
                        if (this.defaultAliases.contains(a.getName().toUpperCase())) continue;
                        this.aliases.put(a.getName(), a);
                    }
                    return Messages.getString("Aliases.15");
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
            }
        } else {
            return MessageFormat.format(Messages.getString("Aliases.16"), filename);
        }
        return "";
    }

    static boolean containsFile(String inFile) {
        String stub;
        boolean retVal = false;
        if (inFile.indexOf(":") > 1 && (stub = inFile.substring(0, inFile.indexOf(":"))).endsWith("file") && stub.indexOf("/") == -1 && stub.indexOf("\\") == -1) {
            retVal = true;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    boolean haveIBytesRaw(String base) {
        if (!Aliases.startsWithHttpOrFtp(base)) {
            return false;
        }
        InputStream is = null;
        URLConnection c = null;
        try {
            String lower = base.toLowerCase();
            if (Aliases.containsFile(lower)) {
                base = base.substring(lower.indexOf("file:"));
            }
            if (base.indexOf("\\") != -1) {
                base.replace("/", "\\");
                c = new URL(base).openConnection();
                is = c.getInputStream();
                if (is.read() != -1) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (MalformedURLException e1) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e1) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static boolean haveIBytes(String base) {
        if (!Aliases.startsWithHttpOrFtp(base)) {
            return false;
        }
        InputStream is = null;
        URLConnection c = null;
        try {
            String lower = base.toLowerCase();
            if (Aliases.containsFile(lower)) {
                base = base.substring(lower.indexOf("file:"));
            }
            if ((is = (c = new URL(base.replaceAll("\\\\", "/")).openConnection()).getInputStream()).read() != -1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (MalformedURLException e1) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e1) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    static boolean startsWithHttpOrFtp(String base) {
        if (base == null) {
            return false;
        }
        String lower = base.toLowerCase();
        return lower.startsWith("http://") || lower.startsWith("http:\\\\") || lower.startsWith("https://") || lower.startsWith("https:\\\\") || Aliases.containsFile(lower) || lower.startsWith("ftp:\\\\") || lower.startsWith("ftp://");
    }
}

