/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class ShowErrors
extends CommandListener
implements IShowCommand {
    private static final String CMD = "show err";
    private static final String SHOCMD = "sho err";
    private static final String VERBOSE_CMD = "set errorswithlines";
    private static final String VERBOSE_CMD_NUM_LINES = "set errorswithlines num lines";
    private ISQLCommand _lastCmd;

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getSql().trim().toLowerCase().startsWith(CMD) && !cmd.getSql().trim().toLowerCase().startsWith(SHOCMD)) {
            this._lastCmd = cmd;
        }
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] parts;
        int linesize = (Integer)ctx.getProperty("script.runner.setlinesize");
        if (cmd.getSql().trim().toLowerCase().startsWith(VERBOSE_CMD)) {
            parts = cmd.getSQLOrig().split(" ");
            if (parts.length >= 3 && parts[2].toLowerCase().trim().equals("on")) {
                ctx.putProperty(VERBOSE_CMD, Boolean.TRUE);
            } else {
                ctx.putProperty(VERBOSE_CMD, Boolean.FALSE);
            }
            if (parts.length == 5) {
                ctx.putProperty(VERBOSE_CMD_NUM_LINES, Integer.parseInt(parts[3]));
            }
        }
        if (cmd.getSql().trim().toLowerCase().startsWith(CMD) || cmd.getSql().trim().toLowerCase().startsWith(SHOCMD)) {
            ArrayList<String> binds;
            if (ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
                ctx.write(ScriptRunnerDbArb.getString("NOT_CONNECTED") + "\n");
                return true;
            }
            parts = cmd.getSQLOrig().split(" ");
            if (!(parts == null || parts.length != 2 || parts[1].toLowerCase().equals("err") || parts[1].toLowerCase().equals("error") || parts[1].toLowerCase().equals("errors"))) {
                return false;
            }
            boolean lastCommand = false;
            boolean linesGot = false;
            String moreArgs = cmd.getSql().trim().replaceAll("^[sS][hH][oO][wW]?\\s+[eE][rR][rR][^\\s]*", "").trim();
            String[] splitMoreArgs = moreArgs.toUpperCase().split("\\s+");
            String name = null;
            String dname = null;
            String type = null;
            if (splitMoreArgs.length > 1) {
                String[] targetDouble = new String[]{"PACKAGE BODY", "TYPE BODY", "JAVA CLASS", "JAVA SOURCE"};
                String[] target = new String[]{"FUNCTION", "PROCEDURE", "PACKAGE", "TRIGGER", "VIEW", "TYPE", "DIMENSION"};
                String[][] bothTargets = new String[][]{targetDouble, target};
                boolean matchOrEnd = false;
                boolean withBody = false;
                String[][] arr$ = bothTargets;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String[] targets;
                    for (String aTarget : targets = arr$[i$]) {
                        String oneOrTwo = splitMoreArgs[0];
                        withBody = false;
                        if (aTarget.contains(" ")) {
                            oneOrTwo = splitMoreArgs[0] + " " + splitMoreArgs[1];
                            withBody = true;
                        }
                        if (!oneOrTwo.equals(aTarget)) continue;
                        matchOrEnd = true;
                        type = aTarget;
                        break;
                    }
                    if (matchOrEnd) break;
                }
                if (type != null) {
                    if (withBody) {
                        moreArgs = moreArgs.replaceAll("^[^\\s]*", "").trim();
                    }
                    name = moreArgs = moreArgs.replaceAll("^[^\\s]*", "").trim();
                }
            }
            if ((type == null && moreArgs.length() > 0) | (type != null && (name == null || name.equals("")))) {
                ctx.write("Usage: SHOW ERRORS [{ FUNCTION | PROCEDURE | PACKAGE |\n    PACKAGE BODY | TRIGGER | VIEW\n    | TYPE | TYPE BODY | DIMENSION\n    | JAVA SOURCE | JAVA CLASS } [schema.]name]\n");
                return true;
            }
            if (name == null || type == null) {
                name = (String)ctx.getProperty("sqldev.last.err.name");
                if (ctx.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(ctx.getProperty("sqlplus.classic.mode").toString()) && name != null && name.length() > 0 && name.lastIndexOf(".") != -1) {
                    name = name.substring(name.lastIndexOf(".") + 1, name.length());
                }
                dname = "";
                if (name != null) {
                    String[] vals;
                    for (String val : vals = name.split("\\.")) {
                        if (!val.toUpperCase(Locale.US).equals(val)) {
                            val = "\"" + val + "\"";
                        }
                        dname = dname + val + ".";
                    }
                    if (dname.contains(".")) {
                        dname = dname.substring(0, dname.lastIndexOf("."));
                    }
                }
                type = (String)ctx.getProperty("sqldev.last.err.type");
                if (name == null || type == null) {
                    ctx.write("No errors.\n");
                    return true;
                }
                lastCommand = true;
            }
            if (name.endsWith(".")) {
                ctx.write(MessageFormat.format(Messages.getString("RESOLVE_FAILED"), name) + "\n");
                return true;
            }
            String useDname = dname;
            if (dname == null) {
                useDname = name;
            }
            Map<String, String> resolved = DBUtil.getInstance(conn).resolveName(useDname, true, false);
            boolean badName = false;
            if (resolved == null && name != null) {
                DBUtil dbutil = DBUtil.getInstance(conn);
                SQLException e = DBUtil.getInstance(conn).getLastException();
                binds = new ArrayList<String>();
                binds.add(useDname);
                dbutil.execute("declare x varchar2(1000);  begin x:=DBMS_ASSERT.SIMPLE_SQL_NAME(:x); end;", binds);
                e = dbutil.getLastException();
                badName = e != null;
            }
            if (resolved == null) {
                if (badName) {
                    ctx.write(MessageFormat.format(Messages.getString("BADOBJECTNAME"), useDname));
                    return true;
                }
                ctx.write("No errors.\n");
                return true;
            }
            if (type.toUpperCase().indexOf("BODY") > 0 && resolved.get("OBJECT_TYPE").toUpperCase().indexOf("BODY") == -1) {
                resolved.put("OBJECT_TYPE", resolved.get("OBJECT_TYPE") + " BODY");
            } else {
                resolved.put("OBJECT_TYPE", resolved.get("OBJECT_TYPE").toUpperCase());
            }
            String val = DBUtil.getInstance(conn).executeReturnOneCol("SELECT value FROM v$parameter WHERE name = 'plsql_warnings'");
            String sql = "select substr(line||'/'||position,0,10) linenum ,text from all_errors  where  type = :TYPE  and    name = :OBJECT_NAME  and    owner = :OWNER and    attribute != 'WARNING' order by line asc, position, sequence desc";
            if (val != null && val.equalsIgnoreCase("ENABLE:ALL")) {
                sql = "select substr(line||'/'||position,0,10) linenum ,text from all_errors  where  type = :TYPE  and    name = :OBJECT_NAME  and    owner = :OWNER order by line asc, position, sequence desc";
            }
            binds = new ArrayList();
            binds.add(resolved.get("OBJECT_TYPE"));
            binds.add(resolved.get("OBJECT_NAME"));
            binds.add(resolved.get("OWNER"));
            ResultSet rs = null;
            ArrayList<String> line = new ArrayList<String>();
            ArrayList<String> txt = new ArrayList<String>();
            try {
                DBUtil dbUtil = DBUtil.getInstance(conn);
                if (LockManager.lock(conn)) {
                    rs = dbUtil.executeQuery(sql, binds);
                    while (rs.next()) {
                        line.add(rs.getString(1));
                        txt.add(rs.getString(2));
                    }
                }
            }
            catch (SQLException e) {
                ctx.write(e.getMessage());
            }
            finally {
                DBUtil.closeResultSet(rs);
                LockManager.unlock(conn);
            }
            String[] lines = null;
            if (line.size() > 0) {
                line.add(0, Messages.getString("LINE_COL"));
                txt.add(0, Messages.getString("ERROR"));
                int lSize = 5;
                int tSize = 10;
                int ttSize = 10;
                for (String l : line) {
                    if (l.length() <= lSize) continue;
                    lSize = l.length();
                }
                for (String t : txt) {
                    if (t.length() > tSize) {
                        tSize = t.length();
                    }
                    for (String tt : t.split("\\r?\\n")) {
                        if (tt == null || tt.length() <= ttSize) continue;
                        ttSize = tt.length();
                    }
                }
                ++lSize;
                String pad = "                                       ";
                ctx.write("\n" + MessageFormat.format(Messages.getString("ERRORS_FOR_TYPE_NAME") + "\n\n", type, useDname));
                this.flush(ctx);
                StringBuffer minuses = new StringBuffer("");
                for (int i = 1; i < lSize + 5; ++i) {
                    minuses.append("-");
                }
                line.add(1, minuses.substring(0, lSize - 1) + " ");
                minuses = new StringBuffer("");
                int errminues = ttSize + 10;
                for (int i = 1; i < errminues + 5; ++i) {
                    minuses.append("-");
                }
                int adjls = (linesize = linesize < 11 ? 11 : linesize) - lSize;
                int adjlsMin = adjls;
                if (adjlsMin > 65) {
                    adjlsMin = 65;
                }
                if (adjlsMin < minuses.length()) {
                    txt.add(1, minuses.substring(0, adjlsMin));
                } else {
                    txt.add(1, minuses.toString());
                }
                for (int i = 0; i < line.size(); ++i) {
                    ctx.write((String)line.get(i) + pad.substring(0, lSize - ((String)line.get(i)).length()));
                    this.flush(ctx);
                    boolean firstOne = true;
                    String lterm = System.getProperty("line.separator");
                    for (String onetxt : ((String)txt.get(i)).split("\\r?\\n", -1)) {
                        if (onetxt != null && onetxt.length() > 0) {
                            onetxt = onetxt.trim();
                            onetxt = ScriptUtils.wordwrap(12, adjls, new StringBuffer(onetxt), -1).toString();
                            onetxt = onetxt.replaceAll(lterm, lterm + String.format("%1$-" + lSize + "s", " "));
                            if (!firstOne) {
                                ctx.write(pad.substring(0, lSize));
                                this.flush(ctx);
                            } else {
                                firstOne = false;
                            }
                            ctx.write(onetxt + "\n");
                            this.flush(ctx);
                            continue;
                        }
                        if (!firstOne) continue;
                        ctx.write("\n");
                        this.flush(ctx);
                        firstOne = false;
                    }
                    Boolean verbose_cmd = (Boolean)ctx.getProperty(VERBOSE_CMD);
                    if (verbose_cmd != null && verbose_cmd.booleanValue()) {
                        if (lastCommand) {
                            lines = this._lastCmd.getSQLOrig().split("\n");
                        } else if (!linesGot) {
                            linesGot = true;
                            ArrayList<String> bindsLines = new ArrayList<String>();
                            bindsLines.add(resolved.get("OBJECT_TYPE"));
                            bindsLines.add(resolved.get("OBJECT_NAME"));
                            bindsLines.add(resolved.get("OWNER"));
                            String sqlLines = "select text from all_source  where  type = :TYPE  and    name = :OBJECT_NAME  and    owner = :OWNER order by line";
                            ArrayList<String> lineList = new ArrayList<String>();
                            try {
                                DBUtil dbUtil = DBUtil.getInstance(conn);
                                if (LockManager.lock(conn)) {
                                    rs = dbUtil.executeQuery(sqlLines, bindsLines);
                                    while (rs.next()) {
                                        lineList.add(rs.getString(1));
                                    }
                                    lines = lineList.toArray(new String[lineList.size()]);
                                    if (lineList.size() == 0) {
                                        lines = null;
                                    }
                                }
                            }
                            catch (SQLException dbUtil) {
                            }
                            finally {
                                if (rs != null) {
                                    DBUtil.closeResultSet(rs);
                                }
                                LockManager.unlock(conn);
                            }
                            if (lines == null) {
                                ctx.write(MessageFormat.format(Messages.getString("TYPE_NAME_SOURCE_NOT_FOUND"), resolved.get("OBJECT_TYPE"), resolved.get("OWNER") + "." + resolved.get("OBJECT_NAME")));
                                this.flush(ctx);
                            }
                        }
                    }
                    if (verbose_cmd == null || !verbose_cmd.booleanValue() || lines == null) continue;
                    Integer showLines = 1;
                    if (ctx.getProperty(VERBOSE_CMD_NUM_LINES) != null) {
                        showLines = (Integer)ctx.getProperty(VERBOSE_CMD_NUM_LINES);
                        showLines = showLines - 1;
                    }
                    int linenum = Integer.parseInt(((String)line.get(i)).substring(0, ((String)line.get(i)).indexOf("/")));
                    --linenum;
                    int colnum = Integer.parseInt(((String)line.get(i)).substring(((String)line.get(i)).indexOf("/") + 1));
                    for (int ii = showLines.intValue(); ii >= 0; --ii) {
                        if (linenum - 1 - ii < 0) continue;
                        ctx.write(linenum - ii + "  " + lines[linenum - 1 - ii] + "\n");
                        this.flush(ctx);
                    }
                    if (linenum > 0 && linenum < lines.length) {
                        ctx.write(linenum + 1 + "* " + lines[linenum] + "\n");
                        String x100 = "                                                                                                    ";
                        int hundreds = (int)Math.round(Math.floor(colnum / 100));
                        String l = new String();
                        l = "" + linenum + "  ";
                        ctx.write(x100.substring(0, l.length()));
                        this.flush(ctx);
                        for (int ii = 0; ii < hundreds; ++ii) {
                            ctx.write(x100);
                            this.flush(ctx);
                        }
                        ctx.write(x100.substring(0, colnum % 100) + "^\n");
                        this.flush(ctx);
                    }
                    for (int ii = 1; ii < showLines + 2; ++ii) {
                        if (linenum + ii >= lines.length) continue;
                        ctx.write(linenum + 1 + ii + "  " + lines[linenum + ii] + "\n");
                        this.flush(ctx);
                    }
                    ctx.write("\n\n");
                    this.flush(ctx);
                }
            } else {
                ctx.write(Messages.getString("ShowErrors.34"));
                this.flush(ctx);
            }
            return true;
        }
        return false;
    }

    private void flush(ScriptRunnerContext ctx) {
        try {
            ctx.getOutputStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void beginScript(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endScript(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"err", "erro", "error", "errors"};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.handleEvent(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

