/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;

public class SetTiming
extends AForAllStmtsCommand {
    private long start;
    private long _runningTotal = 0L;
    private IRaptorTaskProgressUpdater _currentTPU = null;
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_TIMING;

    public SetTiming() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean isListenerOn(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        super.beginEvent(conn, ctx, cmd);
        if (cmd.getStmtSubType() != null && cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SHOW)) {
            Boolean amIOn = Boolean.FALSE;
            if (this.isCmdOn()) {
                amIOn = Boolean.TRUE;
            }
            ctx.putProperty("script.runner.context.timing", amIOn);
        }
    }

    @Override
    public void doBeginWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if ((cmd.getStmtClass() == SQLCommand.StmtType.G_C_PLSQL || cmd.getStmtClass() == SQLCommand.StmtType.G_C_SQL || cmd.getStmtClass() == SQLCommand.StmtType.G_C_SQLPLUS && cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_EXECUTE || cmd.getStmtClass() == SQLCommand.StmtType.G_C_SQLPLUS && cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_AT || cmd.getStmtClass() == SQLCommand.StmtType.G_C_SQLPLUS && cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_START) && !cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_DESCRIBE)) {
            this.start = System.currentTimeMillis();
        }
    }

    @Override
    public void doEndWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if ((cmd.getStmtClass() == SQLCommand.StmtType.G_C_PLSQL || cmd.getStmtClass() == SQLCommand.StmtType.G_C_SQL || cmd.getStmtClass() == SQLCommand.StmtType.G_C_SQLPLUS && cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_EXECUTE || cmd.getStmtClass() == SQLCommand.StmtType.G_C_SQLPLUS && cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_AT || cmd.getStmtClass() == SQLCommand.StmtType.G_C_SQLPLUS && cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_START) && !cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_DESCRIBE)) {
            long stop = System.currentTimeMillis();
            long interval = stop - this.start;
            this.handleScriptTiming(ctx, interval);
            Object[] obj = new Object[]{interval};
            long totalMilliseconds = stop - this.start;
            long remainderMilliseconds = totalMilliseconds % 1000L;
            long totalSeconds = totalMilliseconds / 1000L;
            long remainderSeconds = totalSeconds % 60L;
            long totalMinutes = totalSeconds / 60L;
            long remainderMinutes = totalMinutes % 60L;
            long totalHoures = totalMinutes / 60L;
            String formattedTime = this.leadingZeroIfLessThanTen(totalHoures) + ":" + this.leadingZeroIfLessThanTen(remainderMinutes) + ":" + this.leadingZeroIfLessThanTen(remainderSeconds) + "." + this.leadingTwoZerosIfLessThanTen(remainderMilliseconds);
            String msg = MessageFormat.format(ScriptRunnerDbArb.getString("TIMINGELAPSED"), formattedTime);
            try {
                if (this.m_isCmdOn) {
                    ctx.getOutputStream().write(ScriptRunnerContext.stringToByteArrayForScriptRunner(msg));
                }
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    private void handleScriptTiming(ScriptRunnerContext ctx, long interval) {
        if (ctx != null && ctx.getTaskProgressUpdater() != null && ctx.getTaskProgressUpdater().getDescriptor() != null) {
            if (this._currentTPU != ctx.getTaskProgressUpdater()) {
                this._currentTPU = ctx.getTaskProgressUpdater();
                this._runningTotal = 0L;
            }
            this._runningTotal += interval;
        }
    }

    String leadingZeroIfLessThanTen(long in) {
        String prepend = "";
        if (in < 10L) {
            prepend = "0";
        }
        return prepend + in;
    }

    String leadingTwoZerosIfLessThanTen(long in) {
        String prepend = "";
        if (in < 100L) {
            prepend = "0";
        }
        if (in < 10L) {
            prepend = "00";
        }
        return prepend + in;
    }
}

