/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.lang.constant.Constable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetDescribe
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_DESCRIBE;
    private static final String SET = "set";
    private static final String DESCRIBE = "(?i:desc(?:|r|ri|rib|ribe))";
    private static final String JAVAREGEX = "[\\w|\\$]+\\s+[\\w|$]+|[\\w|\\$]+\\s+[\\w|$]+\\s+[\\w|\\$]+\\s+[\\w|$]+|[\\w|\\$]+\\s+[\\w|$]+\\s+[\\w|\\$]+\\s+[\\w|$]+\\s+[\\w|\\$]+\\s+[\\w|$]+";
    private static final String COMMAND_NAME = "set\\s+(?i:desc(?:|r|ri|rib|ribe))";
    private static final String COMMAND_DEPTH = "DEPTH";
    private static final String COMMAND_LINENUM = "LINENUM";
    private static final String COMMAND_INDENT = "INDENT";
    private int m_depthNum = 1;
    private boolean m_indent = false;
    private boolean m_linenum = false;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public SetDescribe() {
        super(s_cmdStmtSubType);
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        super.beginEvent(conn, ctx, cmd);
    }

    @Override
    public boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String setPtrn = "(?i:set\\b\\s*)";
        String describePtrn = "(?i:desc(?:|r|ri|rib|ribe)\\b\\s*)";
        String descStmt = cmd.getCompoundSetcmd();
        if (descStmt == null) {
            ctx.write(Messages.getString("SETDESCRIBE_USAGE") + "\n");
            return false;
        }
        String rawName = descStmt.replaceFirst(setPtrn, "").trim().replaceFirst(describePtrn, "").trim();
        if (!rawName.matches(JAVAREGEX)) {
            ctx.putProperty("descr.usage", Boolean.TRUE);
            ctx.write(Messages.getString("SETDESCRIBE_USAGE") + "\n");
            return false;
        }
        ArrayList<String> commandList = new ArrayList<String>();
        StringTokenizer strToken = new StringTokenizer(rawName);
        while (strToken.hasMoreElements()) {
            commandList.add((String)strToken.nextElement());
        }
        if (!commandList.isEmpty() && commandList.size() >= 2) {
            for (int i = 0; i < commandList.size(); ++i) {
                String indent_value;
                String command = (String)commandList.get(i);
                if (command.equalsIgnoreCase(COMMAND_DEPTH)) {
                    String depthValue;
                    if ((depthValue = (String)commandList.get(++i)).equalsIgnoreCase("ALL")) {
                        this.setDepthNum(50);
                        continue;
                    }
                    int value = Integer.parseInt(depthValue);
                    if (value > 0 && value <= 50) {
                        this.setDepthNum(Integer.parseInt(depthValue));
                        continue;
                    }
                    ctx.write(Messages.getString("SETDESCRIBE_DEPTH_INVALID") + "\n");
                    continue;
                }
                if (command.equalsIgnoreCase(COMMAND_LINENUM)) {
                    String linenum_value;
                    if ((linenum_value = (String)commandList.get(++i)).equalsIgnoreCase("ON")) {
                        this.setLinenum(true);
                        continue;
                    }
                    if (linenum_value.equalsIgnoreCase("OFF")) {
                        this.setLinenum(false);
                        continue;
                    }
                    ctx.write(Messages.getString("SETDESCRIBE_USAGE") + "\n");
                    continue;
                }
                if (!command.equalsIgnoreCase(COMMAND_INDENT)) continue;
                if ((indent_value = (String)commandList.get(++i)).equalsIgnoreCase("ON")) {
                    this.setIndent(true);
                    continue;
                }
                if (indent_value.equalsIgnoreCase("OFF")) {
                    this.setIndent(false);
                    continue;
                }
                ctx.write(Messages.getString("SETDESCRIBE_USAGE") + "\n");
            }
            this.setDescribeValuesInProperty(ctx);
        }
        return true;
    }

    private void setDescribeValuesInProperty(ScriptRunnerContext ctx) {
        HashMap<String, Constable> properties = new HashMap<String, Constable>();
        properties.put(COMMAND_DEPTH, new Integer(this.getDepthNum()));
        properties.put(COMMAND_LINENUM, new Boolean(this.isLinenum()));
        properties.put(COMMAND_INDENT, new Boolean(this.isIndent()));
        ctx.putProperty("script.runner.setdescribe", properties);
    }

    public int getDepthNum() {
        return this.m_depthNum;
    }

    public void setDepthNum(int m_depthNum) {
        this.m_depthNum = m_depthNum;
    }

    public boolean isIndent() {
        return this.m_indent;
    }

    public void setIndent(boolean m_indent) {
        this.m_indent = m_indent;
    }

    public boolean isLinenum() {
        return this.m_linenum;
    }

    public void setLinenum(boolean m_linenum) {
        this.m_linenum = m_linenum;
    }
}

