/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.crypto.Cipher;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.scriptrunner.Restricted;
import oracle.dbtools.raptor.utils.ProvideTnsnamesDir;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.textui.OraclePKIGenFunc;

@Restricted(level=Restricted.Level.REST)
public class SetCloudConfig
extends CommandListener
implements IShowCommand {
    private static final String CLOUD_CONFIG = "CLOUD_CONFIG_ZIP";
    private static final String CLOUD_CONFIG_ORIG = "CLOUD_CONFIG_ORIG";
    private static final String CLOUD_CONFIG_PATH = "CLOUD_CONFIG_PATH";

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("setcloudconfig") && ctx.isCommandLine()) {
            String[] parts = cmd.getSQLOrig().split(" ");
            if (parts.length < 3) {
                ctx.write(Messages.getString("CLOUD_USAGE"));
                return true;
            }
            if (this.testJCE()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 2; i < parts.length; ++i) {
                    sb.append(parts[i]).append(" ");
                }
                String fName = sb.toString().trim();
                if (fName.equalsIgnoreCase("off")) {
                    System.setProperty("oracle.net.wallet_location", "");
                    System.setProperty("oracle.net.tns_admin", "");
                    System.setProperty("oracle.net.ssl_server_dn_match", "");
                    if (ctx.getProperty(CLOUD_CONFIG) != null) {
                        Path p = (Path)ctx.getProperty(CLOUD_CONFIG_PATH);
                        try {
                            Files.delete(p);
                        }
                        catch (IOException e) {
                            ctx.write(e.getLocalizedMessage());
                        }
                    }
                } else {
                    URLConnection fUrl = FileUtils.getFile(ctx, fName);
                    URL f = fUrl.getURL();
                    if (f.getFile().endsWith(".zip")) {
                        if (this.unzip(ctx, fUrl)) {
                            // empty if block
                        }
                    } else {
                        ctx.write(MessageFormat.format(Messages.getString("CLOUD_INVALID"), fName) + "\n");
                    }
                    if (parts.length < 3) {
                        ctx.write(Messages.getString("CLOUD_USAGE"));
                        return true;
                    }
                }
            } else {
                ctx.write("***** JCE NOT INSTALLED **** \n");
                ctx.write("***** CAN NOT CONNECT TO PDB Service without it **** \n");
                ctx.write("  Current Java: " + System.getProperty("java.home") + "\n");
                ctx.write(" Follow instructions on  http://www.oracle.com/technetwork/java/javase/downloads/jce8-download-2133166.html\n");
            }
            return true;
        }
        return false;
    }

    private boolean testJCE() {
        int maxKeySize = 0;
        try {
            maxKeySize = Cipher.getMaxAllowedKeyLength("AES");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return maxKeySize > 128;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        this.showConfig(ctx);
        return true;
    }

    private void showConfig(ScriptRunnerContext ctx) {
        this.printProp(ctx, "oracle.net.tns_admin");
        this.printProp(ctx, "javax.net.ssl.trustStore");
        this.printProp(ctx, "javax.net.ssl.trustStorePassword");
        this.printProp(ctx, "javax.net.ssl.keyStore");
        this.printProp(ctx, "javax.net.ssl.keyStorePassword");
        this.printProp(ctx, "oracle.net.ssl_server_dn_match");
        this.printProp(ctx, "oracle.net.ssl_version");
    }

    public void printProp(ScriptRunnerContext ctx, String prop) {
        ctx.write(prop + "=" + System.getProperty(prop) + "\n");
    }

    public void setProp(String prop, String value) {
        Properties p = new Properties(System.getProperties());
        p.setProperty(prop, value);
        System.setProperties(p);
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"cloudconfig"};
    }

    private boolean unzip(ScriptRunnerContext ctx, URLConnection fUrl) {
        try {
            Path tmp = Files.createTempDirectory("oracle_cloud_config", new FileAttribute[0]);
            tmp.toFile().deleteOnExit();
            ctx.write("Using temp directory:" + tmp.toAbsolutePath() + "\n");
            Path pzip = tmp.resolve("temp.zip");
            Files.copy(fUrl.getInputStream(), pzip, new CopyOption[0]);
            ZipFile zf = new ZipFile(pzip.toFile());
            Enumeration<? extends ZipEntry> entities = zf.entries();
            while (entities.hasMoreElements()) {
                ZipEntry entry = entities.nextElement();
                String name = entry.getName();
                Path p = tmp.resolve(name);
                File f = p.toFile();
                Files.copy(zf.getInputStream(entry), p, new CopyOption[0]);
            }
            String path = tmp.toFile().getAbsolutePath();
            this.setProp("oracle.net.tns_admin", path);
            this.setStores(path);
            this.setProp("oracle.net.ssl_server_dn_match", "true");
            this.setProp("oracle.net.ssl_version", "1.2");
            CloudProvideTnsnamesDir provider = new CloudProvideTnsnamesDir(path);
            TNSHelper.setProvideTnsnamesDir(provider);
            ctx.putProperty(CLOUD_CONFIG, path);
            ctx.putProperty(CLOUD_CONFIG_ORIG, fUrl.getURL());
            ctx.putProperty(CLOUD_CONFIG_PATH, tmp);
        }
        catch (Exception e) {
            e.printStackTrace();
            ctx.write(MessageFormat.format(Messages.getString("CLOUD_INVALID"), e.getLocalizedMessage()) + "\n");
            return false;
        }
        return true;
    }

    private void setStores(String pathToWallet) throws IOException {
        OracleWallet caWallet = new OracleWallet();
        caWallet.open(pathToWallet, null);
        String passwd = "SQLcl for Oracle Exadata Express";
        char[] keyAndTrustStorePasswd = OraclePKIGenFunc.getCreatePassword((String)passwd, (boolean)false);
        OracleWallet jksK = caWallet.migratePKCS12toJKS(keyAndTrustStorePasswd, 1);
        OracleWallet jksT = caWallet.migratePKCS12toJKS(keyAndTrustStorePasswd, 2);
        String trustPath = pathToWallet + "/sqlclTrustStore.jks";
        String keyPath = pathToWallet + "/sqlclKeyStore.jks";
        jksT.saveAs(trustPath);
        jksK.saveAs(keyPath);
        System.setProperty("javax.net.ssl.trustStore", trustPath);
        System.setProperty("javax.net.ssl.trustStorePassword", passwd.toString());
        System.setProperty("javax.net.ssl.keyStore", keyPath);
        System.setProperty("javax.net.ssl.keyStorePassword", passwd.toString());
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    class CloudProvideTnsnamesDir
    implements ProvideTnsnamesDir {
        File tnsdir = null;

        CloudProvideTnsnamesDir(String file) {
            this.tnsdir = new File(file);
        }

        @Override
        public File getTnsnamesDir() {
            return this.tnsdir;
        }
    }
}

