/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetBlockTerminator
extends AForAllStmtsCommand {
    private String replaceMe = "^\"|^'|\"$|'$";
    private String withblank = "";
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_BLO;

    public SetBlockTerminator() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("prop_file_string") != null) {
            String str = cmd.getSql();
            String[] tokens = str.split("\\s+");
            if (tokens.length != 3) {
                ctx.write(Messages.getString("SetBlockTerminator.1"));
            } else {
                String token = tokens[2];
                if (token.toLowerCase().equals("on") || token.toLowerCase().equals("off")) {
                    this.showModeForBlockTerminator(ctx, cmd, token);
                    ctx.putProperty("BLOCKTERMINATOR", token);
                } else if (this.isAlphaChar(token)) {
                    ctx.write(Messages.getString("SetBlockTerminator.5"));
                } else if (token.replaceAll(this.replaceMe, this.withblank).length() > 1) {
                    ctx.write(MessageFormat.format(Messages.getString("SetBlockTerminator.6"), token));
                } else {
                    this.showModeForBlockTerminator(ctx, cmd, token);
                    ctx.putProperty("BLOCKTERMINATOR", token.replaceAll(this.replaceMe, this.withblank));
                }
            }
        }
        return true;
    }

    private boolean isAlphaChar(String seq) {
        String seq1 = seq.replaceAll(this.replaceMe, this.withblank);
        int len = seq1.length();
        for (int i = 0; i < len; ++i) {
            char c = seq1.charAt(i);
            if ('0' <= c && c <= '9' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == ' ') continue;
            return false;
        }
        return true;
    }

    private void showModeForBlockTerminator(ScriptRunnerContext ctx, ISQLCommand cmd, String termin) {
        char[] charary;
        String btermin = null;
        if (ctx.getProperty("BLOCKTERMINATOR") != null) {
            btermin = ctx.getProperty("BLOCKTERMINATOR").toString();
            if (btermin.equalsIgnoreCase("on")) {
                btermin = "\".\" (hex " + String.format("%02x", 46) + ")";
            } else if (btermin.equalsIgnoreCase("off")) {
                btermin = "OFF";
            } else {
                charary = btermin.toCharArray();
                btermin = "\"" + btermin + "\"" + " (hex " + String.format("%02x", charary[0]) + ")";
            }
        } else {
            btermin = "\".\" (hex " + String.format("%02x", 46) + ")";
        }
        this.setProperties(cmd, ctx, btermin, "blockterminator", "BLOCKTERMINATOR");
        if (termin.equalsIgnoreCase("on")) {
            termin = "\".\" (hex " + String.format("%02x", 46) + ")";
        } else if (termin.equalsIgnoreCase("off")) {
            termin = "OFF";
        } else {
            charary = termin.toCharArray();
            termin = "\"" + termin + "\"" + " (hex " + String.format("%02x", charary[0]) + ")";
        }
        this.writeShowMode(cmd, ctx, termin);
    }
}

