/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.jdbc.OracleConnection;

public class SetAppinfo
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_APPINFO;
    public static String APPINFO = SQLPLUS.PRODUCT_NAME;

    public SetAppinfo() {
        super(m_cmdStmtSubType);
    }

    @Override
    public boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return false;
        }
        String input = (String)cmd.getProperty("prop_file_string");
        if (input != null && !input.toLowerCase().equals("on") && !input.toLowerCase().equals("off")) {
            input = cmd.getSql().trim().replaceFirst("^[Ss][Ee][Tt]\\s+[^\\s]+", "").trim();
            ArrayList<String> al = new ArrayList<String>();
            if (input.startsWith("\"") && input.endsWith("\"") && input.length() > 1) {
                input = input.substring(1, input.length() - 1);
            }
            if (input.startsWith("'") && input.endsWith("'") && input.length() > 1) {
                input = input.substring(1, input.length() - 1);
            }
            if (input == null || input.equals("")) {
                ctx.write(Messages.getString("APPINFONULL"));
            } else if (input.length() > 48) {
                ctx.write(MessageFormat.format(Messages.getString("APPINFO_MAX_STRING_ERROR"), input.substring(0, 10) + "...") + "\n");
            } else {
                al.add(input);
                DBUtil.getInstance(conn).execute("BEGIN DBMS_APPLICATION_INFO.SET_MODULE(:1,null); END;", al);
                ctx.putProperty("script.runner.appinfostring", input);
                APPINFO = input;
            }
        } else if (cmd.getProperty("prop_status_boolean") != null) {
            ctx.putProperty("script.runner.appinfo", (Boolean)cmd.getProperty("prop_status_boolean"));
            if (Boolean.valueOf(cmd.getProperty("prop_status_boolean").equals(new Boolean(false))).booleanValue()) {
                ArrayList<String> al = new ArrayList<String>();
                al.add(SQLPLUS.PRODUCT_NAME);
                DBUtil.getInstance(conn).execute("BEGIN DBMS_APPLICATION_INFO.SET_MODULE(:1,null); END;", al);
            } else if (Boolean.valueOf(cmd.getProperty("prop_status_boolean").equals(new Boolean(true))).booleanValue()) {
                ArrayList scrArrayList = (ArrayList)ctx.getProperty("script.runner.appinfo.arraylist");
                if (scrArrayList.size() != 0) {
                    SetAppinfo.setAppinfo(ctx, ctx.getCurrentConnection(), (String)scrArrayList.get(scrArrayList.size() - 1), scrArrayList.size());
                } else {
                    SetAppinfo.setAppinfo(ctx, ctx.getCurrentConnection(), APPINFO, 0);
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public static void setAppinfo(ScriptRunnerContext src, Connection conn, String scriptname, Integer level) {
        if (src != null && src.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(src.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return;
        }
        if (src.getCurrentConnection() instanceof OracleConnection && src.getProperty("script.runner.appinfo") != null && Boolean.valueOf(src.getProperty("script.runner.appinfo").equals(new Boolean(true))).booleanValue()) {
            if (!DBUtil.isOracleConnectionAlive(src.getCurrentConnection())) {
                return;
            }
            DBUtil myDbUtil = DBUtil.getInstance(src.getCurrentConnection());
            Integer myI = level;
            ArrayList<Object> al = new ArrayList<Object>();
            al.add(new Integer(myI));
            al.add(scriptname);
            if (level.equals(0)) {
                al = new ArrayList();
                al.add(APPINFO);
                myDbUtil.execute("BEGIN DBMS_APPLICATION_INFO.SET_MODULE(:1,null);END;", al);
            } else {
                myDbUtil.execute("DECLARE\n  inN numeric := :1;\n  --inN NUMERIC := 1;\n  inC varchar2(1000) := :2;\n  --inC  VARCHAR2(1000) := '1234567891123456789212345678931234567894123456789';\n  inNtoC NUMERIC        := inN;\n  inNC   VARCHAR2(1000) := inN;\n  toUse  VARCHAR2(1000);\nBEGIN\n  IF (inN<10) THEN\n    inNC:='0'||TO_CHAR(inN);\n  ELSE\n    inNC:=TO_CHAR(inN);\n  END IF;\n  --size is 48 bytes\n  toUse             :=(inNC||' '||inC);\n  \n  IF (lengthB(toUse))>48 THEN\n    DECLARE\n      p_work VARCHAR2(1000);\n      p_bsize NUMBER      := (48-lengthb((inNC||'<')));\n      v_work  VARCHAR2(1000);\n      v_bsize NUMBER(10);\n    BEGIN\n      p_work := inC;\n      IF LENGTHB(p_work) <= p_bsize THEN\n        inC              := p_work;\n      ELSE\n        v_work                              := p_work;\n        v_work                              := LTRIM(SUBSTRB(v_work, - p_bsize));\n        inC := v_work;\n      END IF;\n    END;\n    toUse:=(inNC||'<')||inC;\n  END IF;\n  DBMS_APPLICATION_INFO.SET_MODULE(toUse,null);\nEND;", al);
            }
        }
    }
}

