/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.util.Arrays;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.utils.NLSUtils;

public class RePopulateNLSMap
extends CommandListener
implements IShowCommand {
    private static final String SET_NLS_CMD = "setnls";
    private static final String SET_TIMEZONE_CMD = "altersessionsettime_zone";
    private static final String NLS_AUTO = "NLS_REPOPULATE";
    private static final String NLS_AUTO_PRE = "PRE";
    private static final String NLS_AUTO_POST = "POST";
    private static final String NLS_AUTO_DEFAULT = "DEFAULT";
    private static final String NLS_AUTO_NONE = "OFF";
    private static final String[] OPTIONS = new String[]{"PRE", "POST", "DEFAULT", "OFF"};
    private static final String[] aliases = new String[]{"AUTONLS"};

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getProperty(NLS_AUTO) != null && ctx.getProperty(NLS_AUTO).equals(NLS_AUTO_PRE) && conn != null) {
            NLSUtils.populateNLS(ctx.getCurrentConnection());
        }
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue() || ctx.getProperty(NLS_AUTO) != null && ctx.getProperty(NLS_AUTO).equals(NLS_AUTO_NONE)) {
            return;
        }
        String cmdlower = cmd.getSql().toLowerCase();
        if (ctx.getProperty(NLS_AUTO) != null && ctx.getProperty(NLS_AUTO).equals(NLS_AUTO_DEFAULT) && cmdlower.contains("alter") && cmdlower.contains("time_zone") || cmdlower.contains("nls")) {
            ScriptParser parser = new ScriptParser(cmdlower = ScriptUtils.stripFirstN(cmdlower, 9000, cmd.getProperty("STRIPPED_CONTINUATION") == null, false));
            String sql = parser.stripLine(cmdlower);
            if (sql.indexOf(SET_NLS_CMD) > 0 || sql.startsWith(SET_TIMEZONE_CMD)) {
                NLSUtils.populateNLS(conn);
            }
        } else if (ctx.getProperty(NLS_AUTO) != null && ctx.getProperty(NLS_AUTO).equals(NLS_AUTO_POST)) {
            NLSUtils.populateNLS(conn);
        }
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("setautonls")) {
            String[] parts = cmd.getSQLOrig().split(" ");
            if (parts.length != 3) {
                ctx.write(String.format(Messages.getString("NLS_AUTO"), "") + "\n");
                ctx.write(String.format(Messages.getString("NLS_AUTO_OPTIONS"), "") + "\n");
            } else {
                String option = parts[2].trim().toUpperCase();
                if (Arrays.asList(OPTIONS).contains(option)) {
                    ctx.putProperty(NLS_AUTO, option);
                } else {
                    ctx.write(String.format(Messages.getString("NLS_AUTO_OPTIONS"), "") + "\n");
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getShowAliases() {
        return aliases;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ctx.write("Auto Reload NLS:" + ctx.getProperty(NLS_AUTO) + "\n");
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

