/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;

public class FindCommand
extends CommandListener
implements IHelp {
    private static final String WHERE = "FIND";

    @Override
    public String getCommand() {
        return WHERE;
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand().toUpperCase());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String sqlpcmd = cmd.getSql().trim();
        String[] cmds = sqlpcmd.split("\\s+");
        boolean list = true;
        String filename = null;
        switch (cmds.length) {
            case 1: {
                ctx.write("Usage: where <filename>");
                ctx.write(this.getHelp());
                return true;
            }
            case 2: {
                filename = cmds[1];
                Path[] paths = FileUtils.getFilesOnSQLPATH(ctx, filename);
                if (paths == null) break;
                for (Path path : paths) {
                    try {
                        ctx.write(path.toRealPath(new LinkOption[0]).toString() + "\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                break;
            }
            default: {
                ctx.write(this.getHelp());
                return true;
            }
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

