/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.SQLPLUSCmdFormatter;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQL;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class AutoTrace
extends AForAllStmtsCommand {
    private static final String ctxTraceState = "AUTOTRACE_STATE";
    private static final String ctxTraceType = "AUTOTRACE_TYPE";
    private static final String SPACE = "                                                                                ";
    private String AUTO_EXPLAIN = "EXPLAIN";
    private String AUTO_STAT = "STATISTICS";
    private String AUTO_ALL = "ALL";
    private String AUTO_NONE = "NONE";
    private String statSql1 = "select ms.Statistic# stat,ms.value,sn.name from v$mystat ms, v$statname  sn where sn.statistic# =  ms.statistic# ";
    private String statSql2 = "\n and sn.name in ('recursive calls','db block gets','consistent gets','physical reads','redo size','bytes sent via SQL*Net to client','bytes received via SQL*Net from client','SQL*Net roundtrips to/from client','sorts (memory)','sorts (disk)')";
    private String statSql3 = "\n order by 1";
    private String statSql = this.statSql1 + this.statSql3;
    private ResultSet _rset = null;
    private HashMap<Integer, Stat> bStats;
    private ArrayList<Stat> aStats;
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_AUTOTRACE;

    public AutoTrace() {
        super(s_cmdStmtSubType);
    }

    @Override
    public void doBeginWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return;
        }
        this.statSql = ctx != null && ctx.getProperty("sqlplus.classic.mode") != null && "ON".equals(ctx.getProperty("sqlplus.classic.mode")) || "true".equals(HiddenParameters.parameters.get("classicMode")) ? this.statSql1 + this.statSql2 + this.statSql3 : this.statSql1 + this.statSql3;
        Boolean state = (Boolean)ctx.getProperty(ctxTraceState);
        if (state == null) {
            ctx.putProperty(ctxTraceState, false);
            ctx.putProperty(ctxTraceType, false);
            state = false;
        }
        if (state.booleanValue() && !cmd.getStmtClass().equals((Object)SQLCommand.StmtType.G_C_SQLPLUS)) {
            this.bStats = new HashMap();
            try {
                PreparedStatement ps = conn.prepareStatement(this.statSql);
                this._rset = ps.executeQuery();
                while (this._rset.next()) {
                    Stat _stat = new Stat(this._rset.getInt(2), this._rset.getString(3));
                    this.bStats.put(this._rset.getInt(1), _stat);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void doEndWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return;
        }
        if (cmd.isFail()) {
            return;
        }
        if (((Boolean)ctx.getProperty(ctxTraceState)).booleanValue() && (cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SELECT) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_INSERT) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_UPDATE) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_DELETE) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_MERGE) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_WITH))) {
            PreparedStatement ps2;
            this.aStats = new ArrayList();
            try {
                ps2 = conn.prepareStatement(this.statSql);
                this._rset = ps2.executeQuery();
                while (this._rset.next()) {
                    boolean notZeroValue;
                    String name = this._rset.getString(3);
                    if (name.startsWith("workarea") || name.endsWith("memory") || name.endsWith("memory max")) continue;
                    boolean bl = notZeroValue = this._rset.getInt(2) - this.bStats.get(this._rset.getInt(1)).getValue() != 0;
                    if (ctx != null && ctx.getProperty("sqlplus.classic.mode") != null && "ON".equals(ctx.getProperty("sqlplus.classic.mode")) || "true".equals(HiddenParameters.parameters.get("classicMode"))) {
                        notZeroValue = true;
                    }
                    if (!notZeroValue) continue;
                    Stat _stat = new Stat(this._rset.getInt(2) - this.bStats.get(this._rset.getInt(1)).getValue(), name);
                    this.aStats.add(_stat);
                }
            }
            catch (SQLException ps2) {
                // empty catch block
            }
            if (ctx.getProperty(ctxTraceType).equals(this.AUTO_ALL) || ctx.getProperty(ctxTraceType).equals(this.AUTO_EXPLAIN)) {
                try {
                    ps2 = conn.prepareStatement("explain plan for " + cmd.getSql());
                    SQL tmp = new SQL(cmd, null);
                    tmp.setScriptRunnerContext(ctx);
                    tmp.setConn(conn);
                    tmp.setBinds(ps2);
                    this._rset = ps2.executeQuery();
                    ps2 = conn.prepareStatement("SELECT * FROM table(DBMS_XPLAN.DISPLAY)");
                    this._rset = ps2.executeQuery();
                    SQLPLUSCmdFormatter cmdf = new SQLPLUSCmdFormatter(ctx);
                    StringBuffer buf = new StringBuffer("Explain Plan\n-----------------------------------------------------------\n");
                    this.write(ScriptUtils.wordwrap(1, (Integer)ctx.getProperty("script.runner.setlinesize"), buf, 1).toString(), ctx);
                    try {
                        cmdf.formatResults((BufferedOutputStream)ctx.getOutputStream(), this._rset, cmd);
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    }
                    this.write("\n", ctx);
                }
                catch (SQLException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
            if (ctx.getProperty(ctxTraceType).equals(this.AUTO_ALL) || ctx.getProperty(ctxTraceType).equals(this.AUTO_STAT)) {
                if (this.aStats.size() > 0) {
                    StringBuffer buf = new StringBuffer("   Statistics\n-----------------------------------------------------------\n");
                    this.write("", ctx);
                    Collections.sort(this.aStats, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            return ((Stat)o1).getName().compareTo(((Stat)o2).getName());
                        }
                    });
                    for (Stat stat : this.aStats) {
                        buf.append(AutoTrace.lpad(16, String.valueOf(stat.getValue())) + "  " + stat.getName() + "\n");
                    }
                    this.write(ScriptUtils.wordwrap(1, (Integer)ctx.getProperty("script.runner.setlinesize"), buf, 1).toString(), ctx);
                } else {
                    this.write(Messages.getString("AutoTrace.19"), ctx);
                    this.write(Messages.getString("AutoTrace.20"), ctx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("select 1 from dual");
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            String msg = e.getLocalizedMessage();
            System.out.println(msg);
            boolean bl = true;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        String txt = cmd.getSql().toLowerCase().trim();
        List<LexerToken> src = LexerToken.parse(txt);
        if (src.size() < 2) {
            this.write("Impossible -- incomplete comand", ctx);
            return true;
        }
        if (!"set".equals(src.get((int)0).content)) {
            this.write("Impossible -- not a set command", ctx);
            return true;
        }
        if (src.get((int)1).content.length() < 5 || !"autotrace".startsWith(src.get((int)1).content)) {
            this.write(MessageFormat.format(Messages.getString("AutoTrace.SyntaxError"), src.get((int)1).content), ctx);
            return true;
        }
        if (src.size() == 2) {
            this.write(Messages.getString("AutoTrace.UnknownAction"), ctx);
            return true;
        }
        if ("on".equals(src.get((int)2).content)) {
            if (4 == src.size() && 3 <= src.get((int)3).content.length() && "explain".startsWith(src.get((int)3).content)) {
                ctx.putProperty(ctxTraceState, true);
                ctx.putProperty(ctxTraceType, this.AUTO_EXPLAIN);
                this.write(Messages.getString("AutoTrace.22"), ctx);
            } else if (4 == src.size() && 4 <= src.get((int)3).content.length() && "statistics".startsWith(src.get((int)3).content)) {
                ctx.putProperty(ctxTraceState, true);
                ctx.putProperty(ctxTraceType, this.AUTO_STAT);
                this.write(Messages.getString("AutoTrace.24"), ctx);
            } else if (5 == src.size() && (4 <= src.get((int)3).content.length() && "statistics".startsWith(src.get((int)3).content) && 3 <= src.get((int)4).content.length() && "explain".startsWith(src.get((int)4).content) || 4 <= src.get((int)4).content.length() && "statistics".startsWith(src.get((int)4).content) && 3 <= src.get((int)3).content.length() && "explain".startsWith(src.get((int)3).content))) {
                ctx.putProperty(ctxTraceState, true);
                ctx.putProperty(ctxTraceType, this.AUTO_ALL);
                this.write(Messages.getString("AutoTrace.Enabled"), ctx);
            } else if (3 < src.size()) {
                this.write(MessageFormat.format(Messages.getString("AutoTrace.ExtraOption"), src.get((int)(src.size() - 1)).content), ctx);
            } else {
                ctx.putProperty(ctxTraceState, true);
                ctx.putProperty(ctxTraceType, this.AUTO_ALL);
                this.write(Messages.getString("AutoTrace.Enabled"), ctx);
            }
            return true;
        }
        if ("off".equals(src.get((int)2).content)) {
            if (3 < src.size()) {
                this.write(MessageFormat.format(Messages.getString("AutoTrace.ExtraOption"), src.get((int)(src.size() - 1)).content), ctx);
            } else {
                ctx.putProperty(ctxTraceState, false);
                ctx.putProperty(ctxTraceType, this.AUTO_NONE);
                this.write(Messages.getString("AutoTrace.Disabled"), ctx);
            }
            return true;
        }
        if (5 <= src.get((int)2).content.length() && "traceonly".startsWith(src.get((int)2).content)) {
            this.write(Messages.getString("AutoTrace.26"), ctx);
            return true;
        }
        this.write(Messages.getString("AutoTrace.UnknownAction"), ctx);
        return true;
    }

    private static String lpad(int spaces, String str) {
        StringBuffer result = new StringBuffer(SPACE.substring(0, spaces - str.length()));
        result.append(str);
        return result.toString();
    }

    public void write(String str, ScriptRunnerContext ctx) {
        WrapListenBufferOutputStream out = ctx.getOutputStream();
        try {
            ((FilterOutputStream)out).write(ScriptRunnerContext.stringToByteArrayForScriptRunner(str));
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    @Override
    protected boolean isListenerOn(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Boolean state = (Boolean)ctx.getProperty(ctxTraceState);
        return state != null && state != false;
    }

    private class Stat {
        int _value;
        String _name;

        Stat(int value, String name) {
            this._value = value;
            this._name = name;
        }

        String getName() {
            return this._name;
        }

        Integer getValue() {
            return this._value;
        }
    }
}

