/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.query.Bind;

public class BindPrinter {
    protected static final Logger LOGGER = Logger.getLogger(BindPrinter.class.getName());
    private static final String REFCURSOR = "REFCURSOR";
    private static final String VARCHAR2 = "VARCHAR2";
    private static final String NVARCHAR2 = "NVARCHAR2";
    private static final String CHAR = "CHAR";
    private static final String NCHAR = "NCHAR";
    private static final String BINARY_DOUBLE = "BINARY_DOUBLE";
    private static final String NUMBER = "NUMBER";
    private static final String LONG = "LONG";
    private static final String CLOB = "CLOB";
    private static final String NCLOB = "NCLOB";
    private static final String BLOB = "BLOB";
    private static final String BINARY_FLOAT = "BINARY_FLOAT";
    private static final String BFILE = "BFILE";
    private static final String COLON = ":";
    private static final String EMPTY_STRING = "";
    private static final String NL = "\n";
    private static final char NULL = '\u0000';
    private static final char DASH = '-';
    private static final char SPACE = ' ';
    private ScriptRunnerContext ctx;
    private BufferedOutputStream out;
    private ISQLCommand cmd;
    private int chunkSize = 4000;

    public BindPrinter(ScriptRunnerContext context, BufferedOutputStream outputStream, ISQLCommand command) {
        this.ctx = context;
        this.out = outputStream;
        this.cmd = command;
    }

    public void runPrint() {
        this.report(EMPTY_STRING);
        this.cmd.setSql(this.cmd.getSql().replaceAll(COLON, EMPTY_STRING));
        String[] variablesToPrint = this.nextWordAndRest(this.cmd.getSql());
        if (variablesToPrint[1].trim().equals(EMPTY_STRING)) {
            Map<String, Bind> m = this.getScriptRunnerContext().getVarMap();
            if (m.size() == 0) {
                this.report("SP2-0568: No bind variables declared.\n");
                return;
            }
            this.print(m);
        } else {
            Map<String, Bind> m = this.getScriptRunnerContext().getVarMap();
            String[] vars = variablesToPrint[1].split("\\s");
            this.print(m, vars);
        }
    }

    private void print(Map<String, Bind> m, String[] vars) {
        for (int i = 0; i < vars.length; ++i) {
            String nextKey = vars[i].trim().toUpperCase();
            Bind bind = null;
            bind = m.get(nextKey.toUpperCase());
            if (bind != null) {
                if (bind.getType() != null) {
                    FormattedBind formatter = new FormattedBind(bind);
                    nextKey = formatter.getName();
                    String value = formatter.getValue();
                    if (value == null) {
                        this.reportNull(bind, formatter);
                        continue;
                    }
                    this.reportBind(formatter);
                    continue;
                }
                this.report(ScriptRunnerDbArb.format("UNDECLARED_VARIABLE", nextKey));
                continue;
            }
            this.report(ScriptRunnerDbArb.format("UNDECLARED_VARIABLE", nextKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(Map<String, Bind> m) {
        Set<String> s = m.keySet();
        Map<String, Bind> map = m;
        synchronized (map) {
            for (String key : s) {
                Bind bind = m.get(key.toUpperCase());
                if (bind != null) {
                    FormattedBind formatter = new FormattedBind(bind);
                    String value = formatter.getValue();
                    if (value == null) {
                        this.reportNull(bind, formatter);
                        continue;
                    }
                    this.reportBind(formatter);
                    continue;
                }
                this.report(ScriptRunnerDbArb.format("UNDECLARED_VARIABLE", key));
            }
        }
    }

    private void reportBind(FormattedBind formatter) {
        if (formatter.getName().length() > 0) {
            this.report(formatter.getName());
            this.report(formatter.getDashes());
        }
        int len = formatter.getValue().length();
        int last = 0;
        int k = 0;
        for (k = this.chunkSize; k < len - 2; k += this.chunkSize) {
            this.getScriptRunnerContext().write(formatter.getValue().substring(last, k));
            try {
                this.getScriptRunnerContext().getOutputStream().flush();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            last = k;
        }
        this.report(formatter.getValue().substring(last) + NL);
    }

    private void reportNull(Bind bind, FormattedBind formatter) {
        this.report(bind.getName());
        String nullSetting = (String)this.getScriptRunnerContext().getProperty("script.runner.setnull");
        if (nullSetting != null && !nullSetting.equals(EMPTY_STRING)) {
            this.report(formatter.getDashes());
            this.report(nullSetting + NL);
        } else if (bind.getType() != null && bind.getType().startsWith(BFILE)) {
            String value = "bfilename(NULL)";
            this.report(formatter.getDashes());
            this.report(value + NL);
        } else {
            this.report(formatter.getDashes());
        }
    }

    private String formatNumberDouble(String spaces, String value, int colsize, String type) {
        if (value.trim().equals("0")) {
            value = spaces.substring(0, spaces.length() - value.length()) + value;
        } else if (value.trim().equalsIgnoreCase("nan")) {
            value = "Nan";
            value = spaces.substring(0, spaces.length() - value.length()) + value;
        } else if (value.trim().equalsIgnoreCase("infinity")) {
            value = "Inf";
            value = spaces.substring(0, spaces.length() - value.length()) + value;
        } else if (type.equalsIgnoreCase(NUMBER)) {
            value = spaces.substring(0, spaces.length() - value.length()) + value;
        } else {
            DecimalFormat formatter = new DecimalFormat();
            int minsize = 8;
            char pad = '#';
            if (colsize < minsize) {
                char[] chars = new char[colsize + 1];
                Arrays.fill(chars, pad);
                value = String.valueOf(chars);
            } else {
                String mask = "0.0#E000";
                int formatMask = colsize - minsize;
                String maskFiller = EMPTY_STRING;
                if (formatMask > 0) {
                    char[] chars = new char[formatMask];
                    Arrays.fill(chars, pad);
                    maskFiller = String.valueOf(chars);
                } else {
                    maskFiller = "#";
                }
                formatter = new DecimalFormat(MessageFormat.format(mask, maskFiller));
                String s = formatter.format(Double.valueOf(value));
                String[] as = s.split("E");
                String middle = "+";
                middle = as.length > 1 && as[1].startsWith("-") ? EMPTY_STRING : "+";
                value = as[0] + "E" + middle + as[1];
                if (value.length() <= 10) {
                    value = spaces.substring(0, spaces.length() - value.length()) + value;
                }
            }
        }
        return value;
    }

    private String[] nextWordAndRest(String in) {
        return this.nextWordAndRestOrString(in, null);
    }

    private String[] nextWordAndRestOrString(String in, String extraOne) {
        if ((in = in.trim()).length() == 0) {
            return null;
        }
        int i = 0;
        boolean inQuote = false;
        boolean found = false;
        String rest = EMPTY_STRING;
        String firstWord = EMPTY_STRING;
        for (i = 0; i < in.length(); ++i) {
            if (in.charAt(i) == '\"') {
                inQuote = !inQuote;
            }
            if (!Character.isWhitespace(in.charAt(i)) && (extraOne == null || extraOne.indexOf(in.charAt(i)) == -1) || inQuote) continue;
            found = true;
            break;
        }
        if (found) {
            rest = in.substring(i).trim();
            firstWord = in.substring(0, i);
        } else {
            firstWord = in;
        }
        String[] stringArray = new String[]{firstWord, rest};
        return stringArray;
    }

    private void report(String string) {
        ScriptUtils.report(this.ctx, string, this.out);
    }

    private ScriptRunnerContext getScriptRunnerContext() {
        return this.ctx;
    }

    class FormattedBind {
        private String dashes = "";
        private String name = "";
        private String value = "";
        private Bind bind;

        public FormattedBind(Bind b) {
            this.bind = b;
            this.format();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getDashes() {
            return this.dashes;
        }

        public void format() {
            this.name = this.bind.getName();
            this.value = this.bind.getValue();
            this.dashes = new String(new char[this.bind.getName().length() <= 10 ? 10 : this.bind.getName().length()]).replace('\u0000', '-');
            String spaces = new String(new char[this.bind.getName().length() <= 10 ? 10 : this.bind.getName().length()]).replace('\u0000', ' ');
            switch (this.bind.getType()) {
                case "LONG": {
                    if (this.value == null || this.value.length() <= (Integer)BindPrinter.this.getScriptRunnerContext().getProperty("script.runner.setlong")) break;
                    this.value = this.value.substring(0, (Integer)BindPrinter.this.getScriptRunnerContext().getProperty("script.runner.setlong"));
                    break;
                }
                case "CLOB": 
                case "NCLOB": 
                case "BLOB": {
                    this.dashes = new String(new char[80]).replace('\u0000', '-');
                    int longchunksizeLen = (Integer)BindPrinter.this.getScriptRunnerContext().getProperty("script.runner.setlongchunksize");
                    int longLen = (Integer)BindPrinter.this.getScriptRunnerContext().getProperty("script.runner.setlong");
                    if (this.value == null) break;
                    int valueLen = this.value.length();
                    if (valueLen > longchunksizeLen) {
                        int truncatedValueLen;
                        if (longLen < valueLen) {
                            this.value = this.value.substring(0, longLen);
                        }
                        if (longchunksizeLen >= (truncatedValueLen = this.value.length())) break;
                        StringBuffer sb = new StringBuffer();
                        int partLen = (int)Math.ceil((double)truncatedValueLen / (double)longchunksizeLen);
                        for (int k = 0; k < partLen; ++k) {
                            int startIndex = longchunksizeLen * k;
                            int endIndex = longchunksizeLen * (k + 1);
                            if (endIndex >= this.value.length()) {
                                endIndex = this.value.length();
                            }
                            String partString = this.value.substring(startIndex, endIndex);
                            sb.append(partString + BindPrinter.NL);
                        }
                        this.value = sb.toString();
                        break;
                    }
                    if (longLen >= valueLen) break;
                    this.value = this.value.substring(0, longLen);
                    break;
                }
                case "NUMBER": 
                case "BINARY_DOUBLE": 
                case "BINARY_FLOAT": {
                    int colsize = (Integer)BindPrinter.this.getScriptRunnerContext().getProperty("script.runner.setnumwidth");
                    spaces = new String(new char[this.bind.getName().length() <= colsize ? colsize : this.bind.getName().length()]).replace('\u0000', ' ');
                    this.dashes = new String(new char[this.bind.getName().length() <= colsize ? colsize : this.bind.getName().length()]).replace('\u0000', '-');
                    if (this.value == null || this.value.length() > spaces.length() || this.name == null || this.name.length() > spaces.length()) break;
                    this.name = spaces.substring(0, spaces.length() - this.name.length()) + this.name;
                    this.value = BindPrinter.this.formatNumberDouble(spaces, this.value, colsize, this.bind.getType());
                    break;
                }
                case "VARCHAR2": 
                case "CHAR": 
                case "BFILE": {
                    this.dashes = new String(new char[80]).replace('\u0000', '-');
                    break;
                }
                case "REFCURSOR": {
                    this.name = BindPrinter.EMPTY_STRING;
                    this.dashes = BindPrinter.EMPTY_STRING;
                    break;
                }
                case "NCHAR": {
                    this.dashes = new String(new char[16]).replace('\u0000', '-');
                    break;
                }
                case "NVARCHAR2": {
                    this.dashes = new String(new char[64]).replace('\u0000', '-');
                    break;
                }
            }
        }
    }
}

