/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleClob;
import oracle.sql.BFILE;
import oracle.sql.RAW;

public class InsertFormatter
extends ResultsFormatter {
    private static final Logger LOGGER = Logger.getLogger(InsertFormatter.class.getName());
    public static final String TYPE = "INSERT";
    public static final String EXT = "sql";
    public static final String KEY_REC_TERM = "EXPORT_INS_REC_TERM";
    public static final String COMMIT = "COMMIT";
    public static final String COMMIT_ROWS = "COMMIT_ROWS";
    StringBuffer sb = new StringBuffer();
    String tableName = null;
    boolean isTruncate = false;
    boolean isCommit = false;
    int commitRows = 0;
    boolean isDecSepComma = false;
    long rowCount = 0L;
    float block;

    public InsertFormatter() {
        super(TYPE, "SQL File", EXT);
    }

    public String getString() {
        return this.sb.toString();
    }

    public boolean allowsHeader() {
        return false;
    }

    @Override
    public void setTableName(String tName) {
        this.tableName = tName;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void start() throws IOException {
        this.sb = new StringBuffer();
        this.write("REM INSERTING into " + this.getTableName());
        this.write(this.getLineTerminator());
        this.write("SET DEFINE OFF;");
        this.write(this.getLineTerminator());
        this.isDecSepComma = NLSProvider.getProvider(this.getWrapper().getConnection()).getDecimalSeparator() == ',';
        this.block = 0.0f;
        this.rowCount = 0L;
    }

    @Override
    public void startRow() throws IOException {
        int size = this.getColumnCount();
        StringBuffer header = new StringBuffer();
        int x = 0;
        if (this.getColumnName(0).equals("Row")) {
            x = 1;
        }
        if (size > x) {
            header.append(DBUtil.addDoubleQuote(this.getColumnName(x)));
            ++x;
        }
        for (int i = x; i < size; ++i) {
            header.append(',').append(DBUtil.addDoubleQuote(this.getColumnName(i)));
        }
        this.write("Insert into ");
        if (this.getTableName().indexOf(".") > -1) {
            this.write(this.getTableName());
        } else {
            this.write(DBUtil.addDoubleQuote(this.getTableName()));
        }
        this.write(" (" + header + ") values (");
        ++this.rowCount;
        this.block += 1.0f;
    }

    @Override
    public void printColumn(Object col, int viewIndex, int modelIndex) throws IOException {
        String sep;
        String colm = "";
        String string = sep = viewIndex == 0 ? "" : ",";
        if (col != null) {
            int type = this.getDataType(viewIndex);
            if (type == 91) {
                colm = this.getDateFormat() == null ? sep + "'" + this.cleanString(this.getValue(col).toString()) + "'" : sep + "to_date('" + this.cleanString(this.getValue(col).toString()) + "','" + this.getDateFormat() + "')";
            } else if (type == 4 || type == -5 || type == 6 || type == 7 || type == 8 || type == 2 || type == 2 || type == -6 || type == 3) {
                colm = this.cleanString(this.getValue(col).toString());
                if (this.isDecSepComma && !colm.startsWith("'")) {
                    colm = "'" + colm + "'";
                }
                colm = sep + colm;
            } else if (type == 93 || type == -102) {
                colm = sep + "to_timestamp('" + this.getValue(col) + "','" + this.getTimeStampFormat() + "')";
            } else if (type == -101) {
                colm = sep + "to_timestamp_tz('" + this.getValue(col) + "','" + this.getTimeStampTZFormat() + "')";
            } else if (type == 2005) {
                try {
                    String str = this.getClobString(col, "TO_CLOB");
                    colm = sep + str;
                }
                catch (SQLException sqle) {
                    colm = sep + " EMPTY_CLOB()";
                }
            } else if (type == 2011) {
                try {
                    String str = this.getClobString(col, "TO_NCLOB");
                    colm = sep + str;
                }
                catch (SQLException sqle) {
                    colm = sep + " EMPTY_NCLOB()";
                }
            } else if (type == 2004) {
                try {
                    String str = this.getUUEncodedBlob(col);
                    colm = sep + "'" + str + "'";
                    colm = sep + str;
                }
                catch (SQLException e) {
                    colm = sep + " EMPTY_BLOB()";
                }
            } else if (col instanceof byte[] && (type == -2 || type == -2 || type == -3)) {
                String str = this.byteArrayToHexValue(col);
                colm = sep + "'" + str + "'";
            } else if (type == -13) {
                try {
                    colm = sep + " BFILENAME ('" + ((BFILE)col).getDirAlias() + "', '" + ((BFILE)col).getName() + "')";
                }
                catch (SQLException e) {
                    throw new IOException(e.getMessage());
                }
            } else {
                colm = type == 2003 ? sep + this.getValue(col).toString() : (type == 2002 ? sep + this.getValue(col).toString() : sep + "'" + this.cleanString(this.getValue(col).toString()) + "'");
            }
        } else {
            int type = this.getDataType(viewIndex);
            colm = type == 2005 ? sep + " EMPTY_CLOB()" : (type == 2004 ? sep + " EMPTY_BLOB()" : sep + this.getNullDisplay());
        }
        this.write(colm);
    }

    private String getNullDisplay() {
        Object nullValue = super.getValue(null);
        return nullValue != null ? nullValue.toString() : "null";
    }

    @Override
    public String cleanString(String str) {
        String newStr = "";
        Character qt = Character.valueOf('\'');
        for (int i = 0; i < str.length(); ++i) {
            Character ch = Character.valueOf(str.charAt(i));
            newStr = ch.equals(qt) ? newStr + "''" : newStr + ch;
        }
        return newStr;
    }

    @Override
    public void endRow() throws IOException {
        this.write(");" + this.getLineTerminator());
        if (this.isCommit && this.commitRows > 0 && this.block == (float)this.commitRows) {
            this.write("commit;" + this.getLineTerminator());
            this.block = 0.0f;
        }
    }

    @Override
    public void end() throws IOException {
        if (this.isCommit && this.block != 0.0f) {
            this.write("commit;" + this.getLineTerminator());
        }
    }

    @Override
    public Boolean getPromptForTable() {
        return true;
    }

    @Override
    protected void write(String s) throws IOException {
        if (s != null) {
            if (this._out != null || this._zipper != null) {
                super.write(s);
            } else {
                this.sb.append(s);
            }
            this.checkAndFlush();
        }
    }

    @Override
    public boolean allowsLobs() {
        return false;
    }

    private String getClobString(Object clob, String function) throws SQLException {
        long length = 0L;
        length = clob instanceof OracleClob ? ((OracleClob)clob).length() : ((Clob)clob).length();
        if (length > 500L) {
            StringBuilder work = new StringBuilder();
            Reader dataReader = null;
            dataReader = clob instanceof OracleClob ? ((OracleClob)clob).getCharacterStream() : ((Clob)clob).getCharacterStream();
            char[] cbuf = new char[500];
            int charsRead = 0;
            String savedQuote = "";
            String CONCAT = this.getLineTerminator() + "|| ";
            String concat = "";
            try {
                while ((charsRead = dataReader.read(cbuf, 0, 500)) != -1) {
                    work.append(concat + function + "('" + savedQuote);
                    for (int i = 0; i < charsRead; ++i) {
                        if (cbuf[i] == '\'') {
                            work.append("'");
                        }
                        work.append(cbuf[i]);
                    }
                    work.append("')");
                    if (work.charAt(charsRead - 1) == '\'' && charsRead > 1 && work.charAt(charsRead - 2) != '\'') {
                        work.deleteCharAt(charsRead - 1);
                        savedQuote = "'";
                    }
                    concat = CONCAT;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
                return " EMPTY_CLOB()";
            }
            return work.toString();
        }
        if (length > 0L) {
            return "'" + this.cleanString(this.getValue(clob).toString()) + "'";
        }
        return "";
    }

    private String getUUEncodedBlob(Object aBlob) throws SQLException {
        String encodedString = null;
        long aBlobLength = 0L;
        byte[] aBlobBytes = null;
        Connection conn = this.getConnection();
        OracleCallableStatement ocst = (OracleCallableStatement)conn.prepareCall("{ ? = call utl_encode.uuencode(utl_raw.cast_to_raw(?),'1','uuencode.buf') }");
        ocst.registerOutParameter(1, -2);
        if (aBlob instanceof OracleBlob) {
            aBlobLength = ((OracleBlob)aBlob).length();
            aBlobBytes = ((OracleBlob)aBlob).getBytes(1L, (int)aBlobLength);
        } else if (aBlob instanceof Blob) {
            aBlobLength = ((Blob)aBlob).length();
            aBlobBytes = ((Blob)aBlob).getBytes(1L, (int)aBlobLength);
        }
        ocst.setString(2, new String(aBlobBytes));
        ocst.execute();
        RAW rawEncoded = ocst.getRAW(1);
        encodedString = rawEncoded.stringValue();
        ocst.close();
        if (encodedString.length() > 500) {
            StringBuilder work = new StringBuilder();
            StringReader dataReader = new StringReader(encodedString);
            char[] cbuf = new char[500];
            int charsRead = 0;
            String CONCAT = this.getLineTerminator() + "|| ";
            String concat = "";
            try {
                while ((charsRead = ((Reader)dataReader).read(cbuf, 0, 100)) != -1) {
                    work.append(concat + "TO_BLOB(HEXTORAW('");
                    for (int i = 0; i < charsRead; ++i) {
                        work.append(cbuf[i]);
                    }
                    work.append("'))");
                    concat = CONCAT;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
            return work.toString();
        }
        return "'" + encodedString + "'";
    }

    private String byteArrayToHexValue(Object col) {
        byte[] b = (byte[])col;
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public boolean isTableNameSupported() {
        return true;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    @Override
    public boolean isTruncateSupported() {
        return true;
    }

    @Override
    public boolean isTruncate() {
        return this.isTruncate;
    }

    @Override
    public void isTruncate(boolean value) {
        this.isTruncate = value;
    }

    @Override
    public boolean isCommitSupported() {
        return true;
    }

    @Override
    public boolean isCommit() {
        return this.isCommit;
    }

    @Override
    public void isCommit(boolean value) {
        this.isCommit = value;
    }

    @Override
    public int getCommitRows() {
        return this.commitRows;
    }

    @Override
    public void setCommitRows(int value) {
        this.commitRows = value;
    }

    @Override
    public String getCommitConfigKey() {
        return COMMIT;
    }

    @Override
    public String getCommitRowsConfigKey() {
        return COMMIT_ROWS;
    }

    @Override
    public Boolean isCandidateForSpoolMax() {
        return true;
    }
}

