/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStrategy;
import oracle.dbtools.raptor.datatypes.BindingStrategySplitMode;
import oracle.dbtools.raptor.datatypes.BindingStyle;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataParameter;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.DataVariable;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.PLSQLBlockComponent;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.PLSQLRecord;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingBase;
import oracle.jdbc.OracleCallableStatement;

public class CallableBindingRECORD<S extends OracleCallableStatement, P extends DataBinding>
extends CallableBindingBase<S, P>
implements BindingStrategySplitMode<S, P> {
    private List<BindingStrategySplitMode<S, DataVariable>> subBindings;

    public CallableBindingRECORD(BindContext<S> context, P param) {
        super(context, param);
    }

    @Override
    public void setByNameBindToken(String bindToken) {
    }

    @Override
    public String getByNameBindToken() {
        return null;
    }

    @Override
    public void setByPositionBindToken(String bindToken) {
    }

    @Override
    public String getByPositionBindToken() {
        return null;
    }

    @Override
    public BindingStyle getBindingStyle(BindingMode mode) {
        return BindingStyle.CUSTOM;
    }

    @Override
    public String getBindToken(BindingMode mode) {
        return null;
    }

    @Override
    protected void customBind(DataValue value) throws SQLException {
        List<DataValue> subComponents = value.getComponents();
        Iterator<DataValue> subComponentsIter = subComponents.iterator();
        for (BindingStrategySplitMode binding : this.subBindings) {
            binding.bind(this.getStatement(), subComponentsIter.next());
        }
    }

    @Override
    protected void customBindIN(DataValue value) throws SQLException {
    }

    @Override
    protected void customBind() throws SQLException {
        for (BindingStrategySplitMode binding : this.subBindings) {
            binding.bind(this.getStatement());
        }
    }

    @Override
    protected void customBindOUT() throws SQLException {
    }

    @Override
    public void customReportBinding(StringBuilder buffer, String nullToken, DataValue value) {
        List<DataValue> subComponents = value.getComponents();
        Iterator<DataValue> subComponentsIter = subComponents.iterator();
        for (BindingStrategySplitMode<S, DataVariable> binding : this.subBindings) {
            binding.reportBinding(buffer, nullToken, subComponentsIter.next());
        }
    }

    @Override
    public PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder builder) {
        this.subBindings = new LinkedList<BindingStrategySplitMode<S, DataVariable>>();
        String name = this.getParameter().getName() == null ? "\"<RETURN>\"" : this.getParameter().getName();
        DataType datatype = this.getParameter().getDataType();
        Collection<NamedValue<DataType>> components = datatype.getTypeComponents();
        for (NamedValue namedValue : components) {
            String componentName = name + "." + namedValue.getName();
            DataType componentDataType = (DataType)namedValue.getValue();
            DataVariable field = datatype.getDataTypeFactory().getDataVariable(componentName, componentDataType, this.getMode());
            BindingStrategy fieldbinding = DataTypeFactory.getInstance().getBind(this.getBindContext(), field);
            BindingStrategySplitMode splitBinding = fieldbinding.getSplitModeBinding();
            PLSQLBoundBlockBuilder fieldBuilder = splitBinding.getBuilder();
            builder.addBuilder(fieldBuilder);
            this.subBindings.add(splitBinding);
        }
        if (this.getParameter() instanceof DataParameter) {
            switch (this.getMode()) {
                case RETURN: {
                    builder.addComponent(PLSQLBlockComponent.PreCallWrapper, name + " := ");
                    break;
                }
                default: {
                    builder.addComponent(PLSQLBlockComponent.ParamBinding, name + "=>" + name);
                }
            }
            builder.addComponent(PLSQLBlockComponent.DataDecls, name + " " + datatype.getConstrainedDataTypeString() + ";");
        }
        return builder;
    }

    @Override
    protected DataValue customOutput() throws SQLException {
        PLSQLRecord record = new PLSQLRecord(this.getDataType());
        for (BindingStrategySplitMode<S, DataVariable> binding : this.subBindings) {
            DataValue dataValue = binding.getOutput();
            record.add(dataValue.getTypedValue(this.getBindContext().getDataTypeConnectionProvider(), ValueType.DEFAULT));
        }
        return this.getDataType().getDataValue(record);
    }

    @Override
    protected BindingStrategySplitMode<S, P> customSplitModeBinding() {
        return this;
    }
}

