/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Calendar;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.TimeZoneDatum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraTIMESTAMPLTZFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class TIMESTAMPLTZ
extends TimeZoneDatum {
    protected TIMESTAMPLTZ(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        Object internalValue = value.getInternalValue();
        switch (stringType) {
            case REST: {
                try {
                    OraTIMESTAMPLTZFormat formatter = ((OracleNLSProvider)NLSProvider.getProvider(connectionProvider.getNLSConnection())).getOraTIMESTAMPLTZFormat(FormatType.REST);
                    return new StringValue(formatter.format(internalValue));
                }
                catch (ParseException e) {
                    throw new DataTypeIllegalArgumentException(this, internalValue);
                }
            }
            case GENERIC: {
                try {
                    if (internalValue instanceof oracle.sql.TIMESTAMPLTZ) {
                        return new StringValue(((oracle.sql.TIMESTAMPLTZ)internalValue).timestampValue(connectionProvider.getNLSConnection(), Calendar.getInstance()).toString());
                    }
                    break;
                }
                catch (SQLException e) {
                    throw new DataTypeIllegalArgumentException(this, internalValue);
                }
            }
        }
        return super.customStringValue(connectionProvider, value, stringType, maxLen);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        Object internalValue = value.getInternalValue();
        switch (valueType) {
            case JDBC: {
                try {
                    if (internalValue instanceof oracle.sql.TIMESTAMPLTZ) {
                        oracle.sql.TIMESTAMPLTZ timestampValue = (oracle.sql.TIMESTAMPLTZ)internalValue;
                        return oracle.sql.TIMESTAMPLTZ.toTimestamp(connectionProvider.getNLSConnection(), (byte[])timestampValue.getBytes());
                    }
                    break;
                }
                catch (SQLException e) {
                    throw new DataTypeIllegalArgumentException(this, internalValue);
                }
            }
        }
        return super.customTypedValue(connectionProvider, value, valueType, target);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                if (connectionProvider.peekNLSConnection() == null) {
                    return super.customTypedClass(connectionProvider, valueType);
                }
            }
            case DATUM: {
                return oracle.sql.TIMESTAMPLTZ.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return -102;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        try {
            if (value instanceof oracle.sql.TIMESTAMPLTZ) {
                return value;
            }
            if (value instanceof byte[]) {
                return new oracle.sql.TIMESTAMPLTZ(Arrays.copyOf((byte[])value, ((byte[])value).length));
            }
            Object superObject = super.customInternalValue(connectionProvider, value);
            if (connectionProvider.peekNLSConnection() != null && superObject instanceof Timestamp) {
                return new oracle.sql.TIMESTAMPLTZ(connectionProvider.getNLSConnection(), (Timestamp)superObject);
            }
            return this.typedValueFromNLSString(connectionProvider, superObject.toString());
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, value);
        }
    }

    protected oracle.sql.TIMESTAMPLTZ typedValueFromNLSString(DataTypeConnectionProvider connectionProvider, String value) {
        OraTIMESTAMPLTZFormat format;
        try {
            format = ((OracleNLSProvider)NLSProvider.getProvider(connectionProvider.getNLSConnection())).getOraTIMESTAMPLTZFormat();
        }
        catch (ParseException pe) {
            format = null;
        }
        return format.parse(value, new ParsePosition(0));
    }

    @Override
    protected String customUnconstrainedDataTypeString() {
        return "TIMESTAMP_LTZ_UNCONSTRAINED";
    }

    @Override
    protected String customDataTypeString() {
        Integer scale = this.typeMetadata.get_data_scale();
        if (scale != null) {
            return "TIMESTAMP (" + scale + ") WITH LOCAL TIME ZONE";
        }
        return "TIMESTAMP WITH LOCAL TIME ZONE";
    }
}

