/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;
import oracle.dbtools.raptor.datatypes.objects.ClobDatum;
import oracle.dbtools.raptor.datatypes.objects.LargeVarchar;
import oracle.dbtools.raptor.datatypes.oracle.sql.LOB;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import org.xml.sax.SAXException;

public class CLOB
extends LOB {
    protected CLOB(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        LargeVarchar largeVarchar = (LargeVarchar)value.getInternalValue();
        return largeVarchar.getStringValue(stringType, maxLen);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        Object internalValue = value.getInternalValue();
        ClobDatum clobDatum = (ClobDatum)internalValue;
        try {
            switch (valueType) {
                case JDBC: 
                case DATUM: 
                case TARGET: {
                    return clobDatum.getTypedValue(connectionProvider, valueType, target);
                }
            }
            return super.customTypedValue(connectionProvider, value, valueType, target);
        }
        catch (IllegalArgumentException e) {
            throw new DataTypeIllegalArgumentException(this, internalValue, e);
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, internalValue);
        }
        catch (IOException e) {
            throw new DataTypeIllegalArgumentException(this, internalValue);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case JAVA: {
                return Reader.class;
            }
            case JDBC: 
            case DATUM: {
                return Clob.class;
            }
            case DEFAULT: {
                return ClobDatum.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 2005;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        try {
            if (value == null) {
                return new ClobDatum();
            }
            if (value instanceof ClobDatum) {
                return value;
            }
            return ClobDatum.constructFrom(value);
        }
        catch (IllegalArgumentException e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
        catch (IOException e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
    }

    @Override
    protected void customMarshal(DataTypeConnectionProvider connectionProvider, DataValueInternal value, DataValueMarshalHandler hd, String name) throws SAXException {
        ClobDatum clobDatum = (ClobDatum)value.getInternalValue();
        clobDatum.marshal(this, hd, name);
    }

    @Override
    public Object startDataValue(String name, boolean isNull) {
        if (isNull) {
            return null;
        }
        return ClobDatum.getBuilder();
    }

    @Override
    public void bodyDataValue(NamedValue value, char[] ch, int start, int length) {
        ClobDatum.ClobDatumBuilder builder = (ClobDatum.ClobDatumBuilder)value.getValue();
        try {
            builder.write(ch, start, length);
        }
        catch (IOException e) {
            throw new DataTypeIOException(e);
        }
    }

    @Override
    public DataValue endDataValue(NamedValue value) {
        ClobDatum.ClobDatumBuilder builder = (ClobDatum.ClobDatumBuilder)value.getValue();
        try {
            return this.getDataValue(builder != null ? builder.build() : null);
        }
        catch (IOException e) {
            throw new DataTypeIOException(e);
        }
    }
}

