/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMP;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.datatypes.objects.OraTimeZoneUtil;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPTZ;

public class OraTIMESTAMPTZ
extends OraTemporalDatum {
    private TimeZone sessionTimeZone;

    public static OraTIMESTAMPTZ getInstance() {
        return OraTIMESTAMPTZ.getInstance(TimeZone.getDefault());
    }

    public static OraTIMESTAMPTZ getInstance(TimeZone timeZone) {
        OraTIMESTAMPTZ instance = OraTIMESTAMPTZ.getInstance(Calendar.getInstance(timeZone));
        if (instance != null) {
            instance.setNow();
        }
        return instance;
    }

    public static OraTIMESTAMPTZ getInstance(Calendar calendar, Integer nanos) {
        return calendar != null ? new OraTIMESTAMPTZ(new OraTIMESTAMPTZImpl(UTC, calendar, nanos)) : null;
    }

    public static OraTIMESTAMPTZ getInstance(Calendar calendar) {
        return OraTIMESTAMPTZ.getInstance(calendar, null);
    }

    public static OraTIMESTAMPTZ getInstance(TIMESTAMPTZ date) {
        return date != null ? new OraTIMESTAMPTZ(new OraTIMESTAMPTZImpl(UTC, (Datum)date)) : null;
    }

    public static OraTIMESTAMPTZ getInstance(Date date, TimeZone timeZone) {
        return date != null ? new OraTIMESTAMPTZ(new OraTIMESTAMPTZImpl(timeZone, UTC, date instanceof Timestamp ? (Timestamp)date : new Timestamp(date.getTime()))) : null;
    }

    public static OraTIMESTAMPTZ getInstance(Date date) {
        return OraTIMESTAMPTZ.getInstance(date, TimeZone.getDefault());
    }

    protected OraTIMESTAMPTZ(OraTIMESTAMPTZImpl impl) {
        super(impl);
    }

    @Override
    public boolean userTimeZoneSupported() {
        return true;
    }

    @Override
    public Object clone() {
        OraTIMESTAMPTZ other = (OraTIMESTAMPTZ)super.clone();
        other.sessionTimeZone = this.sessionTimeZone;
        return other;
    }

    @Override
    public void replicate(OraTemporalDatum value) {
        super.replicate(value);
        this.setSessionTimeZone(value.getSessionTimeZone());
    }

    @Override
    public void setSessionTimeZone(TimeZone sessionTimeZone) {
        this.sessionTimeZone = sessionTimeZone;
    }

    @Override
    public TimeZone getSessionTimeZone() {
        return this.sessionTimeZone;
    }

    public TIMESTAMPTZ getDatum(TimeZone timeZone) {
        byte[] bytes = new byte[13];
        OraTIMESTAMPTZImpl utcImpl = (OraTIMESTAMPTZImpl)this.datumImpl.clone();
        utcImpl.setTimeZone(UTC);
        utcImpl.packDatumBytes(bytes, timeZone);
        return new TIMESTAMPTZ(bytes);
    }

    public TIMESTAMPTZ getDatum() {
        return this.getDatum(this.getTimeZone());
    }

    public String toString() {
        try {
            OraTIMESTAMPTZFormat formatter = new OraTIMESTAMPTZFormat(new OracleNLSProvider(null).getTimeStampWithTimeZoneFormat(FormatType.GENERIC), OraLocaleInfo.getInstance((Locale)Locale.US));
            return formatter.format(this.getDatum());
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    protected static class OraTIMESTAMPTZImpl
    extends OraTIMESTAMP.OraTIMESTAMPImpl {
        private static final int REGIONIDBIT = 128;
        private static final byte OFFSET_HOUR = 20;
        private static final byte OFFSET_MINUTE = 60;
        private static final String[] digit = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

        protected OraTIMESTAMPTZImpl(TimeZone datumTimeZone, Calendar calendar, Integer nanos) {
            super(datumTimeZone, calendar, nanos);
            this.setTimeZone(calendar.getTimeZone());
        }

        protected OraTIMESTAMPTZImpl(TimeZone datumTimeZone, Datum date) {
            super(datumTimeZone, date);
        }

        protected OraTIMESTAMPTZImpl(TimeZone timeZone, TimeZone datumTimeZone, Timestamp timestamp) {
            super(datumTimeZone, timestamp);
            this.setTimeZone(timeZone);
        }

        @Override
        protected int getDatumLength(int nanos) {
            return 13;
        }

        @Override
        protected boolean isDatumLengthValid(int length) {
            return length == 13;
        }

        @Override
        protected void unpackDatumBytes(byte[] bytes) {
            super.unpackDatumBytes(bytes);
            String tzID = OraTIMESTAMPTZImpl.unpackTimeZoneID(bytes);
            if (tzID != null) {
                this.setTimeZone(TimeZone.getTimeZone(tzID));
            }
        }

        protected static String unpackTimeZoneID(byte[] bytes) {
            boolean negative;
            if (bytes.length < 13) {
                return null;
            }
            if ((bytes[11] & 0x80) != 0) {
                int regID = ((bytes[11] & 0x7F) << 6) + ((bytes[12] & 0xFC) >> 2);
                return OraTimeZoneUtil.getInstance().getRegion(regID);
            }
            int hours = bytes[11] - 20;
            int minutes = bytes[12] - 60;
            boolean bl = negative = hours < 0 || minutes < 0;
            if (negative) {
                hours = -hours;
                minutes = -minutes;
            }
            return "GMT" + (negative ? "-" : "+") + digit[hours / 10] + digit[hours % 10] + ":" + digit[minutes / 10] + digit[minutes % 10];
        }

        protected void packDatumBytes(byte[] bytes, TimeZone tz) {
            super.packDatumBytes(bytes);
            OraTIMESTAMPTZImpl.packTimeZoneID(bytes, this.getTimeInMillis(), tz);
        }

        protected static void packTimeZoneID(byte[] bytes, long onDate, TimeZone tz) {
            int regID = OraTimeZoneUtil.getInstance().getID(tz.getID());
            if (regID > 0) {
                OraTIMESTAMPTZImpl.packTZRegion(bytes, regID);
            } else {
                OraTIMESTAMPTZImpl.packTZOffset(bytes, tz, onDate);
            }
        }

        private static void packTZRegion(byte[] bytes, int region) {
            bytes[11] = (byte)((region & 0x1FC0) >> 6 | 0x80);
            bytes[12] = (byte)((region & 0x3F) << 2);
        }

        private static void packTZOffset(byte[] bytes, TimeZone tz, long time) {
            int offset = tz.getOffset(time) / 60000;
            bytes[11] = (byte)(offset / 60 + 20);
            bytes[12] = (byte)(offset % 60 + 60);
        }
    }
}

