/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import org.xml.sax.SAXException;

public abstract class LargeDatum {
    public static final int CUTOVER_LENGTH = 32768;
    protected static final int BUFFER_SIZE = 2400;
    private Object value;
    private boolean deleteOnFinalize;

    protected LargeDatum() {
        this.value = null;
        this.deleteOnFinalize = false;
    }

    protected LargeDatum(Object value) {
        this.value = value;
        this.deleteOnFinalize = false;
    }

    protected LargeDatum(LargeDatum source) {
        this.value = source.value;
        this.deleteOnFinalize = source.deleteOnFinalize;
        source.deleteOnFinalize = false;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public Object getValue() {
        return this.value;
    }

    protected void setValue(Object value, boolean deleteOnFinalize) {
        this.value = value;
        this.deleteOnFinalize = deleteOnFinalize;
    }

    public String toString() {
        try {
            StringValue stringValue = this.getStringValue(StringType.DEFAULT, -1);
            return stringValue == null ? null : stringValue.toString();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return super.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.customFinalize(this.value, this.deleteOnFinalize);
        }
        finally {
            super.finalize();
        }
    }

    protected void customFinalize(Object value, boolean deleteOnFinalize) throws Throwable {
        if (!deleteOnFinalize || value != null) {
            // empty if block
        }
    }

    public final Object getTypedValue(DataTypeConnectionProvider connectionProvider, ValueType valueType, Object target) throws IOException, SQLException {
        return this.value == null ? null : this.customTypedValue(connectionProvider, valueType, target);
    }

    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, ValueType valueType, Object target) throws IOException, SQLException {
        switch (valueType) {
            case JAVA: {
                return this.customTypedValue(connectionProvider, ValueType.JDBC, target);
            }
            case DEFAULT: {
                return this.value;
            }
        }
        return this.customTypedValue(connectionProvider, ValueType.DEFAULT, target);
    }

    public abstract long getLength() throws SQLException;

    public final StringValue getStringValue(StringType stringType, int maxLen) {
        StringValue stringValue = this.value == null ? new StringValue(null) : this.customStringValue(stringType, maxLen);
        String valueText = stringValue.toString();
        if (maxLen < 0 || valueText == null || valueText.length() <= maxLen) {
            return stringValue;
        }
        return new StringValue(valueText.substring(0, maxLen), stringValue.getMaxLength());
    }

    protected StringValue customStringValue(StringType stringType, int maxLen) {
        switch (stringType) {
            case DEFAULT: {
                return new StringValue(this.value.toString());
            }
        }
        return this.customStringValue(StringType.DEFAULT, maxLen);
    }

    public abstract void marshal(DataType var1, DataValueMarshalHandler var2, String var3) throws SAXException;

    protected abstract class LargeDatumBuilder {
        protected int cutOverLen;
        protected long length;

        protected LargeDatumBuilder(int cutOverLen) {
            this.cutOverLen = cutOverLen;
            this.length = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkForCutOver(int len) throws IOException {
            if (this.cutOverLen >= 0 && this.length + (long)len > (long)this.cutOverLen) {
                try {
                    this.cutOver();
                }
                finally {
                    this.cutOverLen = -1;
                }
            }
        }

        public abstract LargeDatum build() throws IOException, SQLException;

        protected abstract void cutOver() throws IOException;
    }
}

