/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.marshal;

import java.util.Collection;
import java.util.Stack;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeMarshallingException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;

public class DataValueUnmarshalHandler {
    private Stack<DataType> datatypes = new Stack();
    private Stack<NamedValue> internalValues = new Stack();
    private final DataType datatype;
    private final boolean useName;
    private DataValue datavalue;
    private String name;

    public DataValueUnmarshalHandler(DataType datatype, String name) {
        this(datatype, name, true);
    }

    public DataValueUnmarshalHandler(DataType datatype) {
        this(datatype, null, false);
    }

    private DataValueUnmarshalHandler(DataType datatype, String name, boolean useName) {
        this.datatype = datatype;
        this.datavalue = null;
        this.name = name;
        this.useName = useName;
    }

    public void startDataValue(String name, boolean isNull) {
        DataType datatype = null;
        String focusName = name;
        if (this.internalValues.size() > 0) {
            NamedValue<DataType> typeComponent = this.lookupComponentType(this.datatypes.peek(), focusName);
            if (typeComponent != null) {
                focusName = typeComponent.getName();
                datatype = typeComponent.getValue();
                this.customPushDataType(datatype);
            }
        } else {
            if (this.useName) {
                focusName = this.name;
            } else {
                this.name = focusName;
            }
            datatype = this.datatype;
            this.customPushDataType(datatype);
        }
        if (datatype == null) {
            focusName = this.internalValues.size() == 0 ? focusName : this.internalValues.peek().getName();
            DataType focusDataType = this.datatypes.peek();
            throw new DataTypeMarshallingException(focusName, focusDataType);
        }
        this.internalValues.push(new NamedValue<Object>(focusName, datatype.startDataValue(focusName, isNull)));
    }

    protected void customPushDataType(DataType datatype) {
        this.datatypes.push(datatype);
    }

    protected DataType customPopDataType() {
        return this.datatypes.pop();
    }

    public void bodyDataValue(char[] ch, int start, int length) {
        this.datatypes.peek().bodyDataValue(this.internalValues.peek(), ch, start, length);
    }

    public void bodyDataValue(String text) {
        this.datatypes.peek().bodyDataValue(this.internalValues.peek(), text);
    }

    public void endDataValue() {
        String name = this.internalValues.peek().getName();
        DataValue datavalue = NamedDataValue.getNamedDataValue(name, this.customPopDataType().endDataValue(this.internalValues.pop()));
        if (this.datatypes.size() > 0) {
            this.datatypes.peek().bodyDataValue(this.internalValues.peek(), datavalue);
        } else {
            this.datavalue = datavalue;
        }
    }

    public DataValue getDataValue() {
        return this.datavalue;
    }

    public DataType getDataType() {
        return this.datatype;
    }

    public String getName() {
        return this.name;
    }

    protected NamedValue<DataType> lookupComponentType(DataType datatype, String focusName) {
        Collection<NamedValue<DataType>> components = datatype.getTypeComponents();
        for (NamedValue namedValue : components) {
            String typeName = namedValue.getName();
            if (typeName != null && typeName != focusName && (typeName == null || focusName == null || !typeName.equals(focusName))) continue;
            return namedValue;
        }
        return null;
    }
}

