/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingStrategy;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypePlatformException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;

public class BindContextImpl<S extends Statement>
implements BindContext<S> {
    private Class<? extends S> stmtClass;
    private S stmt;
    protected final DataTypeConnectionProvider connectionProvider;
    private int lastBindIndex;
    private List<String> bindTokens;
    HashMap<BindingStrategy, DataValue> inputs = new HashMap();
    HashMap<BindingStrategy, DataValue> outputs = new HashMap();

    public BindContextImpl(Class<? extends S> stmtClass, DataTypeConnectionProvider provider) {
        this.stmtClass = stmtClass;
        this.connectionProvider = provider;
        this.lastBindIndex = 0;
        this.bindTokens = null;
    }

    @Override
    public String nextBindToken() {
        return ":" + ++this.lastBindIndex;
    }

    @Override
    public String lastBindToken() {
        return ":" + this.lastBindIndex;
    }

    @Override
    public int remapPosition(String bindToken) {
        int newPosition = -1;
        if (this.bindTokens != null && (newPosition = this.bindTokens.indexOf(bindToken)) >= 0) {
            ++newPosition;
        }
        return newPosition;
    }

    @Override
    public void setBindTokens(List<String> bindTokens) {
        this.bindTokens = bindTokens;
    }

    @Override
    public List<String> getBindTokens() {
        return this.bindTokens;
    }

    @Override
    public DataTypeConnectionProvider getDataTypeConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public Class<? extends S> getStatementClass() {
        return this.stmtClass;
    }

    @Override
    public Class<? extends Statement> getEffectiveStatementClass() {
        if (this.stmt != null ? this.stmt instanceof OracleCallableStatement : this.stmtClass != null && OracleCallableStatement.class.isAssignableFrom(this.stmtClass)) {
            return OracleCallableStatement.class;
        }
        return OraclePreparedStatement.class;
    }

    @Override
    public final S getStatement() {
        return this.stmt;
    }

    @Override
    public final void setStatement(S stmt) {
        try {
            this.stmt = (Statement)this.stmtClass.cast(stmt);
        }
        catch (ClassCastException e) {
            throw new DataTypePlatformException(OracleCallableStatement.class);
        }
    }

    @Override
    public DataValue getInput(BindingStrategy binding) {
        return this.inputs.get(binding);
    }

    @Override
    public void cacheInput(BindingStrategy binding, DataValue value) {
        this.inputs.put(binding, value);
    }

    @Override
    public DataValue getOutput(BindingStrategy binding) {
        return this.outputs.get(binding);
    }

    @Override
    public void cacheOutput(BindingStrategy binding, DataValue value) {
        this.outputs.put(binding, value);
    }

    @Override
    public void emptyInputCache() {
        this.inputs.clear();
    }

    @Override
    public void emptyOutputCache() {
        this.outputs.clear();
    }

    @Override
    public void emptyValueCaches() {
        this.emptyInputCache();
        this.emptyOutputCache();
    }

    @Override
    public void uncacheInput(BindingStrategy binding) {
        this.inputs.remove(binding);
    }

    @Override
    public void uncacheOutput(BindingStrategy binding) {
        this.outputs.remove(binding);
    }

    @Override
    public void uncacheValues(BindingStrategy binding) {
        this.uncacheOutput(binding);
        this.uncacheInput(binding);
    }
}

