/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.ITaskDialog;
import oracle.dbtools.raptor.backgroundTask.ITaskTracker;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.TaskLinkedList;
import oracle.dbtools.raptor.backgroundTask.internal.IRaptorTaskUIListener;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.backgroundTask.utils.RaptorTaskWrapper;
import oracle.dbtools.util.Logger;

public class RaptorTaskManager {
    private static RaptorTaskManager schedulerInstance;
    private ITaskTracker _tracker = null;
    private ITaskViewer _viewer = null;
    private ITaskDialog _taskDialog = null;
    private ITaskUI _defaultTaskUI = null;
    private final TaskLinkedList<RaptorTask<?>> _schedulerTaskList = new TaskLinkedList();
    private final Map<RaptorTask<?>, Future<?>> _scheduledTaskMap = new ConcurrentHashMap();
    private final RaptorTaskThreadFactory _threadFactory = new RaptorTaskThreadFactory();
    private final ExecutorService _taskExecutor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this._threadFactory);
    private final Thread.UncaughtExceptionHandler _uncaught = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            Logger.severe(this.getClass(), e);
        }
    };
    private SchedulerThread _schedulerThread = new SchedulerThread();
    private IRaptorTaskListener _taskListener;
    private Map<RaptorTaskDescriptor, ITaskDialog> _taskDialogMap;

    public ITaskUI getDefaultTaskUI() {
        return this._defaultTaskUI;
    }

    public void setDefaultTaskUI(ITaskUI _defaultTaskUI) {
        this._defaultTaskUI = _defaultTaskUI;
    }

    public ITaskDialog getTaskDialog() {
        return this._taskDialog;
    }

    public void setTaskDialog(ITaskDialog _taskDialog) {
        this._taskDialog = _taskDialog;
    }

    public ITaskViewer getTaskProgressViewer() {
        return this._viewer;
    }

    public void setTaskProgressViewer(ITaskViewer viewer) {
        this._viewer = viewer;
    }

    public ITaskTracker getIDETaskTracker() {
        return this._tracker;
    }

    public void setIDETaskTracker(ITaskTracker _tracker1) {
        this._tracker = _tracker1;
    }

    private RaptorTaskManager() {
        this._schedulerThread.setDaemon(true);
        this._schedulerThread.setName("Scheduler");
        this._taskListener = new RaptorTaskAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(RaptorTaskEvent event) {
                IRaptorTaskStatus status = event.getTaskDescriptor().getStatus();
                if (status == IRaptorTaskStatus.FAILED || status == IRaptorTaskStatus.FINISHED || status == IRaptorTaskStatus.PAUSED) {
                    TaskLinkedList taskLinkedList = RaptorTaskManager.this._schedulerTaskList;
                    synchronized (taskLinkedList) {
                        RaptorTaskManager.this._schedulerTaskList.notify();
                    }
                }
            }
        };
        this._schedulerThread.start();
        this._taskDialogMap = new ConcurrentHashMap<RaptorTaskDescriptor, ITaskDialog>();
    }

    public static synchronized RaptorTaskManager getInstance() {
        if (schedulerInstance == null) {
            schedulerInstance = new RaptorTaskManager();
        }
        return schedulerInstance;
    }

    public void addTask(RaptorTask<?> task) {
        this.addTask(task, new ArrayList());
    }

    public void addTask(RaptorTask<?> task, List<? extends ITaskViewer> viewers) {
        this.addTask(task, new ArrayList(), viewers);
    }

    public void addTask(RaptorTaskWrapper<?> taskWrapper) {
        this.addTask(taskWrapper.getTask(), taskWrapper.getRaptorTaskUIListeners(), taskWrapper.getTaskViewers());
    }

    public void addTask(final RaptorTask<?> task, final List<? extends IRaptorTaskUIListener> taskUIListeners, final List<? extends ITaskViewer> viewers) {
        task.getDescriptor().addListener(this._taskListener);
        IRaptorTaskRunMode mode = task.getDescriptor().getRunMode();
        if (mode == IRaptorTaskRunMode.NO_GUI) {
            this.submitTask(task);
            return;
        }
        if (mode == IRaptorTaskRunMode.MODAL || mode == IRaptorTaskRunMode.MODAL_OPTIONAL) {
            this.submitTask(task);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread();
                    Thread.setDefaultUncaughtExceptionHandler(RaptorTaskManager.this._uncaught);
                    ITaskUI taskUI = null;
                    if (viewers.size() > 0) {
                        taskUI = ((ITaskViewer)viewers.get(0)).createTaskUI(task.getDescriptor());
                    }
                    if (taskUI == null) {
                        taskUI = RaptorTaskManager.this.getDefaultTaskUI().getNewTaskUI(task.getDescriptor());
                    }
                    RaptorTaskManager.this.initViewers(task, viewers, taskUIListeners);
                    ArrayList<DefaultTaskUIListener> uiListeners = null;
                    uiListeners = taskUIListeners != null ? new ArrayList(taskUIListeners) : new ArrayList<DefaultTaskUIListener>();
                    uiListeners.add(0, new DefaultTaskUIListener(task, null));
                    RaptorTaskManager.this.setTaskUIState(taskUI, task, uiListeners);
                    ITaskDialog tDialog = RaptorTaskManager.this.createBackgroundDialog(task, taskUIListeners, viewers, taskUI);
                    RaptorTaskManager.this.showModalDialog(task, tDialog);
                }
            });
        } else if (mode == IRaptorTaskRunMode.TASKVIEWER || mode == IRaptorTaskRunMode.IDE_STATUSBAR) {
            Runnable taskUIRunnable = new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread();
                    Thread.setDefaultUncaughtExceptionHandler(RaptorTaskManager.this._uncaught);
                    ArrayList<ITaskViewer> viewerss = new ArrayList<ITaskViewer>(viewers);
                    viewerss.add(0, RaptorTaskManager.this.getTaskProgressViewer());
                    RaptorTaskManager.this.initViewers(task, viewerss, taskUIListeners);
                }
            };
            RaptorTaskManager.invokeInDispatchThreadIfNeeded(taskUIRunnable);
            this.submitTask(task);
        }
    }

    public static void invokeInDispatchThreadIfNeeded(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void showModalDialog(RaptorTask<?> task, ITaskDialog tDialog) {
        tDialog.showDelayedDialog(task);
    }

    private ITaskDialog createBackgroundDialog(final RaptorTask<?> task, final List<? extends IRaptorTaskUIListener> taskUIListeners, final List<? extends ITaskViewer> viewers, ITaskUI defaultUI) {
        boolean runBkGrnd = task.getDescriptor().getRunMode() == IRaptorTaskRunMode.MODAL_OPTIONAL;
        final ITaskDialog tDialog = this.getTaskDialog().createNewDialog(defaultUI, task, runBkGrnd);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (cmd.equals("cancel_task") && IRaptorTaskStatus.isAlive(task.getDescriptor().getStatus())) {
                    if (!RaptorTaskManager.this.cancelTask(task)) {
                        Logger.severe(this.getClass(), e.toString());
                    }
                } else if (cmd.equals("run_in_background")) {
                    ArrayList<ITaskViewer> viewerss = new ArrayList<ITaskViewer>(viewers);
                    viewerss.add(0, RaptorTaskManager.this.getTaskProgressViewer());
                    RaptorTaskManager.this.initViewers(task, viewerss, taskUIListeners);
                    tDialog.setVisible(false);
                } else if (cmd.equals("close_dialog")) {
                    tDialog.setVisible(false);
                }
            }
        };
        WindowAdapter wl = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (IRaptorTaskStatus.isAlive(task.getDescriptor().getStatus()) && !RaptorTaskManager.this.cancelTask(task)) {
                    Logger.severe(this.getClass(), e.toString());
                }
            }
        };
        tDialog.setButtonListener(l);
        tDialog.setWindowCloseListener(wl);
        this._taskDialogMap.put(task.getDescriptor(), tDialog);
        return tDialog;
    }

    private void initViewers(RaptorTask<?> task, List<? extends ITaskViewer> viewers, List<? extends IRaptorTaskUIListener> taskUIListeners) {
        for (ITaskViewer iTaskViewer : viewers) {
            ArrayList<? extends IRaptorTaskUIListener> uiListeners = new ArrayList<IRaptorTaskUIListener>(taskUIListeners);
            ITaskUI ui = iTaskViewer.createTaskUI(task.getDescriptor());
            uiListeners.add(0, new DefaultTaskUIListener(task, viewers));
            this.setTaskUIState(ui, task, uiListeners);
            iTaskViewer.addTaskUI(ui);
        }
    }

    private void setTaskUIState(ITaskUI taskUI, RaptorTask<?> task, List<? extends IRaptorTaskUIListener> taskUIListeners) {
        if (taskUI != null && task != null) {
            taskUI.setCancellable(task.isCancellable());
            taskUI.setPausable(task.isPausable());
            for (IRaptorTaskUIListener iRaptorTaskUIListener : taskUIListeners) {
                taskUI.addListener(iRaptorTaskUIListener);
            }
            task.getDescriptor().addListener(taskUI);
        }
    }

    private void submitTask(RaptorTask<?> task) {
        if (!this._schedulerThread.isAlive()) {
            throw new IllegalStateException(Messages.getString("RaptorTaskManager.3"));
        }
        task.setStatus(IRaptorTaskStatus.NEW);
        this._schedulerTaskList.offer(task);
    }

    public boolean cancelTask(RaptorTask<?> task) {
        Future<?> taskThread;
        if (task.getStatus() == IRaptorTaskStatus.NEW) {
            this._schedulerTaskList.remove(task);
            task.getDescriptor().setCancelled(true);
            task.setStatus(IRaptorTaskStatus.FINISHED);
            return true;
        }
        task.requestCancel();
        if (task.mayInterrupt() && (taskThread = this._scheduledTaskMap.get(task)) != null) {
            boolean cancelled = taskThread.cancel(true);
            task.getDescriptor().setCancelled(cancelled);
            return cancelled;
        }
        return false;
    }

    public void shutdown() {
        this._schedulerThread.interrupt();
        this._taskExecutor.shutdown();
    }

    private void removeDeadTasks() {
        Iterator<Object> iterator = this._scheduledTaskMap.keySet().iterator();
        while (iterator.hasNext()) {
            RaptorTask<?> task = iterator.next();
            if (task.getStatus() != IRaptorTaskStatus.FINISHED && task.getStatus() != IRaptorTaskStatus.FAILED) continue;
            task.getDescriptor().removeAllListeners();
            iterator.remove();
        }
        iterator = this._taskDialogMap.keySet().iterator();
        while (iterator.hasNext()) {
            RaptorTaskDescriptor taskDesc = (RaptorTaskDescriptor)iterator.next();
            if (taskDesc.getStatus() != IRaptorTaskStatus.FINISHED && taskDesc.getStatus() != IRaptorTaskStatus.FAILED) continue;
            ITaskDialog taskDialog = this._taskDialogMap.get(taskDesc);
            if (taskDialog != null && !taskDialog.isVisible()) {
                taskDialog.dispose();
            }
            taskDesc.removeAllListeners();
            iterator.remove();
        }
    }

    private void shiftToForeGround(ITaskUI taskUI) {
        ITaskDialog taskDialog = this._taskDialogMap.get(taskUI.getTaskDescriptor());
        if (taskDialog != null && taskDialog.isDisplayable() && this.getTaskProgressViewer() != null) {
            this.getTaskProgressViewer().removeTaskUI(taskUI);
            taskDialog.setVisible(true);
        }
    }

    private static class RaptorTaskThreadFactory
    implements ThreadFactory {
        private final ThreadFactory _delegate = Executors.defaultThreadFactory();
        private String _threadName = "";
        private int counter = 1;
        private DecimalFormat df = new DecimalFormat("#00");

        private RaptorTaskThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this._delegate.newThread(r);
            t.setName("RaptorTaskThread" + this.df.format(this.counter));
            ++this.counter;
            return t;
        }

        synchronized void setThreadName(String threadName) {
            this._threadName = threadName;
        }
    }

    private class DefaultTaskUIListener
    implements IRaptorTaskUIListener {
        RaptorTask<?> _task = null;
        List<? extends ITaskViewer> _viewers = null;

        public DefaultTaskUIListener(RaptorTask<?> task, List<? extends ITaskViewer> viewers) {
            this._task = task;
            this._viewers = viewers;
        }

        @Override
        public void cancelClicked(RaptorTaskDescriptor desc) {
            if (this._viewers != null) {
                for (ITaskViewer iTaskViewer : this._viewers) {
                    iTaskViewer.taskCancelRequested(desc);
                }
            }
            RaptorTaskManager.this.cancelTask(this._task);
        }

        @Override
        public void pauseClicked(RaptorTaskDescriptor desc) {
            if (this._viewers != null) {
                for (ITaskViewer iTaskViewer : this._viewers) {
                    iTaskViewer.taskPauseRequested(desc);
                }
            }
            if (this._task.getStatus() == IRaptorTaskStatus.PAUSED) {
                this._task.resume();
            } else if (this._task.getStatus() == IRaptorTaskStatus.RUNNABLE) {
                this._task.requestPause();
            }
        }

        @Override
        public void taskClicked(RaptorTaskDescriptor desc) {
            ITaskUI taskUI;
            if (desc.getRunMode() == IRaptorTaskRunMode.MODAL_OPTIONAL && RaptorTaskManager.this.getTaskProgressViewer() != null && (taskUI = RaptorTaskManager.this.getTaskProgressViewer().getTaskUI(desc)) != null) {
                RaptorTaskManager.this.shiftToForeGround(taskUI);
            }
        }
    }

    private class RaptorFutureTask<V>
    extends FutureTask<V> {
        RaptorTask<V> _task;

        public RaptorFutureTask(RaptorTask<V> callable) {
            super(callable);
            this._task = null;
            this._task = callable;
        }

        @Override
        protected void done() {
            super.done();
            try {
                try {
                    if (this.isCancelled()) {
                        boolean bl = false;
                    }
                    if (!Thread.interrupted()) {
                        this.get();
                    }
                    this._task.setStatus(IRaptorTaskStatus.FINISHED);
                }
                catch (ExecutionException ex) {
                    Throwable t = ex.getCause();
                    throw t;
                }
            }
            catch (Throwable t) {
                if (t instanceof TaskException) {
                    this._task.getDescriptor().setStatus(IRaptorTaskStatus.FAILED, ((TaskException)t).getCause());
                }
                this._task.getDescriptor().setStatus(IRaptorTaskStatus.FAILED, t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this._task.getDescriptor().getRunMode() == IRaptorTaskRunMode.IDE_STATUSBAR) {
                RaptorTaskManager.this._tracker.add(this._task, this);
            }
            String tname = Thread.currentThread().getName();
            String rtname = this._task.getDescriptor().getName();
            if (rtname != null && !rtname.isEmpty()) {
                Thread.currentThread().setName(tname + '-' + rtname);
            }
            try {
                super.run();
            }
            finally {
                Thread.currentThread().setName(tname);
            }
        }
    }

    private class SchedulerThread
    extends Thread {
        private SchedulerThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        RaptorTask<?> taskToSchedule;
                        if ((taskToSchedule = RaptorTaskManager.this._schedulerTaskList.takeNextTask(RaptorTaskManager.this._scheduledTaskMap.keySet())) == null) {
                            continue;
                        }
                        if (taskToSchedule.getStatus().equals((Object)IRaptorTaskStatus.NEW)) {
                            RaptorFutureTask taskResult = new RaptorFutureTask(taskToSchedule);
                            taskToSchedule.setFuture(taskResult);
                            RaptorTaskManager.this._threadFactory.setThreadName(taskToSchedule.getDescriptor().getName());
                            RaptorTaskManager.this._taskExecutor.submit(taskResult);
                            RaptorTaskManager.this._scheduledTaskMap.put(taskToSchedule, taskResult);
                        }
                        RaptorTaskManager.this.removeDeadTasks();
                    }
                }
                catch (Throwable e) {
                    Logger.severe(this.getClass(), Messages.getString("RaptorTaskManager.4"), e);
                    continue;
                }
                break;
            }
        }
    }
}

