/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql.doc;

import java.io.Serializable;
import java.util.Set;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.parser.plsql.doc.Substr;
import oracle.dbtools.util.Service;

public class DocURL
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String pageParagraph;
    private final Manual man;

    public DocURL(Manual man, String doc) {
        this.pageParagraph = doc;
        this.man = man;
    }

    public String getPublicURL() {
        return this.man.getBasePublicURL() + this.pageParagraph;
    }

    public String getPrivateURL() {
        return this.man.getBasePrivateURL() + this.pageParagraph;
    }

    public String toString() {
        return this.getPublicURL();
    }

    public static void main(String[] args) {
        int regexp_like_condition = SqlEarley.getInstance().getSymbol("regexp_like_condition");
        int where_clause = SqlEarley.getInstance().getSymbol("where_clause");
        Set<Substr> templates = HarvestDoc.getTemplates().get(Service.lPair(regexp_like_condition, where_clause));
        for (Substr t : templates) {
            System.out.println(t.toString());
        }
    }

    public static enum Manual implements Serializable
    {
        SQL,
        PLSQL;


        public String getBasePrivateURL() {
            switch (this) {
                case SQL: {
                    return "http://st-doc.us.oracle.com/database/122/SQLRF/";
                }
                case PLSQL: {
                    return "http://st-doc.us.oracle.com/database/122/LNPLS/";
                }
            }
            throw new AssertionError((Object)"VT:impossible");
        }

        public String getBasePublicURL() {
            switch (this) {
                case SQL: {
                    return "http://docs.oracle.com/database/121/SQLRF/";
                }
                case PLSQL: {
                    return "http://docs.oracle.com/database/121/LNPLS/";
                }
            }
            throw new AssertionError((Object)"VT:impossible");
        }
    }
}

