/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class SqlRules {
    private static char[] identifiers = new char[]{'(', ')', '\'', ',', ';', ':', '=', '+', '-', '*', '/', '@', '!', '^', '~', 'e', 'f', 'd', '?'};
    private static Earley earley;
    static int bnf;
    static int rawbnf;
    static int boldrawbnf;
    static int identifier;
    static int concat;
    static int block;
    static int sqBr;
    static int curlyBr;
    static int dot;
    static int lt;
    static int gt;
    static int lbr;
    static int rbr;
    static int lcp;
    static int rcp;
    static int dbar;
    static int sbar;
    static Map<String, String> missingSymbols;
    private static final String path = "/oracle/dbtools/parser/plsql/";
    private static Set<String> toDo;
    private static Set<String> notFound;
    private static Set<String> masterRules;
    private static ParseNode fixesParseTree;
    private static List<LexerToken> fixesScan;
    private static ParseNode bnfRoot;

    private static void testParseSqlBnf() throws Exception {
        String input = Service.readFile(SqlRules.class, "testsql.bnf");
        List<LexerToken> src = LexerToken.parse(input);
        SqlRules.correctDots(src);
        Visual visual = null;
        visual = new Visual(src, earley);
        Matrix matrix = new Matrix(earley);
        earley.parse(src, matrix);
        ParseNode root = earley.forest(src, matrix);
        root.printTree();
        if (visual != null) {
            visual.draw(matrix);
        }
        TreeSet<RuleTuple> grammar = new TreeSet<RuleTuple>();
        String hdr = "test";
        grammar.addAll(SqlRules.bnf(root, src, hdr));
        System.out.println("-------------Optimized---------------");
        RuleTuple.printRules(grammar);
        System.out.println("-------------------------------------");
    }

    private static void bnfIdentifiers(Set<RuleTuple> rules) {
        for (char id : identifiers) {
            rules.add(new RuleTuple("identifier", new String[]{"'" + id + "'"}));
        }
    }

    private static Earley bnfParser() throws Exception {
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        String input = Service.readFile(SqlRules.class, "DocBnf.grammar");
        List<LexerToken> src = LexerToken.parse(input, false, 1);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        Grammar.grammar(root, src, rules);
        return new Earley(rules){

            @Override
            protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                LexerToken token = src.get(y);
                return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING;
            }
        };
    }

    static Set<RuleTuple> extractRules() throws Exception {
        TreeSet<RuleTuple> sqlRules = new TreeSet<RuleTuple>();
        missingSymbols.put("access_driver_type", "identifier");
        missingSymbols.put("admin_user_name", "identifier");
        missingSymbols.put("alias", "identifier");
        missingSymbols.put("argument", "expr");
        missingSymbols.put("attribute", "identifier");
        missingSymbols.put("attr_dim", "identifier");
        missingSymbols.put("c_alias", "identifier");
        missingSymbols.put("category", "identifier");
        missingSymbols.put("char1", "expr");
        missingSymbols.put("char2", "expr");
        missingSymbols.put("character_set", "identifier");
        missingSymbols.put("charset", "identifier");
        missingSymbols.put("child_level", "identifier");
        missingSymbols.put("child_key_column", "column");
        missingSymbols.put("cluster", "identifier");
        missingSymbols.put("class", "literal");
        missingSymbols.put("class_value", "expr");
        missingSymbols.put("cluster", "identifier");
        missingSymbols.put("cluster_id", "identifier");
        sqlRules.add(new RuleTuple("cluster_id", new String[]{"identifier", "'.'", "identifier"}));
        missingSymbols.put("cost_value", "literal");
        missingSymbols.put("collection_item", "identifier");
        missingSymbols.put("column_alias", "identifier");
        missingSymbols.put("column_expression", "expr");
        missingSymbols.put("column_name", "identifier");
        missingSymbols.put("comparison_expr", "expr");
        missingSymbols.put("constant", "literal");
        missingSymbols.put("constraint_name", "identifier");
        missingSymbols.put("cpu_cost", "digits");
        missingSymbols.put("create_table_statement", "create_table");
        missingSymbols.put("create_view_statement", "create_view");
        missingSymbols.put("data_item", "identifier");
        sqlRules.add(new RuleTuple("data_item", new String[]{"identifier", "'.'", "identifier"}));
        sqlRules.add(new RuleTuple("data_item", new String[]{"':'", "identifier"}));
        missingSymbols.put("database", "identifier");
        missingSymbols.put("date", "expr");
        missingSymbols.put("db_user_proxy", "identifier");
        missingSymbols.put("default_selectivity", "digits");
        missingSymbols.put("dependent_column", "column");
        missingSymbols.put("directory_name", "identifier");
        missingSymbols.put("dimension", "identifier");
        missingSymbols.put("dimension_column", "identifier");
        missingSymbols.put("directory_name", "identifier");
        missingSymbols.put("directory_object_name", "identifier");
        missingSymbols.put("disk_name", "identifier");
        missingSymbols.put("diskgroup_name", "identifier");
        missingSymbols.put("domain", "identifier");
        missingSymbols.put("edition_name", "identifier");
        missingSymbols.put("else_expr", "expr");
        missingSymbols.put("element", "identifier");
        missingSymbols.put("end_time_column", "identifier");
        missingSymbols.put("esc_char", "string_literal");
        missingSymbols.put("expr1", "expr");
        missingSymbols.put("expr2", "expr");
        missingSymbols.put("expr3", "expr");
        missingSymbols.put("failgroup_name", "identifier");
        missingSymbols.put("filename", "string_literal");
        missingSymbols.put("file_number", "digits");
        missingSymbols.put("file_number", "digits");
        missingSymbols.put("flashback_archive", "identifier");
        missingSymbols.put("fractional_second_precision", "digits");
        missingSymbols.put("function_name", "identifier");
        missingSymbols.put("grant_statement", "grant");
        missingSymbols.put("hash_partition_quantity", "digits");
        missingSymbols.put("hash_subpartition_quantity", "digits");
        missingSymbols.put("hierarchy", "identifier");
        missingSymbols.put("HSM_auth_string", "identifier");
        missingSymbols.put("implementation_type", "identifier");
        missingSymbols.put("index", "identifier");
        missingSymbols.put("indextype", "identifier");
        missingSymbols.put("integer", "digits");
        missingSymbols.put("io_cost", "digits");
        missingSymbols.put("java_ext_name", "identifier");
        missingSymbols.put("keystore_password", "identifier");
        missingSymbols.put("keystore2_password", "identifier");
        missingSymbols.put("keystore3_password", "identifier");
        missingSymbols.put("leading_field_precision", "digits");
        missingSymbols.put("len", "digits");
        missingSymbols.put("level", "identifier");
        missingSymbols.put("level_table", "identifier");
        missingSymbols.put("level_column", "identifier");
        missingSymbols.put("lib_name", "identifier");
        missingSymbols.put("library_name", "identifier");
        missingSymbols.put("LOB_item", "identifier");
        missingSymbols.put("LOB_segname", "identifier");
        missingSymbols.put("log_group", "identifier");
        missingSymbols.put("main_model_name", "identifier");
        missingSymbols.put("materialized_view", "identifier");
        missingSymbols.put("measure_column", "identifier");
        missingSymbols.put("method", "identifier");
        missingSymbols.put("mining_model_name", "identifier");
        missingSymbols.put("model", "identifier");
        missingSymbols.put("n", "digits");
        missingSymbols.put("name", "identifier");
        missingSymbols.put("namespace", "identifier");
        missingSymbols.put("nested_item", "identifier");
        missingSymbols.put("nested_table", "identifier");
        missingSymbols.put("nested_table1", "identifier");
        missingSymbols.put("nested_table2", "identifier");
        missingSymbols.put("network_cost", "digits");
        missingSymbols.put("new_keystore_password", "identifier");
        missingSymbols.put("new_name", "identifier");
        missingSymbols.put("new_table_name", "identifier");
        missingSymbols.put("object", "identifier");
        missingSymbols.put("object_name", "identifier");
        missingSymbols.put("object_step", "identifier");
        missingSymbols.put("object_privilege", "identifier");
        missingSymbols.put("object_table_alias", "identifier");
        missingSymbols.put("old_name", "identifier");
        missingSymbols.put("old_password", "identifier");
        missingSymbols.put("old_keystore_password", "identifier");
        missingSymbols.put("offset", "digits");
        missingSymbols.put("operator", "identifier");
        missingSymbols.put("ordering_column", "identifier");
        missingSymbols.put("outline", "identifier");
        missingSymbols.put("package", "identifier");
        missingSymbols.put("package_name", "identifier");
        missingSymbols.put("parameter", "identifier");
        missingSymbols.put("parameter_name", "identifier");
        missingSymbols.put("parameter_type", "prm_spec_unconstrained_type");
        missingSymbols.put("parameter_value", "expr");
        missingSymbols.put("parent_level", "identifier");
        missingSymbols.put("partition", "identifier");
        missingSymbols.put("partition_name", "identifier");
        missingSymbols.put("partition_name_old", "identifier");
        missingSymbols.put("password", "identifier");
        missingSymbols.put("pattern", "string_literal");
        missingSymbols.put("pdb_name", "identifier");
        missingSymbols.put("percent", "digits");
        missingSymbols.put("policy", "identifier");
        missingSymbols.put("position", "digits");
        sqlRules.add(new RuleTuple("precision", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("precision", new String[]{"'*'"}));
        missingSymbols.put("primary_name", "identifier");
        missingSymbols.put("procedure_name", "identifier");
        missingSymbols.put("procedure", "identifier");
        missingSymbols.put("profile", "identifier");
        missingSymbols.put("query_name", "identifier");
        missingSymbols.put("reference_spreadsheet_name", "identifier");
        missingSymbols.put("restore_point", "identifier");
        missingSymbols.put("return_expr", "expr");
        missingSymbols.put("return_type", "func_return_prm_spec_unconstrained_type");
        missingSymbols.put("role", "identifier");
        missingSymbols.put("role_name", "identifier");
        missingSymbols.put("rollback_segment", "identifier");
        missingSymbols.put("row_pattern_measure_column", "column");
        missingSymbols.put("rowcount", "digits");
        missingSymbols.put("sample_percent", "digits");
        missingSymbols.put("scale", "digits");
        missingSymbols.put("schema", "identifier");
        missingSymbols.put("schema_name", "identifier");
        missingSymbols.put("scope_table", "identifier");
        missingSymbols.put("search_string", "string_literal");
        missingSymbols.put("secret", "identifier");
        missingSymbols.put("seed_value", "digits");
        missingSymbols.put("sequence", "identifier");
        missingSymbols.put("server_file_name", "string_literal");
        missingSymbols.put("size", "digits");
        missingSymbols.put("software_keystore_password", "identifier");
        missingSymbols.put("source_outline", "identifier");
        missingSymbols.put("src_pdb_name", "identifier");
        missingSymbols.put("statement", "sql_stmt");
        missingSymbols.put("start_time_column", "identifier");
        missingSymbols.put("storage_table", "identifier");
        missingSymbols.put("subpartition", "identifier");
        missingSymbols.put("synonym", "identifier");
        missingSymbols.put("t_alias", "identifier");
        missingSymbols.put("table", "identifier");
        missingSymbols.put("tablespace", "identifier");
        missingSymbols.put("table_alias", "identifier");
        missingSymbols.put("tablespace", "identifier");
        missingSymbols.put("template_name", "identifier");
        missingSymbols.put("topN", "digits");
        missingSymbols.put("trigger_name", "identifier");
        missingSymbols.put("type_name", "identifier");
        missingSymbols.put("type", "identifier");
        missingSymbols.put("user", "identifier");
        missingSymbols.put("user_defined_types", "identifier");
        sqlRules.add(new RuleTuple("user_defined_types", new String[]{"identifier", "'.'", "identifier"}));
        sqlRules.add(new RuleTuple("user_defined_types", new String[]{"'REF'", "identifier"}));
        missingSymbols.put("value_expr", "expr");
        missingSymbols.put("value_expression", "expr");
        missingSymbols.put("view", "identifier");
        missingSymbols.put("valid_time_column", "identifier");
        missingSymbols.put("variable_expression", "bind_var");
        missingSymbols.put("variable_name", "identifier");
        missingSymbols.put("varray_item", "identifier");
        missingSymbols.put("varray_type", "identifier");
        missingSymbols.put("XMLSchema_URL", "identifier");
        missingSymbols.put("zonemap_name", "identifier");
        sqlRules.add(new RuleTuple("literal", new String[]{"string_literal"}));
        sqlRules.add(new RuleTuple("literal", new String[]{"number"}));
        sqlRules.add(new RuleTuple("datetime_literal", new String[]{"'TO_DATE'", "'('", "string_literal", "','", "string_literal", "')'"}));
        sqlRules.add(new RuleTuple("literal", new String[]{"datetime_literal"}));
        sqlRules.add(new RuleTuple("not_eq", new String[]{"'<'", "'>'"}));
        sqlRules.add(new RuleTuple("character_datatypes", new String[]{"'VARCHAR2'"}));
        SqlRules.addToDo("commit");
        SqlRules.addToDo("sql_statements");
        while (0 < toDo.size()) {
            String candidate = SqlRules.nextToDo();
            SqlRules.recursiveCollectBNF(sqlRules, candidate);
            toDo.remove(candidate);
        }
        for (String key : notFound) {
            if (missingSymbols.containsKey(key) || !key.contains("name")) continue;
            missingSymbols.put(key, "identifier");
        }
        for (String key : missingSymbols.keySet()) {
            sqlRules.add(new RuleTuple(key, new String[]{missingSymbols.get(key)}));
            notFound.remove(key);
        }
        RuleTransforms.eliminateEmptyProductions(sqlRules);
        RuleTransforms.injectMissingEmptyProductions(sqlRules);
        RuleTransforms.substituteSingleBinaryProductions(sqlRules);
        RuleTransforms.substituteSingleUnaryProductions(sqlRules);
        SqlRules.straightenSemicolon(sqlRules);
        System.out.println("*************NOT FOUND************");
        System.out.println(notFound);
        return sqlRules;
    }

    private static void straightenSemicolon(Set<RuleTuple> sqlRules) {
        String[] heads;
        for (String head : heads = new String[]{"alter_session", "set_transaction"}) {
            SqlRules.straightenSemicolon(sqlRules, head);
        }
    }

    private static void straightenSemicolon(Set<RuleTuple> sqlRules, String head) {
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        for (RuleTuple rule : sqlRules) {
            if (!head.equals(rule.head)) continue;
            if (!"';'".equals(rule.rhs[rule.rhs.length - 1])) {
                throw new AssertionError((Object)"!\"';'\".equals(rule.rhs[rule.rhs.length-1])");
            }
            String[] rhs = new String[rule.rhs.length - 1];
            for (int i = 0; i < rhs.length; ++i) {
                rhs[i] = rule.rhs[i];
            }
            RuleTuple modifiedRule = new RuleTuple(head, rhs);
            rules.add(modifiedRule);
        }
        sqlRules.addAll(rules);
    }

    public static void memorizeRules() throws Exception {
        SqlRules.memorizeRules("isqlBNF.serial");
    }

    public static Set<RuleTuple> getRules() throws Exception {
        return SqlRules.getRules("sqlBNF.serial");
    }

    private static void memorizeRules(String fname) throws Exception {
        Set<RuleTuple> rules = SqlRules.extractRules();
        FileOutputStream fos = new FileOutputStream("src/oracle/dbtools/parser/plsql/" + fname);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(rules);
        out.close();
    }

    private static Set<RuleTuple> getRules(String fname) throws Exception {
        URL u = SqlRules.class.getResource(path + fname);
        InputStream is = u.openStream();
        ObjectInputStream in = new ObjectInputStream(is);
        Set rules = (Set)in.readObject();
        in.close();
        return rules;
    }

    private static void addToDo(String s) {
        if (s.charAt(0) != '\'' && !notFound.contains(s) && !masterRules.contains(s)) {
            toDo.add(s);
        }
    }

    private static String nextToDo() {
        Iterator<String> i$ = toDo.iterator();
        if (i$.hasNext()) {
            String candidate = i$.next();
            return candidate;
        }
        throw new AssertionError((Object)"Empty toDo");
    }

    private static void recursiveCollectBNF(Set<RuleTuple> output, String masterRuleName) throws Exception {
        if (masterRules.contains(masterRuleName)) {
            return;
        }
        if (notFound.contains(masterRuleName)) {
            return;
        }
        System.out.println("searching for...  " + masterRuleName);
        if ("hint".equals(masterRuleName)) {
            return;
        }
        if (!SqlRules.fetchFromFixes(output, masterRuleName)) {
            SqlRules.fetchFromDocWebsite(output, masterRuleName);
        }
    }

    private static void fetchFromDocWebsite(Set<RuleTuple> output, String masterRuleName) throws Exception {
        int iQuote;
        String sqlBNFfiles = "http://st-doc.us.oracle.com/database/122/SQLRF/img_text";
        String masterrulename = masterRuleName.toLowerCase();
        String input = SqlRules.readURL(masterrulename, "http://st-doc.us.oracle.com/database/122/SQLRF/img_text");
        if (input == null) {
            if (notFound.contains(masterrulename)) {
                return;
            }
            input = SqlRules.readURL(masterrulename, "http://st-doc.us.oracle.com/database/122/SQLRF/img_text");
            if (input == null) {
                System.exit(1);
            }
        }
        input = input.replace("<span class=\"bold\">", "<b>");
        input = input.replace("</span>", "</b>");
        int ipre = input.indexOf("<pre");
        int jpre = input.indexOf("</pre>");
        input = input.substring(ipre, jpre + "</pre>".length());
        while ((iQuote = input.indexOf("'")) >= 0) {
            String literal = input.substring(iQuote, input.indexOf("'", iQuote + 1) + 1);
            input = input.replace(literal, "string_literal");
        }
        List<LexerToken> src = LexerToken.parse(input, false, 2);
        SqlRules.correctDots(src);
        System.out.println(masterRuleName + "...");
        Matrix matrix = new Matrix(earley);
        earley.parse(src, matrix);
        ParseNode root = earley.forest(src, matrix);
        if (!root.contains((Integer)SqlRules.earley.symbolIndexes.get("bnf"))) {
            System.err.println("failed to parse >>>" + masterRuleName + "<<< to bnf");
            System.exit(0);
        }
        output.addAll(SqlRules.bnf(root, src, masterRuleName));
    }

    public static String readURL(String masterRuleName, String sqlBNFfiles) {
        try {
            return SqlRules.readURL(sqlBNFfiles + "/" + masterRuleName + ".htm");
        }
        catch (Exception e) {
            if (e.getClass().getPackage().getName().contains("java.net")) {
                System.err.println("Failed to connect to " + e.getMessage());
                return null;
            }
            try {
                return SqlRules.readURL(sqlBNFfiles + "/" + masterRuleName + "s.htm");
            }
            catch (Exception ee) {
                if (e.getClass().getPackage().getName().contains("java.net")) {
                    System.err.println("Failed to connect to " + e.getMessage());
                    return null;
                }
                notFound.add(masterRuleName);
                return null;
            }
        }
    }

    private static boolean contains(Set<RuleTuple> ret, String masterRuleName) {
        for (RuleTuple rule : ret) {
            if (!rule.head.equals(masterRuleName)) continue;
            return true;
        }
        return false;
    }

    private static ParseNode parseFixesFile(List<LexerToken> src, String input) throws Exception {
        SqlRules.correctDots(src);
        Matrix matrix = new Matrix(earley);
        earley.parse(src, matrix);
        SyntaxError s = SyntaxError.checkSyntax(input, new String[]{"bnflist"}, src, earley, matrix);
        if (s != null) {
            System.out.println("Syntax Error");
            System.out.println("at line#" + s.line);
            System.out.println(s.code);
            System.out.println(s.marker);
            System.out.println("Expected:  ");
            for (String tmp : s.getSuggestions()) {
                System.out.print(tmp + ',');
            }
            throw new Exception(">>>> Parse error in SqlFixes.bnf <<<<");
        }
        ParseNode root = earley.forest(src, matrix);
        return root;
    }

    private static boolean fetchFromFixes(Set<RuleTuple> output, String masterRuleName) throws Exception {
        if (fixesParseTree == null || fixesScan == null) {
            String input = Service.readFile(SqlRules.class, "SqlFixes.bnf");
            input = input.replace("<span class=\"bold\">", "<b>");
            input = input.replace("</span>", "</b>");
            fixesScan = LexerToken.parse(input);
            fixesParseTree = SqlRules.parseFixesFile(fixesScan, input);
            SqlRules.bnflist(fixesParseTree, fixesScan, output);
        }
        return masterRules.contains(masterRuleName);
    }

    private static void correctDots(List<LexerToken> src) {
        int i = -1;
        for (LexerToken t : src) {
            if (!".".equals(t.content) || ++i != 0 && ".".equals(src.get((int)(i - 1)).content) || i != src.size() - 1 && ".".equals(src.get((int)(i + 1)).content)) continue;
            t.content = "'.'";
            t.type = Token.IDENTIFIER;
        }
    }

    private static void bnflist(ParseNode root, List<LexerToken> src, Set<RuleTuple> grammar) {
        if (root.contains(bnf)) {
            grammar.addAll(SqlRules.bnf(root, src, null));
        } else {
            for (ParseNode child : root.children()) {
                SqlRules.bnflist(child, src, grammar);
            }
        }
    }

    private static Set<RuleTuple> bnf(ParseNode root, List<LexerToken> src, String header) {
        bnfRoot = root;
        TreeSet<RuleTuple> grammar = new TreeSet<RuleTuple>();
        for (ParseNode child : root.children()) {
            if (header == null && child.contains(identifier)) {
                header = child.content(src);
                continue;
            }
            if (!child.contains(rawbnf)) continue;
            grammar.addAll(SqlRules.rawbnf(child, src, header, false));
        }
        RuleTransforms.eliminateEmptyProductions(grammar);
        RuleTransforms.substituteSingleUnaryProductions(grammar);
        RuleTransforms.substituteSingleBinaryProductions(grammar);
        masterRules.add(header);
        return grammar;
    }

    private static Set<RuleTuple> rawbnf(ParseNode root, List<LexerToken> src, String header, boolean isBold) {
        if (root.contains(concat)) {
            return SqlRules.concat(root, src, header, isBold);
        }
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        for (ParseNode child : root.children()) {
            if (child.contains(identifier) && child.from + 1 == child.to) {
                String id = SqlRules.processId(child, src, isBold);
                ret.add(new RuleTuple(header, new String[]{id}));
                SqlRules.addToDo(id);
                continue;
            }
            if (!child.contains(rawbnf) && !child.contains(concat)) continue;
            ret.addAll(SqlRules.rawbnf(child, src, header, isBold));
        }
        return ret;
    }

    private static Set<RuleTuple> concat(ParseNode root, List<LexerToken> src, String header, boolean isBold) {
        if (root.contains(block)) {
            return SqlRules.block(root, src, header, isBold);
        }
        LinkedList<String> payload = new LinkedList<String>();
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        for (ParseNode child : root.children()) {
            String childHdr;
            String childInterval;
            if (child.contains(identifier) && child.from + 1 == child.to) {
                String id = SqlRules.processId(child, src, isBold);
                payload.add(id);
                SqlRules.addToDo(id);
                continue;
            }
            if (child.contains(concat)) {
                int intervalPos = header.indexOf(91);
                childInterval = "[" + (child.from - SqlRules.bnfRoot.from) + "," + (child.to - SqlRules.bnfRoot.from) + ")";
                childHdr = (0 < intervalPos ? header.substring(0, intervalPos) : header) + childInterval;
                Set<RuleTuple> childRules = SqlRules.concat(child, src, childHdr, isBold);
                TreeSet<RuleTuple> major = new TreeSet<RuleTuple>();
                for (RuleTuple candidate : childRules) {
                    if (!candidate.head.equals(childHdr)) continue;
                    major.add(candidate);
                }
                if (major.size() == 1) {
                    RuleTuple singleton = null;
                    Iterator i$ = major.iterator();
                    while (i$.hasNext()) {
                        RuleTuple r;
                        singleton = r = (RuleTuple)i$.next();
                    }
                    childRules.remove(singleton);
                    ret.addAll(childRules);
                    for (String rhs : singleton.rhs) {
                        payload.add(rhs);
                    }
                    continue;
                }
                ret.addAll(childRules);
                payload.add(childHdr);
                continue;
            }
            if (!child.contains(block)) continue;
            int intervalPos = header.indexOf(91);
            childInterval = "[" + (child.from - SqlRules.bnfRoot.from) + "," + (child.to - SqlRules.bnfRoot.from) + ")";
            childHdr = (0 < intervalPos ? header.substring(0, intervalPos) : header) + childInterval;
            ret.addAll(SqlRules.block(child, src, childHdr, isBold));
            payload.add(childHdr);
        }
        RuleTuple ct = new RuleTuple(header, payload);
        ret.add(ct);
        return ret;
    }

    private static Set<RuleTuple> block(ParseNode root, List<LexerToken> src, String header, boolean isBold) {
        if (root.contains(boldrawbnf)) {
            return SqlRules.boldrawbnf(root, src, header);
        }
        if (root.contains(identifier)) {
            String id = SqlRules.processId(root, src, isBold);
            SqlRules.addToDo(id);
            RuleTuple ct = new RuleTuple(header, new String[]{id});
            TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
            ret.add(ct);
            return ret;
        }
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        for (ParseNode child : root.children()) {
            RuleTuple empty = new RuleTuple(header, new String[0]);
            if (child.contains(sqBr)) {
                ret.add(empty);
                continue;
            }
            if (child.contains(rawbnf)) {
                ret.addAll(SqlRules.rawbnf(child, src, header, isBold));
                continue;
            }
            if (!child.contains(dot)) continue;
            for (RuleTuple t : ret) {
                if (!t.head.equals(header) || 0 >= t.rhs.length) continue;
                t.head = header + "#";
            }
            ret.add(new RuleTuple(header, new String[]{header + "#"}));
            ret.add(new RuleTuple(header, new String[]{header, header + "#"}));
            break;
        }
        return ret;
    }

    private static String processId(ParseNode root, List<LexerToken> src, boolean isBold) {
        String id = root.content(src);
        boolean isPunctuation = false;
        if (id.length() == 1) {
            for (char bnfId : identifiers) {
                if (id.charAt(0) != bnfId) continue;
                isPunctuation = true;
            }
        }
        if ("lt".equals(id)) {
            id = "'<'";
        } else if ("gt".equals(id)) {
            id = "'>'";
        } else if ("lbr".equals(id)) {
            id = "'['";
        } else if ("rbr".equals(id)) {
            id = "']'";
        } else if ("lcp".equals(id)) {
            id = "'{'";
        } else if ("rcp".equals(id)) {
            id = "'}'";
        } else if ("dbar".equals(id)) {
            id = "'||'";
        } else if ("sbar".equals(id)) {
            id = "'|'";
        } else if (isBold || isPunctuation) {
            id = "'" + id.toUpperCase() + "'";
        }
        return id;
    }

    private static Set<RuleTuple> boldrawbnf(ParseNode root, List<LexerToken> src, String header) {
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        for (ParseNode child : root.children()) {
            if (child.contains(rawbnf)) {
                ret.addAll(SqlRules.rawbnf(child, src, header, true));
                continue;
            }
            if (child.contains(lt)) {
                ret.add(new RuleTuple(header, new String[]{"'<'"}));
                continue;
            }
            if (child.contains(gt)) {
                ret.add(new RuleTuple(header, new String[]{"'>'"}));
                continue;
            }
            if (child.contains(lbr)) {
                ret.add(new RuleTuple(header, new String[]{"'['"}));
                continue;
            }
            if (child.contains(rbr)) {
                ret.add(new RuleTuple(header, new String[]{"']'"}));
                continue;
            }
            if (child.contains(lcp)) {
                ret.add(new RuleTuple(header, new String[]{"'{'"}));
                continue;
            }
            if (child.contains(rcp)) {
                ret.add(new RuleTuple(header, new String[]{"'}'"}));
                continue;
            }
            if (child.contains(dbar)) {
                ret.add(new RuleTuple(header, new String[]{"'|'", "'|'"}));
                continue;
            }
            if (!child.contains(sbar)) continue;
            ret.add(new RuleTuple(header, new String[]{"'|'"}));
        }
        if (ret.size() == 0) {
            throw new AssertionError((Object)("unexpected ret for " + header));
        }
        return ret;
    }

    static String readURL(String masterBNFurl) throws Exception {
        byte[] bytes = new byte[4096];
        int bytesRead = 0;
        URL url = new URL(masterBNFurl);
        BufferedInputStream bin = new BufferedInputStream(url.openStream());
        StringBuffer out = new StringBuffer();
        bytesRead = bin.read(bytes, 0, bytes.length);
        StringBuffer sb = new StringBuffer();
        while (bytesRead != -1) {
            sb.append(new String(bytes).substring(0, bytesRead));
            bytesRead = bin.read(bytes, 0, bytes.length);
        }
        String ret = sb.toString();
        int ind = ret.indexOf("<p>Note:");
        if (ind > 0) {
            ret = ret.substring(0, ind);
        }
        if ((ind = ret.indexOf("Note:")) > 0) {
            ret = ret.substring(0, ind);
        }
        if ((ind = ret.indexOf("</pre>")) < 0) {
            ind = ret.indexOf("</PRE>");
        }
        if (ind < 0) {
            ret = ret + "</pre>";
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        boolean test = true;
        test = false;
        if (test) {
            SqlRules.testParseSqlBnf();
        } else {
            String masterBNFurl = "http://docs-uat.us.oracle.com/database/122/SQLRF/";
            String page = SqlRules.readURL(masterBNFurl + "Calculated-Measure-Expressions.htm");
            String str = "<p class=\"subhead2\"><span class=\"italic\">";
            int pos = page.indexOf(str);
            while (0 < pos) {
                int end = page.indexOf("</span>::=</p>", pos + str.length());
                int end1 = page.indexOf("</span> ::=</p>", pos + str.length());
                if (0 < end1 && end1 < end) {
                    end = end1;
                }
                if (end < 0) break;
                if (pos + 100 >= end) {
                    String rule = page.substring(pos + str.length(), end);
                    int hrefPos = page.indexOf("<a href=\"", end);
                    int hrefEnd = page.indexOf("\">", hrefPos);
                    String guid = page.substring(hrefPos + "<a href=\"".length(), hrefEnd);
                    String ruleBNF = SqlRules.readURL(masterBNFurl + guid);
                    String ruleTag = "<pre class=\"oac_no_warn\" dir=\"ltr\">";
                    int from = ruleBNF.indexOf(ruleTag);
                    int to = ruleBNF.indexOf("</pre>", from);
                    ruleBNF = ruleBNF.substring(from + ruleTag.length(), to);
                    ruleBNF = ruleBNF.replace("<span class=\"bold\">", "<b>");
                    ruleBNF = ruleBNF.replace("</span>", "</b>");
                    System.out.println("<pre " + rule + ">");
                    System.out.println(ruleBNF);
                    System.out.println("</pre>");
                    System.out.println();
                    System.out.println();
                }
                pos = page.indexOf(str, pos + str.length());
            }
        }
    }

    static {
        try {
            earley = SqlRules.bnfParser();
            bnf = (Integer)SqlRules.earley.symbolIndexes.get("bnf");
            rawbnf = (Integer)SqlRules.earley.symbolIndexes.get("rawbnf");
            boldrawbnf = (Integer)SqlRules.earley.symbolIndexes.get("boldrawbnf");
            identifier = (Integer)SqlRules.earley.symbolIndexes.get("identifier");
            concat = (Integer)SqlRules.earley.symbolIndexes.get("concat");
            block = (Integer)SqlRules.earley.symbolIndexes.get("block");
            sqBr = (Integer)SqlRules.earley.symbolIndexes.get("'['");
            curlyBr = (Integer)SqlRules.earley.symbolIndexes.get("'{'");
            dot = (Integer)SqlRules.earley.symbolIndexes.get("'.'");
            lt = (Integer)SqlRules.earley.symbolIndexes.get("lt");
            gt = (Integer)SqlRules.earley.symbolIndexes.get("gt");
            lbr = (Integer)SqlRules.earley.symbolIndexes.get("lbr");
            rbr = (Integer)SqlRules.earley.symbolIndexes.get("rbr");
            lcp = (Integer)SqlRules.earley.symbolIndexes.get("lcp");
            rcp = (Integer)SqlRules.earley.symbolIndexes.get("rcp");
            dbar = (Integer)SqlRules.earley.symbolIndexes.get("dbar");
            sbar = (Integer)SqlRules.earley.symbolIndexes.get("sbar");
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        missingSymbols = new TreeMap<String, String>();
        toDo = new HashSet<String>();
        notFound = new HashSet<String>();
        masterRules = new HashSet<String>();
        fixesParseTree = null;
        fixesScan = null;
        bnfRoot = null;
    }
}

