/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parseable;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.UnifiedRules;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Service;

public class SqlEarley
extends Earley
implements Parseable {
    public static boolean visualize = true;
    private static SqlEarley partialRecInst = null;
    private static SqlEarley fullRecInst = null;
    static Set<RuleTuple> origRules;
    private int as;
    private int aliased_dml_table_expression_clause;
    private int basic_decl_item;
    private int begin;
    private int body;
    private int boolean_primary;
    private int compound_expression;
    private int dotted_name;
    public int decl_id;
    private int distinct;
    private int ELSE;
    private int expr;
    public int multiset_except;
    private int pkg_spec;
    private int pls_expr;
    public int select;
    public int simple_expression;
    public int sql_statements;
    private int start;
    public int table_reference;
    private int unlabeled_nonblock_stmt;
    private int[] whatToRecognize = new int[0];
    boolean oldSkipRanges = this.skipRanges;
    public static String[] keywords;
    private Set<Integer> _keywords = new TreeSet<Integer>();

    public static void main(String[] args) throws Exception {
        String file = "test.sql";
        String input = Service.readFile(SqlEarley.class, file);
        if (1 == args.length) {
            input = args[0];
        }
        long t1 = System.currentTimeMillis();
        SqlEarley earley = SqlEarley.getInstance();
        long t2 = System.currentTimeMillis();
        System.out.println("Earley init time = " + (t2 - t1));
        boolean T = true;
        boolean F = false;
        earley.printOrderedRules("json_query", true, true);
        int maxRuleLen = 0;
        for (Earley.Tuple rule : SqlEarley.getInstance().rules) {
            if (maxRuleLen < rule.rhs.length) {
                maxRuleLen = rule.rhs.length;
            }
            if (rule.rhs.length != 1 || rule.head != rule.rhs[0]) continue;
            System.out.println("***** " + SqlEarley.getInstance().allSymbols[rule.head] + ":" + SqlEarley.getInstance().allSymbols[rule.head]);
        }
        System.out.println("----rules=" + SqlEarley.getInstance().rules.length);
        System.out.println("----maxRuleLen=" + maxRuleLen);
        System.out.println("!nil=" + SqlEarley.getInstance().getSymbol("!nil"));
        System.out.println("allSymbols[0]=" + SqlEarley.getInstance().allSymbols[0]);
        System.out.println("allSymbols[1]=" + SqlEarley.getInstance().allSymbols[1]);
        System.out.println("allSymbols[2]=" + SqlEarley.getInstance().allSymbols[2]);
        SqlEarley.parse(input);
    }

    static void parse(String input) throws IOException, AssertionError {
        Cell top;
        long t1 = System.currentTimeMillis();
        List<LexerToken> src = LexerToken.parse(input);
        if (src.size() > Integer.MAX_VALUE) {
            throw new AssertionError((Object)(src.size() + " tokens"));
        }
        long t2 = System.currentTimeMillis();
        System.out.println("Lex time = " + (t2 - t1));
        SqlEarley earley = SqlEarley.getInstance();
        Matrix matrix = new Matrix(earley);
        if (src.size() < 1000) {
            matrix.visual = new Visual(src, earley);
        }
        if (!visualize) {
            matrix.visual = null;
        }
        t1 = System.currentTimeMillis();
        earley.oldSkipRanges = earley.skipRanges;
        earley.parse(src, matrix);
        t2 = System.currentTimeMillis();
        System.out.println("Earley parse time = " + (t2 - t1));
        if (matrix.visual != null) {
            matrix.visual.draw(matrix);
        }
        if ((top = matrix.get(0, src.size())) != null) {
            System.out.println(src.size() + " tokens, top = " + top.toString());
        } else {
            System.out.println("***** Syntactically Invalid fargment *****");
        }
        t1 = System.currentTimeMillis();
        ParseNode root = earley.forest(src, matrix);
        t2 = System.currentTimeMillis();
        System.out.println("Reduction time = " + (t2 - t1));
        if (src.size() < 1000) {
            root.printTree();
        }
        root.contains("identifier");
    }

    private static void outputHighlights() {
        TreeSet<String> keywords = new TreeSet<String>();
        for (RuleTuple rule : origRules) {
            if (!"sql_statement".equals(rule.head)) continue;
            if (rule.rhs[0].startsWith("'")) {
                keywords.add(rule.rhs[0].substring(1, rule.rhs[0].length() - 1).toLowerCase());
                continue;
            }
            for (RuleTuple rule1 : origRules) {
                if (!rule.rhs[0].equals(rule1.head)) continue;
                if (rule1.rhs[0].startsWith("'")) {
                    keywords.add(rule1.rhs[0].substring(1, rule1.rhs[0].length() - 1).toLowerCase());
                    continue;
                }
                for (RuleTuple rule2 : origRules) {
                    if (!rule1.rhs[0].equals(rule2.head)) continue;
                    if (rule2.rhs[0].startsWith("'")) {
                        keywords.add(rule2.rhs[0].substring(1, rule2.rhs[0].length() - 1).toLowerCase());
                        continue;
                    }
                    for (RuleTuple rule3 : origRules) {
                        if (!rule2.rhs[0].equals(rule3.head) || !rule3.rhs[0].startsWith("'")) continue;
                        keywords.add(rule3.rhs[0].substring(1, rule3.rhs[0].length() - 1).toLowerCase());
                    }
                }
            }
        }
        String exclude = " true false null  array bigint binary bit blob boolean char character date dec decimal float int integer interval number   numeric real serial smallint varchar varchar2 varying int8 serial8 text ";
        int lineLen = 0;
        String padding = "    ";
        System.out.print(padding + "'");
        for (String k : keywords) {
            if (-1 < exclude.indexOf(" " + k + " ")) continue;
            if ((lineLen += k.length()) > 80) {
                System.out.println("'+");
                System.out.print(padding + "'");
                lineLen = 0;
            }
            System.out.print(k);
            System.out.print(" ");
        }
        System.out.println(" '+");
    }

    public static SqlEarley partialRecognizer() {
        if (partialRecInst == null) {
            partialRecInst = SqlEarley.partialRecognizer(new String[]{"sql_statements", "subprg_body", "expr"});
        }
        return partialRecInst;
    }

    public static SqlEarley partialRecognizer(String[] what2Recognize) {
        SqlEarley ret = new SqlEarley(){

            @Override
            protected boolean lookaheadOK(Earley.Tuple t, int pos, Matrix matrix) {
                return true;
            }

            @Override
            protected boolean scan(Matrix matrix, List<LexerToken> src) {
                boolean ret = super.scan(matrix, src);
                matrix.LAsuspect = null;
                return ret;
            }
        };
        for (String symbol : what2Recognize) {
            ret.addSymbol2Recognize(symbol);
        }
        return ret;
    }

    public static synchronized SqlEarley getInstance() {
        if (fullRecInst == null) {
            fullRecInst = new SqlEarley();
            fullRecInst.addSymbol2Recognize("sql_statements");
            fullRecInst.addSymbol2Recognize("subprg_body");
            fullRecInst.addSymbol2Recognize("expr");
            fullRecInst.addSymbol2Recognize("fml_part");
            fullRecInst.addSymbol2Recognize("paren_expr_list");
            fullRecInst.addSymbol2Recognize("basic_decl_item");
        }
        return fullRecInst;
    }

    public SqlEarley grammarExtension(Set<RuleTuple> additionalRules) {
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        rules.addAll(origRules);
        rules.addAll(additionalRules);
        return new SqlEarley();
    }

    private SqlEarley() {
        this(origRules);
    }

    private SqlEarley(Set<RuleTuple> rules) {
        super(rules, false);
        this.initKeywords();
        this.as = this.getSymbol("'AS'");
        this.aliased_dml_table_expression_clause = this.getSymbol("aliased_dml_table_expression_clause");
        this.basic_decl_item = this.getSymbol("basic_decl_item");
        this.begin = this.getSymbol("'BEGIN'");
        this.body = this.getSymbol("'BODY'");
        this.boolean_primary = this.getSymbol("boolean_primary");
        this.compound_expression = this.getSymbol("compound_expression");
        this.dotted_name = this.getSymbol("dotted_name");
        this.decl_id = this.getSymbol("decl_id");
        this.distinct = this.getSymbol("'DISTINCT'");
        this.ELSE = this.getSymbol("'ELSE'");
        this.expr = this.getSymbol("expr");
        this.multiset_except = this.getSymbol("multiset_except");
        this.pkg_spec = this.getSymbol("pkg_spec");
        this.pls_expr = this.getSymbol("pls_expr");
        this.select = this.getSymbol("select");
        this.simple_expression = this.getSymbol("simple_expression");
        this.sql_statements = this.getSymbol("sql_statements");
        this.start = this.getSymbol("'START'");
        this.table_reference = this.getSymbol("table_reference");
        this.unlabeled_nonblock_stmt = this.getSymbol("unlabeled_nonblock_stmt");
        this.prioritizeRules();
    }

    private void prioritizeRules() {
        this.prioritizeRules(this.getSymbol("alter_table[17,32)"), new int[]{this.getSymbol("constraint_clauses"), this.getSymbol("alter_external_table"), this.getSymbol("column_clauses")});
        this.prioritizeRules(this.getSymbol("analytic_function"), new int[]{this.getSymbol("count"), this.getSymbol("nth_value"), this.getSymbol("first_last_value"), this.getSymbol("listagg"), this.getSymbol("lag"), this.getSymbol("lead"), this.getSymbol("sum"), this.getSymbol("min"), this.getSymbol("max"), this.getSymbol("a_f")});
        this.prioritizeRules(this.getSymbol("basic_d"), new int[]{this.getSymbol("subprg_i"), this.getSymbol("object_d")});
        this.prioritizeRules(this.basic_decl_item, new int[]{this.getSymbol("pragma"), this.getSymbol("basic_d")});
        this.prioritizeRules(this.boolean_primary, new int[]{this.getSymbol("sim_expr"), this.getSymbol("condition")});
        this.prioritizeRules(this.getSymbol("cell_assignment[13,37)"), new int[]{this.getSymbol("multi_column_for_loop"), this.getSymbol("cell_assignment[14,21)")});
        this.prioritizeRules(this.getSymbol("col_properties"), new int[]{this.getSymbol("out_of_line_ref_constraint"), this.getSymbol("out_of_line_constraint"), this.getSymbol("column_definition")});
        this.prioritizeRules(this.getSymbol("column_definition[72,82)"), new int[]{this.getSymbol("inline_ref_constraint"), this.getSymbol("inline_constraint")});
        this.prioritizeRules(this.getSymbol("comparison_condition"), new int[]{this.getSymbol("between_condition"), this.getSymbol("group_comparison_condition"), this.getSymbol("simple_comparison_condition")});
        this.prioritizeRules(this.compound_expression, new int[]{this.getSymbol("expr"), this.getSymbol("compound_expression[8,22)")});
        this.prioritizeRules(this.getSymbol("datetime_expression[32,57)"), new int[]{this.getSymbol("'DBTIMEZONE'"), this.getSymbol("string_literal"), this.expr});
        this.prioritizeRules(this.getSymbol("expr#"), new int[]{this.simple_expression, this.getSymbol("function_expression"), this.getSymbol("model_expression"), this.getSymbol("object_access_expression"), this.getSymbol("type_constructor_expression")});
        this.prioritizeRules(this.getSymbol("function_expression"), new int[]{this.getSymbol("function"), this.getSymbol("function_call")});
        this.prioritizeRules(this.getSymbol("function"), new int[]{this.getSymbol("aggregate_function"), this.getSymbol("analytic_function"), this.getSymbol("single_row_function"), this.getSymbol("user_defined_function"), this.getSymbol("object_reference_function")});
        this.prioritizeRules(this.getSymbol("group_by_col"), new int[]{this.getSymbol("rollup_cube_clause"), this.getSymbol("expr")});
        this.prioritizeRules(this.pls_expr, new int[]{this.getSymbol("pls_expr"), this.getSymbol("and_expr")});
        this.prioritizeRules(this.getSymbol("select_term"), new int[]{this.expr, this.getSymbol("\"aliased_expr\"")});
        this.prioritizeRules(this.simple_expression, new int[]{this.getSymbol("'NULL'"), this.getSymbol("'CONNECT_BY_ROOT'"), this.getSymbol("'ROWID'"), this.getSymbol("'ROWNUM'"), this.getSymbol("'CONNECT_BY_ISCYCLE'"), this.getSymbol("'CONNECT_BY_ISLEAF'"), this.getSymbol("identifier"), this.getSymbol("column")});
        this.prioritizeRules(this.getSymbol("sim_stmt"), new int[]{this.getSymbol("exit_stmt"), this.getSymbol("procedure_call")});
        this.prioritizeRules(this.getSymbol("ty_def"), new int[]{this.getSymbol("array_ty_def"), this.getSymbol("tbl_ty_def")});
        this.prioritizeRules(this.getSymbol("unconstrained_type_wo_datetime"), new int[]{this.getSymbol("'SYS_REFCURSOR'"), this.getSymbol("pls_number_datatypes"), this.getSymbol("link_expanded_n")});
        this.prioritizeRules(this.unlabeled_nonblock_stmt, new int[]{this.getSymbol("sql_stmt"), this.getSymbol("sim_stmt")});
        this.prioritizeRules(this.getSymbol("values_clause[12,20)"), new int[]{this.getSymbol("par_expr_list"), this.expr});
        this.prioritizeRules(this.getSymbol("windowing_clause[31,73)"), new int[]{this.getSymbol("'UNBOUNDED'"), this.expr});
        this.prioritizeRules(this.getSymbol("windowing_clause[81,123)"), new int[]{this.getSymbol("'UNBOUNDED'"), this.expr});
    }

    private void prioritizeRules(int head, int[] symbols) {
        int[] ruleNumbers = new int[symbols.length];
        block0: for (int i = 0; i < this.rules.length; ++i) {
            Earley.Tuple t = this.rules[i];
            if (t.head != head || t.rhs.length != 1 && t.head != this.unlabeled_nonblock_stmt && t.head != this.pls_expr && t.head != this.boolean_primary && t.head != this.basic_decl_item && t.head != this.simple_expression && t.head != this.compound_expression) continue;
            for (int j = 0; j < symbols.length; ++j) {
                if (t.rhs[0] != symbols[j]) continue;
                ruleNumbers[j] = i;
                continue block0;
            }
        }
        Earley.Tuple[] tuples = new Earley.Tuple[symbols.length];
        for (int j = 0; j < symbols.length; ++j) {
            tuples[j] = this.rules[ruleNumbers[j]];
        }
        Arrays.sort(ruleNumbers);
        for (int i = 0; i < ruleNumbers.length; ++i) {
            this.rules[ruleNumbers[i]] = tuples[i];
        }
    }

    public void addSymbol2Recognize(String additionalSymbol) {
        this.addSymbol2Recognize(this.getSymbol(additionalSymbol));
    }

    public void addSymbol2Recognize(int additionalSymbol) {
        int[] tmp = new int[this.whatToRecognize.length + 1];
        for (int i = 0; i < this.whatToRecognize.length; ++i) {
            if (this.whatToRecognize[i] == additionalSymbol) {
                return;
            }
            tmp[i] = this.whatToRecognize[i];
        }
        tmp[this.whatToRecognize.length] = additionalSymbol;
        this.whatToRecognize = tmp;
    }

    @Override
    protected void initCell00(List<LexerToken> src, Matrix matrix) {
        long t1 = 0L;
        if (matrix.visual != null) {
            t1 = System.nanoTime();
        }
        matrix.initCells(src.size());
        this.initCell(matrix, this.whatToRecognize, 0);
        if (matrix.visual != null) {
            long t2 = System.nanoTime();
            long[] lArray = matrix.visual.visited[0];
            lArray[0] = lArray[0] + (long)((int)(t2 - t1));
        }
        LexerToken LAtoken = src.get(0);
        matrix.LAsuspect = (Integer)this.symbolIndexes.get("'" + LAtoken.content.toUpperCase() + "'");
    }

    @Override
    protected boolean scan(Matrix matrix, List<LexerToken> src) {
        int y = matrix.lastY();
        if (src.size() <= y) {
            return false;
        }
        LexerToken token = src.get(y);
        String tokUpper = token.content.toUpperCase();
        if ("@".equals(tokUpper)) {
            this.oldSkipRanges = this.skipRanges;
            this.skipRanges = false;
        }
        if (this.skipRanges != this.oldSkipRanges && (";".equals(tokUpper) || ",".equals(tokUpper))) {
            this.skipRanges = this.oldSkipRanges;
        }
        Integer suspect = (Integer)this.symbolIndexes.get("'" + tokUpper + "'");
        matrix.LAsuspect = null;
        if (y + 1 < src.size()) {
            LexerToken LAtoken = src.get(y + 1);
            matrix.LAsuspect = (Integer)this.symbolIndexes.get("'" + LAtoken.content.toUpperCase() + "'");
        }
        boolean ret = false;
        for (int i = matrix.allXs.length - 1; 0 <= i; --i) {
            int x = matrix.allXs[i];
            if (!this.scan(matrix, y, src, x, suspect)) continue;
            ret = true;
        }
        if (this.scan(matrix, y, src, y, suspect)) {
            ret = true;
        }
        return ret;
    }

    private boolean scan(Matrix matrix, int y, List<LexerToken> src, int x, Integer suspect) {
        long t1 = 0L;
        if (matrix.visual != null) {
            t1 = System.nanoTime();
        }
        long[] content = null;
        Cell candidateRules = matrix.get(x, y);
        if (candidateRules == null) {
            return false;
        }
        for (int j = 0; j < candidateRules.size(); ++j) {
            int pos = candidateRules.getPosition(j);
            int ruleNo = candidateRules.getRule(j);
            Earley.Tuple t = this.rules[ruleNo];
            if (t.size() - 1 < pos || !this.isScannedSymbol(y, src, pos, t, suspect) || !this.lookaheadOK(t, pos + 1, matrix)) continue;
            long cellElem = this.makeMatrixCellElem(ruleNo, pos + 1, t);
            content = Array.insert(content, cellElem);
            if (t.rhs.length != pos + 1) continue;
            matrix.enqueue(Service.lPair(x, t.head));
        }
        if (content == null) {
            return false;
        }
        matrix.put(x, y + 1, new Earley.EarleyCell(content));
        matrix.allXs = Array.insert(matrix.allXs, x);
        if (matrix.visual != null) {
            long t2 = System.nanoTime();
            long[] lArray = matrix.visual.visited[x];
            int n = y + 1;
            lArray[n] = lArray[n] + (long)((int)(t2 - t1));
        }
        return true;
    }

    @Override
    protected boolean lookaheadOK(Earley.Tuple t, int pos, Matrix matrix) {
        if (pos > t.size() - 1) {
            return true;
        }
        int nextInTuple = t.content(pos);
        if (this.isTerminal(nextInTuple)) {
            return matrix.LAsuspect != null && nextInTuple == matrix.LAsuspect;
        }
        Earley.PredictedTerminals terminal = this.terminalPredictions[nextInTuple];
        if (terminal != null) {
            return terminal.matches(matrix.LAsuspect);
        }
        return true;
    }

    @Override
    protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
        if (symbol != this.identifier) {
            return false;
        }
        if (suspect != null && this._keywords.contains(suspect)) {
            return false;
        }
        LexerToken token = src.get(y);
        if (token.type == Token.DQUOTED_STRING) {
            return true;
        }
        if (token.type != Token.IDENTIFIER) {
            return false;
        }
        if (suspect == null) {
            return true;
        }
        LexerToken prior = null;
        if (0 < y) {
            prior = src.get(y - 1);
        }
        if ("TO".equalsIgnoreCase(token.content) && prior != null && ("YEAR".equalsIgnoreCase(prior.content) || "HOUR".equalsIgnoreCase(prior.content) || "MINUTE".equalsIgnoreCase(prior.content))) {
            return false;
        }
        return !"BY".equalsIgnoreCase(token.content) || prior == null || !"CONNECT".equalsIgnoreCase(prior.content);
    }

    @Override
    protected boolean notConfusedAsId(int suspect, int head, int pos) {
        return !(suspect == this.begin && (head == this.dotted_name || head == this.decl_id) && pos == 0 || suspect == this.start && head == this.table_reference && pos == 1 || suspect == this.distinct && head == this.multiset_except && pos == 3 || suspect == this.body && head == this.pkg_spec && pos == 1 || suspect == this.as && head == this.table_reference && pos == 1 || suspect == this.ELSE && head == this.aliased_dml_table_expression_clause && pos == 1);
    }

    @Override
    public synchronized void parse(List<LexerToken> src, Matrix matrix) {
        super.parse(src, matrix);
    }

    public int recognize(List<LexerToken> src) {
        Matrix matrix = new Matrix(SqlEarley.getInstance());
        this.parse(src, matrix);
        for (int i = src.size(); 0 < i; --i) {
            Cell top = matrix.get(0, i);
            if (top == null) continue;
            return i;
        }
        throw new AssertionError((Object)"all empty cells?");
    }

    void initKeywords() {
        for (String k : keywords) {
            this._keywords.add(this.getSymbol(k));
        }
    }

    @Override
    public ParseNode parse(List<LexerToken> src) {
        Matrix matrix = new Matrix(this);
        this.parse(src, matrix);
        return this.forest(src, matrix);
    }

    @Override
    public ParseNode treeForACell(List<LexerToken> src, Matrix m, Cell cell, int x, int y, Map<Long, ParseNode> explored) {
        int rule = -1;
        int pos = -1;
        for (int i = 0; i < cell.size(); ++i) {
            rule = cell.getRule(i);
            Earley.Tuple t = this.rules[rule];
            if (t.head != this.sql_statements && t.head != this.select || this.rules[rule].rhs.length != (pos = cell.getPosition(i))) continue;
            return this.tree(src, m, x, y, rule, pos, explored);
        }
        return super.treeForACell(src, m, cell, x, y, explored);
    }

    public void parse(List<LexerToken> src, Matrix matrix, InterruptedException interrupted) throws InterruptedException {
        this.initCell00(src, matrix);
        this.predict(matrix);
        while (true) {
            if (interrupted != null && Thread.interrupted()) {
                throw interrupted;
            }
            if (!this.scan(matrix, src)) break;
            this.complete(matrix, src.size());
            this.predict(matrix);
        }
    }

    static {
        try {
            origRules = UnifiedRules.getRules();
            origRules.remove(new RuleTuple("identifier", new String[]{"idq"}));
            origRules.remove(new RuleTuple("identifier", new String[]{"id"}));
            origRules.remove(new RuleTuple("unconstrained_type", new String[]{"alldatetime_d"}));
            origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "';'"}));
            origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'.'", "identifier", "';'"}));
            origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'@'", "dblink", "';'"}));
            origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'.'", "identifier", "'@'", "dblink", "';'"}));
            origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'OR'", "'REPLACE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "';'"}));
            origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'OR'", "'REPLACE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'.'", "identifier", "';'"}));
            origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'OR'", "'REPLACE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'@'", "dblink", "';'"}));
            origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'OR'", "'REPLACE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'.'", "identifier", "'@'", "dblink", "';'"}));
            origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'DATABASE'", "'LINK'", "identifier", "';'"}));
            origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'DATABASE'", "'LINK'", "create_database_link[41,48)", "identifier", "';'"}));
            origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'PUBLIC'", "'DATABASE'", "'LINK'", "identifier", "';'"}));
            origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'DATABASE'", "'LINK'", "identifier", "'USING'", "string_literal", "';'"}));
            origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'PUBLIC'", "'DATABASE'", "'LINK'", "create_database_link[41,48)", "identifier", "';'"}));
            origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'DATABASE'", "'LINK'", "create_database_link[41,48)", "identifier", "'USING'", "string_literal", "';'"}));
            origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'PUBLIC'", "'DATABASE'", "'LINK'", "identifier", "'USING'", "string_literal", "';'"}));
            origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'PUBLIC'", "'DATABASE'", "'LINK'", "create_database_link[41,48)", "identifier", "'USING'", "string_literal", "';'"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        keywords = new String[]{"'WITH'", "'SELECT'", "'FROM'", "'WHERE'", "'AND'", "'OR'", "'NOT'", "'DISTINCT'", "'UNION'", "'ALL'", "'INNER'", "'NATURAL'", "'FULL'", "'ON'", "'INSERT'", "'UPDATE'", "'CREATE'", "'ALTER'", "'TABLE'", "'VALUES'", "'NUMBER'", "'VARCHAR2'", "'DATE'", "'INTEGER'", "'MULTISET'", "'CASE'", "'WHEN'"};
    }
}

