/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Service;

public class Earley
extends Parser {
    public Tuple[] rules;
    public int identifier = (Integer)this.symbolIndexes.get("identifier");
    protected int string_literal = -1;
    protected int digits = -1;
    protected boolean isCaseSensitive = false;
    protected PredictedTerminals[] terminalPredictions = null;
    public Map<Integer, long[]> predicts = null;
    public boolean skipRanges = true;

    public static void main(String[] args) throws Exception {
        String input = "1+1";
        List<LexerToken> src = LexerToken.parse(input);
        System.out.println("src.size()=" + src.size());
        TreeSet<RuleTuple> wiki = new TreeSet<RuleTuple>();
        wiki.add(new RuleTuple("P", new String[]{"S"}));
        wiki.add(new RuleTuple("S", new String[]{"S", "'+'", "M"}));
        wiki.add(new RuleTuple("S", new String[]{"M"}));
        wiki.add(new RuleTuple("M", new String[]{"T", "'*'", "M"}));
        wiki.add(new RuleTuple("M", new String[]{"T"}));
        wiki.add(new RuleTuple("T", new String[]{"'('", "P", "')'"}));
        wiki.add(new RuleTuple("T", new String[]{"digits"}));
        wiki.add(new RuleTuple("T", new String[]{"identifier"}));
        wiki.add(new RuleTuple("T", new String[]{"string_literal"}));
        TreeSet rules = new TreeSet();
        rules = wiki;
        Earley earley = new Earley((Set)rules){};
        earley.isCaseSensitive = true;
        Matrix matrix = new Matrix(earley);
        Visual visual = null;
        long t1 = System.currentTimeMillis();
        earley.parse(src, matrix);
        long t2 = System.currentTimeMillis();
        System.out.println("Earley parse time = " + (t2 - t1));
        System.out.println("#tokens=" + src.size());
        if (visual != null) {
            visual.draw(matrix);
        } else {
            System.out.println(matrix.toString());
        }
    }

    protected void initCell00(List<LexerToken> src, Matrix matrix) {
        long t1 = 0L;
        if (matrix.visual != null) {
            t1 = System.nanoTime();
        }
        long[] content = null;
        for (int i = 0; i < this.rules.length; ++i) {
            Tuple t = this.rules[i];
            String head = this.allSymbols[t.head];
            if (head.charAt(head.length() - 1) == ')') continue;
            content = Array.insert(content, this.makeMatrixCellElem(i, 0, t));
        }
        matrix.initCells(src.size());
        matrix.put(0, 0, new EarleyCell(content));
        matrix.allXs = Array.insert(matrix.allXs, 0);
        if (matrix.visual != null) {
            long t2 = System.nanoTime();
            long[] lArray = matrix.visual.visited[0];
            lArray[0] = lArray[0] + (long)((int)(t2 - t1));
        }
    }

    public synchronized void parse(List<LexerToken> src, Matrix matrix) {
        try {
            this.initCell00(src, matrix);
            this.predict(matrix);
            while (this.scan(matrix, src)) {
                this.complete(matrix, src.size());
                this.predict(matrix);
            }
        }
        catch (Exception e) {
            for (StackTraceElement elem : e.getStackTrace()) {
                if (!elem.toString().contains("UnitTest.assertion") && !elem.toString().contains("SqlEarley.main")) continue;
                System.err.println(e.toString());
                System.err.println("matrix.lastY=" + matrix.lastY() + ", src.size()=" + src.size());
                break;
            }
        }
    }

    public Earley(Set<RuleTuple> originalRules) {
        this(originalRules, true);
    }

    public Earley(Set<RuleTuple> originalRules, boolean precomputePredictions) {
        super(originalRules);
        try {
            this.string_literal = (Integer)this.symbolIndexes.get("string_literal");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.digits = (Integer)this.symbolIndexes.get("digits");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.rules = new Tuple[originalRules.size()];
        int p = 0;
        for (RuleTuple t : originalRules) {
            if (t.rhs.length == 0) {
                throw new AssertionError((Object)("empty production " + t.toString()));
            }
            int h = (Integer)this.symbolIndexes.get(t.head);
            int[] rhs = new int[t.rhs.length];
            for (int i = 0; i < rhs.length; ++i) {
                rhs[i] = (Integer)this.symbolIndexes.get(t.rhs[i]);
            }
            this.rules[p++] = new Tuple(h, rhs);
        }
    }

    protected void precomputePredictions() {
        int before;
        HashMap<Integer, int[]> closure = new HashMap<Integer, int[]>();
        HashMap<Integer, long[]> symbolHead2rules = new HashMap<Integer, long[]>();
        for (int i = 0; i < this.rules.length; ++i) {
            int[] tmp = (int[])closure.get(this.rules[i].head);
            long[] tmp1 = (long[])symbolHead2rules.get(this.rules[i].head);
            tmp = Array.insert(tmp, this.rules[i].rhs[0]);
            tmp1 = Array.insert(tmp1, this.makeMatrixCellElem(i, 0, this.rules[i]));
            closure.put(this.rules[i].head, tmp);
            symbolHead2rules.put(this.rules[i].head, tmp1);
        }
        do {
            before = this.size(closure);
            Iterator i$ = closure.keySet().iterator();
            while (i$.hasNext()) {
                int k = (Integer)i$.next();
                int[] v = (int[])closure.get(k);
                int[] tmp = Array.merge(v, new int[0]);
                for (int n : v) {
                    tmp = Array.merge(tmp, (int[])closure.get(n));
                }
                closure.put(k, tmp);
            }
        } while (before != this.size(closure));
        this.terminalPredictions = new PredictedTerminals[this.allSymbols.length];
        Iterator i$ = closure.keySet().iterator();
        while (i$.hasNext()) {
            int k = (Integer)i$.next();
            long[] tmp = (long[])symbolHead2rules.get(k);
            for (int n : (int[])closure.get(k)) {
                tmp = Array.merge(tmp, (long[])symbolHead2rules.get(n));
                String rhs0 = this.allSymbols[n];
                if (rhs0.charAt(0) == '\'') {
                    if (this.terminalPredictions[k] == null) {
                        this.terminalPredictions[k] = new PredictedTerminals();
                    }
                    this.terminalPredictions[k].add(n);
                    continue;
                }
                if (n != this.identifier && n != this.digits && n != this.string_literal) continue;
                if (this.terminalPredictions[k] == null) {
                    this.terminalPredictions[k] = new PredictedTerminals();
                }
                this.terminalPredictions[k].invalidate();
            }
            this.predicts.put(k, tmp);
        }
    }

    private static void addDependency(int ref, int def, Map<Integer, int[]> forward, Map<Integer, int[]> backward) {
        int key;
        int[] bd = backward.get(def);
        bd = Array.insert(bd, def);
        backward.put(def, bd);
        int[] fr = forward.get(ref);
        fr = Array.insert(fr, ref);
        forward.put(ref, fr);
        int[] br = backward.get(ref);
        br = Array.insert(br, ref);
        backward.put(ref, br);
        int[] fd = forward.get(def);
        fd = Array.insert(fd, def);
        forward.put(def, fd);
        HashMap<Integer, int[]> newForward = new HashMap<Integer, int[]>();
        HashMap<Integer, int[]> newBackward = new HashMap<Integer, int[]>();
        for (int from : br) {
            for (int to : fd) {
                int[] dependents = (int[])newForward.get(from);
                dependents = Array.insert(dependents, to);
                newForward.put(from, dependents);
                int[] referents = (int[])newBackward.get(to);
                referents = Array.insert(referents, from);
                newBackward.put(to, referents);
            }
        }
        Iterator i$ = newForward.keySet().iterator();
        while (i$.hasNext()) {
            key = (Integer)i$.next();
            int[] existing = forward.get(key);
            if (existing == null) {
                forward.put(key, (int[])newForward.get(key));
                continue;
            }
            existing = Array.merge(existing, (int[])newForward.get(key));
            forward.put(key, existing);
        }
        i$ = newBackward.keySet().iterator();
        while (i$.hasNext()) {
            key = (Integer)i$.next();
            int[] existing = backward.get(key);
            if (existing == null) {
                backward.put(key, (int[])newBackward.get(key));
                continue;
            }
            existing = Array.merge(existing, (int[])newBackward.get(key));
            backward.put(key, existing);
        }
    }

    private int size(Map<Integer, int[]> closure) {
        int ret = 0;
        for (int[] tmp : closure.values()) {
            ret += tmp.length;
        }
        return ret;
    }

    protected boolean scan(Matrix matrix, List<LexerToken> src) {
        int y = matrix.lastY();
        if (src.size() <= y) {
            return false;
        }
        LexerToken token = src.get(y);
        Integer suspect = (Integer)this.symbolIndexes.get("'" + (this.isCaseSensitive ? token.content : token.content.toUpperCase()) + "'");
        boolean ret = false;
        for (int i = matrix.allXs.length - 1; 0 <= i; --i) {
            int x = matrix.allXs[i];
            if (!this.scan(matrix, y, src, x, suspect)) continue;
            ret = true;
        }
        if (this.scan(matrix, y, src, y, suspect)) {
            ret = true;
        }
        return ret;
    }

    private boolean scan(Matrix matrix, int y, List<LexerToken> src, int x, Integer suspect) {
        long t1 = 0L;
        if (matrix.visual != null) {
            t1 = System.nanoTime();
        }
        long[] content = null;
        Cell candidateRules = matrix.get(x, y);
        if (candidateRules == null) {
            return false;
        }
        for (int j = 0; j < candidateRules.size(); ++j) {
            int pos = candidateRules.getPosition(j);
            int ruleNo = candidateRules.getRule(j);
            Tuple t = this.rules[ruleNo];
            if (t.size() - 1 < pos || !this.isScannedSymbol(y, src, pos, t, suspect) || !this.lookaheadOK(t, pos + 1, matrix)) continue;
            content = Array.insert(content, this.makeMatrixCellElem(ruleNo, pos + 1, t));
            if (t.rhs.length != pos + 1) continue;
            matrix.enqueue(Service.lPair(x, t.head));
        }
        if (matrix.visual != null) {
            long t2 = System.nanoTime();
            long[] lArray = matrix.visual.visited[x];
            int n = y + 1;
            lArray[n] = lArray[n] + (long)((int)(t2 - t1));
        }
        if (content == null) {
            return false;
        }
        matrix.put(x, y + 1, new EarleyCell(content));
        matrix.allXs = Array.insert(matrix.allXs, x);
        return true;
    }

    protected boolean isScannedSymbol(int y, List<LexerToken> src, int pos, Tuple t, Integer suspect) {
        int symbol = t.content(pos);
        LexerToken token = src.get(y);
        if (symbol == this.digits && token.type == Token.DIGITS) {
            return true;
        }
        if (symbol == this.string_literal && token.type == Token.QUOTED_STRING) {
            return true;
        }
        return suspect != null && suspect == symbol || this.isIdentifier(y, src, symbol, suspect) && (suspect == null || this.notConfusedAsId(suspect, t.head, pos));
    }

    protected boolean notConfusedAsId(int symbol, int head, int pos) {
        return true;
    }

    protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
        if (symbol != this.identifier) {
            return false;
        }
        LexerToken token = src.get(y);
        return symbol == this.identifier && token.type == Token.IDENTIFIER;
    }

    protected void predict(Matrix matrix) {
        if (this.predicts == null) {
            this.predicts = new HashMap<Integer, long[]>();
            this.precomputePredictions();
        }
        long t1 = 0L;
        if (matrix.visual != null) {
            t1 = System.nanoTime();
        }
        int y = matrix.lastY();
        EarleyCell cell = (EarleyCell)matrix.get(y, y);
        long[] content = null;
        if (cell != null) {
            content = cell.content;
        }
        int[] symbols = new int[]{};
        Map<Integer, Cell> xRange = matrix.getXRange(y);
        for (int mid : xRange.keySet()) {
            Cell candidateRules = matrix.get(mid, y);
            for (int j = 0; j < candidateRules.size(); ++j) {
                int pos = candidateRules.getPosition(j);
                int ruleNo = candidateRules.getRule(j);
                Tuple t = this.rules[ruleNo];
                if (t.size() <= pos) continue;
                int symbol = t.content(pos);
                symbols = Array.insert(symbols, symbol);
            }
        }
        for (int symbol : symbols) {
            PredictedTerminals terminal;
            if (matrix.LAsuspect != null && (terminal = this.terminalPredictions[symbol]) != null && !terminal.matches(matrix.LAsuspect)) continue;
            content = Array.merge(content, this.predicts.get(symbol));
        }
        if (matrix.visual != null) {
            long t2 = System.nanoTime();
            long[] lArray = matrix.visual.visited[y];
            int n = y;
            lArray[n] = lArray[n] + (long)((int)(t2 - t1));
        }
        if (content == null || content.length <= 0) {
            return;
        }
        matrix.put(y, y, new EarleyCell(content));
    }

    protected void complete(Matrix matrix, int srcLength) {
        long completionCandidate;
        HashMap<Integer, Integer> skipIntervals = new HashMap<Integer, Integer>();
        while ((completionCandidate = matrix.dequeue()) != -1L) {
            int symbol = Service.lY(completionCandidate);
            int mid = Service.lX(completionCandidate);
            int y = matrix.lastY();
            int indexX = Array.indexOf(matrix.allXs, mid);
            if (matrix.allXs.length - 1 < indexX) {
                indexX = matrix.allXs.length - 1;
            }
            if (mid < matrix.allXs[indexX]) {
                // empty if block
            }
            for (int i = --indexX; 0 <= i; --i) {
                Integer predecessor;
                Cell pres;
                int x = matrix.allXs[i];
                int skipTo = y;
                long t1 = 0L;
                if (matrix.visual != null) {
                    t1 = System.nanoTime();
                }
                if ((pres = matrix.get(x, mid)) == null) {
                    if (matrix.visual == null) continue;
                    long t2 = System.nanoTime();
                    matrix.visual.visited[x][y] = Service.addlY(matrix.visual.visited[x][y], (int)(t2 - t1));
                    continue;
                }
                long mask = (long)symbol << 48;
                int start = Array.indexOf(pres.getContent(), mask);
                int stop = Array.indexOf(pres.getContent(), mask | 0xFFFFFFFFFFFFL) + 1;
                EarleyCell content = (EarleyCell)matrix.get(x, y);
                for (int ii = start; ii < stop && ii < pres.size(); ++ii) {
                    int symPre;
                    int dotPre = pres.getPosition(ii);
                    int rulePre = pres.getRule(ii);
                    Tuple tPre = this.rules[rulePre];
                    if (tPre.size() == dotPre || (symPre = tPre.content(dotPre)) != symbol || y < srcLength && !this.lookaheadOK(tPre, dotPre + 1, matrix)) continue;
                    if (content == null) {
                        content = new EarleyCell(null);
                    }
                    long promotedRule = this.makeMatrixCellElem(rulePre, dotPre + 1, tPre);
                    int before = content.size();
                    content.insertContent(promotedRule);
                    int after = content.size();
                    if (before < after) {
                        matrix.put(x, y, content);
                        if (this.skipRanges && tPre.rhs.length == dotPre + 1 && mid < skipTo && this.allSymbols[tPre.head].charAt(0) != '\"') {
                            skipTo = mid;
                        }
                    }
                    if (tPre.size() != dotPre + 1 || before >= after) continue;
                    matrix.enqueue(Service.lPair(x, tPre.head));
                }
                if (matrix.visual != null) {
                    long t2 = System.nanoTime();
                    matrix.visual.visited[x][y] = Service.addlY(matrix.visual.visited[x][y], (int)(t2 - t1));
                }
                if (!this.skipRanges || x >= skipTo || skipTo >= y || (predecessor = (Integer)skipIntervals.get(x + 1)) != null && skipTo >= predecessor) continue;
                skipIntervals.put(x + 1, skipTo);
            }
        }
        Iterator i$ = skipIntervals.keySet().iterator();
        while (i$.hasNext()) {
            int x = (Integer)i$.next();
            int y = (Integer)skipIntervals.get(x);
            for (int k = x; k < y; ++k) {
                matrix.allXs = Array.delete(matrix.allXs, k);
            }
        }
    }

    protected boolean lookaheadOK(Tuple tPre, int pos, Matrix matrix) {
        return true;
    }

    void toHtml(int ruleNo, int pos, boolean selected, int x, int mid, int y, Matrix matrix, StringBuffer sb) {
        block14: {
            Tuple rule = this.rules[ruleNo];
            String size = "+1";
            if (selected) {
                sb.append("<b>");
                size = "+2";
            }
            sb.append("<font size=" + size + " color=blue>" + this.allSymbols[rule.head] + ":</font> ");
            String greenish = "<font size=" + size + " bgcolor=rgb(150,200,150))>";
            String bluish = "<font size=" + size + " bgcolor=rgb(150,150,200))>";
            sb.append(greenish);
            for (int i = 0; i < rule.rhs.length; ++i) {
                if (pos == i) {
                    sb.append("</font>" + bluish);
                }
                sb.append(this.allSymbols[rule.rhs[i]] + " ");
            }
            sb.append("</font>");
            if (selected) {
                sb.append("</b>");
            }
            if (mid == -1) {
                return;
            }
            if (!selected || x + y == 0) break block14;
            if (mid < x || x == y) {
                sb.append("<i> predict from </i>");
                Cell bc = matrix.get(mid, y);
                for (int j = 0; j < bc.size(); ++j) {
                    int bp = bc.getPosition(j);
                    int br = bc.getRule(j);
                    Tuple bt = this.rules[br];
                    if (bp >= bt.rhs.length || bt.rhs[bp] != rule.head) continue;
                    this.toHtml(br, bp, false, -1, -1, -1, null, sb);
                    return;
                }
            } else if (y < mid) {
                sb.append("<i> scan from </i>");
                Cell bc = matrix.get(x, y - 1);
                for (int j = 0; j < bc.size(); ++j) {
                    int bp = bc.getPosition(j);
                    int br = bc.getRule(j);
                    Tuple bt = this.rules[br];
                    if (br != ruleNo || bp + 1 != pos) continue;
                    this.toHtml(br, bp, false, -1, -1, -1, null, sb);
                    return;
                }
            } else {
                sb.append("<i> complete from </i>");
                boolean secondTime = false;
                Cell pre = matrix.get(x, mid);
                Cell post = matrix.get(mid, y);
                for (int i = 0; i < pre.size(); ++i) {
                    for (int j = 0; j < post.size(); ++j) {
                        int symPre;
                        int dotPre = pre.getPosition(i);
                        int dotPost = post.getPosition(j);
                        int rulePre = pre.getRule(i);
                        int rulePost = post.getRule(j);
                        Tuple tPre = this.rules[rulePre];
                        Tuple tPost = this.rules[rulePost];
                        if (tPre.size() != dotPre && tPost.size() != dotPost || tPost.size() != dotPost || rulePre != ruleNo || dotPre + 1 != pos || (symPre = tPre.content(dotPre)) != tPost.head) continue;
                        if (secondTime) {
                            sb.append("<b> or </b>");
                        }
                        this.toHtml(rulePre, dotPre, false, -1, -1, -1, null, sb);
                        sb.append("<i> and </i>");
                        this.toHtml(rulePost, dotPost, false, -1, -1, -1, null, sb);
                        secondTime = true;
                    }
                }
            }
        }
    }

    void toString(int ruleNo, int pos, StringBuffer sb) {
        Tuple rule = this.rules[ruleNo];
        sb.append(rule.toString(pos));
    }

    public void initCell(Matrix matrix, int[] heads, int pos) {
        long[] content = null;
        block0: for (int i = 0; i < this.rules.length; ++i) {
            Tuple t = this.rules[i];
            for (int h : heads) {
                if (t.head != h) continue;
                content = Array.insert(content, this.makeMatrixCellElem(i, 0, t));
                continue block0;
            }
        }
        matrix.put(pos, pos, new EarleyCell(content));
        matrix.allXs = Array.insert(matrix.allXs, pos);
    }

    @Override
    public ParseNode treeForACell(List<LexerToken> src, Matrix m, Cell cell, int x, int y, Map<Long, ParseNode> explored) {
        explored = new HashMap<Long, ParseNode>();
        int rule = -1;
        int pos = -1;
        for (int i = 0; i < cell.size(); ++i) {
            rule = cell.getRule(i);
            pos = cell.getPosition(i);
            if (this.rules[rule].rhs.length != pos) continue;
            return this.tree(src, m, x, y, rule, pos, explored);
        }
        if (rule != -1 && pos != -1 && x + 1 == y) {
            return this.tree(src, m, x, y, rule, pos, explored);
        }
        return null;
    }

    private long encode(int x, int y, int rule, int pos) {
        return (long)pos << 49 | (long)rule << 44 | (long)y << 22 | (long)x;
    }

    protected ParseNode tree(List<LexerToken> src, Matrix m, int x, int y, int rule, int pos, Map<Long, ParseNode> explored) {
        long key = this.encode(x, y, rule, pos);
        ParseNode val = explored.get(key);
        if (val != null) {
            return val;
        }
        ParseNode ret = this.followScan(src, m, x, y, rule, pos, explored);
        if (ret == null) {
            ret = this.followComplete(src, m, x, y, rule, pos, explored);
        }
        explored.put(key, ret);
        return ret;
    }

    private ParseNode followScan(List<LexerToken> src, Matrix m, int x, int y, int rule, int pos, Map<Long, ParseNode> explored) {
        if (pos == 0) {
            return null;
        }
        EarleyCell pre = (EarleyCell)m.get(x, y - 1);
        if (pre == null) {
            return null;
        }
        long demotedRule = this.makeMatrixCellElem(rule, pos - 1, this.rules[rule]);
        if (pre.content[Array.indexOf(pre.content, demotedRule)] == demotedRule) {
            Tuple t = this.rules[rule];
            LexerToken token = src.get(y - 1);
            Integer suspect = (Integer)this.symbolIndexes.get("'" + (this.isCaseSensitive ? token.content : token.content.toUpperCase()) + "'");
            if (!this.isScannedSymbol(y - 1, src, pos - 1, t, suspect)) {
                return null;
            }
            ParseNode branch = new ParseNode(y - 1, y, this.rules[rule].rhs[pos - 1], this.rules[rule].rhs[pos - 1], this);
            if (x + 1 == y) {
                if (this.rules[rule].rhs.length == 1) {
                    branch.addContent(this.rules[rule].head);
                }
                return branch;
            }
            int head = this.rules[rule].head;
            if (pos != this.rules[rule].rhs.length) {
                head = -1;
            }
            ParseNode ret = new ParseNode(x, y, head, head, this);
            ret.lft = this.tree(src, m, x, y - 1, rule, pos - 1, explored);
            ret.lft.parent = ret;
            ret.rgt = branch;
            ret.rgt.parent = ret;
            return ret;
        }
        return null;
    }

    private ParseNode followComplete(List<LexerToken> src, Matrix m, int x, int y, int rule, int pos, Map<Long, ParseNode> explored) {
        if (pos != 0) {
            for (int mid = y - 1; x <= mid; --mid) {
                long demotedRule;
                Cell post;
                EarleyCell pre = (EarleyCell)m.get(x, mid);
                if (pre == null || (post = m.get(mid, y)) == null || pre.content[Array.indexOf(pre.content, demotedRule = this.makeMatrixCellElem(rule, pos - 1, this.rules[rule]))] != demotedRule) continue;
                for (int j = 0; j <= post.size() - 1; ++j) {
                    int rJ = post.getRule(j);
                    int pJ = post.getPosition(j);
                    Tuple tPost = this.rules[rJ];
                    if (this.rules[rJ].rhs.length != pJ || this.rules[rJ].head != this.rules[rule].rhs[pos - 1]) continue;
                    int head = this.rules[rule].head;
                    if (this.rules[rule].rhs.length != pos) {
                        head = -1;
                    }
                    ParseNode ret = new ParseNode(x, y, head, head, this);
                    try {
                        if (x != mid) {
                            ret.lft = this.tree(src, m, x, mid, rule, pos - 1, explored);
                            ret.lft.parent = ret;
                            ret.rgt = this.tree(src, m, mid, y, rJ, pJ, explored);
                            ret.rgt.parent = ret;
                        } else if (rJ != rule || pJ != pos) {
                            ret = this.tree(src, m, mid, y, rJ, pJ, explored);
                            if (head != -1) {
                                ret.addContent(head);
                            }
                        }
                    }
                    catch (AssertionError e) {
                        if (((Throwable)((Object)e)).getMessage().startsWith("unwind")) continue;
                        throw e;
                    }
                    return ret;
                }
            }
        }
        throw new AssertionError((Object)("unwind " + this.rules[rule].toString(pos) + " @[" + x + "," + y + ")"));
    }

    protected long makeMatrixCellElem(int rule, int pos, Tuple t) {
        long activeVar = 0L;
        if (pos < t.rhs.length) {
            activeVar = t.rhs[pos];
        }
        return (long)rule << 16 | (long)pos | activeVar << 48;
    }

    public static int ruleFromEarleyCell(long code) {
        return (int)((code & 0xFFFFFFFFFFFFL) >> 16);
    }

    public static int posFromEarleyCell(long code) {
        return (int)(code & 0xFFFFL);
    }

    public static int activeVarFromEarleyCell(long code) {
        return (int)(code >> 48);
    }

    public class PredictedTerminals {
        private boolean isValid = true;
        int[] symbols = null;

        void add(int sym) {
            if (this.isValid) {
                this.symbols = Array.insert(this.symbols, sym);
            } else {
                this.invalidate();
            }
        }

        void invalidate() {
            this.symbols = null;
            this.isValid = false;
        }

        public boolean matches(Integer lookahead) {
            if (!this.isValid) {
                return true;
            }
            if (this.symbols == null) {
                return true;
            }
            return lookahead != null && this.symbols[Array.indexOf(this.symbols, lookahead)] == lookahead;
        }

        public String toString() {
            if (!this.isValid) {
                return "*invalid*";
            }
            if (this.symbols == null) {
                return "*symbols == null*";
            }
            StringBuilder ret = new StringBuilder("{");
            for (int s : this.symbols) {
                ret.append(Earley.this.allSymbols[s]);
                ret.append(',');
            }
            return ret.toString();
        }
    }

    public class EarleyCell
    implements Cell {
        long[] content = null;

        public EarleyCell(long[] content) {
            this.content = content;
        }

        @Override
        public int getRule(int index) {
            return Earley.ruleFromEarleyCell(this.content[index]);
        }

        @Override
        public int getPosition(int index) {
            return Earley.posFromEarleyCell(this.content[index]);
        }

        @Override
        public int size() {
            if (this.content == null) {
                return 0;
            }
            return this.content.length;
        }

        @Override
        public long[] getContent() {
            return this.content;
        }

        @Override
        public void insertContent(long cellElem) {
            this.content = Array.insert(this.content, cellElem);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            for (int i = 0; i < this.content.length; ++i) {
                if (0 < i) {
                    sb.append(" , ");
                }
                Tuple t = Earley.this.rules[this.getRule(i)];
                sb.append(t.toString(this.getPosition(i)));
            }
            sb.append(" }");
            return sb.toString();
        }
    }

    public class Tuple
    implements Comparable<Tuple> {
        public int head;
        public int[] rhs;

        public Tuple(int h, int[] r) {
            this.head = h;
            this.rhs = r;
        }

        public int size() {
            return this.rhs.length;
        }

        public int content(int i) {
            return this.rhs[i];
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Tuple && this.compareTo((Tuple)obj) == 0;
        }

        public int hashCode() {
            throw new RuntimeException("hashCode inconsistent with equals");
        }

        @Override
        public int compareTo(Tuple src) {
            if (this.head == 0 || src.head == 0) {
                throw new RuntimeException("head==0 || src.head==0");
            }
            int cmp = this.head - src.head;
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.rhs.length - src.rhs.length;
            if (cmp != 0) {
                return cmp;
            }
            for (int i = 0; i < this.rhs.length; ++i) {
                cmp = this.rhs[i] - src.rhs[i];
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        public String toString() {
            StringBuilder s = new StringBuilder(Earley.this.allSymbols[this.head] + ":");
            for (int i : this.rhs) {
                s.append("  " + Earley.this.allSymbols[i]);
            }
            s.append(";");
            return s.toString();
        }

        public String toString(int pos) {
            StringBuilder s = new StringBuilder(Earley.this.allSymbols[this.head] + ":");
            for (int i = 0; i < this.rhs.length; ++i) {
                s.append(' ');
                if (pos == i) {
                    s.append('!');
                }
                s.append(Earley.this.allSymbols[this.rhs[i]]);
            }
            if (pos == this.rhs.length) {
                s.append('!');
            }
            s.append(";");
            return s.toString();
        }
    }
}

