/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.Messages;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.jdbc.OracleCallableStatement;

final class OracleUtil
extends DBUtil {
    private static QueryXMLSupport s_xml;
    private static Set<String> s_reservedWords;
    private static final Version LG_BUFFER_REQ_VERSION;

    protected static synchronized QueryXMLSupport getXMLQueries() {
        if (s_xml == null) {
            s_xml = QueryXMLSupport.getQueryXMLSupport(new MetaResource(DBUtil.class.getClassLoader(), "oracle/dbtools/db/dbutilsql.xml"));
        }
        return s_xml;
    }

    public static synchronized Set<String> getReservedWords() {
        if (s_reservedWords == null) {
            String[] words = new String[]{"ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MLSLABEL", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"};
            s_reservedWords = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList(words)));
        }
        return s_reservedWords;
    }

    OracleUtil(ConnectionIdentifier id) {
        super(id);
    }

    @Override
    public ResultSet executeQuery(String query, Map<String, ?> binds) {
        return this.executeOracleQuery(query, binds);
    }

    @Override
    protected PreparedStatement prepareQuery(String query) throws SQLException {
        return this.m_conn.prepareCall(query);
    }

    @Override
    protected String fetchDbVersionImpl() throws SQLException {
        String result = "10.1";
        String banner = this.executeReturnOneCol("select * from v$version where banner like '%Oracle%'");
        String[] first = banner.split(" ");
        String regex = ".*[0-9]\\.+[0-9]\\.+.*";
        for (String s : first) {
            if (!Pattern.matches(regex, s)) continue;
            result = s;
            break;
        }
        return result;
    }

    @Override
    public void setDBAction(String action) {
        Query q = OracleUtil.getXMLQueries().getQuery("ACTION", this.m_conn);
        this.execute(q.getSql(), Collections.singletonList(action == null ? "" : action));
    }

    @Override
    public void setDBModuleAction(String action) {
        Query q = OracleUtil.getXMLQueries().getQuery("MODULE", this.m_conn);
        this.execute(q.getSql(), Arrays.asList(s_prodName, action == null ? "" : action));
    }

    private boolean largeBuffer(ConnectionIdentifier id) {
        return LG_BUFFER_REQ_VERSION.compareTo(VersionTracker.getDbVersion(id)) <= 0;
    }

    @Override
    public String getDBMSOUTPUT() {
        DBUtil.OperImpl<String> callable = new DBUtil.OperImpl<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws SQLException {
                StringBuilder sb = new StringBuilder();
                Statement stmt = null;
                try {
                    Query q = OracleUtil.getXMLQueries().getQuery("GET_DBMSOUTPUT", OracleUtil.this.m_conn);
                    stmt = OracleUtil.this.m_conn.prepareCall(q.getSql());
                    boolean useLargeBuffer = OracleUtil.this.largeBuffer(OracleUtil.this.mID);
                    if (useLargeBuffer) {
                        stmt.registerOutParameter(2, 4);
                        stmt.registerOutParameter(3, 12);
                        stmt.registerOutParameter(4, 12);
                    } else {
                        stmt.registerOutParameter(2, 4);
                        stmt.registerOutParameter(3, 12);
                    }
                    do {
                        stmt.setInt(1, 1000);
                        stmt.executeUpdate();
                        if (useLargeBuffer) {
                            String got = stmt.getString(3);
                            if (got != null) {
                                sb.append(got);
                            }
                            if ((got = stmt.getString(4)) != null) {
                                sb.append(got + "\n");
                                continue;
                            }
                            sb.append("\n");
                            continue;
                        }
                        sb.append(stmt.getString(3));
                    } while (stmt.getInt(2) != 1);
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
                return sb.toString();
            }
        };
        return this.lockForOperation(callable, "");
    }

    @Override
    protected boolean isOracleConnectionAlive() {
        Query q = OracleUtil.getXMLQueries().getQuery("IS_ALIVE", this.m_conn);
        return this.execute(q.getSql(), Collections.EMPTY_LIST);
    }

    @Override
    public int getErrorOffset(final String sql) {
        DBUtil.OperImpl<Integer> oper = new DBUtil.OperImpl<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws SQLException {
                Statement stmt = null;
                try {
                    Query q = OracleUtil.getXMLQueries().getQuery("ERR_SQL", OracleUtil.this.m_conn);
                    stmt = OracleUtil.this.m_conn.prepareCall(q.getSql());
                    DBUtil.LOGGER.info(Messages.getString("DBUtil.55") + q.getSql());
                    stmt.setString(1, sql);
                    stmt.setString(2, sql);
                    stmt.registerOutParameter(3, 4);
                    stmt.execute();
                    Integer n = stmt.getInt(3);
                    return n;
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        };
        return this.lockForOperation(oper, 0);
    }

    @Override
    protected boolean hasTransaction() {
        DBUtil.OperImpl<Boolean> oper = new DBUtil.OperImpl<Boolean>(){

            @Override
            public Boolean call() throws SQLException {
                if (OracleUtil.this.m_conn == null || OracleUtil.this.m_conn.isClosed()) {
                    return false;
                }
                Query q = OracleUtil.getXMLQueries().getQuery("TRANSACTION", OracleUtil.this.m_conn);
                String ret = OracleUtil.this.executeOracleReturnOneCol(q.getSql(), Collections.EMPTY_MAP);
                return ModelUtil.hasLength(ret);
            }
        };
        return this.lockForOperation(oper, Boolean.FALSE);
    }

    @Override
    public Map<String, String> resolveName(String descr, boolean withPackageBody, boolean ignoreSynonyms) {
        Object o;
        List<Map<String, ?>> ret;
        String bodyWhere = "N";
        if (withPackageBody) {
            bodyWhere = "Y";
        }
        String[] s = descr.split("\\.");
        String objName = null;
        String ownerName = null;
        if (s.length == 2) {
            objName = s[1];
            ownerName = s[0];
        } else {
            objName = s.length == 1 ? s[0] : descr;
        }
        String sql = null;
        objName = this.scrubObjectName(objName);
        if (ownerName != null) {
            ownerName = this.scrubObjectName(ownerName);
        }
        String[] dbLink = OracleUtil.resolveDBLink(objName);
        HashMap<String, String> binds = new HashMap<String, String>();
        String schemaContext = DBUtil.getInstance(this.m_conn).executeReturnOneCol("select UPPER(sys_context('USERENV', 'CURRENT_SCHEMA')) from dual");
        String atDbLink = "";
        if (dbLink != null) {
            atDbLink = "@" + dbLink[1];
            binds.put("NAME", dbLink[0]);
        } else {
            binds.put("NAME", objName);
        }
        binds.put("OWNER", ownerName);
        binds.put("SCHEMA_CONTEXT", schemaContext);
        binds.put("BODY_WHERE", bodyWhere);
        String synonymsQuery = "  union all    select ao.object_type,ao.owner,ao.object_name,decode(UPPER(syn.owner), nvl(:OWNER,:SCHEMA_CONTEXT),10,20)    from all_objects" + atDbLink + " ao,all_synonyms" + atDbLink + " syn  " + "  where ao.owner = syn.table_owner  " + "  and   ao.object_name = syn.table_name  " + "  and   syn.synonym_name = :NAME  " + "  and ( UPPER(syn.owner) = nvl(:OWNER,:SCHEMA_CONTEXT) \n" + "        OR UPPER(syn.owner) = nvl(:OWNER,'PUBLIC') )";
        if (ignoreSynonyms) {
            synonymsQuery = "";
        }
        if ((ret = this.executeReturnList(sql = "select object_type,owner,object_name,rank from (    select object_type,owner,object_name,0 rank    from all_objects  " + atDbLink + "  where object_name = :NAME  " + "  and UPPER(owner) = nvl(:OWNER,:SCHEMA_CONTEXT)  " + "  and object_type not in ( 'SYNONYM' )   " + synonymsQuery + " ) where ((:BODY_WHERE='Y') OR  (object_type not in ('PACKAGE BODY'))) AND rownum < 100 order by rank," + "  CASE object_type " + "    WHEN 'TABLE' " + "    THEN 0 " + "    WHEN 'VIEW' " + "    THEN 1 " + "    WHEN 'INDEX' " + "    THEN 2 " + "    WHEN 'PACKAGE' " + "    THEN 3 " + "    WHEN 'PACKAGE BODY' " + "    THEN 4 " + "    ELSE 5 " + "  END", binds)).size() == 0 && objName != null && ownerName == null) {
            sql = "select 'SCHEMA' object_type , :OWNER owner , :OWNER object_name from all_users where username = :OWNER";
            binds.put("OWNER", objName);
            ret = this.executeReturnList(sql, binds);
        }
        Map<String, ?> result = null;
        if (ret.size() > 0) {
            result = ret.get(0);
        }
        if (result != null && (o = result.get("OBJECT_TYPE")) != null && ((String)o).indexOf("TABLE PARTITION") != -1) {
            result.put("OBJECT_TYPE", "TABLE");
        }
        return result;
    }

    @Override
    public String executeReturnOneCol(String query, Map<String, ? extends Object> binds) {
        return this.executeOracleReturnOneCol(query, binds);
    }

    @Override
    public String executeReturnOneCol(String query) {
        return this.executeOracleReturnOneCol(query, null);
    }

    @Override
    protected PreparedStatement prepareExecuteImpl(String sql, Map<String, ?> binds) throws SQLException {
        CallableStatement stmt = this.m_conn.prepareCall(sql);
        LOGGER.info(Messages.getString("DBUtil.17") + sql);
        if (binds != null) {
            OracleUtil.bind((PreparedStatement)stmt, binds);
        }
        return stmt;
    }

    @Override
    protected boolean checkAccessImpl(String s) {
        boolean hasAccess = false;
        if (this.m_conn != null) {
            Query q = OracleUtil.getXMLQueries().getQuery("ORACLE_NAME_RESOLVE", this.m_conn);
            try (CallableStatement stmt = this.m_conn.prepareCall(q.getSql());){
                ((OracleCallableStatement)stmt).setStringAtName("obj_name", s);
                stmt.execute();
                hasAccess = true;
            }
            catch (SQLException ex) {
                LOGGER.info(s + oracle.dbtools.raptor.query.Messages.getString("QueryUtils.31"));
            }
        }
        return hasAccess;
    }

    static {
        LG_BUFFER_REQ_VERSION = new Version("10.2");
    }
}

