/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.Connection;
import java.util.concurrent.Callable;

public abstract class LockManager {
    public static final LockManager NOOP_LOCK_MANAGER;
    private static LockManager sInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setLockManager(LockManager impl) {
        Class<LockManager> clazz = LockManager.class;
        synchronized (LockManager.class) {
            if (impl != sInstance) {
                if (sInstance != null) {
                    sInstance.uninstall();
                }
                sInstance = impl != null ? impl : NOOP_LOCK_MANAGER;
                sInstance.install();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean lock(Connection conn) {
        return LockManager.lock(conn, false);
    }

    public static boolean lock(Connection conn, boolean promptUser) {
        return sInstance.lockImpl(conn, promptUser);
    }

    public static void unlock(Connection conn) {
        sInstance.unlockImpl(conn);
    }

    public static boolean checkLock(Connection conn) {
        return sInstance.checkLockImpl(conn);
    }

    public static boolean tryLock(Connection conn, long timeout) {
        return sInstance.tryLockImpl(conn, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <V> V executeWithLock(Connection conn, Callable<V> oper) throws Exception {
        if (LockManager.lock(conn)) {
            try {
                V v = oper.call();
                return v;
            }
            finally {
                LockManager.unlock(conn);
            }
        }
        return null;
    }

    protected LockManager() {
    }

    protected abstract boolean lockImpl(Connection var1, boolean var2);

    protected abstract void unlockImpl(Connection var1);

    protected abstract boolean checkLockImpl(Connection var1);

    protected abstract boolean tryLockImpl(Connection var1, long var2);

    protected void install() throws IllegalStateException {
    }

    protected void uninstall() throws IllegalStateException {
    }

    static {
        sInstance = NOOP_LOCK_MANAGER = new LockManager(){

            @Override
            public void unlockImpl(Connection conn) {
            }

            @Override
            public boolean lockImpl(Connection conn, boolean promptUser) {
                return true;
            }

            @Override
            public boolean checkLockImpl(Connection conn) {
                return true;
            }

            @Override
            public boolean tryLockImpl(Connection conn, long timeout) {
                return true;
            }
        };
    }
}

