/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.loadservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.loadservice.LoadService;
import oracle.dbtools.data.loadservice.LoadServiceJdbcBatch;

public class LoadServicesRegistry {
    private static Map<String, Class<? extends LoadService>> s_registry = new HashMap<String, Class<? extends LoadService>>();

    public static synchronized void registerService(LoadService clazz) {
        s_registry.put(clazz.getType().toLowerCase(), clazz.getClass());
    }

    public static synchronized void unregisterService(LoadService clazz) {
        s_registry.remove(clazz.getType().toLowerCase());
    }

    public static synchronized LoadService getService(String type) {
        try {
            return s_registry.get(type.toLowerCase()).newInstance();
        }
        catch (InstantiationException e) {
            Logger.getLogger(LoadServicesRegistry.class.getName()).log(Level.SEVERE, "Unable to instantiate the Data Reader");
        }
        catch (IllegalAccessException e) {
            Logger.getLogger(LoadServicesRegistry.class.getName()).log(Level.SEVERE, "Unable to instantiate the Data Reader");
        }
        return null;
    }

    public static synchronized List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(s_registry.keySet());
        return types;
    }

    public static boolean isServiceRegistered(String type) {
        return s_registry.get(type.toLowerCase()) != null;
    }

    static {
        LoadServicesRegistry.registerService(new LoadServiceJdbcBatch());
    }
}

